/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.actions.newFile.OCNewStringsFileAction;
import com.jetbrains.cidr.lang.intentions.OCLocalizeStringIntentionAction;
import com.jetbrains.cidr.lang.psi.OCStringsFile;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.references.OCStringResourceReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OCProvideStringLocalizationsIntentionAction
extends OCQuickFix {
    private OCStringResourceReference myReference;

    public OCProvideStringLocalizationsIntentionAction(OCStringResourceReference reference) {
        this.myReference = reference;
    }

    @Override
    protected String getTextInternal() {
        return "Provide localizations for \"" + this.myReference.getCanonicalText() + "\"";
    }

    @NotNull
    public String getFamilyName() {
        if ("Provide localizations" == null) {
            OCProvideStringLocalizationsIntentionAction.$$$reportNull$$$0(0);
        }
        return "Provide localizations";
    }

    @Override
    public boolean isAvailable() {
        return OCSearchScope.isInProjectSources(this.myReference.getElement()) && this.myReference.getTableFileName() != null;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull Project project2) {
        if (project2 == null) {
            OCProvideStringLocalizationsIntentionAction.$$$reportNull$$$0(1);
        }
        if (this.checkFilesForWrite()) {
            this.invokeBool(file);
        }
    }

    public boolean checkFilesForWrite() {
        final String key = this.myReference.getCanonicalText();
        CommonProcessors.CollectProcessor<OCStringsFile> collector = new CommonProcessors.CollectProcessor<OCStringsFile>(){

            protected boolean accept(OCStringsFile file) {
                return file.findStringPair(key) == null;
            }
        };
        this.myReference.processStringFiles((Processor<OCStringsFile>)collector);
        return FileModificationService.getInstance().preparePsiElementsForWrite(collector.getResults().toArray(PsiElement.EMPTY_ARRAY));
    }

    public boolean invokeBool(PsiFile file) {
        String key = this.myReference.getCanonicalText();
        String contents = "\n\"" + OCLocalizeStringIntentionAction.getKeyString(key) + "\" = \"" + key + "\";";
        ArrayList files = new ArrayList();
        Ref wasFile = Ref.create((Object)false);
        this.myReference.processStringFiles((Processor<OCStringsFile>)((Processor)file1 -> {
            if (file1.findStringPair(key) == null) {
                files.add(file1);
            }
            wasFile.set((Object)true);
            return true;
        }));
        if (!((Boolean)wasFile.get()).booleanValue() && !ApplicationManager.getApplication().isUnitTestMode()) {
            String tableName = FileUtil.getNameWithoutExtension((String)this.myReference.getTableFileName());
            OCNewStringsFileAction action = new OCNewStringsFileAction(tableName, contents){

                @Override
                protected boolean isNameFieldEnabled() {
                    return false;
                }

                @Override
                protected void openCreatedFiles(@NotNull PsiFile[] createdElements) {
                    if (createdElements == null) {
                        2.$$$reportNull$$$0(0);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdElements", "com/jetbrains/cidr/lang/quickfixes/OCProvideStringLocalizationsIntentionAction$2", "openCreatedFiles"));
                }
            };
            return action.performAction(file.getProject(), file.getParent(), file, tableName) != null;
        }
        WriteAction.run(() -> {
            for (OCStringsFile stringsFile : files) {
                OCChangeUtil.changeText(stringsFile.getProject(), stringsFile, stringsFile.getTextLength(), 0, contents, false);
            }
        });
        return true;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCProvideStringLocalizationsIntentionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCProvideStringLocalizationsIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

