/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class OCRemoveTypeModifierIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private OCElementType myModifier;
    private final String myText;

    public OCRemoveTypeModifierIntentionAction(@NotNull OCSymbolWithQualifiedName symbol, OCElementType modifier, @NotNull Project project2) {
        if (symbol == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(1);
        }
        this(symbol, modifier, symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, project2)));
    }

    public OCRemoveTypeModifierIntentionAction(@NotNull OCSymbolWithQualifiedName symbol, OCElementType modifier, String subject) {
        if (symbol == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(2);
        }
        super(symbol);
        this.myModifier = modifier;
        this.myText = "Make " + subject + " non-" + this.myModifier.getName();
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        String string = "Remove '" + this.myModifier.getName() + "'";
        if (string == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        if (!super.isAvailable()) {
            return false;
        }
        if (!(this.myModifier != OCTokenTypes.CONST_KEYWORD || ((OCDeclaratorSymbol)this.mySymbol).isConst() && this.mySymbol.getKind() != OCSymbolKind.ENUM_CONST)) {
            return false;
        }
        return this.myModifier != OCTokenTypes.BLOCK_KEYWORD || ((OCDeclaratorSymbol)this.mySymbol).isBlockModifiable();
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (project2 == null) {
            OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(4);
        }
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project2))) {
            return;
        }
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)collector, project2);
        List psiSmartPointers = collector.getResults().stream().map(symbol1 -> {
            if (project2 == null) {
                OCRemoveTypeModifierIntentionAction.$$$reportNull$$$0(5);
            }
            return symbol1.locateDefinition(project2);
        }).filter(Objects::nonNull).map(OCElementUtil::createPsiElementPointer).collect(Collectors.toList());
        for (SmartPsiElementPointer pointer : psiSmartPointers) {
            OCTypeElement typeElement;
            PsiElement element = pointer.getElement();
            if (element == null || this.findAndRemove(element) || !(element instanceof OCDeclarator) || !(element.getParent() instanceof OCDeclaration) || (typeElement = ((OCDeclaration)element.getParent()).getTypeElement()) == null || this.findAndRemove(typeElement)) continue;
            this.findAndRemove(typeElement.getParent());
        }
    }

    private boolean findAndRemove(PsiElement element) {
        ASTNode[] children = element.getNode().getChildren(null);
        for (int i = children.length - 1; i >= 0; --i) {
            if (children[i].getElementType() != this.myModifier) continue;
            PsiElement psi = children[i].getPsi();
            if (psi != null) {
                OCChangeUtil.delete(psi);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveTypeModifierIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCRemoveTypeModifierIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$invoke$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

