/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCReuseDeclarationIntentionAction
extends OCSymbolQuickFix<OCSymbol<?>> {
    private String myIntentionName;

    public OCReuseDeclarationIntentionAction(@NotNull OCSymbol symbol, String intentionName) {
        if (symbol == null) {
            OCReuseDeclarationIntentionAction.$$$reportNull$$$0(0);
        }
        super(symbol);
        this.myIntentionName = intentionName;
    }

    @Override
    protected String getTextInternal() {
        return this.myIntentionName;
    }

    @NotNull
    public String getFamilyName() {
        if ("Reuse declaration" == null) {
            OCReuseDeclarationIntentionAction.$$$reportNull$$$0(1);
        }
        return "Reuse declaration";
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        OCDeclarator declarator;
        if (project2 == null) {
            OCReuseDeclarationIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid(declarator = (OCDeclarator)this.mySymbol.locateDefinition(project2))) {
            return;
        }
        if (declarator.getInitializer() != null) {
            OCExpressionStatement assignment = OCElementUtil.getTextWithMacros(declarator.getParent()).endsWith(";") ? (OCExpressionStatement)OCElementFactory.statementFromText(declarator.getName() + "=b;", declarator) : (OCExpressionStatement)((OCForStatement)OCElementFactory.statementFromText("for(" + declarator.getName() + "=b;;);", declarator)).getInitializer();
            OCAssignmentExpression expr = (OCAssignmentExpression)assignment.getExpression();
            OCChangeUtil.replaceHandlingMacros(expr.getSourceExpression(), declarator.getInitializer());
            OCDeclaration declaration = (OCDeclaration)declarator.getParent();
            PsiElement parent = declaration.getParent();
            if (!(parent instanceof OCDeclarationStatement)) {
                return;
            }
            parent.getParent().addAfter((PsiElement)assignment, parent);
        }
        if (declarator.getParent().getParent() instanceof OCForeachStatement) {
            OCExpression expression = OCElementFactory.expressionFromText(declarator.getName(), declarator);
            OCChangeUtil.replaceHandlingMacros(declarator.getParent(), expression);
        } else {
            OCChangeUtil.delete(declarator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCReuseDeclarationIntentionAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCReuseDeclarationIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

