/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCConvertMemberRefactoringProcessor<M extends OCMemberSymbol>
extends BaseRefactoringProcessor {
    private OCClassSymbol myParentClass;
    private List<M> myMembers;
    private Map<M, String> myNewMembersNames;
    private Map<M, OCInstanceVariableSymbol> myNewIvars = new HashMap<M, OCInstanceVariableSymbol>();
    protected Map<M, PsiElement> myNewDeclarations;
    private Map<M, OCMemberSymbol> myExistingDeclarations;
    private List<OCSynthesizePropertiesList> mySynthesizes;
    private OCElementType myNewQualifierType;
    private String myCommandName;
    private OCReleaseVariablesIntentionAction myReleaseAction;
    private final PsiElement myNewQualifyingToken;
    private Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> myElemsToEscalateVisibility = new HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>>();
    private Set<M> myMembersWithConflicts = new HashSet<M>();
    private boolean myConvertUsages;

    private OCConvertMemberRefactoringProcessor(OCClassSymbol parentClass, OCElementType newQualifierType, Project project2) {
        super(project2, EmptyRunnable.INSTANCE);
        this.myParentClass = parentClass;
        this.myNewQualifierType = newQualifierType;
        this.myNewQualifyingToken = OCElementFactory.create(this.myNewQualifierType, this.myParentClass.getContainingOCFile(this.myProject));
    }

    public OCConvertMemberRefactoringProcessor(OCClassSymbol parentClass, List<M> members, Map<M, String> newMemberNames, Map<M, PsiElement> newDeclarations, Map<M, OCMemberSymbol> existingDeclarations, List<OCSynthesizePropertiesList> synthesizes, OCReleaseVariablesIntentionAction releaseAction, OCElementType newQualifierType, String commandName, boolean convertUsages, Project project2) {
        this(parentClass, newQualifierType, project2);
        this.myMembers = members;
        this.myNewMembersNames = newMemberNames;
        this.myNewDeclarations = newDeclarations;
        this.myExistingDeclarations = existingDeclarations;
        this.mySynthesizes = synthesizes;
        this.myReleaseAction = releaseAction;
        this.myCommandName = commandName;
        this.myConvertUsages = convertUsages;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            OCConvertMemberRefactoringProcessor.$$$reportNull$$$0(0);
        }
        OCUsageViewDescriptor oCUsageViewDescriptor = new OCUsageViewDescriptor((PsiElement)this.myParentClass.locateDefinition(this.myProject), this.getCommandName());
        if (oCUsageViewDescriptor == null) {
            OCConvertMemberRefactoringProcessor.$$$reportNull$$$0(1);
        }
        return oCUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        ArrayList<ConvertUsage<OCMemberSymbol>> usages = new ArrayList<ConvertUsage<OCMemberSymbol>>();
        for (OCMemberSymbol member : this.myMembers) {
            Object element = member.locateDefinition(this.myProject);
            String newName = this.myNewMembersNames.get(member);
            OCInstanceVariableSymbolImpl ivar = new OCInstanceVariableSymbolImpl(this.myProject, this.myParentClass.getContainingFile(), Long.MAX_VALUE, newName, Collections.emptyList(), this.myParentClass, member.getType(), OCVisibility.PRIVATE, null);
            this.myNewIvars.put(member, ivar);
            if (element == null || !this.isReplaceMode()) continue;
            for (PsiReference reference : ReferencesSearch.search(element).findAll()) {
                usages.add(new ConvertUsage<OCMemberSymbol>(reference, member));
                PsiElement referenceElement = reference.getElement();
                if (!(member instanceof OCPropertySymbol) || referenceElement == null) continue;
                OCVisibility curVisibility = OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(ivar, referenceElement, null);
                ivar.updateVisibility(OCVisibility.mostVisible(ivar.getVisibility(), curVisibility));
            }
        }
        UsageInfo[] usageInfoArray = usages.toArray(new ConvertUsage[0]);
        if (usageInfoArray == null) {
            OCConvertMemberRefactoringProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    private boolean isReplaceMode() {
        return this.mySynthesizes == null;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            OCConvertMemberRefactoringProcessor.$$$reportNull$$$0(3);
        }
        Arrays.sort(usages, (u1, u2) -> u2.getNavigationOffset() - u1.getNavigationOffset());
        OCClassDeclarationBase classDeclaration = (OCClassDeclarationBase)this.myParentClass.locateDefinition(this.myProject);
        OCImplementationSymbol implementation = this.myParentClass.getImplementation(this.myProject);
        OCClassDeclarationBase anInterface = (OCClassDeclarationBase)this.myParentClass.getInterface(this.myProject).locateDefinition(this.myProject);
        OCClassDeclarationBase implDeclaration = implementation != null ? (OCClassDeclarationBase)implementation.locateDefinition(this.myProject) : null;
        OCElementsMover mover = new OCElementsMover(true);
        ArrayList elementsToRemove = new ArrayList();
        HashMap existingPsiDeclarations = new HashMap();
        if (this.isReplaceMode()) {
            for (OCMemberSymbol member : this.myMembers) {
                if (this.myMembersWithConflicts.contains(member)) continue;
                OCMemberSymbol associatedSymbol = member.getAssociatedSymbol(this.myProject);
                elementsToRemove.add(member.locateDefinition(this.myProject));
                elementsToRemove.add(associatedSymbol != null ? (Object)associatedSymbol.locateDefinition(this.myProject) : null);
            }
        }
        Iterator<M> iterator = this.myMembers.iterator();
        while (iterator.hasNext()) {
            OCMemberSymbol member;
            OCMemberSymbol existingSymbol = this.myExistingDeclarations.get(member = (OCMemberSymbol)iterator.next());
            existingPsiDeclarations.put(member, existingSymbol != null ? (Object)existingSymbol.locateDefinition(this.myProject) : null);
        }
        for (OCMemberSymbol member : this.myMembers) {
            PsiElement newDeclaration = this.myNewDeclarations.get(member);
            PsiElement existingDecl = (PsiElement)existingPsiDeclarations.get(member);
            OCMemberSymbol existingSymbol = this.myExistingDeclarations.get(member);
            if (member instanceof OCPropertySymbol) {
                OCInstanceVariableSymbol newIvar = this.myNewIvars.get(member);
                if (existingDecl != null) {
                    if (((OCInstanceVariableSymbol)existingSymbol).getVisibility().ordinal() <= newIvar.getVisibility().ordinal()) continue;
                    SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(existingDecl);
                    this.myElemsToEscalateVisibility.put(pointer, (Pair<OCSymbol, OCVisibility>)new Pair((Object)existingSymbol, (Object)newIvar.getVisibility()));
                    continue;
                }
                if (newDeclaration == null) continue;
                OCClassDeclaration parent = (OCClassDeclaration)(newIvar.getVisibility() == OCVisibility.PRIVATE || anInterface == null ? classDeclaration : anInterface);
                this.myNewDeclarations.put(member, mover.addInstanceVariable(parent, newIvar, (OCDeclaration)newDeclaration));
                continue;
            }
            if (existingDecl != null || newDeclaration == null) continue;
            this.myNewDeclarations.put(member, OCChangeUtil.add(classDeclaration, newDeclaration));
        }
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            String newSymbolName = this.myNewMembersNames.get(((ConvertUsage)usage).getSymbol());
            this.changeUsage(element, newSymbolName);
        }
        if (implDeclaration != null && this.mySynthesizes != null) {
            for (OCSynthesizePropertiesList synthesize : this.mySynthesizes) {
                OCChangeUtil.add(implDeclaration, synthesize);
            }
        }
        PsiFile file = classDeclaration.getContainingFile();
        for (PsiElement element : elementsToRemove) {
            if (element == null || !element.isValid()) continue;
            OCChangeUtil.delete(element);
        }
        if (this.myReleaseAction != null) {
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
            OCFile associatedFile = ((OCFile)file).getAssociatedFile();
            if (associatedFile != null) {
                document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)associatedFile);
                PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(document);
            }
            this.myReleaseAction.invoke(this.myProject, null, file);
        }
    }

    protected void performPsiSpoilingRefactoring() {
        OCBindUtil.escalateVisibilities(this.myProject, this.myElemsToEscalateVisibility, new VirtualFile[0]);
    }

    private PsiElement changeUsage(PsiElement element, String newSymbolName) {
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return element;
        }
        if (element instanceof OCQualifiedExpression) {
            if (!this.myConvertUsages) {
                ((OCQualifiedExpression)element).setName(newSymbolName);
                return element;
            }
            OCExpression qualifier = ((OCQualifiedExpression)element).getQualifier();
            if (this.myNewQualifierType == OCTokenTypes.DEREF && qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText(newSymbolName, element));
            }
            ((OCQualifiedExpression)element).setName(newSymbolName);
            PsiElement qualifyingToken = ((OCQualifiedExpression)element).getQualifyingToken().getPsi();
            OCChangeUtil.replaceHandlingMacros(qualifyingToken, this.myNewQualifyingToken);
            return element;
        }
        if (element instanceof OCReferenceElement) {
            if (!this.myConvertUsages) {
                ((OCReferenceElement)element).setNameOfIdentifier(newSymbolName);
                return element;
            }
            if (element.getParent() instanceof OCSynthesizeProperty) {
                OCChangeUtil.delete(element.getParent());
                return null;
            }
            assert (this.myNewQualifierType == OCTokenTypes.DOT);
            return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText("self." + newSymbolName, element));
        }
        if (element instanceof OCSendMessageExpression) {
            List<OCExpression> arguments = ((OCSendMessageExpression)element).getArgumentExpressions();
            OCExpression receiver = ((OCSendMessageExpression)element).getReceiverExpression();
            if (arguments.isEmpty()) {
                if (receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                    return OCChangeUtil.replaceHandlingMacros(element, OCElementFactory.expressionFromText(newSymbolName, element));
                }
                OCQualifiedExpression expression = (OCQualifiedExpression)OCElementFactory.expressionFromText("a->" + newSymbolName, element);
                OCChangeUtil.replaceHandlingMacros(expression.getQualifier(), receiver);
                return OCChangeUtil.replaceHandlingMacros(element, expression);
            }
            assert (arguments.size() == 1);
            if (receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                OCAssignmentExpression expression = (OCAssignmentExpression)OCElementFactory.expressionFromText(newSymbolName + "=a", element);
                OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), arguments.get(0));
                return OCChangeUtil.replaceHandlingMacros(element, expression);
            }
            OCAssignmentExpression expression = (OCAssignmentExpression)OCElementFactory.expressionFromText("a->" + newSymbolName + "=a", element);
            OCChangeUtil.replaceHandlingMacros(expression.getSourceExpression(), arguments.get(0));
            OCChangeUtil.replaceHandlingMacros(((OCQualifiedExpression)expression.getReceiverExpression()).getQualifier(), receiver);
            return OCChangeUtil.replaceHandlingMacros(element, expression);
        }
        return null;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            OCConvertMemberRefactoringProcessor.$$$reportNull$$$0(4);
        }
        if (!this.isReplaceMode()) {
            return super.preprocessUsages(refUsages);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        HashMap<String, Object> uniqueConflicts = new HashMap<String, Object>();
        for (OCMemberSymbol member : this.myMembers) {
            CommonProcessors.FindFirstProcessor accessorFinder = new CommonProcessors.FindFirstProcessor();
            CommonProcessors.FindFirstProcessor overloadFinder = new CommonProcessors.FindFirstProcessor();
            OCCompilationContext compilationContext = OCCompilationContext.create(member, this.myProject);
            if (member instanceof OCPropertySymbol && !((OCPropertySymbol)member).processAccessorMethods((Processor<? super OCMethodSymbol>)accessorFinder, false, this.myProject)) {
                uniqueConflicts.put(member.getNameWithKindUppercase(compilationContext) + " has custom accessor methods", ((OCMethodSymbol)accessorFinder.getFoundValue()).locateDefinition(this.myProject));
                this.myMembersWithConflicts.add(member);
            }
            if (member instanceof OCPropertySymbol && !OCSearchUtil.processMembersHierarchy(member, overloadFinder, true, false, false, this.myProject)) {
                uniqueConflicts.put(member.getNameWithKindUppercase(compilationContext) + " overrides the property from the " + ((OCClassSymbol)((OCMemberSymbol)overloadFinder.getFoundValue()).getParent()).getNameWithKindLowercase(compilationContext), ((OCMemberSymbol)overloadFinder.getFoundValue()).locateDefinition(this.myProject));
                this.myMembersWithConflicts.add(member);
                continue;
            }
            if (!(member instanceof OCPropertySymbol) || OCSearchUtil.processMembersHierarchy(member, overloadFinder, false, true, false, this.myProject)) continue;
            uniqueConflicts.put(member.getNameWithKindUppercase(compilationContext) + " is overridden in the " + ((OCClassSymbol)((OCMemberSymbol)overloadFinder.getFoundValue()).getParent()).getNameWithKindLowercase(compilationContext), ((OCMemberSymbol)overloadFinder.getFoundValue()).locateDefinition(this.myProject));
            this.myMembersWithConflicts.add(member);
        }
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            Object symbol = ((ConvertUsage)usage).getSymbol();
            OCCompilationContext compilationContext = OCCompilationContext.create(symbol, this.myProject);
            if (element instanceof OCSelectorExpression) {
                uniqueConflicts.put(symbol.getNameWithKindUppercase(compilationContext) + " has @selector references", element);
                this.myMembersWithConflicts.add(symbol);
                continue;
            }
            if (usage.getReference() instanceof OCExternalReference) {
                String componentName = ((OCExternalReference)usage.getReference()).getExternalComponentName();
                uniqueConflicts.put(symbol.getNameWithKindUppercase(compilationContext) + " has " + componentName + " references", element);
                this.myMembersWithConflicts.add(symbol);
                continue;
            }
            if (element == null || !"Swift".equals(element.getLanguage().getDisplayName())) continue;
            conflicts.putValue((Object)element, (Object)"Property is accessed from Swift");
            this.myMembersWithConflicts.add(symbol);
        }
        for (String string : uniqueConflicts.keySet()) {
            conflicts.putValue(uniqueConflicts.get(string), (Object)string);
        }
        return this.showConflicts(conflicts, usages);
    }

    @NotNull
    protected String getCommandName() {
        String string = this.myCommandName;
        if (string == null) {
            OCConvertMemberRefactoringProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/OCConvertMemberRefactoringProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCConvertMemberRefactoringProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertUsage<M extends OCMemberSymbol>
    extends UsageInfo {
        private M mySymbol;

        public ConvertUsage(@NotNull PsiReference reference, M symbol) {
            if (reference == null) {
                ConvertUsage.$$$reportNull$$$0(0);
            }
            super(reference);
            this.mySymbol = symbol;
        }

        public M getSymbol() {
            return this.mySymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/refactoring/OCConvertMemberRefactoringProcessor$ConvertUsage", "<init>"));
        }
    }
}

