/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.refactoring.OCExtractMethodProcessor;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;

public class OCExtractMethodHandler
implements RefactoringActionHandler {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"extract.method.title");

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file, DataContext dataContext) {
        if (project2 == null) {
            OCExtractMethodHandler.$$$reportNull$$$0(0);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        SelectionModel model2 = editor.getSelectionModel();
        if (!model2.hasSelection()) {
            model2.selectLineAtCaret();
        }
        int startOffset = model2.getSelectionStart();
        int endOffset = model2.getSelectionEnd();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        OCExpression expr = OCCodeInsightUtil.findExpressionAtRange(file, startOffset, endOffset);
        if (expr != null) {
            OCExtractMethodHandler.extractExpression(project2, editor, dataContext, expr);
            return;
        }
        PsiElement[] statements = OCCodeInsightUtil.findStatementsAtRange(file, startOffset, endOffset, true);
        if (statements != null && statements.length > 0) {
            new OCExtractMethodProcessor(statements, project2, new TextRange(startOffset, endOffset), dataContext).invoke(editor);
            return;
        }
        endOffset = CharArrayUtil.shiftBackward((CharSequence)editor.getDocument().getCharsSequence(), (int)(endOffset - 1), (String)" \t\n;") + 1;
        expr = OCCodeInsightUtil.findExpressionAtRange(file, startOffset, endOffset);
        if (expr != null) {
            OCExtractMethodHandler.extractExpression(project2, editor, dataContext, expr);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Selected block should represent a set of statements or an expression", (String)REFACTORING_NAME, null);
        }
    }

    private static void extractExpression(Project project2, Editor editor, DataContext dataContext, OCExpression expr) {
        if (!(expr.getParent() instanceof OCExpressionStatement) && expr.getResolvedType().getGuessedType() == OCUnknownType.INSTANCE) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)"Cannot determine type of the selected expression", (String)REFACTORING_NAME, null);
        } else {
            new OCExtractMethodProcessor(new OCExpression[]{expr}, project2, expr.getRangeWithMacros(), dataContext).invoke(editor);
        }
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            OCExtractMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            OCExtractMethodHandler.$$$reportNull$$$0(2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/refactoring/OCExtractMethodHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

