/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.OCErrorAnnotator;
import com.jetbrains.cidr.lang.daemon.OCResolveAnnotator;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCImportsOptimizer
implements ImportOptimizer {
    public boolean supports(PsiFile file) {
        return file instanceof OCFile;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            OCImportsOptimizer.$$$reportNull$$$0(0);
        }
        if (!(file instanceof OCFile) || !OCImportsOptimizer.shouldOptimizeImports(file)) {
            Runnable runnable2 = EmptyRunnable.INSTANCE;
            if (runnable2 == null) {
                OCImportsOptimizer.$$$reportNull$$$0(1);
            }
            return runnable2;
        }
        List<OCIncludeDirective> imports = OCImportsOptimizer.getUnusedImports((OCFile)file);
        OCRemoveElementsIntentionAction action = new OCRemoveElementsIntentionAction(imports, "", "");
        Runnable runnable3 = () -> {
            if (file == null) {
                OCImportsOptimizer.$$$reportNull$$$0(4);
            }
            action.invoke(file.getProject(), null, file);
        };
        if (runnable3 == null) {
            OCImportsOptimizer.$$$reportNull$$$0(2);
        }
        return runnable3;
    }

    public static boolean shouldOptimizeImports(@NotNull PsiFile file) {
        if (file == null) {
            OCImportsOptimizer.$$$reportNull$$$0(3);
        }
        return OCInclusionContextUtil.isRoot(file);
    }

    public static List<OCIncludeDirective> getUnusedImports(OCFile file) {
        return OCImportsOptimizer.runAnnotatorAndGetImports(file, Collections.singletonList(file), false, true);
    }

    public static List<OCIncludeDirective> getUnusedImports(OCFile file, Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return OCImportsOptimizer.runAnnotatorAndGetImports(file, elements, false, false);
    }

    public static List<OCIncludeDirective> getUsedImports(OCFile file, Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        return OCImportsOptimizer.runAnnotatorAndGetImports(file, elements, true, false);
    }

    private static List<OCIncludeDirective> runAnnotatorAndGetImports(OCFile file, Collection<? extends PsiElement> elements, boolean used, boolean requiredAsUsed) {
        final OCResolveAnnotator resolveAnnotator = new OCResolveAnnotator();
        final OCErrorAnnotator errorAnnotator = new OCErrorAnnotator();
        final AnnotationSession session = new AnnotationSession((PsiFile)file);
        file.pushAnnotationSession(session);
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof OCSymbolHolderVirtualPsiElement) {
                OCFileSymbols.markImportNeeded(file, ((OCSymbolHolderVirtualPsiElement)psiElement).getSymbol());
                continue;
            }
            assert (psiElement.getContainingFile() == file);
            psiElement.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    resolveAnnotator.annotate(element, null, session);
                    errorAnnotator.annotate(element, null, session);
                }
            });
        }
        List<OCIncludeDirective> result = OCImportsOptimizer.doGetImports(file, used, requiredAsUsed);
        file.popAnnotationSession();
        return result;
    }

    public static List<OCIncludeDirective> doGetImports(OCFile file, boolean used, boolean requiredAsUsed) {
        ArrayList<OCIncludeDirective> result = new ArrayList<OCIncludeDirective>();
        HashSet<VirtualFile> usedFiles = new HashSet<VirtualFile>();
        for (OCIncludeDirective directive : file.findIncludeDirectives()) {
            if (!OCCodeInsightUtil.isValid(directive) || !directive.isTopLevel() || !directive.getContainingFile().equals(file)) continue;
            PsiFile importedFile = directive.getIncludedFile();
            VirtualFile filePath = OCElementUtil.getFilePath(importedFile);
            if (!(importedFile instanceof OCFile) || filePath == null) continue;
            if ((OCFileSymbols.isImportUsed(file, filePath) || requiredAsUsed && OCFileSymbols.isImportRequired(file, filePath)) && !usedFiles.contains(filePath)) {
                usedFiles.add(filePath);
                if (!used) continue;
                result.add(directive);
                continue;
            }
            if (used) continue;
            result.add(directive);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/OCImportsOptimizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCImportsOptimizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldOptimizeImports";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

