/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNameSuggester {
    public static final String BOOLEAN_SHORT_NAME = "b";
    public static final String INT_SHORT_NAME = "i";
    public static final String DOUBLE_SHORT_NAME = "d";
    public static final String STRING_SHORT_NAME = "string";
    public static final String AUTO_SHORT_NAME = "item";
    public static final String POINTER_SHORT_NAME = "ptr";
    public static final String OBJECT_SHORT_NAME = "o";
    public static final String FUNCTION_SHORT_NAME = "fun";
    public static final String UDL_SHORT_NAME = "_op";
    public static final String VOID_SHORT_NAME = "v";
    public static final String BOOLEAN_LONG_NAME = "boolean";
    public static final String INT_LONG_NAME = "int";
    public static final String DOUBLE_LONG_NAME = "double";
    public static final String OBJECT_LONG_NAME = "object";
    public static final String FUNCTION_LONG_NAME = "function";
    public static final String VOID_LONG_NAME = "void";
    private static String[] GARBAGE_SUFFIXES = new String[]{"Impl", "IMPL", "Ref", "REF", "_t"};
    private static String[] SHORT_NAMES = new String[]{"b", "i", "d", "string", "ptr", "o", "fun", "_op", "v", "item"};
    private static final String EMPTY_PREFIX = "";

    private OCNameSuggester() {
    }

    public static Collection<String> suggestForDeclaration(OCDeclarator subj, boolean unique, @NotNull Collection<String> predefinedNames) {
        if (predefinedNames == null) {
            OCNameSuggester.$$$reportNull$$$0(0);
        }
        HashSet whiteList = ContainerUtil.newHashSet(predefinedNames);
        HashSet blackList = ContainerUtil.newHashSet();
        Ref symbolKindRef = new Ref();
        Collection<String> candidates = OCNameSuggester.doSuggestForDeclaration(subj, (Ref<OCSymbolKind>)symbolKindRef, whiteList, blackList);
        HashSet result = ContainerUtil.newHashSet(candidates);
        if (unique) {
            blackList.removeAll(whiteList);
            result.retainAll(whiteList);
            HashSet toProcess = ContainerUtil.newHashSet(candidates);
            toProcess.removeAll(whiteList);
            result.addAll(OCNameSuggester.convertToUniqueNames((OCSymbolKind)((Object)symbolKindRef.get()), toProcess, subj, blackList));
        }
        return result;
    }

    private static Collection<String> doSuggestForDeclaration(@NotNull OCDeclarator subj, Ref<OCSymbolKind> symbolKindRef, Collection<String> whiteList, Collection<String> blackList) {
        OCSymbol subjSymbol;
        Object classSymbol;
        PsiElement ifs;
        if (subj == null) {
            OCNameSuggester.$$$reportNull$$$0(1);
        }
        if (subj.getParent() instanceof OCDeclaration && ((OCDeclaration)subj.getParent()).isTypedef()) {
            return Collections.emptyList();
        }
        OCResolveContext context = OCResolveContext.forPsi(subj);
        OCExpression initializer = subj.getInitializer();
        if (initializer != null) {
            return OCNameSuggester.doSuggestForExpression(initializer, context);
        }
        PsiElement declContext = subj.getContext();
        if (declContext != null && (declContext = declContext.getContext()) instanceof OCDeclarationStatement) {
            declContext = declContext.getContext();
        }
        if (declContext instanceof OCForeachStatement) {
            OCExpression collectionExpression = ((OCForeachStatement)declContext).getCollectionExpression();
            LinkedHashSet<String> candidates = new LinkedHashSet<String>();
            for (String collectionSuggestion : OCNameSuggester.doSuggestionForContext(collectionExpression)) {
                String unplured = StringUtil.unpluralize((String)collectionSuggestion);
                candidates.add(unplured != null ? unplured : collectionSuggestion);
            }
            candidates.addAll(OCNameSuggester.doSuggestForType(subj.getType(), EMPTY_PREFIX, context));
            return candidates;
        }
        if (declContext instanceof OCProperty) {
            Object classSymbol2;
            ifs = declContext.getParent();
            if (ifs instanceof OCSymbolDeclarator && (classSymbol2 = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
                symbolKindRef.set((Object)OCSymbolKind.PROPERTY);
                return OCNameSuggester.suggestForProperty(subj, (OCClassSymbol)classSymbol2, whiteList, blackList, context);
            }
        } else if (declContext instanceof OCInstanceVariablesList && (ifs = declContext.getParent()) instanceof OCSymbolDeclarator && (classSymbol = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
            symbolKindRef.set((Object)OCSymbolKind.INSTANCE_VARIABLE);
            return OCNameSuggester.suggestForIvar(subj, (OCClassSymbol)classSymbol, blackList, context);
        }
        if ((subjSymbol = subj.getSymbol()) instanceof OCFunctionSymbol && ((OCFunctionSymbol)subjSymbol).isUDL()) {
            return OCNameSuggester.doSuggestForSimpleType(UDL_SHORT_NAME, UDL_SHORT_NAME, EMPTY_PREFIX);
        }
        return OCNameSuggester.doSuggestForType(subj.getType(), EMPTY_PREFIX, context);
    }

    private static Collection<String> suggestForIvar(OCDeclarator declarator, OCClassSymbol classSymbol, Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(2);
        }
        THashSet names = new THashSet();
        Project project2 = context.getProject();
        OCInterfaceSymbol mi = classSymbol.getMainInterface(project2);
        String auxCategoryName = classSymbol instanceof OCInterfaceSymbol ? classSymbol.getCategoryName() : EMPTY_PREFIX;
        OCClassSymbol mainInterface = mi == null ? classSymbol : mi;
        Processor propertyProcessor = arg_0 -> OCNameSuggester.lambda$suggestForIvar$0(project2, declarator, context, (Set)names, arg_0);
        Processor<OCSymbol> iVarProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        mainInterface.processCategories((Processor<? super OCClassSymbol>)((Processor)ifs -> {
            if (StringUtil.compare((String)ifs.getCategoryName(), (String)auxCategoryName, (boolean)false) == 0 || ifs == mainInterface) {
                ifs.processMembers(OCPropertySymbol.class, propertyProcessor);
                ifs.processMembers(OCInstanceVariableSymbol.class, iVarProcessor);
            }
            return true;
        }), true, null, project2);
        for (String name2 : OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context)) {
            names.add(OCNameSuggester.getNonCollidingName(name2, OCSymbolKind.PROPERTY, true, declarator.getProject()));
        }
        return names;
    }

    private static Collection<String> suggestForProperty(@NotNull OCDeclarator declarator, @NotNull OCClassSymbol interfaceSymbol, Collection<String> whiteList, Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        OCImplementationSymbol implementation;
        if (declarator == null) {
            OCNameSuggester.$$$reportNull$$$0(3);
        }
        if (interfaceSymbol == null) {
            OCNameSuggester.$$$reportNull$$$0(4);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(5);
        }
        THashSet names = new THashSet();
        Processor ivarProcessor = arg_0 -> OCNameSuggester.lambda$suggestForProperty$2(declarator, context, (Set)names, whiteList, arg_0);
        Processor<OCSymbol> propertyProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        interfaceSymbol.processCategories((Processor<? super OCClassSymbol>)((Processor)interfaceSymbol1 -> {
            String category = interfaceSymbol1.getCategoryName();
            if (category == null || category.isEmpty()) {
                interfaceSymbol1.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
                interfaceSymbol1.processMembers(OCPropertySymbol.class, propertyProcessor);
            }
            return true;
        }), true, null, context.getProject());
        String categoryName = interfaceSymbol.getCategoryName();
        if ((categoryName == null || categoryName.isEmpty()) && (implementation = interfaceSymbol.getMainImplementation(declarator.getProject())) != null) {
            implementation.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
        }
        names.addAll(OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context));
        return names;
    }

    private static Processor<OCSymbol> namesCollectProcessor(Collection<String> names, @NotNull OCElement excludedElement) {
        if (excludedElement == null) {
            OCNameSuggester.$$$reportNull$$$0(6);
        }
        return symbol -> {
            Object ivarDecl;
            if (excludedElement == null) {
                OCNameSuggester.$$$reportNull$$$0(20);
            }
            if ((ivarDecl = symbol.locateDefinition(excludedElement.getProject())) != null && ivarDecl.getTextOffset() != excludedElement.getTextOffset()) {
                names.add(symbol.getName());
            }
            return true;
        };
    }

    public static Collection<String> suggestForExpression(@Nullable OCSymbolKind symbolKind, OCExpression expr) {
        final ArrayList<String> forbiddenNames = new ArrayList<String>();
        expr.accept(new OCRecursiveVisitor(){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                if (referenceElement.resolveToSymbol() != null) {
                    forbiddenNames.add(referenceElement.getName());
                }
            }
        });
        return OCNameSuggester.convertToUniqueNames(symbolKind, OCNameSuggester.doSuggestForExpression(expr, OCResolveContext.forPsi(expr)), expr, forbiddenNames);
    }

    private static Collection<String> doSuggestForExpression(OCExpression expr, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(7);
        }
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        OCExpression topmost = OCParenthesesUtils.topmostParenthesized(expr);
        answer.addAll(OCNameSuggester.doSuggestForExpressionContext(topmost, topmost.getParent()));
        answer.addAll(OCNameSuggester.doSuggestForType(expr.getType().getGuessedType(), EMPTY_PREFIX, context));
        answer.addAll(OCNameSuggester.doSuggestionForContext(OCParenthesesUtils.diveIntoParentheses(expr)));
        return answer;
    }

    private static List<String> doSuggestForExpressionContext(OCExpression expr, PsiElement context) {
        List<OCDeclaratorSymbol> symbols;
        OCSymbol fun;
        int index;
        PsiElement arglistParent;
        if (context instanceof OCMessageArgument) {
            OCMethodSymbol.SelectorPartSymbol selector;
            OCDeclaratorSymbol parameter;
            List<OCMethodSymbol.SelectorPartSymbol> selectors;
            OCMethodSymbol responder;
            OCSendMessageExpression call = (OCSendMessageExpression)context.getParent();
            int index2 = call.getArguments().indexOf(context);
            if (index2 >= 0 && (responder = call.getProbableResponders().getKnownResponder()) != null && index2 < (selectors = responder.getSelectors()).size() && (parameter = (selector = selectors.get(index2)).getParameter()) != null) {
                return OCNameSuggester.doGetSuggestionsByName(parameter.getName(), EMPTY_PREFIX);
            }
        } else if (context instanceof OCArgumentList && (arglistParent = context.getParent()) instanceof OCCallExpression && (index = ((OCCallExpression)arglistParent).getArguments().indexOf(expr)) >= 0 && (fun = OCGetSymbolVisitor.getSymbol(((OCCallExpression)arglistParent).getFunctionReferenceExpression())) instanceof OCFunctionSymbol && index < (symbols = ((OCFunctionSymbol)fun).getParameterSymbols()).size()) {
            return OCNameSuggester.doGetSuggestionsByName(symbols.get(index).getName(), EMPTY_PREFIX);
        }
        return Collections.emptyList();
    }

    private static List<String> doSuggestionForContext(@Nullable OCExpression expr) {
        if (expr instanceof OCReferenceExpression && ((OCReferenceExpression)expr).getSelfSuperToken() == null) {
            return OCNameSuggester.doGetSuggestionsByName(expr.getTextWithMacros(), EMPTY_PREFIX);
        }
        if (expr instanceof OCQualifiedExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCQualifiedExpression)expr).getName(), EMPTY_PREFIX);
        }
        if (expr instanceof OCSendMessageExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCSendMessageExpression)expr).getMessageSelector(), EMPTY_PREFIX);
        }
        if (expr instanceof OCCallExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCCallExpression)expr).getFunctionReferenceExpression().getTextWithMacros(), EMPTY_PREFIX);
        }
        return Collections.emptyList();
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(8);
        }
        return OCNameSuggester.convertToUniqueNames(null, OCNameSuggester.doSuggestForType(type, EMPTY_PREFIX, context), scope, forbiddenNames);
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement scope, String prefix, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(9);
        }
        return OCNameSuggester.convertToUniqueNames(null, OCNameSuggester.doSuggestForType(type, prefix, context), scope, Collections.emptyList());
    }

    public static Collection<String> suggestForType(OCSymbolKind symbolKind, OCType type, @Nullable PsiElement scope, String prefix, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(10);
        }
        return OCNameSuggester.convertToUniqueNames(symbolKind, OCNameSuggester.doSuggestForType(type, prefix, context), scope, Collections.emptyList());
    }

    private static Collection<String> doSuggestForType(OCType type, String prefix, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(11);
        }
        if (type == null) {
            return Collections.emptyList();
        }
        if (OCIntType.isBool(type, context)) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        if (type instanceof OCIntType) {
            return OCNameSuggester.doSuggestForSimpleType(INT_SHORT_NAME, INT_LONG_NAME, prefix);
        }
        if (type instanceof OCRealType) {
            return OCNameSuggester.doSuggestForSimpleType(DOUBLE_SHORT_NAME, DOUBLE_LONG_NAME, prefix);
        }
        if (type.isCString()) {
            return OCNameSuggester.doGetSuggestionsByName(STRING_SHORT_NAME, prefix);
        }
        if (type instanceof OCPointerType) {
            OCType ref = ((OCPointerType)type).getRefType();
            Collection<String> raw = OCNameSuggester.doSuggestForType(ref, !prefix.isEmpty() || ref instanceof OCObjectType || ref instanceof OCReferenceType ? prefix : "p", context);
            return raw.isEmpty() ? Collections.singleton(POINTER_SHORT_NAME) : raw;
        }
        if (type instanceof OCObjectType) {
            OCClassSymbol smb = ((OCObjectType)type).getClassSymbol();
            if (smb == null) {
                return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
            }
            return OCNameSuggester.doSuggestionsByTypeName(smb.getName(), prefix);
        }
        if (type instanceof OCFunctionType) {
            return OCNameSuggester.doSuggestForSimpleType(FUNCTION_SHORT_NAME, FUNCTION_LONG_NAME, prefix);
        }
        if (type instanceof OCVoidType) {
            return OCNameSuggester.doSuggestForSimpleType(VOID_SHORT_NAME, VOID_LONG_NAME, prefix);
        }
        if (type instanceof OCAutoType) {
            return OCNameSuggester.doSuggestForSimpleType(AUTO_SHORT_NAME, AUTO_SHORT_NAME, prefix);
        }
        if (type instanceof OCReferenceType) {
            return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
        }
        if (type instanceof OCStructType) {
            return OCNameSuggester.doSuggestionsByTypeName(((OCStructType)type).getSymbol().getName(), prefix);
        }
        if (type instanceof OCCppReferenceType) {
            return OCNameSuggester.doSuggestForType(((OCCppReferenceType)type).getRefType(), prefix, context);
        }
        if (type instanceof OCVariadicType) {
            return OCNameSuggester.doSuggestForType(((OCVariadicType)type).getUnderlyingType(), prefix, context);
        }
        if (type instanceof OCMagicType) {
            return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
        }
        return Collections.emptyList();
    }

    private static Collection<String> doSuggestionsByTypeName(String typeName, String prefix) {
        int pos = typeName.indexOf(60);
        if (pos != -1) {
            typeName = typeName.substring(0, pos);
        }
        if (typeName.equals("id")) {
            return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
        }
        if (typeName.equals("BOOL")) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        typeName = StringUtil.trimStart((String)typeName, (String)"NS");
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)OCNameSuggester.stripSuffixes(typeName), (String)"const"), prefix);
    }

    private static Collection<String> doSuggestForSimpleType(String shortName, String longName, String prefix) {
        return Collections.singleton(!prefix.isEmpty() ? prefix + StringUtil.capitalize((String)longName) : shortName);
    }

    private static String stripSuffixes(String suggestion) {
        for (String suff : GARBAGE_SUFFIXES) {
            if (!StringUtil.endsWith((CharSequence)suggestion, (CharSequence)suff)) continue;
            return OCNameSuggester.stripSuffixes(suggestion.substring(0, suggestion.length() - suff.length()));
        }
        return suggestion;
    }

    private static List<String> doGetSuggestionsByName(String name2, String prefix) {
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)name2, (String)"get"), false, prefix, EMPTY_PREFIX);
    }

    private static List<String> doGetSuggestionsByName(String name2, boolean uppercaseStyle, String prefix, String suffix) {
        List raw = NameUtil.getSuggestionsByName((String)name2, (String)prefix, (String)suffix, (boolean)uppercaseStyle, (boolean)false, (boolean)false);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : raw) {
            String s = OCNameSuggester.changeIfNotIdentifier(suggestion);
            if (!OCNamesValidator.isIdentifier(s) || OCNamesValidator.isKeyword(s)) continue;
            answer.add(s);
        }
        return answer;
    }

    @NonNls
    private static String changeIfNotIdentifier(String name2) {
        if (!OCNamesValidator.isIdentifier(name2 = StringUtil.trimEnd((String)name2, (String)":"))) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name2);
        }
        return name2;
    }

    public static String suggestUniqueName(OCSymbol symbol, PsiElement scope) {
        return OCNameSuggester.suggestUniqueName(symbol.getKind(), symbol.getName(), scope);
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, PsiElement scope) {
        return OCNameSuggester.suggestUniqueName(symbolKind, baseName, scope, Collections.emptyList());
    }

    public static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, @Nullable PsiElement scope, Collection<String> forbiddenNames) {
        return OCNameSuggester.suggestUniqueName(symbolKind, baseName, scope != null ? Collections.singletonList(scope) : Collections.emptyList(), forbiddenNames);
    }

    private static String suggestUniqueName(@Nullable OCSymbolKind symbolKind, String baseName, List<PsiElement> scopes, Collection<String> forbiddenNames) {
        int count = 0;
        while (true) {
            String candidate = count > 0 ? baseName + count : baseName;
            boolean isUnique = true;
            if (forbiddenNames.contains(candidate)) {
                isUnique = false;
            }
            for (PsiElement scope : scopes) {
                if (scope == null || OCCodeInsightUtil.isUniqueInScope(symbolKind, candidate, scope, scope.getProject())) continue;
                isUnique = false;
                break;
            }
            if (isUnique) {
                return candidate;
            }
            ++count;
        }
    }

    private static Collection<String> convertToUniqueNames(@Nullable OCSymbolKind symbolKind, Collection<String> candidates, @Nullable PsiElement scope, Collection<String> forbiddenNames) {
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        LinkedHashSet<String> augmented = new LinkedHashSet<String>();
        for (String candidate : candidates) {
            String unique = OCNameSuggester.suggestUniqueName(symbolKind, candidate, scope, forbiddenNames);
            if (Comparing.equal((String)unique, (String)candidate)) {
                answer.add(unique);
                continue;
            }
            augmented.add(unique);
        }
        answer.addAll(augmented);
        return answer;
    }

    public static String removeVariablePrefixes(String name2) {
        if (name2.startsWith("an")) {
            name2 = StringUtil.decapitalize((String)name2.substring(2));
        } else if (name2.startsWith("a") || name2.startsWith("_")) {
            name2 = StringUtil.decapitalize((String)name2.substring(1));
        }
        return name2;
    }

    public static String removeSelectorPrefixes(String selectorPart) {
        if (selectorPart.startsWith("and")) {
            selectorPart = StringUtil.decapitalize((String)selectorPart.substring(3));
        }
        return selectorPart;
    }

    public static String suggestForParameter(Collection<String> prevParamNames, boolean isFirstSelector, String selector, OCType type, @Nullable OCMethodSymbol method, @Nullable OCExpression expression, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(12);
        }
        String paramName = isFirstSelector || selector.equals(":") ? OCNameSuggester.suggestForParameter(prevParamNames, type, expression, context) : (selector.endsWith(":") ? StringUtil.decapitalize((String)OCNameSuggester.getLastSubword(selector.substring(0, selector.length() - 1))) : "param");
        ArrayList<PsiElement> contexts = new ArrayList<PsiElement>();
        if (method != null) {
            Project project2 = context.getProject();
            method.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                Object definition = symbol.locateDefinition(project2);
                if (definition != null) {
                    contexts.add((PsiElement)definition);
                }
                return true;
            }), project2);
        }
        return OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, paramName, contexts, prevParamNames);
    }

    public static String suggestForParameter(Collection<String> forbiddenNames, OCType type, @Nullable OCExpression expression, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(13);
        }
        Collection<String> suggestedNames = new ArrayList<String>(OCNameSuggester.doSuggestForType(type, EMPTY_PREFIX, context));
        suggestedNames.addAll(OCNameSuggester.doSuggestionForContext(expression));
        suggestedNames = OCNameSuggester.convertToUniqueNames(null, suggestedNames, null, forbiddenNames);
        for (String name2 : suggestedNames) {
            if (ArrayUtil.contains((String)name2, (String[])SHORT_NAMES)) continue;
            return name2;
        }
        return suggestedNames.isEmpty() ? "param" : suggestedNames.iterator().next();
    }

    public static String getLastSubword(String word) {
        String[] subwords = NameUtil.nameToWords((String)word);
        String result = EMPTY_PREFIX;
        for (int i = subwords.length - 1; i >= 0; --i) {
            result = subwords[i] + result;
            if (!StringUtil.isJavaIdentifier((String)result)) continue;
            return result;
        }
        return word;
    }

    public static String getSelectorNameWithoutParameter(String firstSelector, @Nullable String paramName) {
        if (paramName == null) {
            return firstSelector;
        }
        if (firstSelector.endsWith(StringUtil.capitalize((String)(paramName = OCNameSuggester.removeVariablePrefixes(paramName))))) {
            firstSelector = firstSelector.substring(0, firstSelector.length() - paramName.length());
        }
        return firstSelector;
    }

    public static String getNonCollidingName(OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCNameSuggester.$$$reportNull$$$0(14);
        }
        return OCNameSuggester.getNonCollidingName(symbol, false, project2);
    }

    public static String getNonCollidingName(OCSymbol symbol, boolean allowCollision, @NotNull Project project2) {
        if (project2 == null) {
            OCNameSuggester.$$$reportNull$$$0(15);
        }
        return OCNameSuggester.getNonCollidingName(symbol.getName(), symbol.getKind(), allowCollision, project2);
    }

    public static String getNonCollidingName(String name2, OCSymbolKind symbolKind, boolean allowCollision, Project project2) {
        String suffix;
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        String prefix = settings != null ? settings.IVARS_PREFIX : "_";
        String string = suffix = settings != null ? settings.IVARS_SUFFIX : EMPTY_PREFIX;
        if (symbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            String newName = OCNameSuggester.getNameWithoutPrefixAndSuffix(name2, prefix, suffix);
            if (newName.equals(name2) && !allowCollision) {
                return StringUtil.fixVariableNameDerivedFromPropertyName((String)name2);
            }
            return newName;
        }
        if (symbolKind == OCSymbolKind.PROPERTY) {
            return OCNameSuggester.getNameWithPrefixAndSuffix(name2, prefix, suffix);
        }
        if (!allowCollision) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name2);
        }
        return name2;
    }

    private static String getNameWithPrefixAndSuffix(String name2, String prefix, String suffix) {
        boolean isLetterPrefix;
        boolean bl = isLetterPrefix = !prefix.isEmpty() && Character.isLetter(prefix.charAt(prefix.length() - 1));
        if (isLetterPrefix) {
            return prefix + StringUtil.capitalize((String)name2) + suffix;
        }
        return prefix + name2 + suffix;
    }

    private static String getNameWithoutPrefixAndSuffix(String name2, String prefix, String suffix) {
        boolean isLetterPrefix;
        boolean bl = isLetterPrefix = !prefix.isEmpty() && Character.isLetter(prefix.charAt(prefix.length() - 1));
        if (name2.length() > prefix.length() && prefix.length() + suffix.length() > 0 && (isLetterPrefix ? OCElementUtil.startsWithWord(name2, prefix) : name2.startsWith(prefix))) {
            String result = name2.substring(prefix.length());
            if (isLetterPrefix) {
                result = StringUtil.decapitalize((String)result);
            }
            if (result.endsWith(suffix) && result.length() > suffix.length()) {
                result = result.substring(0, result.length() - suffix.length());
            }
            if (OCNamesValidator.isKeyword(result)) {
                return StringUtil.fixVariableNameDerivedFromPropertyName((String)result);
            }
            return result;
        }
        return name2;
    }

    @NotNull
    public static String getClang4ImplicitIvarName(String propertyName) {
        String string = "_" + propertyName;
        if (string == null) {
            OCNameSuggester.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nullable
    public static String getClang4PropertyName(String implicitIvarName) {
        return implicitIvarName.startsWith("_") ? implicitIvarName.substring(1) : null;
    }

    public static String getCppFieldNameWithoutPrefixAndSuffix(OCDeclaratorSymbol field, @NotNull Project project2) {
        OCCodeStyleSettings settings;
        if (project2 == null) {
            OCNameSuggester.$$$reportNull$$$0(17);
        }
        String prefix = (settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class)) != null ? settings.FIELDS_PREFIX : EMPTY_PREFIX;
        String suffix = settings != null ? settings.FIELDS_SUFFIX : EMPTY_PREFIX;
        return OCNameSuggester.getNameWithoutPrefixAndSuffix(field.getName(), prefix, suffix);
    }

    public static String getCppGetterName(OCDeclaratorSymbol field, @NotNull Project project2) {
        String fieldName;
        OCCodeStyleSettings settings;
        if (project2 == null) {
            OCNameSuggester.$$$reportNull$$$0(18);
        }
        String getterPrefix = (settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class)) != null ? settings.GETTERS_PREFIX : "get";
        String name2 = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project2);
        if (name2.equals(fieldName = field.getName()) && getterPrefix.isEmpty()) {
            getterPrefix = "get";
        }
        OCResolveContext context = OCResolveContext.forSymbol(field, project2);
        boolean isBoolField = OCIntType.isBool(field.getResolvedType(context), context);
        if (getterPrefix.equals("get") && isBoolField) {
            getterPrefix = "is";
            if (!name2.equals(fieldName) && OCElementUtil.startsWithWord(StringUtil.decapitalize((String)name2), getterPrefix)) {
                getterPrefix = EMPTY_PREFIX;
                name2 = StringUtil.decapitalize((String)name2);
            }
        }
        if (getterPrefix.equals("Get") && isBoolField) {
            getterPrefix = "Is";
            if (!name2.equals(fieldName) && OCElementUtil.startsWithWord(StringUtil.decapitalize((String)name2), StringUtil.decapitalize((String)getterPrefix))) {
                getterPrefix = EMPTY_PREFIX;
                name2 = StringUtil.capitalize((String)name2);
            }
        }
        return OCNameSuggester.getNameWithPrefixAndSuffix(name2, getterPrefix, EMPTY_PREFIX);
    }

    public static String getCppSetterName(OCDeclaratorSymbol field, @NotNull Project project2) {
        OCCodeStyleSettings settings;
        if (project2 == null) {
            OCNameSuggester.$$$reportNull$$$0(19);
        }
        String setterPrefix = (settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class)) != null ? settings.SETTERS_PREFIX : "set";
        String name2 = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project2);
        if (name2.equals(field.getName()) && setterPrefix.isEmpty()) {
            setterPrefix = "set";
        }
        return OCNameSuggester.getNameWithPrefixAndSuffix(name2, setterPrefix, EMPTY_PREFIX);
    }

    public static boolean isObjCGetter(String name2) {
        return !name2.endsWith(":");
    }

    public static boolean isObjCSetter(String name2) {
        return name2.indexOf(58) == name2.length() - 1;
    }

    public static String getObjCSetterFromGetter(String getter) {
        return "set" + StringUtil.capitalize((String)getter) + ":";
    }

    @Nullable
    public static String getObjCGetterFromSetter(String setter) {
        if (OCElementUtil.startsWithWord(setter, "set") && setter.length() > 4 && OCNameSuggester.isObjCSetter(setter)) {
            return StringUtil.decapitalize((String)setter.substring(3, setter.length() - 1));
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$suggestForProperty$2(@NotNull OCDeclarator declarator, @NotNull OCResolveContext context, Set names, Collection whiteList, OCInstanceVariableSymbol ivar) {
        if (declarator == null) {
            OCNameSuggester.$$$reportNull$$$0(21);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(22);
        }
        if (!OCResolveUtil.isDisabledSymbol(ivar, declarator.getContainingFile()) && ivar.getAssociatedProperty(context.getProject()) == null && declarator.getType().isCompatible(ivar.getType(), context)) {
            String name2 = OCNameSuggester.getNonCollidingName(ivar, true, context.getProject());
            names.add(name2);
            whiteList.add(name2);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$suggestForIvar$0(Project project2, OCDeclarator declarator, @NotNull OCResolveContext context, Set names, OCPropertySymbol propertySymbol) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(23);
        }
        OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar(project2);
        if (propertySymbol.getType().isCompatible(declarator.getType(), context) && (ivar == null || ivar.getGeneratedFromProperty() != null)) {
            names.add(OCNameSuggester.getNonCollidingName(propertySymbol, true, project2));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subj";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceSymbol";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedElement";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/OCNameSuggester";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCNameSuggester";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClang4ImplicitIvarName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestForDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suggestForIvar";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suggestForProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "namesCollectProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForExpression";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestForType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestForParameter";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNonCollidingName";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCppFieldNameWithoutPrefixAndSuffix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCppGetterName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCppSetterName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$namesCollectProcessor$4";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestForProperty$2";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$suggestForIvar$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

