/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureUsageProcessor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameProcessor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    public static Key<Boolean> CHECK_CONFLICTS = Key.create((String)"CHECK_CONFLICTS");
    private OCCallableKind myCallableKind;
    private OCCallable myCallable;
    private String myCommandName;
    private OCRenameProcessor.RenameUsages myOption;

    protected OCChangeSignatureProcessor(Project project2, OCCallableKind callableKind, OCCallable callable, OCChangeInfo changeInfo, String commandName) {
        super(project2, (ChangeInfo)changeInfo);
        this.myCallableKind = callableKind;
        this.myCallable = callable;
        this.myCommandName = commandName;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(0);
        }
        OCUsageViewDescriptor oCUsageViewDescriptor = new OCUsageViewDescriptor(this.myCallable, RefactoringBundle.message((String)"0.to.change.signature", (Object[])new Object[]{this.myCallableKind.toString()}));
        if (oCUsageViewDescriptor == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(1);
        }
        return oCUsageViewDescriptor;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(2);
        }
        MultiMap conflictDescriptions = new MultiMap();
        OCChangeSignatureProcessor.collectConflictsFromExtensions(refUsages, (MultiMap)conflictDescriptions, (ChangeInfo)this.myChangeInfo);
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        RenameUtil.addConflictDescriptions((UsageInfo[])usagesIn, (MultiMap)conflictDescriptions);
        HashSet<UsageInfo> usagesSet = new HashSet<UsageInfo>(Arrays.asList(usagesIn));
        RenameUtil.removeConflictUsages(usagesSet);
        if (!conflictDescriptions.isEmpty() && this.myCallable.getProject().getUserData(CHECK_CONFLICTS) != Boolean.FALSE) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StringBuilder message = new StringBuilder();
                for (String conflict : conflictDescriptions.values()) {
                    if (message.length() != 0) {
                        message.append("; ");
                    }
                    message.append(conflict);
                }
                throw new CommonRefactoringUtil.RefactoringErrorHintException(message.toString());
            }
            ConflictsDialog dialog = this.prepareConflictsDialog(conflictDescriptions, usagesIn);
            if (!dialog.showAndGet()) {
                if (dialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        UsageInfo[] newUsages = usagesSet.toArray(UsageInfo.EMPTY_ARRAY);
        refUsages.set((Object)newUsages);
        this.prepareSuccessful();
        this.myOption = this.myChangeInfo.isNameChanged() ? OCRenameProcessor.validateUsages(this.myCallable, refUsages) : OCRenameProcessor.RenameUsages.RENAME;
        return this.myOption != OCRenameProcessor.RenameUsages.CANCEL;
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(3);
        }
        return super.isPreviewUsages(usages) || this.myOption == OCRenameProcessor.RenameUsages.SHOW_USAGES;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(final @NotNull MultiMap<PsiElement, String> conflicts, final UsageInfo[] usages) {
        if (conflicts == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(4);
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, null){

            protected Runnable getDoRefactoringRunnable(@Nullable UsageView usageView) {
                return () -> {
                    Collection usagesToRefactor = OCChangeSignatureProcessor.getNonExcludedUsageInfos(usages, usageView);
                    OCChangeSignatureProcessor.this.execute(usagesToRefactor.toArray(UsageInfo.EMPTY_ARRAY));
                };
            }

            @NotNull
            protected Action getOKAction() {
                Action action = super.getOKAction();
                for (String conflict : conflicts.values()) {
                    if (OCChangeSignatureUsageProcessor.canProceedWithConflict(conflict)) continue;
                    action.setEnabled(false);
                }
                Action action2 = action;
                if (action2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return action2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureProcessor$1", "getOKAction"));
            }
        };
        if (conflictsDialog == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(5);
        }
        return conflictsDialog;
    }

    private static Collection<? extends UsageInfo> getNonExcludedUsageInfos(UsageInfo[] usages, @Nullable UsageView usageView) {
        MultiMap result = MultiMap.createLinked();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            result.putValue((Object)element, (Object)usage);
        }
        if (usageView != null) {
            for (Usage usage : usageView.getExcludedUsages()) {
                if (!(usage instanceof UsageInfo2UsageAdapter)) continue;
                result.remove((Object)((UsageInfo2UsageAdapter)usage).getElement());
            }
        }
        return result.values();
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        PsiElement method;
        if (usages == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(6);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.changeSignature");
        PsiFile oldContainingFile = ((OCChangeInfo)this.myChangeInfo).getOldMethodDescriptor().getMethod().getContainingFile();
        Arrays.sort(usages, (u1, u2) -> {
            int rank1 = u1 instanceof OCUsageInfo ? ((OCUsageInfo)((Object)u1)).getUsageRank() : 0;
            int rank2 = u2 instanceof OCUsageInfo ? ((OCUsageInfo)((Object)u2)).getUsageRank() : 0;
            return rank2 - rank1;
        });
        RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])ContainerUtil.filter((Object[])usages, info -> info instanceof NonCodeUsageInfo).toArray(new NonCodeUsageInfo[0]));
        super.performRefactoring(usages);
        if (((OCChangeInfo)this.myChangeInfo).getGenerated().getMethodReference() == null && (method = this.myChangeInfo.getMethod()) != null && method.isValid() && !oldContainingFile.equals(method.getContainingFile())) {
            OCCodeInsightUtil.selectElement(method);
        }
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(7);
        }
        ArrayList<PsiFile> elements = new ArrayList<PsiFile>();
        elements.addAll(super.getElementsToWrite(descriptor2));
        elements.addAll(((OCChangeInfo)this.myChangeInfo).getGenerated().getFilesToWrite());
        ArrayList<PsiFile> arrayList = elements;
        if (arrayList == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void runSynchronously() {
        this.doRun();
    }

    @NotNull
    protected String getCommandName() {
        if (this.myCommandName != null) {
            String string = this.myCommandName;
            if (string == null) {
                OCChangeSignatureProcessor.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = super.getCommandName();
        if (string == null) {
            OCChangeSignatureProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConflictsDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

