/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCCallableKind;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCMethodDescriptor;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCBlockDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCGeneratedMethodUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDefinitionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCParameterUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelfSuperUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCUsageInfo;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.refactoring.changeSignature.ChangeSignatureUsageProcessor");
    private static final String BLOCK_CONFLICT = OCBundle.message("changeSignature.usages.cantConvertToBlock", new Object[0]);

    public UsageInfo[] findUsages(ChangeInfo info) {
        if (!(info instanceof OCChangeInfo)) {
            return UsageInfo.EMPTY_ARRAY;
        }
        return OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, false);
    }

    private static UsageInfo[] findUsages(@NotNull OCChangeInfo info, boolean onlyCalls) {
        OCCallable method;
        if (info == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        if (!(method = info.getMethod()).isValid()) {
            return UsageInfo.EMPTY_ARRAY;
        }
        HashSet<UsageInfo> result = new HashSet<UsageInfo>();
        HashSet<OCCallable> visited = new HashSet<OCCallable>();
        if (info.getGenerated().getMethodReference() != null) {
            result.add(new OCGeneratedMethodUsage(info.getGenerated().getMethodReference()));
            if (info.getGenerated().getCallString() != null) {
                result.add(new OCGeneratedCallUsage(info.getGenerated().getMethodReference()));
            }
        }
        OCChangeSignatureUsageProcessor.findAllMethodUsages(info, method, onlyCalls, result, visited, false);
        for (final Pair<Integer, Runnable> pair2 : info.getGenerated().getCallbacks()) {
            result.add(new OCUsageInfo<PsiElement>(info.getContext()){

                @Override
                public boolean processUsage(@NotNull OCChangeInfo changeInfo, @NotNull PsiElement element, @NotNull Project project2) {
                    if (changeInfo == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (project2 == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    ((Runnable)pair2.getSecond()).run();
                    return true;
                }

                @Override
                public int getUsageRank() {
                    return (Integer)pair2.getFirst();
                }

                public int hashCode() {
                    return 0;
                }

                public boolean equals(Object o) {
                    return this == o;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "changeInfo";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureUsageProcessor$1";
                    objectArray[2] = "processUsage";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static void findAllMethodUsages(@NotNull OCChangeInfo info, @NotNull OCCallable method, boolean onlyCalls, @NotNull Set<UsageInfo> result, @NotNull Set<OCCallable> visited, boolean isInherited) {
        if (info == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
        }
        if (method == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(2);
        }
        if (result == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(3);
        }
        if (visited == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(4);
        }
        if (!visited.add(method)) {
            return;
        }
        OCChangeSignatureUsageProcessor.findOneMethodUsages(info, method, onlyCalls, result, isInherited);
        if (method instanceof OCBlockExpression || !info.isChangeUsages()) {
            return;
        }
        OCSearchUtil.processMembersHierarchyPsi((OCSymbolWithParent)method.getSymbol(), new OCCommonProcessors.TypeFilteredProcessor(element -> {
            if (info == null) {
                OCChangeSignatureUsageProcessor.$$$reportNull$$$0(9);
            }
            if (result == null) {
                OCChangeSignatureUsageProcessor.$$$reportNull$$$0(10);
            }
            if (visited == null) {
                OCChangeSignatureUsageProcessor.$$$reportNull$$$0(11);
            }
            OCChangeSignatureUsageProcessor.findAllMethodUsages(info, element, onlyCalls, result, visited, true);
            return true;
        }, OCCallable.class), info.isChangeAncestors(), true, method.getProject());
    }

    private static void findOneMethodUsages(@NotNull OCChangeInfo info, @NotNull OCCallable method, boolean onlyCalls, @NotNull Set<UsageInfo> result, boolean isInherited) {
        List<PsiNamedElement> parameters;
        if (info == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(5);
        }
        if (method == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(6);
        }
        if (result == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(7);
        }
        if (info.isChangeUsages()) {
            OCSearchUtil.findOneMethodUsages(method, result);
            String oldName = info.getMethod().getName();
            if (oldName != null && !oldName.isEmpty()) {
                TextOccurrencesUtil.findNonCodeUsages((PsiElement)method, (String)oldName, (boolean)true, (boolean)true, (String)info.getNewName(), result);
            }
        }
        if (onlyCalls) {
            return;
        }
        if (info.getGenerated().getMethodReference() == null) {
            if (method instanceof OCFunctionDeclaration) {
                result.add(new OCFunctionDefinitionUsage((OCFunctionDeclaration)method, isInherited));
            } else if (method instanceof OCBlockExpression) {
                result.add(new OCBlockDefinitionUsage((OCBlockExpression)method));
            } else if (method instanceof OCMethod) {
                result.add(new OCMethodDefinitionUsage((OCMethod)method, isInherited));
            }
        }
        if ((parameters = method.getParameters()) == null) {
            return;
        }
        for (OCParameterInfo newParam : info.getNewParameters()) {
            PsiNamedElement oldParam;
            if (newParam.getUsages() != null) {
                for (PsiReference usage : newParam.getUsages()) {
                    result.add(new OCParameterUsage(usage, newParam, method, isInherited));
                }
            }
            if (newParam.getOldIndex() < 0 || newParam.getOldIndex() >= parameters.size() || Comparing.equal((String)(oldParam = parameters.get(newParam.getOldIndex())).getName(), (String)newParam.getName())) continue;
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                if (newParam.getName().isEmpty()) {
                    result.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref.getElement(), (PsiElement)oldParam){

                        public String getDescription() {
                            return OCBundle.message("changeSignature.usages.cantBeUnnamed", oldParam.getName());
                        }
                    });
                    continue;
                }
                result.add(new OCParameterUsage(ref, newParam, method, isInherited));
            }
        }
        Set newIndices = ContainerUtil.map2Set((Object[])info.getNewParameters(), info1 -> info1.getOldIndex());
        for (int i = 0; i < parameters.size(); ++i) {
            if (newIndices.contains(i)) continue;
            final PsiNamedElement oldParam = parameters.get(i);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)oldParam, (SearchScope)oldParam.getUseScope())) {
                result.add((UsageInfo)new UnresolvableCollisionUsageInfo(ref.getElement(), (PsiElement)oldParam){

                    public String getDescription() {
                        return OCBundle.message("changeSignature.usages.cantBeRemoved", oldParam.getName());
                    }
                });
            }
        }
        for (OCReferenceExpression expr : info.getOldMethodDescriptor().getSelfReferences()) {
            if (!expr.isValid()) continue;
            result.add(new OCSelfSuperUsage(expr));
        }
    }

    public static boolean canProceedWithConflict(String conflict) {
        return !conflict.startsWith(BLOCK_CONFLICT);
    }

    public MultiMap<PsiElement, String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        if (!(info instanceof OCChangeInfo)) {
            return MultiMap.empty();
        }
        MultiMap result = new MultiMap();
        PsiElement method = info.getMethod();
        OCChangeInfo changeInfo = (OCChangeInfo)info;
        String fullNewName = (Object)((Object)changeInfo.getNewCallableKind()) + " '" + changeInfo.getNewName() + "'";
        if (!changeInfo.willBeMethod()) {
            for (UsageInfo usage : (UsageInfo[])refUsages.get()) {
                PsiElement psiElement = usage.getElement();
                if (!(psiElement instanceof OCSelectorExpression)) continue;
                result.putValue((Object)usage.getElement(), (Object)OCBundle.message("changeSignature.usages.cantConvertSelectorToFuncBlock", new Object[0]));
            }
            UsageInfo[] usages = OCChangeSignatureUsageProcessor.findUsages((OCChangeInfo)info, true);
            if (changeInfo.willBeBlock() && !(changeInfo.getMethod() instanceof OCBlockExpression) && changeInfo.getGenerated().getMethodReference() == null) {
                for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                    PsiElement element = usageInfo.getElement();
                    if (element == null || ((Object)((Object)OCLanguage.getInstance())).equals(element.getLanguage())) continue;
                    result.putValue((Object)usageInfo.getElement(), (Object)OCBundle.message("changeSignature.usages.cantConvertLanguage", element.getLanguage().getDisplayName()));
                }
                if (usages.length == 0) {
                    result.putValue((Object)method, (Object)(BLOCK_CONFLICT + " " + OCBundle.message("changeSignature.usages.noUsagesFound", new Object[0])));
                } else if (usages.length > 1) {
                    result.putValue((Object)method, (Object)(BLOCK_CONFLICT + " " + OCBundle.message("changeSignature.usages.moreThan1Found", new Object[0])));
                } else if (PsiTreeUtil.isAncestor((PsiElement)changeInfo.getMethod(), (PsiElement)usages[0].getElement(), (boolean)true)) {
                    result.putValue((Object)method, (Object)(BLOCK_CONFLICT + " " + OCBundle.message("changeSignature.usages.usageInsideFunction", new Object[0])));
                }
            }
        }
        Project project2 = method.getProject();
        OCResolveContext context = OCResolveContext.forPsi(method);
        if (changeInfo.willBeFunction()) {
            OCQualifiedName parentName;
            OCSymbolWithQualifiedName originalSymbol;
            OCSymbolWithQualifiedName oCSymbolWithQualifiedName = originalSymbol = method instanceof OCFunctionDeclaration ? (OCSymbolWithQualifiedName)((OCFunctionDeclaration)method).getSymbol() : null;
            if (originalSymbol != null) {
                OCQualifiedName oCQualifiedName = originalSymbol.getResolvedQualifiedName(context);
                OCQualifiedName qualifier = originalSymbol.getQualifiedName().getQualifier();
                parentName = oCQualifiedName != null ? oCQualifiedName.getQualifier() : (qualifier != null ? OCQualifiedName.GLOBAL.append(qualifier) : OCQualifiedName.GLOBAL);
            } else {
                parentName = OCQualifiedName.GLOBAL;
            }
            List list = ContainerUtil.map((Object[])changeInfo.getNewParameters(), info1 -> {
                OCType result1 = info1.getType();
                return result1 != null ? result1.resolve(changeInfo.getContext()) : OCUnknownType.INSTANCE;
            });
            OCFunctionType functionType = new OCFunctionType(OCVoidType.instance(), list);
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)((Processor)symbol -> {
                boolean conflict = false;
                if (symbol instanceof OCSymbolWithQualifiedName && (!symbol.isSameSymbol(originalSymbol, project2) || !method.isPhysical()) && OCResolveUtil.isDuplicate(OCSymbolKind.FUNCTION_DECLARATION, symbol.getKind())) {
                    OCQualifiedName name2 = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context);
                    if (name2 != null && Comparing.equal((Object)parentName, (Object)name2.getQualifier())) {
                        if (symbol instanceof OCFunctionSymbol && (((OCFile)method.getContainingFile()).isCpp() || symbol.getAttributes().contains("overloadable"))) {
                            OCResolveContext resolveContext = OCResolveContext.forPsi(method);
                            OCType type = symbol.getResolvedType(resolveContext);
                            OCTypeEqualityVisitor visitor = new OCTypeEqualityVisitor(type, false, resolveContext);
                            if (type instanceof OCFunctionType && visitor.isFunctionSignatureEqual(functionType)) {
                                conflict = true;
                            }
                        } else {
                            conflict = true;
                        }
                    }
                    if (conflict) {
                        String kind = symbol.getKindLowercase(OCCompilationContext.create(symbol, project2));
                        OCQualifiedName symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context);
                        if (symbolName != null) {
                            String conflictWith = kind + " " + symbolName.dropSuperQualifier().toString() + (symbol instanceof OCFunctionSymbol ? ((OCFunctionSymbol)symbol).getParamsSignatureWithoutNames() : "");
                            result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.willConflictWith", fullNewName, conflictWith));
                        }
                    }
                }
                return true;
            }), info.getNewName());
        } else if (changeInfo.willBeMethod()) {
            OCClassSymbol oCClassSymbol;
            OCClassDeclaration parentClass;
            UsageInfo[] usages = (UsageInfo[])refUsages.get();
            int numOfFunctions = 0;
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                ++numOfFunctions;
            }
            if (numOfFunctions > 1) {
                for (UsageInfo usageInfo : usages) {
                    if (!(usageInfo.getElement() instanceof OCFunctionDefinition)) continue;
                    result.putValue((Object)usageInfo.getElement(), (Object)OCBundle.message("changeSignature.usages.functionHasSeveralDefinitions", changeInfo.getNewName()));
                }
            }
            if ((parentClass = OCElementUtil.resolveClassDeclaration(oCClassSymbol = (OCClassSymbol)changeInfo.getGenerated().getMethodParent(), project2)) == null) {
                parentClass = changeInfo.getNewContainerClass();
            }
            if (parentClass != null && (changeInfo.isNameChanged() || oCClassSymbol != null)) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(changeInfo.getNewName(), parentClass.getSymbol(), project2, OCMethodSymbol.class, changeInfo.getMethod() instanceof OCMethod && ((OCMethod)changeInfo.getMethod()).isInstanceMethod() ? OCObjectTypeContext.StaticMode.INSTANCE : OCObjectTypeContext.StaticMode.STATIC);
                parameters.setIncludeSelfImplementation(true);
                parameters.setAncestors(true);
                OCMemberInheritorsSearch.search(parameters).forEach(methodSymbol -> {
                    result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.willConflictWithMethod", fullNewName, ((OCClassSymbol)methodSymbol.getParent()).getNameWithKindLowercase(context)));
                    return true;
                });
            }
        }
        OCBlockStatement body = ((OCCallable)info.getMethod()).getBody();
        HashSet<String> set = new HashSet<String>();
        for (ParameterInfo parameterInfo : info.getNewParameters()) {
            if (parameterInfo.getName().isEmpty() || set.add(parameterInfo.getName())) continue;
            result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.atLeasTwoParams", parameterInfo.getName()));
        }
        if (body != null) {
            for (ParameterInfo parameterInfo : info.getNewParameters()) {
                OCResolveUtil.processLocalSymbols(parameterInfo.getName(), body.getClosingBrace(), (Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE && Comparing.equal((Object)symbol.getContainingFile(), (Object)body.getContainingFile().getVirtualFile())) {
                        result.putValue((Object)method, (Object)OCBundle.message("changeSignature.usages.conflictsWithNewParameter", symbol.getNameWithKindUppercase(context)));
                    }
                    return true;
                }), false);
            }
        }
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            PsiElement element;
            if (usageInfo instanceof OCSelectorExpressionUsage) {
                element = usageInfo.getElement();
                if (!(element instanceof OCSelectorExpression) || OCSelectorAdHocResolver.getActionTargetContext((OCExpression)element) != null) continue;
                result.putValue((Object)element, (Object)OCBundle.message("changeSignature.usages.unrelatedSelector", new Object[0]));
                continue;
            }
            if (!(usageInfo instanceof OCMethodCallUsage) || !((element = usageInfo.getElement()) instanceof OCSendMessageExpression) || ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder() != null) continue;
            result.putValue((Object)element, (Object)OCBundle.message("changeSignature.usages.unrelatedSelector", new Object[0]));
        }
        return result;
    }

    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usageInfo, boolean beforeMethodChange, UsageInfo[] usages) {
        if (!(usageInfo instanceof OCUsageInfo)) {
            return false;
        }
        if (beforeMethodChange) {
            return true;
        }
        Project project2 = changeInfo.getMethod().getProject();
        PsiElement element = usageInfo.getElement();
        return ((OCUsageInfo)usageInfo).processUsage((OCChangeInfo)changeInfo, element, project2);
    }

    public static void processParameters(OCChangeInfo changeInfo, OCCallable function, OCParameterList parameters, Project project2, boolean isInherited) {
        int paramIndex = 0;
        if (parameters != null) {
            OCParameterInfo[] newParameters = changeInfo.getNewParameters();
            for (OCParameterDeclaration parameter : parameters.getParameterDeclarations()) {
                OCTypeElement typeElement = parameter.getTypeElement();
                if (paramIndex >= newParameters.length) {
                    if (paramIndex == 0 && newParameters.length == 0 && typeElement != null && typeElement.getType().isVoid()) break;
                    LOG.error("Invalid parameter is involved into rename procedure!");
                    break;
                }
                OCDeclarator declarator = parameter.getDeclarator();
                if (declarator != null) {
                    OCParameterDeclaration parameterDeclaration;
                    OCSymbol symbol;
                    String oldTypeText;
                    PsiElement identifier = declarator.getNameIdentifier();
                    OCParameterInfo parameterInfo = newParameters[paramIndex];
                    if (typeElement != null && parameterInfo.isTypeChanged(oldTypeText = declarator.getType().getBestNameInContext(declarator, OCElementUtil.getTypeTextWithModifiers(parameter))) && (symbol = declarator.getSymbol()) != null) {
                        new OCChangeTypeIntentionAction(symbol, parameterInfo.getType(), OCCompilationContext.create(declarator)).invoke(project2, null, declarator.getContainingFile());
                    }
                    String newName = changeInfo.getNewParameterName(isInherited, function, parameterInfo);
                    boolean newNameEmpty = OCCallableUtil.isParameterNameEmpty(newName);
                    if (identifier != null) {
                        if (newNameEmpty) {
                            OCChangeUtil.delete(identifier);
                        } else {
                            OCElementUtil.replaceWithIdentifier(identifier, newName, identifier);
                        }
                    } else if (!newNameEmpty && (parameterDeclaration = OCElementFactory.paramDeclarationByNameAndType(newName, parameterInfo.getType(), function)).getDeclarator() != null) {
                        OCChangeUtil.replaceHandlingMacros(declarator, parameterDeclaration.getDeclarator());
                    }
                }
                ++paramIndex;
            }
        }
    }

    public static void changeConstructorOrMethodCall(@Nullable OCElement callExpression, OCChangeInfo changeInfo) {
        int paramIndex = 0;
        PsiElement name2 = null;
        OCArgumentList oldArguments = null;
        if (callExpression instanceof OCCppNewExpression) {
            oldArguments = ((OCCppNewExpression)callExpression).getArgumentList();
        } else if (callExpression instanceof OCDeclarator) {
            oldArguments = (OCArgumentList)PsiTreeUtil.getChildOfType((PsiElement)callExpression, OCArgumentList.class);
            if (oldArguments == null) {
                OCCallExpression emptyCall = OCElementFactory.callExpression(changeInfo.getNewName(), Collections.emptyList(), changeInfo.getContext());
                oldArguments = (OCArgumentList)callExpression.add(emptyCall.getArgumentList());
            }
        } else if (callExpression instanceof OCConstructorFieldInitializer) {
            oldArguments = ((OCConstructorFieldInitializer)callExpression).getArgumentList();
        } else if (callExpression instanceof OCCallExpression) {
            oldArguments = ((OCCallExpression)callExpression).getArgumentList();
            OCExpression function = ((OCCallExpression)callExpression).getFunctionReferenceExpression();
            if (function instanceof OCReferenceExpression) {
                OCReferenceElement referenceElement = ((OCReferenceExpression)function).getReferenceElement();
                name2 = referenceElement != null ? referenceElement.getNameIdentifier() : null;
            } else if (function instanceof OCQualifiedExpression) {
                name2 = ((OCQualifiedExpression)function).getNameIdentifier();
            }
        }
        ArrayList<String> paramStubs = new ArrayList<String>();
        for (OCParameterInfo param : changeInfo.getNewParameters()) {
            paramStubs.add(param.getParameterStubText(false, false, callExpression));
        }
        OCCallExpression stubCall = OCElementFactory.callExpression(changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        if (oldArguments != null) {
            for (OCExpression argument : stubCall.getArguments()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= oldArguments.getArguments().size()) continue;
                OCChangeUtil.replaceHandlingMacros(argument, oldArguments.getArguments().get(parameterInfo.getOldIndex()));
            }
            oldArguments = (OCArgumentList)OCChangeUtil.replaceHandlingMacros(oldArguments, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        } else if (callExpression instanceof OCCppNewExpression) {
            oldArguments = OCChangeUtil.add(callExpression, stubCall.getArgumentList());
            OCImportSymbolFix.fixAllSymbolsRecursively(oldArguments);
        }
        if (name2 != null && changeInfo.isNameChanged()) {
            OCElementUtil.replaceWithIdentifier(name2, changeInfo.getNewName(), stubCall);
        }
    }

    public static PsiElement generateCall(@Nullable OCExpression receiver, List<OCExpression> arguments, OCChangeInfo changeInfo) {
        OCCallable block;
        int paramIndex;
        ArrayList<String> paramStubs = new ArrayList<String>();
        OCCallable parentCallable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)receiver, OCCallable.class);
        boolean isSelfSuperCall = changeInfo.getMethod().equals(parentCallable) || receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null && parentCallable instanceof OCMethod && Comparing.equal((String)changeInfo.getMethod().getName(), (String)parentCallable.getName());
        for (OCParameterInfo param : changeInfo.getNewParameters()) {
            paramStubs.add(param.getParameterStubText(changeInfo.willBeMethod(), isSelfSuperCall, null));
        }
        if (changeInfo.willBeMethod()) {
            OCSendMessageExpression sendMessageExpression = OCElementFactory.sendMessageExpression(paramStubs, changeInfo.getContext());
            paramIndex = 0;
            for (OCExpression stubArgument : sendMessageExpression.getArgumentExpressions()) {
                OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
                if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= arguments.size()) continue;
                OCExpression newArgument = arguments.get(parameterInfo.getOldIndex());
                OCChangeUtil.replaceHandlingMacros(stubArgument, newArgument);
            }
            if (changeInfo.getOldMethodDescriptor().getCallableKind() != OCCallableKind.METHOD) {
                receiver = OCElementFactory.expressionFromText(changeInfo.getNewContainerClass().getName(), changeInfo.getContext());
            }
            OCChangeUtil.replaceHandlingMacros(sendMessageExpression.getReceiverExpression(), receiver);
            return sendMessageExpression;
        }
        OCCallExpression callExpression = OCElementFactory.callExpression(changeInfo.willBeBlock() ? "block" : changeInfo.getNewName(), paramStubs, changeInfo.getContext());
        paramIndex = 0;
        for (OCExpression argument : callExpression.getArguments()) {
            OCParameterInfo parameterInfo = changeInfo.getNewParameters()[paramIndex++];
            if (parameterInfo.getOldIndex() < 0 || parameterInfo.getOldIndex() >= arguments.size()) continue;
            OCExpression oldArgument = arguments.get(parameterInfo.getOldIndex());
            OCChangeUtil.replaceHandlingMacros(argument, oldArgument);
        }
        if (changeInfo.willBeBlock() && (block = OCChangeSignatureUsageProcessor.generateMethodDefinition(changeInfo, changeInfo.getMethod(), true, true, false)) != null) {
            OCChangeUtil.replaceHandlingMacros(callExpression.getFunctionReferenceExpression(), block);
            changeInfo.setNewMethod(block);
        }
        return callExpression;
    }

    @Nullable
    public static OCCallable generateMethodDefinition(OCChangeInfo changeInfo, OCCallable oldMethod, boolean needBody, boolean needComments, boolean isInherited) {
        String newSignature;
        OCCallable<OCMethodSymbol> result = null;
        OCBlockStatement body = oldMethod.getBody();
        PsiFile context = oldMethod.getContainingFile();
        String string = newSignature = isInherited ? changeInfo.getNewInheritedSignature(oldMethod) : changeInfo.getNewSignature();
        if (changeInfo.willBeMethod()) {
            result = OCElementFactory.methodFromSignature(newSignature, (PsiElement)context, needBody && (body != null || oldMethod instanceof OCFunctionDeclaration), false);
        } else if (changeInfo.willBeFunction()) {
            OCMethodDescriptor methodDescriptor = changeInfo.getOldMethodDescriptor();
            OCDeclaration declaration = methodDescriptor.isConstructor() ? OCElementFactory.constructorFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context) : OCElementFactory.declarationFromText(newSignature + (needBody && body != null ? "{\n}" : ""), (PsiElement)context);
            OCLog.LOG.assertTrue(declaration instanceof OCCallable, (Object)declaration.getTextWithMacros());
            result = (OCCallable)((Object)declaration);
        } else if (changeInfo.willBeBlock()) {
            result = body != null ? (OCBlockExpression)OCElementFactory.expressionFromText(newSignature + "{\n}", (PsiElement)context) : null;
        } else assert (false);
        if (needBody && body != null && result != null && body.isValid()) {
            OCChangeUtil.replaceHandlingMacros(result.getBody(), body);
        }
        OCElementUtil.replaceDeclarationQualifiers(result, oldMethod);
        if (needComments) {
            OCElementUtil.replaceComments(result, oldMethod);
        }
        if (result != null && changeInfo.getContext() != null) {
            OCElementFactory.initIndentFromContext(changeInfo.getContext(), result);
        }
        return result;
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        return changeInfo instanceof OCChangeInfo;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project2) {
        return true;
    }

    public void registerConflictResolvers(List<ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            OCChangeSignatureUsageProcessor.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCChangeSignatureUsageProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findAllMethodUsages";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findOneMethodUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConflictResolvers";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findAllMethodUsages$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

