/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterInfo
implements ParameterInfo,
Cloneable {
    private final int myOldIndex;
    private String mySelector;
    private String myName;
    private OCType myType;
    private String myTypeText;
    private boolean myEllipsisType;
    private boolean mySelfParameter;
    private Collection<PsiReference> myUsages;
    private boolean myReferenceMode;
    private String myArgumentValue;
    @NotNull
    private final PsiElement myTypeContext;

    public OCParameterInfo(String selector, String name2, OCType type, int oldIndex, @NotNull PsiElement context) {
        if (context == null) {
            OCParameterInfo.$$$reportNull$$$0(0);
        }
        this(selector, name2, type, OCParameterInfo.getTextFromType(type, context), oldIndex, context);
    }

    public OCParameterInfo(String selector, String name2, OCType type, String typeText, int oldIndex, @NotNull PsiElement context) {
        if (context == null) {
            OCParameterInfo.$$$reportNull$$$0(1);
        }
        this.mySelector = "";
        this.myName = "";
        this.myTypeContext = context;
        this.mySelector = selector.endsWith(":") ? selector.substring(0, selector.length() - 1) : selector;
        this.myName = name2 != null ? name2 : "";
        this.myType = type;
        this.myTypeText = typeText;
        this.myOldIndex = oldIndex;
    }

    @NotNull
    private static String getTextFromType(OCType type, @NotNull PsiElement typeContext) {
        OCPointerType pointerType;
        if (typeContext == null) {
            OCParameterInfo.$$$reportNull$$$0(2);
        }
        if (type == null) {
            if ("" == null) {
                OCParameterInfo.$$$reportNull$$$0(3);
            }
            return "";
        }
        if (type.getClass().equals(OCPointerType.class) && (pointerType = (OCPointerType)type).isArrayLikeParameter()) {
            type = OCArrayType.to(pointerType.getRefType(), pointerType.getLengthInBrackets(), pointerType.getARCAttribute());
        }
        String string = type.getName(typeContext);
        if (string == null) {
            OCParameterInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setSelfParameter(boolean selfParameter) {
        this.mySelfParameter = selfParameter;
    }

    public void setEllipsisType(boolean ellipsisType) {
        this.myEllipsisType = ellipsisType;
    }

    public void setReferenceMode(boolean referenceMode) {
        this.myReferenceMode = referenceMode;
    }

    public void setArgumentValue(String argumentValue) {
        this.myArgumentValue = argumentValue;
    }

    public String getSelector() {
        return this.mySelector;
    }

    public String getName() {
        return this.myName;
    }

    public int getOldIndex() {
        return this.myOldIndex;
    }

    public String getDefaultValue() {
        return null;
    }

    public void setName(String name2) {
        this.myName = name2 != null ? name2 : "";
    }

    public void setSelector(String selector) {
        this.mySelector = selector;
    }

    @Nullable
    public OCType getType() {
        return this.myType != null ? (this.myReferenceMode ? OCPointerType.to(this.myType) : this.myType) : null;
    }

    public String getTypeText() {
        if (this.myReferenceMode) {
            return this.myTypeText + "*";
        }
        return this.myTypeText;
    }

    public void setType(OCType type) {
        this.myType = type;
        this.myTypeText = OCParameterInfo.getTextFromType(this.myType, this.myTypeContext);
    }

    public void setTypeText(String typeText) {
        this.myTypeText = typeText;
    }

    public boolean isEllipsisType() {
        return this.myEllipsisType;
    }

    public boolean isSelfParameter() {
        return this.mySelfParameter;
    }

    public String getParameterStubText(boolean appendSelectors, boolean isSelfSuperCall, @Nullable PsiElement usageContext) {
        StringBuilder result = new StringBuilder();
        if (appendSelectors) {
            result.append(this.mySelector);
            if (this.myName.isEmpty()) {
                return result.toString();
            }
            result.append(':');
        }
        if (isSelfSuperCall) {
            result.append(this.myName);
        } else if (this.isSelfParameter()) {
            result.append("self");
        } else if (this.myArgumentValue != null) {
            result.append(this.myArgumentValue);
        } else if (this.myType instanceof OCStructType) {
            result.append(this.myType.getDefaultValue(OCResolveContext.forPsi(usageContext != null ? usageContext : this.myTypeContext)));
        } else if (this.myType != null) {
            result.append(this.myType.getDefaultValue(OCResolveContext.forPsi(this.myTypeContext)));
        } else {
            result.append("0");
        }
        return result.toString();
    }

    public boolean isTypeChanged(String oldTypeText) {
        return !oldTypeText.replaceAll(" ", "").equals(this.myTypeText.replaceAll(" ", ""));
    }

    public boolean isUseAnySingleVariable() {
        return false;
    }

    public void setUseAnySingleVariable(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void setUsages(Collection<PsiReference> usages) {
        this.myUsages = usages;
    }

    public Collection<PsiReference> getUsages() {
        return this.myUsages;
    }

    public boolean isReferenceMode() {
        return this.myReferenceMode;
    }

    public OCParameterInfo clone() {
        try {
            return (OCParameterInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCParameterInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/changeSignature/OCParameterInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromType";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

