/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInlineLocalVarHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    protected String getElementKind(OCDeclarator element) {
        return "local variable";
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        if ("refactoring.inlineLocalVar" == null) {
            OCInlineLocalVarHandler.$$$reportNull$$$0(0);
        }
        return "refactoring.inlineLocalVar";
    }

    public boolean canInlineElement(PsiElement element) {
        if (!(element instanceof OCDeclarator)) {
            return false;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        return symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE;
    }

    @Override
    protected boolean allowInlineSingleUsage() {
        return false;
    }

    @Override
    protected String checkValidness(OCDeclarator element, List<PsiElement> usages, PsiElement selectedUsage, String elementNameWithKind, Editor editor, Ref<PsiElement> elementData, List<String> warnings, boolean silentMode) {
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
        OCSymbol symbol = element.getSymbol();
        if (callable == null) {
            return "Can't find the method/function";
        }
        if (symbol == null) {
            return "SILENT_EXIT";
        }
        PsiElement startElement = selectedUsage instanceof OCReferenceElement ? selectedUsage.getParent() : element.getNameIdentifier();
        OCControlFlowGraph graph = OCInlineLocalVarHandler.getCFG(callable, startElement);
        if (graph == null) {
            return "SILENT_EXIT";
        }
        OCLocalDefinitionsSearcher searcher = new OCLocalDefinitionsSearcher(graph, symbol, startElement, false, true, true);
        searcher.process();
        List<PsiElement> declarations = OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.WRITE));
        ArrayList<PsiElement> reads = new ArrayList<PsiElement>();
        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
        ArrayList<PsiElement> usagesInBlocks = new ArrayList<PsiElement>();
        boolean fromStart = false;
        if (declarations.size() == 0) {
            declarations = new ArrayList<PsiElement>();
            for (OCControlFlowGraph parentGraph = graph.getParentGraph(); parentGraph != null; parentGraph = parentGraph.getParentGraph()) {
                Iterator instructions = parentGraph.getInstructions(symbol);
                if (instructions == null) continue;
                declarations.addAll(OCInlineLocalVarHandler.getElements(instructions.get((Object)OCInstruction.InstructionKind.WRITE)));
                reads.addAll(OCInlineLocalVarHandler.getElements(instructions.get((Object)OCInstruction.InstructionKind.READ)));
                references.addAll(OCInlineLocalVarHandler.getElements(instructions.get((Object)OCInstruction.InstructionKind.REFERENCE)));
                usagesInBlocks.addAll(OCInlineLocalVarHandler.getElements(instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK)));
                usagesInBlocks.addAll(OCInlineLocalVarHandler.getElements(instructions.get((Object)OCInstruction.InstructionKind.WRITE_IN_BLOCK)));
            }
            for (PsiElement usage : usagesInBlocks) {
                if (PsiTreeUtil.isAncestor((PsiElement)graph.getCodeFragment(), (PsiElement)usage, (boolean)false)) continue;
                return OCInlineLocalVarHandler.highlightError(editor, "There are usages in other blocks", usagesInBlocks);
            }
            if (declarations.size() == 0) {
                return StringUtil.capitalize((String)elementNameWithKind) + " was not initialized";
            }
            if (declarations.size() > 1) {
                return OCInlineLocalVarHandler.highlightError(editor, "There are several definitions of " + elementNameWithKind, declarations);
            }
            fromStart = true;
        } else if (declarations.size() > 1) {
            return OCInlineLocalVarHandler.highlightError(editor, "There are several definitions of " + elementNameWithKind, declarations);
        }
        PsiElement definition = declarations.get(0);
        searcher = new OCLocalDefinitionsSearcher(graph, symbol, definition, true, true, false);
        if (fromStart) {
            searcher.processFromStart();
        } else {
            searcher.process();
        }
        reads.addAll(OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.READ)));
        references.addAll(OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.REFERENCE)));
        List<PsiElement> blockReads = OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.READ_IN_BLOCK));
        List<PsiElement> writes = OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.WRITE));
        List<PsiElement> blockWrites = OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.WRITE_IN_BLOCK));
        writes.remove(definition);
        if (!references.isEmpty()) {
            return OCInlineLocalVarHandler.highlightError(editor, "The address of " + elementNameWithKind + " is taken", references);
        }
        if (!blockWrites.isEmpty()) {
            return OCInlineLocalVarHandler.highlightError(editor, StringUtil.capitalize((String)elementNameWithKind) + " is written in the block", blockWrites);
        }
        for (PsiElement write2 : writes) {
            searcher = new OCLocalDefinitionsSearcher(graph, symbol, write2, true, false, true);
            searcher.process();
            List<PsiElement> nextReads = OCInlineLocalVarHandler.getElements(searcher.getInstructionsOfKind(OCInstruction.InstructionKind.READ));
            nextReads.retainAll(reads);
            if (nextReads.isEmpty()) continue;
            if (editor != null) {
                OCInlineLocalVarHandler.highlightUsages(element.getProject(), editor, nextReads, EditorColors.SEARCH_RESULT_ATTRIBUTES);
            }
            return OCInlineLocalVarHandler.highlightError(editor, "There are several definitions of " + elementNameWithKind, Arrays.asList(definition, write2));
        }
        usages.clear();
        usages.addAll(reads);
        usages.addAll(blockReads);
        usages.add(definition);
        for (PsiElement usage : usages) {
            PsiElement parent = usage.getParent();
            OCElementType operator = null;
            if (parent instanceof OCPostfixExpression) {
                operator = ((OCPostfixExpression)parent).getOperationSign();
            } else if (parent instanceof OCPrefixExpression) {
                operator = ((OCPrefixExpression)parent).getOperationSign();
            }
            if (operator != OCTokenTypes.PLUSPLUS && operator != OCTokenTypes.MINUSMINUS && (!(parent instanceof OCAssignmentExpression) || ((OCAssignmentExpression)parent).getReceiverExpression() != usage || ((OCAssignmentExpression)parent).getOperationSign() == OCTokenTypes.EQ)) continue;
            return OCInlineLocalVarHandler.highlightError(editor, StringUtil.capitalize((String)elementNameWithKind) + " is accessed for writing", Collections.singletonList(usage));
        }
        usages.remove(usages.size() - 1);
        ArrayList<PsiElement> badMacros = new ArrayList<PsiElement>();
        List newUsages = ContainerUtil.mapNotNull(usages, element1 -> {
            OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element1);
            if (macroRange == null) {
                return element1;
            }
            if (macroRange.mapsToArguments()) {
                return PsiTreeUtil.getParentOfType((PsiElement)macroRange.getFirstElement(), OCReferenceExpression.class);
            }
            badMacros.add(macroRange.getMacroCall());
            return element1;
        });
        if (!badMacros.isEmpty()) {
            return OCInlineLocalVarHandler.highlightError(editor, "Can't inline usages inside the macro substitutions", badMacros);
        }
        usages.clear();
        usages.addAll(newUsages);
        elementData.set((Object)definition);
        return super.checkValidness(element, usages, selectedUsage, elementNameWithKind, editor, elementData, warnings, silentMode);
    }

    @Nullable
    private static OCControlFlowGraph getCFG(OCCallable callable, PsiElement startElement) {
        OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, null);
        analyzer.buildControlFlowGraph();
        return analyzer.findGraph(startElement);
    }

    private static List<PsiElement> getElements(Collection<OCInstruction> instructions) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (OCInstruction instruction : instructions) {
            PsiElement element = instruction.getRValue();
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    private static String highlightError(Editor editor, String message, List<PsiElement> usages) {
        if (editor != null) {
            OCInlineLocalVarHandler.highlightUsages(editor.getProject(), editor, usages, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES);
            OCInlineLocalVarHandler.showHighlightRemovalStatus(editor.getProject());
        }
        return message;
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (!(usage instanceof OCReferenceExpression)) {
            return;
        }
        OCParenthesesUtils.replaceExpressionAndAppendParentheses((OCExpression)usage, (OCExpression)elementData);
    }

    @Override
    protected void deleteElement(OCDeclarator element, PsiElement elementData) {
        PsiElement parent = elementData.getParent();
        if (parent instanceof OCAssignmentExpression) {
            if (parent.getParent() instanceof OCStatement) {
                OCChangeUtil.delete(parent.getParent());
            } else {
                OCChangeUtil.replaceHandlingMacros(parent, ((OCAssignmentExpression)parent).getReceiverExpression());
            }
        } else if (parent instanceof OCDeclarator) {
            OCChangeUtil.delete(((OCDeclarator)parent).getInitializer());
        } else assert (false) : parent.getClass();
        if (ReferencesSearch.search((PsiElement)element, (SearchScope)element.getUseScope()).forEach((Processor)new CommonProcessors.FindFirstProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                return !OCElementUtil.isPartOfMacroSubstitution(reference.getElement());
            }
        })) {
            OCChangeUtil.delete(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/inline/OCInlineLocalVarHandler", "getFeatureID"));
    }
}

