/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.inline.OCInlineActionHandlerBase;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCInlineTypedefHandler
extends OCInlineActionHandlerBase<OCDeclarator> {
    @Override
    protected String getElementKind(OCDeclarator element) {
        return "typedef";
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof OCDeclarator && ((OCDeclaration)element.getParent()).isTypedef();
    }

    @Override
    protected String checkUsageValid(PsiElement usage, OCDeclarator element) {
        OCType elementType = element.getType();
        OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        if (typeElement != null && typeElement.getParent() instanceof OCFunctionDeclaration && elementType.getTerminalType() instanceof OCFunctionType) {
            return "Can't inline the function type in the return type of another function";
        }
        return null;
    }

    @Override
    protected void inlineUsage(PsiElement usage, OCDeclarator element, PsiElement elementData, Project project2, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        if (usage instanceof OCCppNamespaceQualifier) {
            OCCppNamespaceQualifier qualifier = OCElementFactory.declarationFromText("int " + element.getType().getCanonicalName(OCResolveContext.forPsi(usage)) + "::x;", usage).getDeclarators().get(0).getNamespaceQualifier();
            OCChangeUtil.replaceHandlingMacros(usage, qualifier);
            return;
        }
        if (!(usage instanceof OCReferenceElement)) {
            return;
        }
        OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.getParentOfType((PsiElement)usage, OCTypeElement.class);
        OCSymbol symbol = element.getSymbol();
        OCType elementType = element.getType();
        if (typeElement == null || symbol == null) {
            return;
        }
        if (typeElement.getParent() instanceof OCDeclaration) {
            for (OCDeclaration declaration : OCNormalizeUtil.normalizeDeclaration((OCDeclaration)typeElement.getParent())) {
                OCDeclarator declarator = declaration.getDeclarators().get(0);
                OCType newType = OCInlineTypedefHandler.transformType(symbol, elementType, declarator.getType(), element.getContainingFile(), project2);
                OCDeclaration newDeclaration = OCElementFactory.declarationStatement(declarator.getName(), newType, declarator.getInitializer(), declarator).getDeclaration();
                OCElementUtil.replaceDeclarationQualifiers(newDeclaration, declaration);
                OCElementUtil.replaceDeclarationQualifiers(newDeclaration.getTypeElement(), declaration.getTypeElement());
                OCChangeUtil.replaceHandlingMacros(declaration, newDeclaration);
            }
        } else {
            OCType newType = OCInlineTypedefHandler.transformType(symbol, elementType, typeElement.getType(), typeElement.getContainingFile(), project2);
            OCTypeElement newTypeElement = OCElementFactory.typeElementFromText(newType.getBestNameInContext(usage), usage);
            OCChangeUtil.replaceHandlingMacros(typeElement, newTypeElement);
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        if ("refactoring.inlineTypedef" == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(0);
        }
        return "refactoring.inlineTypedef";
    }

    private static OCType transformType(final OCSymbol symbol, final OCType elementType, OCType usageType, final PsiFile containingFile, final @NotNull Project project2) {
        if (project2 == null) {
            OCInlineTypedefHandler.$$$reportNull$$$0(1);
        }
        return usageType.transformType(new OCTypeCloneVisitor(false){

            @Override
            public OCType visitReferenceType(OCReferenceType type) {
                List<OCSymbol> symbols = type.getReference(containingFile).resolveToSymbols(OCResolveContext.forPsi((PsiElement)containingFile));
                if (symbols.contains(symbol)) {
                    return type.isConst() ? elementType.cloneWithConstModifier(project2) : elementType;
                }
                return super.visitReferenceType(type);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineTypedefHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/inline/OCInlineTypedefHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "transformType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

