/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCBaseInplaceIntroducer<V extends PsiNameIdentifierOwner, E extends PsiElement>
extends AbstractInplaceIntroducer<V, E> {
    private RangeMarker myVarMarker;
    protected PsiFile myVarFile;
    private Class<V> myVariableClass;
    private boolean myCreateFromUsageMode;
    protected OCSymbol myParentSymbol;
    protected String myUsageName;
    protected OCType myExprType;
    protected String myOldDocumentText;
    protected JCheckBox myPutToHeaderCb;
    protected List<MyPsiPointer> myOccurrencePtrs;
    protected MyPsiPointer myExprPtr;
    private MyPsiPointer myAnchorPtr;

    public OCBaseInplaceIntroducer(Project project2, Editor editor, E expression, List<E> occurrences, Class<V> variableClass, Class<E> expressionClass, String refactoringName) {
        super(project2, editor, expression, null, (PsiElement[])ContainerUtil.toArray(occurrences, (Object[])((PsiElement[])Array.newInstance(expressionClass, occurrences.size()))), refactoringName, (FileType)OCFileType.INSTANCE);
        this.myVariableClass = variableClass;
        this.myExprPtr = new MyPsiPointer((PsiElement)expression);
    }

    public void configurePanel() {
        PsiElement parent;
        if (!this.isPreviewDisabled()) {
            this.myWholePanel.add(this.getPreviewComponent());
        }
        if ((parent = this.myAnchorPtr.getElement().getParent()) instanceof OCFile && !((OCFile)parent).isHeader() && ((OCFile)parent).getAssociatedFile() != null) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(OCCodeStyleSettings.class);
            this.myPutToHeaderCb = this.createCheckBox("Put to &header", settings.INTRODUCE_GLOBALS_TO_HEADER, () -> {
                settings.INTRODUCE_GLOBALS_TO_HEADER = this.myPutToHeaderCb.isSelected();
            });
        }
    }

    protected NonFocusableCheckBox createCheckBox(String caption, boolean selected, @Nullable Runnable listener2) {
        return OCBaseInplaceIntroducer.createCheckBox(this.myProject, this.myTitle, this.myWholePanel, caption, selected, (Processor<Boolean>)((Processor)aBoolean -> {
            if (listener2 != null) {
                listener2.run();
            }
            return true;
        }));
    }

    public static NonFocusableCheckBox createCheckBox(final Project project2, final String actionTitle, JPanel panel, String caption, boolean selected, final @Nullable Processor<Boolean> listener2) {
        final NonFocusableCheckBox checkBox = new NonFocusableCheckBox(caption);
        checkBox.setSelected(selected);
        DialogUtil.registerMnemonic((AbstractButton)checkBox, (char)'&');
        OCBaseInplaceIntroducer.addControl(panel, (JComponent)checkBox);
        if (listener2 != null) {
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new WriteCommandAction(project2, actionTitle, actionTitle, new PsiFile[0]){

                        protected void run(@NotNull Result result) throws Throwable {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            listener2.process((Object)checkBox.isSelected());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer$1$1", "run"));
                        }
                    }.execute();
                }
            });
        }
        return checkBox;
    }

    protected static void addControl(JPanel panel, JComponent checkBox) {
        int controlsCnt = panel.getComponentCount();
        panel.add((Component)checkBox, new GridBagConstraints(0, controlsCnt++, 1, 1, 1.0, 0.0, 18, 0, new Insets(controlsCnt > 0 ? 0 : 5, 5, 5, 5), 0, 0));
        controlsCnt = panel.getComponentCount();
        panel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, controlsCnt, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    public void setCreateFromUsageMode(boolean createFromUsageMode) {
        this.myCreateFromUsageMode = createFromUsageMode;
    }

    protected boolean isCreateFromUsageMode() {
        return this.myCreateFromUsageMode;
    }

    public void setParentSymbol(OCSymbol parentSymbol) {
        this.myParentSymbol = parentSymbol;
    }

    public void setUsageName(String usageName) {
        this.myUsageName = usageName;
    }

    protected RangeMarker createMarker(PsiElement element) {
        return this.myEditor.getDocument().createRangeMarker(OCElementUtil.getRangeWithMacros(element));
    }

    protected boolean changeUsages(String newName) {
        return !this.isCreateFromUsageMode() || !newName.equals(this.myUsageName);
    }

    public void setExprType(OCType exprType) {
        if (exprType != null) {
            this.myExprType = exprType;
        }
    }

    protected boolean isPreviewDisabled() {
        return false;
    }

    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            OCBaseInplaceIntroducer.$$$reportNull$$$0(0);
        }
        for (PsiElement expression : this.getOccurrences()) {
            if (!expression.isValid()) continue;
            OCMacroCall macroCall = OCElementUtil.getElementMacroCall(expression);
            TextRange range = OCElementUtil.getRangeWithMacros(expression);
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)(macroCall != null ? macroCall : expression), (Object)new TextRange(0, range.getLength())));
        }
    }

    @Nullable
    protected V getVariable() {
        PsiNameIdentifierOwner variable;
        if (this.myVarMarker == null) {
            return null;
        }
        if (!this.myVarFile.isValid()) {
            return null;
        }
        PsiElement element = this.myVarFile.getContainingFile().findElementAt(this.myVarMarker.getStartOffset());
        if (element instanceof PsiWhiteSpace) {
            element = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
        }
        if ((variable = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, this.myVariableClass, (boolean)false)) != null) {
            return (V)variable;
        }
        element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
        return (V)((PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)element, this.myVariableClass, (boolean)false));
    }

    protected void setVariable(V variable) {
        this.myVarFile = variable.getContainingFile();
        this.myVarMarker = this.myEditor.getDocument().createRangeMarker(variable.getTextRange());
    }

    public void setOccurrences(Collection<E> occurrences) {
        this.myOccurrences = (PsiElement[])occurrences.toArray(ArrayUtil.ensureExactSize((int)occurrences.size(), (Object[])this.myOccurrences));
        this.myOccurrenceMarkers = null;
        this.myOccurrencePtrs = new ArrayList<MyPsiPointer>();
        for (PsiElement occurrence : this.getOccurrences()) {
            this.myOccurrencePtrs.add(new MyPsiPointer(occurrence));
        }
        this.initOccurrencesMarkers();
    }

    protected RangeMarker addOccurrence(E occurrence) {
        RangeMarker marker = this.myEditor.getDocument().createRangeMarker(occurrence.getTextRange());
        this.myOccurrences = (PsiElement[])ArrayUtil.append((Object[])this.myOccurrences, occurrence);
        this.myOccurrenceMarkers.add(marker);
        this.myOccurrencePtrs.add(new MyPsiPointer((PsiElement)occurrence));
        return marker;
    }

    protected E getMainExpression() {
        PsiElement mainExpression = this.myOccurrences[0];
        if (mainExpression instanceof OCExpression && !OCElementUtil.isPartOfMacroSubstitution(mainExpression)) {
            return (E)OCParenthesesUtils.diveIntoParentheses((OCExpression)mainExpression);
        }
        return (E)mainExpression;
    }

    protected PsiElement getAnchorParent(PsiElement anchor, boolean isPreview) {
        PsiElement parent = anchor.getParent();
        if (!isPreview && this.myPutToHeaderCb != null && this.myPutToHeaderCb.isSelected() && parent instanceof OCFile) {
            OCFile file = (OCFile)parent;
            if (!file.isHeader()) {
                file = file.getAssociatedFile();
            }
            if (file != null && CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return file;
            }
        }
        return parent;
    }

    @Nullable
    protected JComponent getComponent() {
        return this.myWholePanel;
    }

    protected void updateTitle(@Nullable V variable, String value) {
        if (variable == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String variableName = variable.getName();
        if (variableName == null) {
            return;
        }
        PsiElement element = this.getPreviewElement(variable);
        int elementOffset = element.getTextRange().getStartOffset();
        TextRange range = this.getMarkupRange(variable);
        String text = this.getVariableTextWithReplacedName(variable, value);
        String varText = null;
        if (range != null) {
            int startOffset = range.getStartOffset() - elementOffset;
            int endOffset = range.getEndOffset() - elementOffset - element.getTextLength() + text.length();
            varText = text.substring(startOffset, endOffset);
            text = text.substring(0, startOffset) + "<var>" + text.substring(endOffset);
        }
        text = this.trimTextForPreview(text);
        if (range != null) {
            this.setPreviewText(text.replaceAll("<var>", varText));
        } else {
            this.setPreviewText(text);
        }
        if (range != null) {
            TextAttributes textAttributes = new TextAttributes();
            textAttributes.setEffectType(EffectType.ROUNDED_BOX);
            textAttributes.setEffectColor((Color)JBColor.RED);
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)this.getPreviewEditor().getDocument(), (Project)this.myProject, (boolean)true);
            markupModel.removeAllHighlighters();
            int startPos = text.indexOf("<var>");
            int endPos = startPos + varText.length();
            markupModel.addRangeHighlighter(startPos, endPos, 0, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
        this.revalidate();
    }

    protected String getVariableTextWithReplacedName(V variable, String newName) {
        PsiElement element = this.getPreviewElement(variable);
        String text = OCElementUtil.getTextWithMacros(element);
        int offset = variable.getTextOffset() - element.getTextRange().getStartOffset();
        int index = text.indexOf(variable.getName(), offset);
        if (index >= 0) {
            return text.substring(0, index) + newName + text.substring(index + variable.getName().length());
        }
        return text;
    }

    protected String trimTextForPreview(String text) {
        StringBuilder builder = new StringBuilder();
        for (String line : StringUtil.splitByLines((String)text)) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(line.trim());
        }
        return builder.toString();
    }

    protected void updateTitle(@Nullable V variable) {
        if (variable != null) {
            this.updateTitle(variable, variable.getName());
        }
    }

    @Nullable
    protected TextRange getMarkupRange(V variable) {
        return null;
    }

    protected PsiElement getPreviewElement(V element) {
        return element;
    }

    protected SearchScope getReferencesSearchScope(VirtualFile file) {
        return new LocalSearchScope((PsiElement)this.myElementToRename.getContainingFile());
    }

    protected PsiElement checkLocalScope() {
        return this.myElementToRename.getContainingFile();
    }

    protected String getActionName() {
        return this.myTitle;
    }

    protected V createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        this.myOldDocumentText = this.myEditor.getDocument().getText();
        String name2 = this.getInputName() != null ? this.getInputName() : names[0];
        ApplicationManager.getApplication().runWriteAction(() -> this.introduceForPreview(name2));
        this.restoreOccurrences();
        return this.getVariable();
    }

    private static boolean isInvalidOccurrence(PsiElement element) {
        while (element != null && !(element instanceof PsiFile)) {
            element = element.getParent();
        }
        return element == null;
    }

    private void restoreOccurrences() {
        for (int i = 0; i < this.myOccurrences.length; ++i) {
            RangeMarker marker = (RangeMarker)this.myOccurrenceMarkers.get(i);
            MyPsiPointer pointer = this.myOccurrencePtrs.get(i);
            PsiElement newElement = OCCodeInsightUtil.findElementAtRange(this.myVarFile, new TextRange(marker.getStartOffset(), marker.getEndOffset()), pointer.getElementClass(), true);
            if (newElement == null || !OCBaseInplaceIntroducer.isInvalidOccurrence(this.myOccurrences[i])) continue;
            this.myOccurrences[i] = newElement;
        }
    }

    protected int getCaretOffset() {
        if (this.isPreviewDisabled()) {
            V variable = this.getVariable();
            return variable != null ? variable.getTextOffset() : super.getCaretOffset();
        }
        return super.getCaretOffset();
    }

    protected int restoreCaretOffset(int offset) {
        return (offset = super.restoreCaretOffset(offset)) >= this.myEditor.getDocument().getTextLength() ? 0 : offset;
    }

    protected void performIntroduce() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            CommandProcessor.getInstance().setCurrentCommandName(this.myTitle);
            FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureID());
            this.introduceForReal(this.getInputName());
        });
    }

    public void cancelIntroduce() {
        this.releaseResources();
    }

    protected void restoreState(@NotNull V psiField) {
        if (psiField == null) {
            OCBaseInplaceIntroducer.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            Document document = this.myEditor.getDocument();
            document.setText((CharSequence)this.myOldDocumentText);
            documentManager.commitDocument(document);
            ArrayList<PsiElement> newOccurrences = new ArrayList<PsiElement>();
            for (MyPsiPointer ptr : this.myOccurrencePtrs) {
                PsiElement occurrence = ptr.getElement();
                if (occurrence == null) continue;
                newOccurrences.add(occurrence);
            }
            this.myExpr = this.myExprPtr.getElement();
            this.myExprMarker = this.createMarker(this.myExpr);
            this.setOccurrences(newOccurrences);
        });
    }

    public void finish(boolean success) {
        if (!this.myFinished) {
            super.finish(success);
        }
    }

    public E restoreExpression(PsiFile containingFile, V variable, RangeMarker marker, String exprText) {
        assert (false);
        return null;
    }

    @Nullable
    protected PsiElement findAnchor(PsiElement parent) {
        PsiElement lastKnownGood = null;
        block0: for (PsiElement statement2 : parent.getChildren()) {
            for (PsiElement expression : this.myOccurrences) {
                if (expression.isValid() && OCElementUtil.getRangeWithMacros(expression).getStartOffset() < statement2.getTextRange().getStartOffset()) break block0;
            }
            lastKnownGood = statement2;
        }
        if (lastKnownGood == null) {
            return null;
        }
        PsiElement prevElement = OCElementUtil.getPrevSiblingOrParentSibling(lastKnownGood);
        while (lastKnownGood instanceof OCMacroCall || prevElement instanceof OCMacroCall) {
            lastKnownGood = prevElement;
            prevElement = OCElementUtil.getPrevSiblingOrParentSibling(lastKnownGood);
        }
        return lastKnownGood;
    }

    protected boolean hasNonConstUsages() {
        OCReadWriteAccessDetector detector = new OCReadWriteAccessDetector();
        for (PsiElement occurrence : this.myOccurrences) {
            if (detector.getExpressionAccess(occurrence) == ReadWriteAccessDetector.Access.Read && detector.canBeConstReference(occurrence, false)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract String checkExpression(E var1);

    @Nullable
    public abstract PsiElement evaluateAnchor();

    protected abstract void introduceForPreview(String var1);

    protected abstract void introduceForReal(String var1);

    @NotNull
    protected abstract String getFeatureID();

    public void setAnchor(PsiElement anchor) {
        this.myAnchorPtr = new MyPsiPointer(anchor);
    }

    @NotNull
    protected PsiElement getAnchor() {
        PsiElement anchor = this.myAnchorPtr.getElement();
        if (anchor == null) {
            anchor = this.evaluateAnchor();
        }
        PsiElement psiElement = anchor;
        if (psiElement == null) {
            OCBaseInplaceIntroducer.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Nullable
    protected PsiElement getCommonContext() {
        return PsiTreeUtil.findCommonContext((Collection)ContainerUtil.filter((Object[])this.myOccurrences, e -> e.isValid()));
    }

    public boolean isReplaceAllOccurrences() {
        return true;
    }

    public void setReplaceAllOccurrences(boolean allOccurrences) {
    }

    protected void saveSettings(@NotNull V variable) {
        if (variable == null) {
            OCBaseInplaceIntroducer.$$$reportNull$$$0(3);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/introduce/OCBaseInplaceIntroducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalElementsToRename";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyPsiPointer {
        PsiFile file;
        TextRange range;
        Class<? extends PsiElement> clazz;

        MyPsiPointer(PsiElement element) {
            this.file = element.getContainingFile();
            this.range = OCElementUtil.getRangeWithMacros(element);
            this.clazz = element.getClass();
        }

        Class<? extends PsiElement> getElementClass() {
            return this.clazz;
        }

        @Nullable
        PsiElement getElement() {
            return OCCodeInsightUtil.findElementAtRange(this.file, this.range, this.clazz, true);
        }
    }
}

