/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCVariableInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, OCExpression> {
    private JCheckBox myAutoCB;
    private JCheckBox myConstCB;
    private boolean myCreateFromAssignment;

    public OCVariableInplaceIntroducer(Project project2, Editor editor, OCExpression expression, List<OCExpression> occurrences, String refactoringName) {
        super(project2, editor, expression, occurrences, OCDeclarator.class, OCExpression.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)this.myProject).getCustomSettings(OCCodeStyleSettings.class);
        if (this.isAutoAvailable()) {
            this.myAutoCB = this.createCheckBox("Declare &auto", settings.INTRODUCE_AUTO_VARS, () -> {
                settings.INTRODUCE_AUTO_VARS = this.myAutoCB.isSelected();
                this.rebuildDeclaration();
            });
        }
        if (this.isConstAvailable()) {
            this.myConstCB = this.createCheckBox("Declare &const", settings.INTRODUCE_CONST_VARS, () -> {
                settings.INTRODUCE_CONST_VARS = this.myConstCB.isSelected();
                this.rebuildDeclaration();
            });
        }
    }

    private void rebuildDeclaration() {
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (declarator != null) {
            declarator = this.rebuildDeclarator(declarator, new OCBaseExpressionInplaceIntroducer.Rebuilder(){

                @Override
                public OCDeclarator rebuild(OCDeclarator declarator) {
                    OCStatement newDeclaration = OCVariableInplaceIntroducer.this.createDeclaration(declarator.getName(), declarator.getInitializer(), declarator);
                    newDeclaration = (OCStatement)OCChangeUtil.replaceHandlingMacros(declarator.getParent().getParent(), newDeclaration);
                    return ((OCDeclarationStatement)newDeclaration).getDeclaration().getDeclarators().get(0);
                }
            });
            TextRange range = declarator.getNameIdentifier().getTextRange();
            this.myEditor.getCaretModel().moveToOffset(range.getStartOffset());
        }
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.LOCAL_VARIABLE;
    }

    @Override
    public boolean isPreviewDisabled() {
        return true;
    }

    @Nullable
    private OCExpression getInitializer(OCExpression mainExpression) {
        OCAssignmentExpression assignment;
        if (!this.isCreateFromUsageMode()) {
            return mainExpression;
        }
        if (mainExpression.getParent() instanceof OCAssignmentExpression && mainExpression.getParent().getParent() instanceof OCExpressionStatement && mainExpression.getParent().getParent() == this.getAnchor() && (assignment = (OCAssignmentExpression)mainExpression.getParent()).getReceiverExpression() == mainExpression) {
            return assignment.getSourceExpression();
        }
        return null;
    }

    private OCStatement createDeclaration(String name2, OCExpression initializer, PsiElement context) {
        boolean isAuto = this.myAutoCB != null && this.myAutoCB.isSelected();
        boolean isConst = this.myConstCB != null && this.myConstCB.isSelected();
        return OCElementFactory.declarationStatement(name2, this.getType(initializer, isAuto, isConst), initializer, context);
    }

    @Override
    public void introduceForPreview(String name2) {
        OCDeclarationStatement added;
        OCExpression mainExpression = (OCExpression)this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        OCStatement newDeclarationStatement = this.createDeclaration(name2, this.getInitializer(mainExpression), anchor.getParent());
        anchor = this.ensureParentIsBlockStatement(anchor);
        boolean bl = this.myCreateFromAssignment = this.isCreateFromUsageMode() && this.getInitializer(mainExpression) != null;
        if (mainExpression.getParent() instanceof OCExpressionStatement && !(mainExpression.getParent().getParent() instanceof OCMacroCallArgument) || this.myCreateFromAssignment) {
            OCStatement parentStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)(mainExpression.isValid() ? mainExpression : anchor), OCStatement.class, (boolean)false);
            added = (OCDeclarationStatement)OCChangeUtil.replaceHandlingMacros(parentStmt, newDeclarationStatement);
        } else {
            added = (OCDeclarationStatement)OCChangeUtil.addBefore(anchor.getParent(), newDeclarationStatement, anchor);
        }
        this.setVariable((PsiNameIdentifierOwner)added.getDeclaration().getDeclarators().get(0));
    }

    @Override
    protected void introduceForReal(String name2) {
        OCAddInitializerIntentionAction action;
        this.introduceForPreview(name2);
        boolean wasInitialized = false;
        for (OCExpression expression : (OCExpression[])this.myOccurrences) {
            if (this.changeUsages(name2)) {
                OCChangeUtil.replaceHandlingMacros(expression, OCElementFactory.expressionFromText(name2, expression));
            }
            if (new OCReadWriteAccessDetector().getExpressionAccess(expression) != ReadWriteAccessDetector.Access.Write) continue;
            wasInitialized = true;
        }
        OCDeclarator declarator = (OCDeclarator)this.getVariable();
        if (this.isCreateFromUsageMode() && !this.myCreateFromAssignment && !wasInitialized && declarator != null && (action = new OCAddInitializerIntentionAction(declarator, declarator.getSymbol())).isAvailable(declarator.getProject(), this.myEditor, declarator.getContainingFile())) {
            action.invoke(declarator.getProject(), this.myEditor, declarator.getContainingFile());
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        if ("refactoring.appCodeIntroduceVariable" == null) {
            OCVariableInplaceIntroducer.$$$reportNull$$$0(0);
        }
        return "refactoring.appCodeIntroduceVariable";
    }

    protected void moveOffsetAfter(boolean success) {
        super.moveOffsetAfter(success);
        OCDeclarator variable = (OCDeclarator)this.getVariable();
        if (success && this.isCreateFromUsageMode() && variable != null) {
            this.myEditor.getCaretModel().moveToOffset(variable.getTextRange().getEndOffset());
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Nullable
    private static String getAdvertisementText() {
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts("PreviousTemplateVariable");
        if (shortcuts.length > 0) {
            return "Press " + shortcuts[0] + " to change type";
        }
        return null;
    }

    @Override
    protected void restoreState(@NotNull OCDeclarator variable) {
        if (variable == null) {
            OCVariableInplaceIntroducer.$$$reportNull$$$0(1);
        }
        this.myExprType = variable.getResolvedType();
        super.restoreState(variable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/introduce/OCVariableInplaceIntroducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/introduce/OCVariableInplaceIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

