/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.move.OCTargetClass;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OCCppTargetClass
extends OCTargetClass<OCStruct, OCStructSymbol> {
    private OCFile myImplementationFile;

    public OCCppTargetClass(String name2, Set<VirtualFile> files, OCStructSymbol symbol, OCStructSymbol sourceSymbol, Project project2) {
        super(name2, files, symbol, sourceSymbol, project2);
    }

    @Override
    public void locateTargetClass() {
        super.locateTargetClass();
        OCFile interfaceFile = ((OCStruct)this.myPsi).getContainingOCFile();
        if (interfaceFile.isHeader()) {
            this.myImplementationFile = interfaceFile.getAssociatedFile();
            if (this.myImplementationFile == null) {
                ((OCStructSymbol)this.mySymbol).processMembers((String)null, (Processor<OCSymbol>)((Processor)symbol -> {
                    if (symbol instanceof OCSymbolWithParent) {
                        if ((symbol = symbol.getAssociatedSymbol(this.myProject)) != null) {
                            this.myImplementationFile = symbol.getContainingOCFile(this.myProject);
                        }
                        if (this.myImplementationFile != null && this.myImplementationFile != interfaceFile) {
                            return false;
                        }
                    }
                    return true;
                }));
            }
        }
        if (this.myImplementationFile == null) {
            this.myImplementationFile = interfaceFile;
        }
    }

    @Override
    @Nullable
    public VirtualFile getTargetFile(PsiElement element, OCSymbol symbol) {
        if (((OCFile)element.getContainingFile()).isHeader()) {
            return ((OCStruct)this.myPsi).getContainingFile().getVirtualFile();
        }
        return this.myImplementationFile.getVirtualFile();
    }

    @Override
    public OCSymbolDeclarator addMember(PsiElement element, OCSymbol symbol, OCVisibility visibility) {
        List<OCDeclarator> declarators;
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).getParent() != this.mySourceSymbol) {
            this.myMover.addBaseClass((OCStruct)this.myPsi, (OCStructSymbol)symbol, visibility, false);
            return null;
        }
        OCDeclaration newDeclaration = symbol instanceof OCSymbolWithParent && !(((OCSymbolWithParent)symbol).getParent() instanceof OCStructSymbol) ? OCChangeUtil.add(this.myImplementationFile, (OCDeclaration)element) : this.myMover.addClassMemberVariable((OCStruct)this.myPsi, (OCSymbolWithQualifiedName)symbol, (OCDeclaration)element);
        if (symbol.getKind().isConstructorOrDestructor()) {
            newDeclaration.getDeclarators().get(0).setName(this.myName);
            PsiElement identifier = newDeclaration.getDeclarators().get(0).getNameIdentifier();
            if (identifier != null) {
                CodeEditUtil.markToReformatBefore((ASTNode)identifier.getNode(), (boolean)true);
            }
        }
        if ((declarators = newDeclaration.getDeclarators()).isEmpty()) {
            OCTypeElement typeElement = newDeclaration.getTypeElement();
            if (typeElement != null) {
                for (PsiElement child : typeElement.getChildren()) {
                    if (!(child instanceof OCSymbolDeclarator)) continue;
                    return (OCSymbolDeclarator)child;
                }
            }
        } else {
            return declarators.get(0);
        }
        return null;
    }
}

