/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.classMembers.DependentMembersCollectorBase;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.HashSet;
import java.util.Set;

public class OCDependentMembersCollector
extends DependentMembersCollectorBase<OCSymbolHolderVirtualPsiElement, PsiElement> {
    private VirtualFile myTopLevelFile;
    private OCSymbol myClassSymbol;
    private OCSymbol myTargetClassSymbol;
    private Set<OCSymbol> myDependenciesFromSameFile = new HashSet<OCSymbol>();

    public OCDependentMembersCollector(PsiElement parent, PsiElement superClass) {
        super((Object)parent, (Object)superClass);
        if (parent instanceof OCSymbolDeclarator) {
            this.myClassSymbol = ((OCSymbolDeclarator)parent).getSymbol();
            this.myTargetClassSymbol = superClass != null ? ((OCSymbolDeclarator)superClass).getSymbol() : null;
        } else {
            this.myTopLevelFile = ((OCFile)parent).getVirtualFile();
        }
    }

    public void collect(final OCSymbolHolderVirtualPsiElement member) {
        OCPropertySymbol property;
        final Project project2 = member.getProject();
        Object definition = member.getSymbol().locateDefinition(project2);
        if (definition == null) {
            return;
        }
        if (definition instanceof OCDeclarator) {
            definition = definition.getParent();
        }
        if (member.getSymbol() instanceof OCInstanceVariableSymbol && (property = ((OCInstanceVariableSymbol)member.getSymbol()).getAssociatedProperty(project2)) != null) {
            this.myCollection.add(new OCSymbolHolderVirtualPsiElement(property, project2));
        }
        definition.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                super.visitSendMessageExpression(expression);
                OCMethodSymbol responder = expression.getProbableResponders().getKnownResponder();
                OCExpression receiver = expression.getReceiverExpression();
                if (responder != null && responder.isStatic() || receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() != null) {
                    this.visitMember((OCSymbol)member.getSymbol(), responder);
                } else {
                    this.addDependencyFromSameFile((OCSymbol)member.getSymbol(), responder);
                }
            }

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                super.visitReferenceElement(referenceElement);
                this.visitMember((OCSymbol)member.getSymbol(), referenceElement.resolveToSymbol());
            }

            @Override
            public void visitQualifiedExpression(OCQualifiedExpression expression) {
                super.visitQualifiedExpression(expression);
                if (expression.getQualifier() instanceof OCReferenceExpression && ((OCReferenceExpression)expression.getQualifier()).isSelfSuperOrThis()) {
                    for (OCSymbol member2 : expression.resolveToOverloadsSymbols()) {
                        this.visitMember(member2, member2);
                    }
                }
            }

            @Override
            public void visitLiteralExpression(OCLiteralExpression expression) {
                super.visitLiteralExpression(expression);
                for (PsiReference reference : expression.getReferences()) {
                    if (!(reference instanceof OCExternalReference)) continue;
                    this.visitMember((OCSymbol)member.getSymbol(), ((OCReference)reference).resolveToSymbol());
                }
            }

            private void visitMember(OCSymbol caller, OCSymbol callee) {
                boolean isMemberDependency = false;
                if (callee != null && OCDependentMembersCollector.this.myTopLevelFile != null) {
                    isMemberDependency = true;
                    OCDependentMembersCollector.this.myCollection.add(new OCSymbolHolderVirtualPsiElement(callee, project2));
                    OCSymbol definition = callee.getDefinitionSymbol(project2);
                    if (definition != null) {
                        OCDependentMembersCollector.this.myCollection.add(new OCSymbolHolderVirtualPsiElement(definition, project2));
                    }
                } else if (callee instanceof OCSymbolWithParent) {
                    Object parent = ((OCSymbolWithParent)callee).getParent();
                    OCSymbol definition = callee.getDefinitionSymbol(project2);
                    if (OCDependentMembersCollector.this.myClassSymbol != null && OCDependentMembersCollector.this.myClassSymbol.equals(parent) || OCDependentMembersCollector.this.myClassSymbol instanceof OCClassSymbol && ((OCClassSymbol)OCDependentMembersCollector.this.myClassSymbol).isSameCategory((OCSymbol)parent)) {
                        isMemberDependency = true;
                        if (callee instanceof OCMethodSymbol && OCDependentMembersCollector.this.myTargetClassSymbol instanceof OCClassSymbol) {
                            String targetCategory;
                            String string = targetCategory = OCDependentMembersCollector.this.myClassSymbol.getName().equals(OCDependentMembersCollector.this.myTargetClassSymbol.getName()) ? ((OCClassSymbol)OCDependentMembersCollector.this.myTargetClassSymbol).getCategoryName() : null;
                            if (!((OCClassSymbol)OCDependentMembersCollector.this.myTargetClassSymbol).processMembers(targetCategory, callee.getName(), OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), false, project2)) {
                                isMemberDependency = false;
                            }
                        }
                        if (callee instanceof OCFunctionSymbol && OCDependentMembersCollector.this.myTargetClassSymbol instanceof OCStructSymbol && !((OCStructSymbol)OCDependentMembersCollector.this.myTargetClassSymbol).processMembers(callee.getName(), (Processor<OCSymbol>)new CommonProcessors.FindFirstProcessor())) {
                            isMemberDependency = false;
                        }
                        if (isMemberDependency) {
                            OCDependentMembersCollector.this.myCollection.add(new OCSymbolHolderVirtualPsiElement(definition != null ? definition : callee, project2));
                        }
                    }
                }
                if (!isMemberDependency) {
                    this.addDependencyFromSameFile(caller, callee);
                }
            }

            private void addDependencyFromSameFile(OCSymbol caller, OCSymbol<?> callee) {
                if (caller != null && callee != null && !callee.getKind().isLocal() && Comparing.equal((Object)caller.getContainingFile(), (Object)callee.getContainingFile()) && OCSearchUtil.processPredeclarations(callee, (Processor<OCSymbol>)((Processor)symbol -> Comparing.equal((Object)caller.getContainingFile(), (Object)symbol.getContainingFile())), project2)) {
                    OCDependentMembersCollector.this.myDependenciesFromSameFile.add(callee);
                }
            }
        });
    }

    public Set<OCSymbol> getDependenciesFromSameFile() {
        return this.myDependenciesFromSameFile;
    }
}

