/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCObjcTargetClass;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveObjCProcessor
extends OCMoveProcessor<OCClassDeclaration, OCClassSymbol, OCObjcTargetClass> {
    protected SmartPsiElementPointer<OCClassDeclaration> myMainInterface;

    public OCMoveObjCProcessor(OCClassDeclaration sourceClass, List<OCMemberInfo> selectedMemberInfos, @Nullable String targetClassName, Collection<OCClassSymbol> targetSymbols) {
        super(sourceClass, selectedMemberInfos, targetClassName, targetSymbols);
        Project project2 = sourceClass.getProject();
        OCInterfaceSymbol mainInterfaceSymbol = ((OCClassSymbol)this.mySourceClassSymbol).getMainInterface(project2);
        OCClassDeclaration mainInterface = OCElementUtil.resolveClassDeclaration(mainInterfaceSymbol, project2);
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project2);
        this.myMainInterface = mainInterface != null ? pointerManager.createSmartPsiElementPointer((PsiElement)mainInterface) : this.mySourceClass;
    }

    @Override
    protected OCObjcTargetClass createTargetClass(OCFile sourceFile, OCFile mainTargetFile, String targetClassName, Set<VirtualFile> files, OCClassSymbol targetSymbol, OCClassSymbol sourceSymbol, Project project2) {
        return new OCObjcTargetClass(targetClassName, files, targetSymbol, sourceSymbol, project2);
    }

    @Override
    protected void removeMember(PsiElement element, OCSymbol symbol) {
        if (symbol instanceof OCProtocolSymbol) {
            OCClassDeclaration sourceClass = (OCClassDeclaration)this.mySourceClass.getElement();
            if (sourceClass != null) {
                this.myMover.removeBaseProtocol(sourceClass, symbol.getName());
            }
        } else {
            OCChangeUtil.delete(element);
        }
    }

    @Override
    protected void addMissingImports(MultiMap<OCObjcTargetClass, PsiElement> newElements) {
        super.addMissingImports(newElements);
        for (OCObjcTargetClass targetClass : this.myTargetClasses) {
            OCImportSymbolFix.fixAllSymbolsRecursively(((OCClassDeclaration)targetClass.getPsi()).getSuperClassRef());
            OCImportSymbolFix.fixAllSymbolsRecursively(((OCClassDeclaration)targetClass.getPsi()).getProtocolList());
        }
    }

    @Override
    protected List<OCMoveProcessor.Member> getAssociatedSymbols(OCMemberInfo info, OCSymbol symbol) {
        ArrayList<OCMoveProcessor.Member> members = new ArrayList<OCMoveProcessor.Member>();
        this.addAssociatedMember(members, symbol, info);
        OCSymbol associatedSymbol = symbol.getAssociatedSymbol(this.mySourceFile.getProject());
        if (!(associatedSymbol instanceof OCInstanceVariableSymbol) || ((OCInstanceVariableSymbol)associatedSymbol).getGeneratedFromProperty() == null) {
            this.addAssociatedMember(members, associatedSymbol, info);
        }
        if (symbol instanceof OCPropertySymbol) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            ((OCPropertySymbol)symbol).processSynthesizes((Processor<? super OCSynthesizeSymbol>)collector, this.myProject);
            for (OCSynthesizeSymbol synthesize : collector.getResults()) {
                this.addAssociatedMember(members, synthesize, info);
            }
        }
        return members;
    }
}

