/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.refactoring.move.OCTargetClass;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OCObjcTargetClass
extends OCTargetClass<OCClassDeclaration, OCClassSymbol> {
    @Nullable
    private OCClassDeclaration myImplementation;
    private OCClassDeclaration myPrivateCategory;

    public OCObjcTargetClass(String name2, Set<VirtualFile> files, OCClassSymbol symbol, OCClassSymbol sourceSymbol, Project project2) {
        super(name2, files, symbol, sourceSymbol, project2);
    }

    @Override
    public void locateTargetClass() {
        super.locateTargetClass();
        OCSymbol associatedClassSymbol = ((OCClassSymbol)this.mySymbol).getAssociatedSymbol(this.myProject);
        this.myImplementation = associatedClassSymbol != null ? (OCClassDeclaration)associatedClassSymbol.locateDefinition(this.myProject) : null;
    }

    @Override
    @Nullable
    protected VirtualFile getTargetFile(PsiElement element, OCSymbol symbol) {
        if (symbol instanceof OCMemberSymbol) {
            if ("".equals(((OCClassSymbol)((OCMemberSymbol)symbol).getParent()).getCategoryName())) {
                return this.myImplementation != null ? this.myImplementation.getContainingFile().getVirtualFile() : null;
            }
            if (((OCClassSymbol)((OCMemberSymbol)symbol).getParent()).getKind() == ((OCClassSymbol)this.mySymbol).getKind()) {
                return ((OCClassDeclaration)this.myPsi).getContainingFile().getVirtualFile();
            }
            return this.myImplementation != null ? this.myImplementation.getContainingFile().getVirtualFile() : null;
        }
        return null;
    }

    @Override
    @Nullable
    public OCSymbolDeclarator addMember(PsiElement element, OCSymbol symbol, OCVisibility visibility) {
        OCSymbolDeclarator newDeclarator = null;
        if (symbol instanceof OCMemberSymbol) {
            OCClassDeclaration clazz;
            if ("".equals(((OCClassSymbol)((OCMemberSymbol)symbol).getParent()).getCategoryName())) {
                if (this.myPrivateCategory == null && this.myImplementation != null) {
                    this.myPrivateCategory = OCElementFactory.interfaceByName(((OCClassSymbol)this.mySymbol).getName() + "()", this.myImplementation);
                    this.myPrivateCategory = OCChangeUtil.addBefore(this.myImplementation.getParent(), this.myPrivateCategory, this.myImplementation);
                }
                clazz = this.myPrivateCategory;
            } else {
                clazz = ((OCMemberSymbol)symbol).getParent() instanceof OCImplementationSymbol ? this.myImplementation : (OCClassDeclaration)this.myPsi;
            }
            if (clazz == null) {
                return null;
            }
            if (symbol instanceof OCInstanceVariableSymbol) {
                newDeclarator = this.myMover.addInstanceVariable(clazz, (OCInstanceVariableSymbol)symbol, (OCDeclaration)element);
            } else {
                PsiElement newElement;
                if (symbol instanceof OCPropertySymbol) {
                    element = PsiTreeUtil.getParentOfType((PsiElement)element, OCProperty.class);
                }
                if ((newElement = OCChangeUtil.add(clazz, element)) instanceof OCProperty) {
                    newDeclarator = ((OCProperty)newElement).getDeclaration().getDeclarators().get(0);
                } else if (newElement instanceof OCMethod) {
                    newDeclarator = (OCSymbolDeclarator)newElement;
                } else if (newElement instanceof OCSynthesizePropertiesList) {
                    newDeclarator = ((OCSynthesizePropertiesList)newElement).getProperties().get(0);
                }
            }
        } else if (symbol instanceof OCProtocolSymbol) {
            this.myMover.addBaseProtocol((OCClassDeclaration)this.myPsi, symbol.getName());
        }
        return newDeclarator;
    }
}

