/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.refactoring.move.OCCopyMoveProcessor;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveFilesHandlerDelegate<M, R, G extends R, P, RTP, RPP>
extends MoveFilesOrDirectoriesHandler {
    private static Function<MultiMap<PsiElement, String>, Boolean> ourShowConflictsFunction;

    public static void setShowConflictsFunctionInTests(Function<MultiMap<PsiElement, String>, Boolean> conflictsFunction, @NotNull Disposable disposable) {
        if (disposable == null) {
            OCMoveFilesHandlerDelegate.$$$reportNull$$$0(0);
        }
        ourShowConflictsFunction = conflictsFunction;
        Disposer.register((Disposable)disposable, () -> {
            ourShowConflictsFunction = null;
        });
    }

    public void doMove(final Project project2, final PsiElement[] elements, PsiElement targetContainer, final MoveCallback callback) {
        if (targetContainer == null) {
            for (PsiElement element : elements) {
                if (!this.skipElement(element)) continue;
                return;
            }
            MoveFilesOrDirectoriesDialog moveDialog = new MoveFilesOrDirectoriesDialog(project2, new MoveFilesOrDirectoriesDialog.Callback(){

                public void run(MoveFilesOrDirectoriesDialog dialog) {
                    OCMoveFilesHandlerDelegate.this.doMove(project2, elements, (PsiElement)dialog.getTargetDirectory(), callback);
                    dialog.close(1);
                }
            });
            moveDialog.setData(elements, MoveFilesOrDirectoriesUtil.getInitialTargetDirectory(null, (PsiElement[])elements), "refactoring.moveFile");
            moveDialog.show();
            return;
        }
        new OCCopyMoveProcessor<M, R, G, P>(elements){

            @Override
            protected void doActionForExternalFiles(Project project22, final @NotNull P projectFile, final @NotNull List<VirtualFile> notInProjectFiles, @Nullable G targetGroup, @NotNull PsiDirectory targetDirectory) {
                if (projectFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notInProjectFiles == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (targetDirectory == null) {
                    2.$$$reportNull$$$0(2);
                }
                new WriteCommandAction(project22, new PsiFile[0]){

                    protected void run(@NotNull Result result) throws Throwable {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        THashSet paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                        for (VirtualFile file : notInProjectFiles) {
                            VfsUtil.processFilesRecursively((VirtualFile)file, file1 -> paths.add((Object)file1.getPath()));
                        }
                        OCMoveFilesHandlerDelegate.this.removePaths((THashSet<String>)paths, projectFile);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveFilesHandlerDelegate$2$1", "run"));
                    }
                }.execute();
                ProjectUtil.focusProjectWindow((Project)project22, (boolean)true);
                OCMoveFilesHandlerDelegate.this.addFiles(project22, projectFile, notInProjectFiles, targetGroup, targetDirectory);
            }

            @Override
            protected void doAction(@NotNull OCCopyMoveProcessor.Helper<M, R, G, P> helper, @NotNull P projectFile, final @NotNull PsiDirectory targetDir, final @NotNull G targetGroup, @NotNull List<R> sourceRefs) {
                boolean canRefactor;
                Object targetProvider;
                if (helper == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (projectFile == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (targetDir == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (targetGroup == null) {
                    2.$$$reportNull$$$0(6);
                }
                if (sourceRefs == null) {
                    2.$$$reportNull$$$0(7);
                }
                if ((targetProvider = OCMoveFilesHandlerDelegate.this.getTargetProvider(sourceRefs, targetGroup)) == null) {
                    return;
                }
                MultiMap conflicts = new MultiMap();
                final Object manipulator = helper.getManipulator(projectFile);
                final Completer completer = new Completer(helper, manipulator);
                SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)targetDir.getProject());
                for (final Object sourceRef : sourceRefs) {
                    PsiFileSystemItem sourceElement = OCMoveFilesHandlerDelegate.this.findPsiFileItemToMove(sourceRef);
                    if (OCMoveFilesHandlerDelegate.this.isValid(sourceRef) && OCMoveFilesHandlerDelegate.this.isValid(targetGroup)) {
                        final String srcPath = OCMoveFilesHandlerDelegate.this.getPath(sourceRef);
                        if (sourceElement == null || srcPath == null) continue;
                        String errorMessage = 2.checkOperationIsValid(sourceElement, targetDir, sourceElement.getName(), false, true);
                        if (errorMessage == null) {
                            SmartPsiElementPointer pointer = pointerManager.createSmartPsiElementPointer((PsiElement)sourceElement);
                            completer.addTask(() -> {
                                PsiFileSystemItem validSourceElement;
                                if (targetDir == null) {
                                    2.$$$reportNull$$$0(12);
                                }
                                if (targetGroup == null) {
                                    2.$$$reportNull$$$0(13);
                                }
                                if ((validSourceElement = (PsiFileSystemItem)pointer.getElement()) == null) {
                                    return;
                                }
                                new MoveFilesOrDirectoriesProcessor(project2, new PsiElement[]{validSourceElement}, targetDir, RefactoringSettings.getInstance().MOVE_SEARCH_FOR_REFERENCES_FOR_FILE, false, false, new MoveCallback(){

                                    public void refactoringCompleted() {
                                        VirtualFile dstVFile;
                                        DocumentReference ref = DocumentReferenceManager.getInstance().create(targetDir.getVirtualFile());
                                        UndoManager.getInstance((Project)project2).nonundoableActionPerformed(ref, true);
                                        PsiDirectory newFile = validSourceElement.isDirectory() ? targetDir.findSubdirectory(validSourceElement.getName()) : targetDir.findFile(validSourceElement.getName());
                                        VirtualFile virtualFile = dstVFile = newFile == null ? null : newFile.getVirtualFile();
                                        if (dstVFile != null) {
                                            String dstPath = dstVFile.getPath();
                                            Object pathProvider = OCMoveFilesHandlerDelegate.this.getReferencePathProviderForCopying(dstPath, srcPath);
                                            OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, pathProvider, targetGroup, targetProvider);
                                        }
                                        WriteAction.run(() -> {
                                            completer.oneTaskExecuted();
                                            if (callback != null) {
                                                callback.refactoringCompleted();
                                            }
                                        });
                                    }
                                }, null).run();
                            });
                            continue;
                        }
                        if (OCMoveFilesHandlerDelegate.this.isFilesView(project2)) {
                            conflicts.putValue((Object)sourceElement, (Object)(errorMessage + ". File won't be moved."));
                            continue;
                        }
                        conflicts.putValue((Object)sourceElement, (Object)(errorMessage + ". File won't be moved, only reference will be changed."));
                        completer.addTask(() -> {
                            if (targetGroup == null) {
                                2.$$$reportNull$$$0(10);
                            }
                            WriteAction.run(() -> {
                                if (targetGroup == null) {
                                    2.$$$reportNull$$$0(11);
                                }
                                OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, OCMoveFilesHandlerDelegate.this.getIdPathProvider(), targetGroup, targetProvider);
                                completer.oneTaskExecuted();
                            });
                        });
                        continue;
                    }
                    completer.addTask(() -> {
                        if (targetGroup == null) {
                            2.$$$reportNull$$$0(8);
                        }
                        WriteAction.run(() -> {
                            if (targetGroup == null) {
                                2.$$$reportNull$$$0(9);
                            }
                            OCMoveFilesHandlerDelegate.this.moveReference(manipulator, sourceRef, OCMoveFilesHandlerDelegate.this.getIdPathProvider(), targetGroup, targetProvider);
                            completer.oneTaskExecuted();
                        });
                    });
                }
                boolean bl = canRefactor = !completer.isEmpty();
                if (!conflicts.isEmpty()) {
                    canRefactor = ourShowConflictsFunction != null ? (canRefactor &= ((Boolean)ourShowConflictsFunction.apply(conflicts)).booleanValue()) : (canRefactor &= new ConflictsDialog(project2, conflicts, null, canRefactor, false).showAndGet());
                }
                if (canRefactor) {
                    completer.executeTasks();
                }
            }

            @Override
            protected OCCopyMoveProcessor.Helper<M, R, G, P> getHelper() {
                return OCMoveFilesHandlerDelegate.this.getHelper();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "projectFile";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notInProjectFiles";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetDirectory";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "helper";
                        break;
                    }
                    case 5: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetDir";
                        break;
                    }
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetGroup";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceRefs";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveFilesHandlerDelegate$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doActionForExternalFiles";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doAction";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$doAction$4";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$3";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$doAction$2";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$1";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$doAction$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.process(project2, targetContainer);
    }

    protected abstract boolean isFilesView(Project var1);

    protected abstract boolean skipElement(PsiElement var1);

    protected abstract RPP getReferencePathProviderForCopying(String var1, String var2);

    protected abstract RPP getIdPathProvider();

    protected abstract boolean isValid(R var1);

    protected abstract String getPath(R var1);

    protected abstract PsiFileSystemItem findPsiFileItemToMove(R var1);

    protected abstract void addFiles(Project var1, P var2, List<VirtualFile> var3, G var4, PsiDirectory var5);

    protected abstract void removePaths(THashSet<String> var1, P var2);

    protected abstract OCCopyMoveProcessor.Helper<M, R, G, P> getHelper();

    @NotNull
    protected abstract List<? extends Object> moveReference(@NotNull M var1, @NotNull R var2, @NotNull RPP var3, @NotNull G var4, @NotNull RTP var5);

    @Nullable
    protected abstract RTP getTargetProvider(@NotNull List<R> var1, @NotNull G var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveFilesHandlerDelegate", "setShowConflictsFunctionInTests"));
    }

    private class Completer {
        private final ArrayList<Runnable> myRefactorings = new ArrayList();
        private volatile int myCounter = 0;
        private final OCCopyMoveProcessor.Helper<M, R, G, P> myHelper;
        private final M myManipulator;

        public Completer(OCCopyMoveProcessor.Helper<M, R, G, P> helper, M manipulator) {
            this.myHelper = helper;
            this.myManipulator = manipulator;
        }

        void addTask(Runnable refactoring) {
            this.myRefactorings.add(refactoring);
            ++this.myCounter;
        }

        boolean isEmpty() {
            return this.myCounter == 0;
        }

        void executeTasks() {
            for (Runnable refactoring : this.myRefactorings) {
                refactoring.run();
            }
        }

        void oneTaskExecuted() {
            --this.myCounter;
            if (this.myCounter == 0) {
                this.myHelper.completeManipulation(this.myManipulator);
            }
        }
    }
}

