/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project2 == null) {
            OCMoveRefactoringHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            OCMoveRefactoringHandler.$$$reportNull$$$0(1);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        OCSymbolDeclarator clazz = (OCSymbolDeclarator)PsiTreeUtil.getNonStrictParentOfType((PsiElement)elements[0], (Class[])new Class[]{OCClassDeclaration.class, OCStruct.class});
        if (clazz == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)OCMoveRefactoringHandler.getInvalidPositionMessage());
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getTitle(), null);
            return;
        }
        HashSet<PsiElement> set = new HashSet<PsiElement>(Arrays.asList(elements));
        this.showDialog(clazz, (Condition<PsiElement>)((Condition)element -> set.contains(element)), editor);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file, DataContext dataContext) {
        if (project2 == null) {
            OCMoveRefactoringHandler.$$$reportNull$$$0(2);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(this.getFeatureID());
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)OCMoveRefactoringHandler.getInvalidPositionMessage());
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getTitle(), null);
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)element)) {
                return;
            }
            if (this.acceptsElement(element)) break;
            element = element.getParent();
        }
        OCSymbolDeclarator clazz = (OCSymbolDeclarator)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class, OCStruct.class});
        if (clazz == null && element instanceof OCFunctionDeclaration) {
            OCSymbol symbol = ((OCFunctionDeclaration)element).getSymbol();
            symbol = symbol != null ? symbol.getAssociatedSymbol(project2) : null;
            element = symbol != null ? symbol.locateDefinition(project2) : null;
            clazz = (OCSymbolDeclarator)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class, OCStruct.class});
        }
        if (clazz == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)OCMoveRefactoringHandler.getInvalidPositionMessage());
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getTitle(), null);
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            TextRange selectionRange = new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
            this.showDialog(clazz, (Condition<PsiElement>)((Condition)element12 -> element12 != null && file.equals(element12.getContainingFile()) && selectionRange.contains(element12.getTextRange())), editor);
        } else {
            PsiElement chosenElement = element;
            this.showDialog(clazz, (Condition<PsiElement>)((Condition)element1 -> element1 == chosenElement), editor);
        }
    }

    protected boolean acceptsElement(PsiElement element) {
        if (element instanceof OCDeclarator) {
            OCSymbol symbol = ((OCDeclarator)element).getSymbol();
            return symbol instanceof OCInstanceVariableSymbol || symbol instanceof OCPropertySymbol || symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() instanceof OCStructSymbol;
        }
        return element instanceof OCClassDeclaration || element instanceof OCMethod || element instanceof OCProperty || element instanceof OCStruct || element instanceof OCFunctionDeclaration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDialog(OCSymbolDeclarator clazz, Condition<PsiElement> selectedCond, Editor editor) {
        OCAbstractMoveDialog dialog;
        Project project2 = clazz.getProject();
        Object symbol = clazz.getSymbol();
        if (!OCSearchScope.isInProjectSources(clazz)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactoringBundle.message((String)"error.out.of.project.element.default"), (String)this.getTitle(), null);
            return;
        }
        if (symbol == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)"Can't find the symbol for the selected class");
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getTitle(), null);
            return;
        }
        if (symbol instanceof OCClassSymbol) {
            OCInterfaceSymbol anInterface;
            OCClassSymbol classSymbol = (OCClassSymbol)symbol;
            OCInterfaceSymbol oCInterfaceSymbol = anInterface = "".equals(classSymbol.getCategoryName()) ? classSymbol.getMainInterface(project2) : classSymbol.getInterface(project2);
            if (anInterface != symbol) {
                OCClassDeclarationBase interfaceElement;
                OCClassDeclarationBase oCClassDeclarationBase = interfaceElement = anInterface != null ? (OCClassDeclarationBase)anInterface.locateDefinition(project2) : null;
                if (anInterface != null && interfaceElement != null) {
                    symbol = anInterface;
                    clazz = interfaceElement;
                }
            }
        }
        if ((dialog = this.createDialog(clazz, (OCSymbol)symbol, selectedCond, editor)) == null) {
            return;
        }
        if (!dialog.allowsEmptySelection() && dialog.getMemberInfos().isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)(symbol.getNameWithKindUppercase(OCCompilationContext.create(clazz)) + " has no members to move"));
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)message, (String)this.getTitle(), null);
            Disposer.dispose((Disposable)dialog.getDisposable());
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                if (dialog.checkConflicts()) {
                    Pair<OCFile[], String> pair2 = dialog.invokeRefactoring();
                    this.passToTest((String)pair2.getSecond(), (OCFile[])pair2.getFirst());
                }
                return;
            }
            finally {
                Disposer.dispose((Disposable)dialog.getDisposable());
            }
        }
        dialog.show();
    }

    protected void passToTest(String conflicts, OCFile[] newFiles) {
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        for (PsiElement element : elements) {
            if (this.acceptsElement(element)) continue;
            return false;
        }
        return true;
    }

    protected static String getInvalidPositionMessage() {
        return "The caret should be positioned inside a class";
    }

    protected abstract String getTitle();

    @Nullable
    protected abstract OCAbstractMoveDialog createDialog(OCSymbolDeclarator var1, OCSymbol var2, Condition<PsiElement> var3, Editor var4);

    @NotNull
    protected abstract String getFeatureID();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/refactoring/move/handlers/OCMoveRefactoringHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

