/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.classMembers.UsedByDependencyMemberInfoModel;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCategoryAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCObjcTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractExtractDialog;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCExtractCategoryDialog
extends OCAbstractExtractDialog {
    public OCExtractCategoryDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition) {
        if (clazz == null) {
            OCExtractCategoryDialog.$$$reportNull$$$0(0);
        }
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(clazz);
        this.setMembersChecked();
        this.setTitle("Extract Category");
        this.init();
    }

    @Override
    protected String getClassType() {
        return "Category";
    }

    @Override
    protected OCMoveProcessor createProcessor() {
        return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), this.getClassName(), Collections.emptyList()){

            @Override
            protected OCNewFileActionBase getNewClassAction() {
                return new OCNewCategoryAction(){

                    @Override
                    @Nullable
                    protected OCClassSymbol getBaseClass() {
                        OCClassDeclaration element = (OCClassDeclaration)mySourceClass.getElement();
                        return element != null ? element.getSymbol() : null;
                    }
                };
            }

            @Override
            protected void locateTargetClasses() {
                ((OCObjcTargetClass)this.myTargetClasses.get(0)).setName(OCCodeInsightUtil.getClassNameWithCategory(((OCClassSymbol)this.mySourceClassSymbol).getName(), OCExtractCategoryDialog.this.getClassName()));
                super.locateTargetClasses();
            }

            @NotNull
            protected String getCommandName() {
                String string = OCExtractCategoryDialog.this.getTitle();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/ui/OCExtractCategoryDialog$1", "getCommandName"));
            }
        };
    }

    @Override
    public boolean checkConflicts() {
        String className = this.getClassName();
        OCSymbol existing = OCCodeInsightUtil.resolveNameInScope(this.getSymbolKind(), this.myClassSymbol.getName(), className, null, this.myProject);
        if (existing != null) {
            Messages.showErrorDialog((String)(existing.getNameWithKindUppercase(OCCompilationContext.create(existing, this.myProject)) + " already exists"), (String)"Unable to Create a File");
            return false;
        }
        return true;
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return "Extracted code will be inaccessible from the " + symbol.getNameWithKindLowercase(OCCompilationContext.create(symbol, this.myProject));
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new UsedByDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass){

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCExtractCategoryDialog.this.isMemberEnabled(member);
            }
        };
    }

    @Override
    protected boolean isMemberEnabled(OCMemberInfo member) {
        if (member.getSymbol() instanceof OCInstanceVariableSymbol) {
            return false;
        }
        return !(member.getSymbol() instanceof OCPropertySymbol) || ((OCPropertySymbol)member.getSymbol()).processSynthesizes((Processor<? super OCSynthesizeSymbol>)new CommonProcessors.FindFirstProcessor(), this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/refactoring/move/ui/OCExtractCategoryDialog", "<init>"));
    }
}

