/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewSourceFileAction;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveTopLevelProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCTopLevelModel;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.ui.OCFileReferenceEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMoveTopLevelDialog
extends OCAbstractMoveDialog {
    private OCFileReferenceEditor myTargetFileField;

    public OCMoveTopLevelDialog(@NotNull OCFile file, Condition<PsiElement> selectedCondition, String targetFileName) {
        if (file == null) {
            OCMoveTopLevelDialog.$$$reportNull$$$0(0);
        }
        super(null, null, selectedCondition, file.getProject());
        this.mySourceFile = file;
        this.myMemberInfos = this.myStorage.getClassMemberInfos(file);
        this.myMemberInfoModel = this.createModel();
        this.setMembersChecked();
        this.setTitle("Move Declarations");
        this.init();
        if (targetFileName != null) {
            this.myTargetFileField.setText(targetFileName);
        }
    }

    public OCMoveTopLevelDialog(@NotNull OCCppNamespace namespace, OCNamespaceSymbol symbol, Condition<PsiElement> selectedCondition, String targetFileName) {
        if (namespace == null) {
            OCMoveTopLevelDialog.$$$reportNull$$$0(1);
        }
        super(namespace, symbol, selectedCondition, namespace.getProject());
        this.myMemberInfos = this.myStorage.getClassMemberInfos(namespace);
        this.myMemberInfoModel = this.createModel();
        this.setMembersChecked();
        this.setTitle("Move Declarations");
        this.init();
        if (targetFileName != null) {
            this.myTargetFileField.setText(targetFileName);
        }
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.moveMembers";
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel("Move declarations to file (existing or new):"), "North");
        this.myTargetFileField = OCFileReferenceEditor.create(this.myProject);
        _panel.add((Component)((Object)this.myTargetFileField), "Center");
        this.myTargetFileField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                OCMoveTopLevelDialog.this.validateButtons();
            }
        });
        Box box = Box.createVerticalBox();
        box.add(_panel);
        box.add(Box.createVerticalStrut(7));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)box, "Center");
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTargetFileField;
    }

    @Override
    public boolean allowsEmptySelection() {
        return false;
    }

    @Override
    protected void checkCanRun() throws ConfigurationException {
        super.checkCanRun();
        String targetName = this.getTargetName();
        OCFile file = this.getTargetFile();
        if (targetName.isEmpty()) {
            throw new ConfigurationException("No target file is selected");
        }
        if (!PathUtil.isValidFileName((String)targetName)) {
            throw new ConfigurationException("Name of the file is invalid");
        }
        if (file != null && !file.isInProjectSources()) {
            throw new ConfigurationException("File \"" + file.getName() + "\" is not located inside the project");
        }
        if (file != null && file.equals(this.mySourceFile)) {
            throw new ConfigurationException("Source and target files should be different");
        }
    }

    @Override
    public boolean checkConflicts() {
        String message = "Target file \"" + this.getTargetName() + "\" doesn't yet exist.";
        return this.getTargetFile() != null || OCNewFileActionBase.isNewFileActionSupported() && Messages.showYesNoDialog((Project)this.getProject(), (String)message, (String)this.getTitle(), (String)"Create New File", (String)"Cancel", (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    public String getTargetName() {
        String string = this.myTargetFileField.getText().trim();
        if (string == null) {
            OCMoveTopLevelDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private OCFile getTargetFile() {
        return this.myTargetFileField != null ? this.myTargetFileField.getFile(this.myProject) : null;
    }

    @Override
    protected String getOKButtonText() {
        return "&Move";
    }

    private PsiElement getSource() {
        return this.mySourceClass != null ? this.mySourceClass : this.mySourceFile;
    }

    @Override
    @Nullable
    protected OCMoveProcessor createProcessor() {
        return new OCMoveTopLevelProcessor(this.getSource(), this.getTargetName(), this.getTargetFile(), this.getSelectedMemberInfos()){

            @NotNull
            protected String getCommandName() {
                String string = OCMoveTopLevelDialog.this.getTitle();
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @Nullable
            protected OCNewFileActionBase getNewClassAction() {
                return new OCNewSourceFileAction();
            }

            @Override
            protected boolean importTargetFromSource() {
                return ((OCTopLevelModel)OCMoveTopLevelDialog.this.myMemberInfoModel).importTargetFromSource();
            }

            @Override
            protected boolean importSourceFromTarget() {
                return ((OCTopLevelModel)OCMoveTopLevelDialog.this.myMemberInfoModel).importSourceFromTarget();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/ui/OCMoveTopLevelDialog$2", "getCommandName"));
            }
        };
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new OCTopLevelModel(this.getSource());
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/move/ui/OCMoveTopLevelDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/ui/OCMoveTopLevelDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

