/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move.ui;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractUsesDependencyMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveCppProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveObjCProcessor;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.move.ui.OCAbstractMoveDialog;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPullUpDialog
extends OCAbstractMoveDialog {
    private JComboBox mySuperClassCombo;
    private List<OCSymbolDeclarator> mySuperClasses;
    private String myTargetClassName;
    private boolean myRemoveConflictingMembers;
    private Map<OCSymbolDeclarator, OCSymbol> myTargetSymbolsMap;

    public OCPullUpDialog(@NotNull OCSymbolDeclarator clazz, OCSymbol classSymbol, Condition<PsiElement> selectedCondition, @Nullable String targetClassName, boolean removeConflictingMembers) {
        if (clazz == null) {
            OCPullUpDialog.$$$reportNull$$$0(0);
        }
        super(clazz, classSymbol, selectedCondition, clazz.getProject());
        this.myTargetSymbolsMap = new HashMap();
        this.myTargetClassName = targetClassName;
        this.myRemoveConflictingMembers = removeConflictingMembers;
        this.mySuperClasses = this.myStorage.getSuperClasses();
        this.setTitle(RefactoringBundle.message((String)"pull.members.up.title"));
        this.init();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.pullMembersUp";
    }

    protected JComponent createNorthPanel() {
        int index;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classComboLabel = new JLabel();
        panel.add((Component)classComboLabel, gbConstraints);
        for (OCSymbolDeclarator clazz : this.mySuperClasses) {
            this.myTargetSymbolsMap.put(clazz, (OCSymbol)clazz.getSymbol());
        }
        this.mySuperClassCombo = new JComboBox<Object>(this.mySuperClasses.toArray());
        if (this.myTargetClassName != null) {
            OCSymbolDeclarator superClass;
            OCSymbol symbol;
            for (index = 0; !(index >= this.mySuperClasses.size() || (symbol = this.myTargetSymbolsMap.get(superClass = this.mySuperClasses.get(index))) != null && symbol.getName().equals(this.myTargetClassName)); ++index) {
            }
            assert (index < this.mySuperClasses.size()) : "Target class '" + this.myTargetClassName + "' is not found";
        } else {
            index = this.mySuperClasses.size() - 1;
        }
        this.mySuperClassCombo.setSelectedIndex(index);
        this.mySuperClassCombo.setRenderer(new ListCellRendererWrapper<OCSymbolDeclarator>(){

            public void customize(JList list, OCSymbolDeclarator clazz, int index, boolean selected, boolean hasFocus) {
                OCSymbol symbol = (OCSymbol)OCPullUpDialog.this.myTargetSymbolsMap.get(clazz);
                if (symbol != null) {
                    this.setText(symbol.getPresentableName());
                    this.setIcon(symbol.getIcon(OCPullUpDialog.this.getProject()));
                } else {
                    this.setText(((OCElementBase)((Object)clazz)).getName());
                }
            }
        });
        classComboLabel.setText(RefactoringBundle.message((String)"pull.up.members.to", (Object[])new Object[]{this.myClassSymbol.getNameWithKindLowercase(OCCompilationContext.create(this.mySourceFile))}));
        classComboLabel.setLabelFor(this.mySuperClassCombo);
        this.mySuperClassCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    OCPullUpDialog.this.updateMembersInfo();
                    if (OCPullUpDialog.this.myMemberSelectionPanel != null) {
                        OCSymbolDeclarator targetClass = (OCSymbolDeclarator)OCPullUpDialog.this.mySuperClassCombo.getSelectedItem();
                        ((AbstractUsesDependencyMemberInfoModel)OCPullUpDialog.this.myMemberInfoModel).setSuperClass((PsiElement)targetClass);
                        OCPullUpDialog.this.myMemberSelectionPanel.getTable().setMemberInfos(OCPullUpDialog.this.myMemberInfos);
                        OCPullUpDialog.this.myMemberSelectionPanel.getTable().fireExternalDataChange();
                    }
                }
            }
        });
        ++gbConstraints.gridy;
        panel.add((Component)this.mySuperClassCombo, gbConstraints);
        this.updateMembersInfo();
        return panel;
    }

    private void updateMembersInfo() {
        OCSymbolDeclarator targetClass = (OCSymbolDeclarator)this.mySuperClassCombo.getSelectedItem();
        if (targetClass != null) {
            this.myMemberInfos = this.myStorage.getIntermediateMemberInfosList(targetClass);
            this.setMembersChecked();
        } else {
            this.myMemberInfos = this.myStorage.getClassMemberInfos(this.mySourceClass);
        }
    }

    @Override
    protected boolean isMemberEnabled(OCMemberInfo member) {
        OCSymbolDeclarator targetClass = (OCSymbolDeclarator)this.mySuperClassCombo.getSelectedItem();
        if (this.myStorage.getExtending(targetClass).contains(member.getSymbol().locateDefinition(this.myProject))) {
            return false;
        }
        if (targetClass instanceof OCProtocol && member.getSymbol() instanceof OCInstanceVariableSymbol) {
            return false;
        }
        return !this.myStorage.getDuplicatedMemberInfos(targetClass).contains((Object)member);
    }

    public Collection<OCSymbolDeclarator> getSuperClasses() {
        return this.mySuperClasses;
    }

    @Override
    protected OCMoveProcessor createProcessor() {
        OCSymbol targetSymbol = this.myTargetSymbolsMap.get((OCSymbolDeclarator)this.mySuperClassCombo.getSelectedItem());
        assert (targetSymbol != null);
        if (this.mySourceClass instanceof OCClassDeclaration) {
            return new OCMoveObjCProcessor((OCClassDeclaration)this.mySourceClass, this.getSelectedMemberInfos(), null, Collections.singletonList((OCClassSymbol)targetSymbol)){

                @NotNull
                protected String getCommandName() {
                    String string = OCPullUpDialog.this.getTitle();
                    if (string == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected boolean removeConflictingMembers() {
                    return OCPullUpDialog.this.myRemoveConflictingMembers;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPullUpDialog$3", "getCommandName"));
                }
            };
        }
        if (this.mySourceClass instanceof OCStruct) {
            return new OCMoveCppProcessor((OCStruct)this.mySourceClass, this.getSelectedMemberInfos(), null, Collections.singletonList((OCStructSymbol)targetSymbol)){

                @NotNull
                protected String getCommandName() {
                    String string = OCPullUpDialog.this.getTitle();
                    if (string == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                protected boolean removeConflictingMembers() {
                    return OCPullUpDialog.this.myRemoveConflictingMembers;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPullUpDialog$4", "getCommandName"));
                }
            };
        }
        assert (false) : this.mySourceClass;
        return null;
    }

    @Override
    protected MemberInfoModel<OCSymbolHolderVirtualPsiElement, OCMemberInfo> createModel() {
        return new AbstractUsesDependencyMemberInfoModel<OCSymbolHolderVirtualPsiElement, OCSymbolDeclarator, OCMemberInfo>(this.mySourceClass, null, false){

            protected int doCheck(@NotNull OCMemberInfo memberInfo, int problem) {
                if (memberInfo == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (problem == 2 && memberInfo.isStatic()) {
                    return 1;
                }
                return problem;
            }

            public boolean isMemberEnabled(OCMemberInfo member) {
                return OCPullUpDialog.this.isMemberEnabled(member);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberInfo", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPullUpDialog$5", "doCheck"));
            }
        };
    }

    @Override
    protected String getConflictMessage(OCMemberInfo info, OCSymbol symbol) {
        return symbol.getNameWithKindUppercase(OCCompilationContext.create(symbol, this.myProject)) + " will be inaccessible in the pulled code";
    }

    @Override
    protected String getOKButtonText() {
        return "P&ull";
    }

    @Override
    public boolean allowsEmptySelection() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/jetbrains/cidr/lang/refactoring/move/ui/OCPullUpDialog", "<init>"));
    }
}

