/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.rename.OCInplaceRenamer;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.refactoring.rename.OCUnresolvedReferenceRenamer;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedVirtualPsiElement;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInplaceRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(PsiElement element, Editor editor, PsiFile file) {
        OCSymbol<PsiElement> symbol;
        PsiElement atCursor;
        if (!(file instanceof OCFile)) {
            return false;
        }
        if (!(element == null || element.getContainingFile() instanceof OCFile && file.getManager().isInProject(element))) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)offset);
        if (reference != null && ((atCursor = reference.getElement()) instanceof OCReferenceElement || atCursor instanceof OCQualifiedExpression)) {
            return true;
        }
        if (element == null) {
            return false;
        }
        if (element instanceof OCMethod) {
            symbol = (OCMethodSymbol)((OCMethod)element).getSymbol();
            OCSymbol<PsiElement> oCSymbol = symbol = symbol != null ? symbol.getAssociatedSymbol(element.getProject()) : null;
            if (symbol != null && symbol.getGeneratedFromProperty() != null) {
                return false;
            }
        } else if (element instanceof OCDeclarator) {
            symbol = ((OCDeclarator)element).getSymbol();
            if (symbol instanceof OCPropertySymbol) {
                if (reference != null && reference.getElement() instanceof OCSendMessageExpression && !symbol.getName().equals(((OCSendMessageExpression)reference.getElement()).getMessageSelector())) {
                    return false;
                }
            } else if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppOperator()) {
                return ((OCFunctionSymbol)symbol).isUDL();
            }
        }
        if (element instanceof PsiNameIdentifierOwner) {
            PsiElement id = ((PsiNameIdentifierOwner)element).getNameIdentifier();
            return id != null && !element.getTextRange().isEmpty();
        }
        return false;
    }

    public VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor) {
        if (elementToRename == null) {
            OCInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        return OCInplaceRenameHandler.createRenamer(elementToRename, editor, null, null);
    }

    @Nullable
    static VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, Editor editor, @Nullable String initialName, @Nullable String oldName) {
        if (elementToRename == null) {
            OCInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (elementToRename instanceof OCCategoryName) {
            OCClassSymbol symbol = ((OCClassDeclaration)elementToRename.getParent()).getSymbol();
            if (symbol != null) {
                return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, true, initialName, oldName);
            }
        } else {
            PsiElement element;
            OCSymbol<?> symbol = OCRenameUtil.getSymbolToRename(elementToRename);
            if (symbol == null) {
                return null;
            }
            if (symbol instanceof OCFunctionGroupSymbol) {
                CommonRefactoringUtil.showErrorHint((Project)elementToRename.getProject(), (Editor)editor, (String)OCBundle.message("refactoring.ambiguous", new Object[0]), (String)RefactoringBundle.message((String)"rename.title"), null);
                return null;
            }
            PsiFile currentFile = PsiDocumentManager.getInstance((Project)elementToRename.getProject()).getPsiFile(editor.getDocument());
            PsiElement psiElement = element = currentFile != null ? currentFile.findElementAt(editor.getCaretModel().getOffset()) : null;
            if (currentFile != null && OCElementUtil.getElementType(element) != OCTokenTypes.IDENTIFIER) {
                element = currentFile.findElementAt(editor.getCaretModel().getOffset() - 1);
            }
            if (elementToRename instanceof OCMethod) {
                OCMethod method = (OCMethod)elementToRename;
                if (symbol instanceof OCMethodSymbol && element != null && OCElementUtil.getElementType(element) == OCTokenTypes.IDENTIFIER) {
                    PsiElement parent = element.getParent();
                    OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol;
                    int index = -1;
                    if (parent instanceof OCMethodSelectorPart && ((OCMethodSelectorPart)parent).getSelectorIdentifier() == element) {
                        index = method.getSelectors().indexOf(element);
                    } else if (parent instanceof OCArgumentSelector && ((OCArgumentSelector)parent).getSelectorIdentifier() == element) {
                        OCSendMessageExpression sendMessageExpr = (OCSendMessageExpression)parent.getParent().getParent();
                        index = sendMessageExpr.getArgumentSelectors().indexOf(parent);
                    } else if (parent instanceof OCQualifiedExpression) {
                        index = 0;
                    } else if (parent instanceof OCSelectorExpression) {
                        index = ((OCSelectorExpression)parent).getSelectorParts().indexOf(element);
                    }
                    if (index != -1) {
                        return new OCInplaceRenamer(method, methodSymbol, element, index, editor, initialName, oldName);
                    }
                }
                return new OCInplaceRenamer((OCMethod)elementToRename, symbol, editor, false, initialName, oldName){

                    @Override
                    public boolean performInplaceRename() {
                        return true;
                    }
                };
            }
            if (symbol instanceof OCInstanceVariableSymbol && elementToRename instanceof OCReferenceElement) {
                return new OCInplaceRenamer((PsiNamedElement)new OCSymbolHolderVirtualPsiElement(symbol, elementToRename.getProject()), symbol, editor, false, initialName, oldName);
            }
            if (symbol instanceof OCPropertySymbol && element != null && element.getParent() instanceof OCSelectorExpression && OCNameSuggester.isObjCSetter(((OCSelectorExpression)element.getParent()).getSelector())) {
                return null;
            }
            if (elementToRename instanceof OCLocalizedString) {
                int offset;
                if (OCElementUtil.getElementType(elementToRename.getFirstChild()) != OCTokenTypes.STRING_LITERAL || ((OCLocalizedString)elementToRename).getKey().isEmpty()) {
                    return null;
                }
                if (currentFile != null && (element = currentFile.findElementAt(offset = editor.getCaretModel().getOffset())) != null && OCElementUtil.getElementType(element) == OCTokenTypes.STRING_LITERAL && offset == element.getTextOffset()) {
                    editor.getCaretModel().moveToOffset(offset + 1);
                }
            } else if (symbol instanceof OCStructSymbol && elementToRename instanceof OCCompilerGeneratedVirtualPsiElement && (elementToRename = symbol.locateDefinition(elementToRename.getProject())) == null) {
                return null;
            }
            return new OCInplaceRenamer((PsiNamedElement)elementToRename, symbol, editor, false, initialName, oldName);
        }
        return null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file, DataContext dataContext) {
        PsiElement element;
        if (project2 == null) {
            OCInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement psiElement = element = dataContext != null ? PsiElementRenameHandler.getElement((DataContext)dataContext) : null;
        if (element == null) {
            PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset());
            PsiElement psiElement2 = element = reference != null && reference.resolve() == null ? reference.getElement() : null;
            if (element != null) {
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                if (ApplicationManager.getApplication().isUnitTestMode() || this.checkAvailable(element, editor, dataContext)) {
                    String initialName = dataContext != null ? (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext) : null;
                    OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(element instanceof PsiNamedElement ? (PsiNamedElement)element : null, editor, file, project2, reference, initialName, reference.getCanonicalText());
                    renamer.performInplaceRename();
                }
                return;
            }
        }
        super.invoke(project2, editor, file, dataContext);
    }

    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, Editor editor, @Nullable DataContext dataContext) {
        VariableInplaceRenamer renamer;
        if (elementToRename == null) {
            OCInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if ((renamer = this.createRenamer(elementToRename, editor)) != null) {
            renamer.performInplaceRename();
        }
        return renamer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

