/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCGroupedFileNaming;
import com.jetbrains.cidr.lang.OCGroupedFileNamings;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameFileProcessor
extends RenamePsiFileProcessor {
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(0);
        }
        if (newName == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(1);
        }
        if (allRenames == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(2);
        }
        this.gatherRenames(element, newName, allRenames);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(4);
        }
        if (conflicts == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(5);
        }
        MultiMap cs = new MultiMap();
        this.findRenameConflicts(element, newName, (MultiMap<PsiElement, Conflict>)cs);
        for (Map.Entry entry : cs.entrySet()) {
            for (Conflict conflict : (Collection)entry.getValue()) {
                conflicts.putValue(entry.getKey(), (Object)conflict.toString());
            }
        }
        super.findExistingNameConflicts(element, newName, conflicts);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project2, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
        if (project2 == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(6);
        }
        if (element == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(7);
        }
        RenamePsiFileProcessor.PsiFileRenameDialog psiFileRenameDialog = new RenamePsiFileProcessor.PsiFileRenameDialog(project2, element, nameSuggestionContext, editor){

            protected RenameProcessor createRenameProcessor(String newName) {
                return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                    @NotNull
                    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
                        if (conflicts == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ConflictsDialog conflictsDialog = new ConflictsDialog(this.myProject, conflicts, null, false, false);
                        if (conflictsDialog == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return conflictsDialog;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "conflicts";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameFileProcessor$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameFileProcessor$1$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "createConflictsDialog";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "createConflictsDialog";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
            }
        };
        if (psiFileRenameDialog == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(8);
        }
        return psiFileRenameDialog;
    }

    public void gatherRenames(PsiElement root, String newRootName, Map<PsiElement, String> allRenames) {
        if (!(root instanceof PsiFileSystemItem)) {
            return;
        }
        HashMap<PsiFileSystemItem, String> result = new HashMap<PsiFileSystemItem, String>();
        LinkedList<Pair> processQueue = new LinkedList<Pair>();
        processQueue.addLast(Pair.create((Object)((PsiFileSystemItem)root), (Object)newRootName));
        while (!processQueue.isEmpty()) {
            Pair info = (Pair)processQueue.removeFirst();
            PsiFileSystemItem element = (PsiFileSystemItem)info.first;
            String newName = (String)info.second;
            result.put(element, newName);
            ArrayList<PsiFileSystemItem> unprocessedVariants = new ArrayList<PsiFileSystemItem>();
            unprocessedVariants.add(element);
            OCRenameFileProcessor.iterateVariantsForRename(element, newName, (variant, newVariantName) -> {
                if (result.put(variant, newVariantName) == null) {
                    unprocessedVariants.add(variant);
                }
            });
            for (PsiFileSystemItem variant2 : unprocessedVariants) {
                this.findExtraVariants(variant2, (String)result.get(variant2), (version, newVersionName) -> {
                    if (result.get(version) == null) {
                        processQueue.addLast(Pair.create((Object)version, (Object)newVersionName));
                    }
                });
            }
        }
        allRenames.putAll(result);
    }

    protected void findExtraVariants(@NotNull PsiFileSystemItem variant, @NotNull String newRootName, @NotNull VariantProcessor localizedProcessor) {
        if (variant == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(9);
        }
        if (newRootName == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(10);
        }
        if (localizedProcessor == null) {
            OCRenameFileProcessor.$$$reportNull$$$0(11);
        }
        for (OCRenameProcessorExtension each : (OCRenameProcessorExtension[])Extensions.getExtensions(OCRenameProcessorExtension.EP)) {
            each.findExtraVariants(variant, newRootName, localizedProcessor);
        }
    }

    private static void iterateVariantsForRename(PsiFileSystemItem element, String newName, VariantProcessor variantProcessor) {
        if (element instanceof PsiFile) {
            PsiDirectory parent = ((PsiFile)element).getParent();
            OCGroupedFileNaming groupedNaming = OCRenameFileProcessor.getGroupedNaming((PsiElement)element);
            if (parent != null && groupedNaming != null) {
                String newBaseName = FileUtil.getNameWithoutExtension((String)groupedNaming.getBaseName(newName));
                String name2 = element.getName();
                String baseNameExt = groupedNaming.getBaseName(name2);
                String baseName = FileUtil.getNameWithoutExtension((String)baseNameExt);
                for (PsiElement variant : parent.getChildren()) {
                    OCGroupedFileNaming variantNaming;
                    PsiFile variantFile;
                    if (!(variant instanceof PsiFile) || (variantFile = (PsiFile)variant).equals(element) || (variantNaming = OCRenameFileProcessor.getGroupedNaming((PsiElement)variantFile)) == null || !baseNameExt.equals(variantNaming.getBaseName(variantFile.getName()))) continue;
                    String newVariantName = variantFile.getName().replace(baseName, newBaseName);
                    variantProcessor.processVariant((PsiFileSystemItem)variantFile, newVariantName);
                }
            }
        }
    }

    public void findRenameConflicts(PsiElement element, String newName, MultiMap<PsiElement, Conflict> conflicts) {
        HashMap<PsiElement, String> renames = new HashMap<PsiElement, String>();
        this.gatherRenames(element, newName, renames);
        if (renames.size() < 2) {
            return;
        }
        MultiMap pathsToElements = new MultiMap();
        for (Map.Entry<PsiElement, String> entry : renames.entrySet()) {
            PsiElement e = entry.getKey();
            OCLog.LOG.assertTrue(e instanceof PsiFileSystemItem);
            VirtualFile file = ((PsiFileSystemItem)e).getVirtualFile();
            OCLog.LOG.assertTrue(file != null);
            String newPath = new File(file.getParent().getPath(), entry.getValue()).getPath();
            pathsToElements.putValue((Object)newPath, (Object)e);
        }
        if (pathsToElements.size() == renames.size()) {
            return;
        }
        for (Map.Entry<Object, String> entry : pathsToElements.entrySet()) {
            Collection elements = (Collection)((Object)entry.getValue());
            if (elements == null || elements.size() <= 1) continue;
            String newElementName = new File((String)entry.getKey()).getName();
            conflicts.putValue((Object)element, (Object)new Conflict(newElementName, elements));
        }
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    private static OCGroupedFileNaming getGroupedNaming(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return null;
        }
        return OCGroupedFileNamings.getGroupedFileNaming(((PsiFile)element).getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameFileProcessor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRootName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizedProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameFileProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findExtraVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Conflict {
        public final String name;
        public final Collection<PsiElement> elements;

        public Conflict(String name2, Collection<PsiElement> elements) {
            this.name = name2;
            this.elements = elements;
        }

        private static String quote(String string) {
            return StringUtil.wrapWithDoubleQuote((String)string);
        }

        public String toString() {
            List badElements = ContainerUtil.filter(this.elements, element -> {
                if (!(element instanceof PsiFileSystemItem)) {
                    return false;
                }
                return !((PsiFileSystemItem)element).getName().equals(this.name);
            });
            List oldNames = ContainerUtil.map((Collection)badElements, element -> {
                OCLog.LOG.assertTrue(element instanceof PsiFileSystemItem);
                return Conflict.quote(((PsiFileSystemItem)element).getName());
            });
            return "Trying to rename " + StringUtil.join((Collection)oldNames, (String)", ") + " to existing file name " + Conflict.quote(this.name);
        }
    }

    @FunctionalInterface
    public static interface VariantProcessor {
        public void processVariant(PsiFileSystemItem var1, String var2);
    }
}

