/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLocalizedString;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCRenameProcessorExtension;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.rename.OCRenameUtil;
import com.jetbrains.cidr.lang.search.OCElementInMacroSubstitutionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRenameProcessor
extends RenamePsiElementProcessor {
    private OCSynthesizeProperty myOldSynthesize;
    private OCSynthesizeProperty myNewSynthesize;

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(0);
        }
        return element instanceof OCElement && element instanceof PsiNamedElement || element instanceof OCReferenceElement && element.getParent() instanceof OCSynthesizeProperty || element instanceof OCLocalizedString;
    }

    public void prepareRenaming(@NotNull PsiElement element, final @NotNull String newName, final @NotNull Map<PsiElement, String> allRenames, final @NotNull SearchScope scope) {
        OCClassDeclaration clazz;
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(2);
        }
        if (allRenames == null) {
            OCRenameProcessor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            OCRenameProcessor.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        this.myNewSynthesize = null;
        this.myOldSynthesize = null;
        OCSymbol symbol = OCRenameUtil.getSymbolToRename(element);
        final Project project2 = element.getProject();
        if (symbol != null) {
            OCSymbolWithQualifiedName owner2;
            if (symbol instanceof OCStructSymbol) {
                OCRenameProcessor.prepareStruct((OCStructSymbol)symbol, newName, allRenames, project2);
            } else if (!(symbol instanceof OCClassSymbol)) {
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> {
                    if (newName == null) {
                        OCRenameProcessor.$$$reportNull$$$0(30);
                    }
                    if (allRenames == null) {
                        OCRenameProcessor.$$$reportNull$$$0(31);
                    }
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol12, project2);
                    return true;
                }), project2);
            }
            if (symbol instanceof OCSymbolWithParent) {
                OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, symbol1 -> {
                    if (newName == null) {
                        OCRenameProcessor.$$$reportNull$$$0(28);
                    }
                    if (allRenames == null) {
                        OCRenameProcessor.$$$reportNull$$$0(29);
                    }
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1, project2);
                    return true;
                }, false, true, project2);
            }
            if (symbol instanceof OCFunctionSymbol && (((OCFunctionSymbol)symbol).isCppConstructor() || ((OCFunctionSymbol)symbol).isCppDestructor()) && (owner2 = ((OCFunctionSymbol)symbol).getResolvedOwner(OCResolveContext.forPsi(element))) instanceof OCStructSymbol) {
                OCRenameProcessor.addSymbol(newName, allRenames, owner2, project2);
                OCRenameProcessor.prepareStruct((OCStructSymbol)owner2, newName, allRenames, project2);
            }
            if ((symbol = symbol.getDefinitionSymbol(project2)) != null) {
                element = symbol.locateDefinition(project2);
                OCRenameProcessor.processAssociatedSymbols(symbol, new AssociatedElementsProcessor(){

                    @Override
                    public boolean processIvar(OCInstanceVariableSymbol ivar, OCPropertySymbol fromProperty) {
                        OCRenameProcessor.this.prepareInstanceVariable(newName, allRenames, fromProperty, ivar, project2);
                        return true;
                    }

                    @Override
                    public boolean processPropertyAccessors(OCPropertySymbol property) {
                        OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property, project2);
                        return true;
                    }

                    @Override
                    public boolean processProperty(OCPropertySymbol property, OCSymbol fromSymbol) {
                        OCRenameProcessor.this.prepareProperty(newName, allRenames, fromSymbol, property, project2);
                        return true;
                    }

                    @Override
                    public boolean processClassAlias(OCClassSymbol clazz, OCCompatibilityAliasSymbol alias) {
                        OCRenameProcessor.prepareClassAlias(newName, allRenames, clazz, alias, project2);
                        return true;
                    }

                    @Override
                    public boolean processClass(OCCompatibilityAliasSymbol alias, OCClassSymbol clazz) {
                        OCRenameProcessor.prepareClass(newName, allRenames, alias, clazz, scope, project2);
                        return true;
                    }
                }, scope, project2);
            }
        }
        if (element instanceof OCFile) {
            OCRenameProcessor.prepareFile((OCFile)element, newName, allRenames, scope, project2);
        } else if (element instanceof OCClassDeclaration) {
            clazz = (OCClassDeclaration)element;
            String category = clazz.getCategory();
            OCRenameProcessor.prepareClass(clazz.getName(), category, category != null ? newName + "+" + category : newName, allRenames, scope, element instanceof OCProtocol, project2);
        } else if (element instanceof OCCategoryName) {
            clazz = (OCClassDeclaration)element.getParent();
            OCRenameProcessor.prepareClass(clazz.getName(), clazz.getCategory(), clazz.getName() + "+" + newName, allRenames, scope, false, project2);
        }
        Iterator<PsiElement> iterator = allRenames.keySet().iterator();
        while (iterator.hasNext()) {
            PsiElement e = iterator.next();
            if (OCSearchScope.isInProjectSources(e) && !OCElementUtil.hasSyntheticIdentifier(e)) continue;
            iterator.remove();
        }
    }

    private static void addSymbol(String newName, Map<PsiElement, String> allRenames, OCSymbol symbol, Project project2) {
        Object element;
        if (symbol != null && (element = symbol.locateDefinition(project2)) != null) {
            allRenames.put((PsiElement)element, newName);
        }
    }

    public static void processAssociatedSymbols(OCSymbol symbol, AssociatedElementsProcessor processor2, SearchScope scope, Project project2) {
        if (symbol instanceof OCPropertySymbol) {
            OCPropertySymbol property = (OCPropertySymbol)symbol;
            OCInstanceVariableSymbol ivar = property.getAssociatedIvar(project2);
            if (ivar != null && OCElementUtil.endsWithIgnoringFirstLetterCase(ivar.getName(), symbol.getName())) {
                ivar.processSameSymbols((Processor<OCSymbol>)((Processor)symbol14 -> processor2.processIvar((OCInstanceVariableSymbol)symbol14, property)), project2);
            }
            property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol13 -> processor2.processPropertyAccessors((OCPropertySymbol)symbol13)), project2);
        } else if (symbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)symbol;
            OCPropertySymbol property = ivar.getAssociatedProperty(project2);
            if (property != null && OCElementUtil.endsWithIgnoringFirstLetterCase(symbol.getName(), property.getName())) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)symbol12 -> processor2.processProperty((OCPropertySymbol)symbol12, ivar)), project2);
            }
        } else if (symbol instanceof OCMethodSymbol) {
            OCPropertySymbol property = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
            if (property == null) {
                OCMethodSymbol associatedSymbol = (OCMethodSymbol)symbol.getAssociatedSymbol(project2);
                OCPropertySymbol oCPropertySymbol = property = associatedSymbol != null ? associatedSymbol.getGeneratedFromProperty() : null;
            }
            if (property != null) {
                property.processSameSymbols((Processor<OCSymbol>)((Processor)property1 -> processor2.processProperty((OCPropertySymbol)property1, symbol)), project2);
            }
        } else if (symbol instanceof OCCompatibilityAliasSymbol) {
            OCClassSymbol clazz;
            OCCompatibilityAliasSymbol alias = (OCCompatibilityAliasSymbol)symbol;
            OCType type = alias.getResolvedType(OCResolveContext.forSymbol(alias, project2));
            if (type instanceof OCObjectType && (clazz = ((OCObjectType)type).getClassSymbol()) != null && OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), alias.getName())) {
                processor2.processClass(alias, clazz);
            }
        } else if (symbol instanceof OCClassSymbol) {
            OCClassSymbol clazz = (OCClassSymbol)symbol;
            OCGlobalProjectSymbolsCache.processAliasNamesForType(project2, clazz.getName(), (Processor<String>)((Processor)s -> {
                OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)((Processor)symbol1 -> {
                    if (symbol1 instanceof OCCompatibilityAliasSymbol && OCRenameProcessor.isInScope(symbol1, scope)) {
                        OCType type = symbol1.getResolvedType(OCResolveContext.forSymbol(symbol1, project2));
                        if (!(type instanceof OCObjectType)) {
                            return true;
                        }
                        OCClassSymbol classSymbol = ((OCObjectType)type).getClassSymbol();
                        if (classSymbol == null || !classSymbol.equals(clazz)) {
                            return true;
                        }
                        if (OCElementUtil.endsWithIgnoringFirstLetterCase(clazz.getName(), symbol1.getName()) && !processor2.processClassAlias(clazz, (OCCompatibilityAliasSymbol)symbol1)) {
                            return false;
                        }
                    }
                    return true;
                }), s);
                return true;
            }));
        }
    }

    private static boolean isInScope(OCSymbol symbol, SearchScope scope) {
        return !(scope instanceof LocalSearchScope) || ((LocalSearchScope)scope).isInScope(symbol.getContainingFile());
    }

    private void prepareInstanceVariable(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, OCInstanceVariableSymbol ivar, Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        String newIvarName = OCRenameProcessor.getNewIvarName(newName, ivar.getName(), property.getName());
        if (ivar.isClang4ImplicitIvar(project2)) {
            allRenames.put(new OCSymbolHolderVirtualPsiElement(ivar, project2), newIvarName);
        } else if (settings.REFACTOR_PROPERTIES_AND_IVARS) {
            OCRenameProcessor.addSymbol(newIvarName, allRenames, ivar, project2);
        } else {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ivar.processSynthesizes((Processor<OCSynthesizeSymbol>)finder, project2);
            OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)finder.getFoundValue();
            if (synthesizeSymbol != null && !synthesizeSymbol.hasIvar()) {
                this.myOldSynthesize = (OCSynthesizeProperty)synthesizeSymbol.locateDefinition(project2);
                this.myNewSynthesize = OCElementFactory.synthesize(newName, ivar.getName(), this.myOldSynthesize);
            }
        }
    }

    private static String getNewIvarName(String newPropName, String ivarName, String propName) {
        int prefixLength = ivarName.length() - propName.length();
        String suffix = newPropName;
        if (newPropName.length() > 0 && prefixLength < ivarName.length() && Character.isUpperCase(ivarName.charAt(prefixLength)) && (!Character.isUpperCase(propName.charAt(0)) || Character.isUpperCase(newPropName.charAt(0)) || prefixLength != 0 && Character.isLetter(ivarName.charAt(prefixLength - 1)))) {
            suffix = StringUtil.capitalize((String)suffix);
        }
        return ivarName.substring(0, prefixLength) + suffix;
    }

    private static void preparePropertyAccessors(String newName, Map<PsiElement, String> allRenames, OCPropertySymbol property, Project project2) {
        ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, symbol -> {
            if (symbol.getGeneratedFromProperty() == property) {
                OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
                if (symbol.isGetter(context) && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.GETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, project2), newName);
                } else if (symbol.isSetter(context) && !property.hasAttribute(OCPropertySymbol.PropertyAttribute.SETTER)) {
                    allRenames.put(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, project2), OCNameSuggester.getObjCSetterFromGetter(newName));
                }
            }
            return true;
        });
        property.processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method -> {
            String oldName = method.getName();
            if (oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.GETTER)) || oldName.equals(property.getAttributeValue(OCPropertySymbol.PropertyAttribute.SETTER) + ":")) {
                return true;
            }
            OCRenameProcessor.addSymbol(OCElementUtil.startsWithWord(oldName, "set") ? "set" + StringUtil.capitalize((String)newName) : newName, allRenames, method, project2);
            List<OCMethodSymbol.SelectorPartSymbol> selectors = method.getSelectors();
            OCDeclaratorSymbol parameter = selectors.get(0).getParameter();
            if (parameter != null && OCElementUtil.endsWithIgnoringFirstLetterCase(parameter.getName(), property.getName())) {
                OCRenameProcessor.addSymbol(OCRenameProcessor.getNewIvarName(newName, parameter.getName(), property.getName()), allRenames, parameter, project2);
            }
            return true;
        }), true, project2);
    }

    private void prepareProperty(String newName, Map<PsiElement, String> allRenames, OCSymbol fromSymbol, OCPropertySymbol property, Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (fromSymbol instanceof OCInstanceVariableSymbol) {
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)fromSymbol;
            if (settings.REFACTOR_PROPERTIES_AND_IVARS || ivar.isClang4ImplicitIvar(project2)) {
                String newPropertyName;
                String prefix = ivar.getName().substring(0, ivar.getName().length() - property.getName().length());
                if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
                    newPropertyName = newName.substring(prefix.length());
                    if (Character.isLowerCase(property.getName().charAt(0))) {
                        newPropertyName = StringUtil.decapitalize((String)newPropertyName);
                    }
                } else {
                    newPropertyName = newName;
                }
                OCRenameProcessor.addSymbol(newPropertyName, allRenames, property, project2);
                OCRenameProcessor.preparePropertyAccessors(newPropertyName, allRenames, property, project2);
            } else {
                CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                ivar.processSynthesizes((Processor<OCSynthesizeSymbol>)finder, project2);
                OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)finder.getFoundValue();
                if (synthesizeSymbol != null && !synthesizeSymbol.hasIvar()) {
                    this.myOldSynthesize = (OCSynthesizeProperty)synthesizeSymbol.locateDefinition(project2);
                    this.myNewSynthesize = OCElementFactory.synthesize(property.getName(), newName, this.myOldSynthesize);
                }
            }
        } else if (fromSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol accessor = (OCMethodSymbol)fromSymbol;
            if (accessor.isSetter(OCResolveContext.forSymbol(accessor, project2))) {
                String getter = OCNameSuggester.getObjCGetterFromSetter(newName);
                newName = getter != null ? getter : newName;
            }
            OCRenameProcessor.addSymbol(newName, allRenames, property, project2);
            OCRenameProcessor.preparePropertyAccessors(newName, allRenames, property, project2);
        }
    }

    private static void prepareClassAlias(String newName, Map<PsiElement, String> allRenames, @NotNull OCClassSymbol clazz, OCCompatibilityAliasSymbol alias, Project project2) {
        if (clazz == null) {
            OCRenameProcessor.$$$reportNull$$$0(5);
        }
        int endPrefixIndex = clazz.getName().length() - alias.getName().length();
        String prefix = clazz.getName().substring(0, endPrefixIndex);
        if (newName.startsWith(prefix) && newName.length() > prefix.length()) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
            if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
                String newAliasName = newName.substring(prefix.length());
                OCRenameProcessor.addSymbol(newAliasName, allRenames, alias, project2);
            }
        }
    }

    private static void prepareFile(OCFile file, String newName, Map<PsiElement, String> allRenames, SearchScope scope, Project project2) {
        if (!FileUtilRt.extensionEquals((String)newName, (String)FileUtilRt.getExtension((String)file.getName()))) {
            allRenames.put(file, newName);
            return;
        }
        OCSymbol mainClass = file.getSameNamedClass();
        if (mainClass instanceof OCClassSymbol) {
            OCRenameProcessor.prepareClass(mainClass.getName(), ((OCClassSymbol)mainClass).getCategoryName(), FileUtil.getNameWithoutExtension((String)newName), allRenames, scope, mainClass instanceof OCProtocolSymbol, project2);
        } else if (mainClass instanceof OCStructSymbol) {
            OCRenameProcessor.prepareStruct((OCStructSymbol)mainClass, FileUtil.getNameWithoutExtension((String)newName), allRenames, project2);
        } else {
            OCRenameProcessor.processAssociatedFiles(file, newName, allRenames);
        }
    }

    private static void processAssociatedFiles(OCFile file, String newName, Map<PsiElement, String> allRenames) {
        allRenames.put(file, newName);
        file = file.getAssociatedFileWithSameName();
        if (file != null) {
            allRenames.put(file, FileUtil.getNameWithoutExtension((String)newName) + '.' + FileUtilRt.getExtension((String)file.getName()));
        }
    }

    private static void prepareStruct(OCStructSymbol struct, String newName, Map<PsiElement, String> allRenames, Project project2) {
        OCResolveContext context = OCResolveContext.forSymbol(struct, project2);
        struct.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
            OCStructSymbol struct1 = (OCStructSymbol)symbol;
            OCRenameProcessor.addSymbol(newName, allRenames, struct1, project2);
            if (!struct1.isPredeclaration()) {
                Processor processor2 = symbol1 -> {
                    OCRenameProcessor.addSymbol(newName, allRenames, symbol1, project2);
                    return true;
                };
                struct1.processConstructors((Processor<? super OCFunctionSymbol>)processor2, true, context);
                struct1.processDestructors((Processor<OCFunctionSymbol>)processor2, true, context);
            }
            return true;
        }), project2);
        OCFile file = struct.getContainingOCFile(project2);
        if (file != null && FileUtil.getNameWithoutExtension((String)file.getName()).equals(struct.getName())) {
            OCRenameProcessor.processAssociatedFiles(file, newName + '.' + FileUtilRt.getExtension((String)file.getName()), allRenames);
        }
    }

    private static void prepareClass(String newName, Map<PsiElement, String> allRenames, OCCompatibilityAliasSymbol alias, OCClassSymbol clazz, SearchScope scope, Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        if (settings.REFACTOR_COMPATIBILITY_ALIASES_AND_CLASSES) {
            int endPrefixIndex = clazz.getName().length() - alias.getName().length();
            String prefix = clazz.getName().substring(0, endPrefixIndex);
            String newClassName = prefix + newName;
            String categoryName = clazz.getCategoryName();
            if (categoryName != null) {
                newClassName = newClassName + "+" + categoryName;
            }
            OCRenameProcessor.prepareClass(clazz.getName(), categoryName, newClassName, allRenames, scope, clazz instanceof OCProtocolSymbol, project2);
        }
    }

    private static void prepareClass(String oldClassName, String oldCategoryName, String newName, Map<PsiElement, String> allRenames, SearchScope scope, boolean isProtocol, Project project2) {
        int categoryIdx = newName.lastIndexOf(43);
        String newClassName = categoryIdx > 0 ? newName.substring(0, categoryIdx) : newName;
        OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<OCSymbol>)((Processor)ocSymbol -> {
            if (ocSymbol instanceof OCClassSymbol && OCRenameProcessor.isInScope(ocSymbol, scope) && isProtocol == ocSymbol instanceof OCProtocolSymbol) {
                boolean sameCategory = Comparing.equal((String)((OCClassSymbol)ocSymbol).getCategoryName(), (String)oldCategoryName);
                if (!sameCategory && oldClassName.equals(newClassName)) {
                    return true;
                }
                Object def = ocSymbol.locateDefinition(project2);
                if (def != null) {
                    if (sameCategory) {
                        allRenames.put((PsiElement)def, newName);
                    } else {
                        allRenames.put((PsiElement)def, newClassName);
                    }
                    PsiFile file = def.getContainingFile();
                    String fileName = file.getName();
                    String name2 = FileUtil.getNameWithoutExtension((String)fileName);
                    int categoryIdx1 = name2.lastIndexOf(43);
                    String category = null;
                    if (categoryIdx1 > 0) {
                        category = name2.substring(categoryIdx1 + 1);
                        name2 = name2.substring(0, categoryIdx1);
                    }
                    if (name2.equals(oldClassName)) {
                        if (Comparing.equal((String)oldCategoryName, (String)category)) {
                            allRenames.put((PsiElement)file, newName + "." + FileUtilRt.getExtension((String)fileName));
                        } else {
                            allRenames.put((PsiElement)file, newClassName + fileName.substring(name2.length()));
                        }
                    }
                }
            }
            return true;
        }), oldClassName);
    }

    private static boolean isSetter(OCMethod method) {
        return method.getSelector().endsWith(":");
    }

    private static boolean isSetter(OCSendMessageExpression call) {
        return call.getMessageSelector().endsWith(":");
    }

    private static boolean isSetter(OCPropertyAttribute attribute) {
        return "setter".equals(attribute.getName());
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(6);
        }
        Collection<PsiReference> collection = this.findReferences(element, null);
        if (collection == null) {
            OCRenameProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(PsiElement element, SearchScope scope) {
        Project project2 = element.getProject();
        Object elementToSearch = element;
        OCMethodSymbol accessor = null;
        if (OCRenameProcessor.isAccessor(element)) {
            accessor = (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            elementToSearch = accessor.getGeneratedFromProperty().locateDefinition(project2);
        }
        if (elementToSearch == null) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                OCRenameProcessor.$$$reportNull$$$0(8);
            }
            return list;
        }
        OCResolveContext context = OCResolveContext.forPsi(elementToSearch);
        if (elementToSearch instanceof OCClassDeclaration && ((OCClassDeclaration)elementToSearch).getCategoryElement() != null) {
            List<PsiReference> list = Collections.emptyList();
            if (list == null) {
                OCRenameProcessor.$$$reportNull$$$0(9);
            }
            return list;
        }
        Collection result = ReferencesSearch.search((ReferencesSearch.SearchParameters)new OCElementInMacroSubstitutionReferenceSearch.MySearchParameters((PsiElement)elementToSearch, scope != null ? scope : elementToSearch.getUseScope(), false, true)).findAll();
        Iterator itr = result.iterator();
        while (itr.hasNext()) {
            PsiElement usage = ((PsiReference)itr.next()).getElement();
            if (usage instanceof OCSendMessageExpression) {
                if (accessor != null && accessor.isSetter(context) == OCRenameProcessor.isSetter((OCSendMessageExpression)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCMethod) {
                if (accessor != null && accessor.isSetter(context) == OCRenameProcessor.isSetter((OCMethod)usage)) continue;
                itr.remove();
                continue;
            }
            if (usage instanceof OCPropertyAttribute) {
                if (accessor != null && accessor.isSetter(context) == OCRenameProcessor.isSetter((OCPropertyAttribute)usage)) continue;
                itr.remove();
                continue;
            }
            if (accessor != null) {
                itr.remove();
                continue;
            }
            if (!(element instanceof OCDeclarator) || !(usage instanceof OCDeclarator)) continue;
            itr.remove();
        }
        Collection collection = result;
        if (collection == null) {
            OCRenameProcessor.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static boolean isAccessor(PsiElement element) {
        return element instanceof OCSymbolHolderVirtualPsiElement && ((OCSymbolHolderVirtualPsiElement)element).getSymbol() instanceof OCMethodSymbol;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(11);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(12);
        }
        if (usages == null) {
            OCRenameProcessor.$$$reportNull$$$0(13);
        }
        Project project2 = element.getProject();
        ArrayList<UsageInfo> nonMacroUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            PsiElement refElement = usage.getElement();
            if (refElement != null && OCElementUtil.isPartOfMacroSubstitution(refElement)) {
                OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(refElement);
                if (macroRange != null && !macroRange.mapsToArguments() && element instanceof PsiNamedElement) {
                    OCDefineDirective macro;
                    String name2 = ((PsiNamedElement)element).getName();
                    OCMacroSymbol macroSymbol = macroRange.getMacroCall().resolveToSymbol();
                    OCDefineDirective oCDefineDirective = macro = macroSymbol != null ? (OCDefineDirective)macroSymbol.locateDefinition(project2) : null;
                    if (macro != null) {
                        PsiElement macroNameId = macro.getNameIdentifier();
                        for (ASTNode child : macro.getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IDENTIFIER}))) {
                            PsiElement psi = child.getPsi();
                            if (psi == macroNameId || !psi.getText().equals(name2)) continue;
                            OCElementUtil.replaceWithIdentifier(psi, newName, refElement);
                        }
                    }
                }
                FileSymbolTablesCache.getInstance(project2).scheduleReparseFile((OCFile)element.getContainingFile());
                continue;
            }
            nonMacroUsages.add(usage);
        }
        super.renameElement(element, newName, nonMacroUsages.toArray(UsageInfo.EMPTY_ARRAY), listener2);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        OCSymbol symbol;
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(15);
        }
        if (conflicts == null) {
            OCRenameProcessor.$$$reportNull$$$0(16);
        }
        Project project2 = element.getProject();
        OCSymbol duplicate = null;
        if (element instanceof OCCategoryName) {
            OCSymbol oCSymbol = symbol = (element = element.getParent()) instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            if (symbol instanceof OCClassSymbol) {
                duplicate = OCCodeInsightUtil.resolveNameInScope(symbol.getKind(), symbol.getName(), newName, null, project2);
            }
        } else {
            if (element instanceof OCFile) {
                if (!OCSearchUtil.getProjectVirtualFilesByName(project2, newName).isEmpty()) {
                    conflicts.putValue((Object)element, (Object)("File '" + newName + "' already exists in the project"));
                }
                return;
            }
            symbol = element instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)element).getSymbol() : null;
            String categoryName = symbol instanceof OCClassSymbol ? ((OCClassSymbol)symbol).getCategoryName() : null;
            PsiElement scope = symbol instanceof OCClassSymbol ? null : element;
            duplicate = OCCodeInsightUtil.resolveNameInScope(symbol != null ? symbol.getKind() : null, newName, categoryName, scope, project2);
        }
        if (duplicate != null && (symbol == null || symbol.isGlobal() == duplicate.isGlobal())) {
            String scope = duplicate.isGlobal() ? duplicate.getContainingFile().getName() : "the scope";
            Object definition = duplicate.locateDefinition(project2);
            if (definition != null) {
                conflicts.putValue(definition, (Object)(duplicate.getNameWithKindUppercase(OCCompilationContext.create(element)) + " already exists in " + scope));
            }
        }
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        OCSymbolWithQualifiedName struct;
        OCSymbol symbol;
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(17);
        }
        PsiElement originalElement = element;
        if (element instanceof OCDeclarator) {
            element = ((OCDeclarator)element).getExtendedContext();
        }
        if (element instanceof PsiNameIdentifierOwner) {
            element = OCElementUtil.substituteNamedElementToRename(element, false);
        }
        if (element instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)element).getSymbol()) != null && ((OCSymbolBase)symbol).getKind().isConstructorOrDestructor() && (struct = ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(OCResolveContext.forPsi(element))) instanceof OCStructSymbol) {
            return struct.locateDefinition(element.getProject());
        }
        if (OCRenameProcessor.isAccessor(element) || element instanceof OCCallable) {
            OCSymbol oCSymbol = symbol = element instanceof OCCallable ? ((OCCallable)element).getSymbol() : (OCMethodSymbol)((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCMethodSymbol) {
                OCPropertySymbol property;
                OCPropertySymbol oCPropertySymbol = property = (symbol = symbol.getAssociatedSymbol(element.getProject())) != null ? ((OCMethodSymbol)symbol).getGeneratedFromProperty() : null;
                if (property != null) {
                    return property.locateDefinition(element.getProject());
                }
            }
            if (element instanceof OCCallable && !ApplicationManager.getApplication().isUnitTestMode()) {
                OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler((OCCallable)element, element);
                if (!OCChangeSignatureActionHandler.checkVariableArguments(element.getProject(), editor, handler)) {
                    handler.invoke();
                }
                return null;
            }
        }
        return super.substituteElementToRename(originalElement, editor);
    }

    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(18);
        }
        if (newName == null) {
            OCRenameProcessor.$$$reportNull$$$0(19);
        }
        if (elementListener == null) {
            OCRenameProcessor.$$$reportNull$$$0(20);
        }
        return () -> {
            if (this.myOldSynthesize != null) {
                this.myOldSynthesize.replace(this.myNewSynthesize);
                this.myNewSynthesize = null;
                this.myOldSynthesize = null;
            }
        };
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(21);
        }
        return true;
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        Object symbol;
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(22);
        }
        return !(element instanceof OCSymbolDeclarator) || (symbol = ((OCSymbolDeclarator)element).getSymbol()) == null || !symbol.getKind().isLocal();
    }

    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        if (element == null) {
            OCRenameProcessor.$$$reportNull$$$0(23);
        }
        if (element instanceof OCClassDeclaration && ((OCClassDeclaration)element).getCategoryElement() != null) {
            return null;
        }
        if (element instanceof OCFile) {
            return null;
        }
        return element;
    }

    @NotNull
    public static RenameUsages validateUsages(PsiNamedElement elementToRename, Ref<UsageInfo[]> refUsages) {
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            if (!(processor2 instanceof OCRenameProcessor)) continue;
            OCRenameProcessor cfr_ignored_0 = (OCRenameProcessor)processor2;
            RenameUsages renameUsages = OCRenameProcessor.doValidateUsages(elementToRename, refUsages);
            if (renameUsages == null) {
                OCRenameProcessor.$$$reportNull$$$0(24);
            }
            return renameUsages;
        }
        RenameUsages renameUsages = RenameUsages.CANCEL;
        if (renameUsages == null) {
            OCRenameProcessor.$$$reportNull$$$0(25);
        }
        return renameUsages;
    }

    public static RenameUsages doValidateUsages(PsiNamedElement elementToRename, Ref<UsageInfo[]> refUsages) {
        int code;
        String message;
        String oldName = elementToRename.getName();
        int nonCodeUsages = 0;
        OCSymbolBase badMacro = null;
        ArrayList<UsageInfo> filteredUsages = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof NonCodeUsageInfo) {
                if (OCRenameProcessor.skipNonCodeUsage(elementToRename, usageInfo)) continue;
                ++nonCodeUsages;
                filteredUsages.add(usageInfo);
                continue;
            }
            filteredUsages.add(usageInfo);
            if (!(usageInfo.getReference() instanceof OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)) continue;
            badMacro = ((OCElementInMacroSubstitutionReferenceSearch.BadMacroSubstitutionReference)usageInfo.getReference()).getMacroSymbol();
        }
        refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
        if (badMacro != null) {
            String[] options;
            message = badMacro.getNameWithKindUppercase(OCCompilationContext.create((PsiElement)elementToRename)) + " has several usages with different mappings for \"" + oldName + "\". Rename may break the code. Would you like to proceed?";
            code = Messages.showDialog((String)message, (String)"Rename", (String[])(options = new String[]{"Show usages", "Cancel", "Proceed"}), (int)0, (int)1, (Icon)Messages.getQuestionIcon(), null);
            if (code == 0) {
                return RenameUsages.SHOW_USAGES;
            }
            if (code == 1 || code == -1) {
                return RenameUsages.CANCEL;
            }
        }
        if (nonCodeUsages > 0 && !ApplicationManager.getApplication().isUnitTestMode()) {
            String[] options;
            message = nonCodeUsages + " usage" + (nonCodeUsages > 1 ? "s were" : " was") + " found in comments and non-code files.\nWould you like to rename " + (nonCodeUsages > 1 ? "them" : "it") + "?";
            code = Messages.showDialog((String)message, (String)"Rename", (String[])(options = new String[]{"Show Usages", "Cancel", "Rename Only Code Usages", "Rename All Usages"}), (int)0, (int)2, (Icon)Messages.getQuestionIcon(), null);
            if (code == 3) {
                return RenameUsages.RENAME;
            }
            if (code == 2) {
                refUsages.set((Object)ContainerUtil.filter((Object[])((Object[])refUsages.get()), info -> !(info instanceof NonCodeUsageInfo)).toArray(UsageInfo.EMPTY_ARRAY));
                return RenameUsages.RENAME;
            }
            if (code == 0) {
                return RenameUsages.SHOW_USAGES;
            }
            return RenameUsages.CANCEL;
        }
        return RenameUsages.RENAME;
    }

    private static boolean skipNonCodeUsage(@NotNull PsiNamedElement elementToRename, @NotNull UsageInfo usageInfo) {
        PsiElement element;
        PsiElement parent;
        if (elementToRename == null) {
            OCRenameProcessor.$$$reportNull$$$0(26);
        }
        if (usageInfo == null) {
            OCRenameProcessor.$$$reportNull$$$0(27);
        }
        PsiElement psiElement = parent = (element = usageInfo.getElement()) != null ? element.getParent() : null;
        if (parent instanceof OCLocalizedString) {
            return true;
        }
        if (element != null && parent instanceof OCLiteralExpression && elementToRename instanceof OCLocalizedString) {
            OCReferenceElement macro;
            OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)parent, OCMacroCall.class);
            OCReferenceElement oCReferenceElement = macro = macroCall != null ? macroCall.getMacroReferenceElement() : null;
            if (macro != null && macro.getName().startsWith("NSLocalizedString")) {
                return true;
            }
        }
        for (OCRenameProcessorExtension each : (OCRenameProcessorExtension[])Extensions.getExtensions(OCRenameProcessorExtension.EP)) {
            if (!each.skipNonCodeUsage(elementToRename, usageInfo)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 12: 
            case 15: 
            case 19: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementListener";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/rename/OCRenameProcessor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "validateUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassAlias";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "skipNonCodeUsage";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRenaming$1";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$prepareRenaming$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum RenameUsages {
        RENAME,
        CANCEL,
        SHOW_USAGES;

    }

    static interface AssociatedElementsProcessor {
        public boolean processIvar(OCInstanceVariableSymbol var1, OCPropertySymbol var2);

        public boolean processPropertyAccessors(OCPropertySymbol var1);

        public boolean processProperty(OCPropertySymbol var1, OCSymbol var2);

        public boolean processClassAlias(OCClassSymbol var1, OCCompatibilityAliasSymbol var2);

        public boolean processClass(OCCompatibilityAliasSymbol var1, OCClassSymbol var2);
    }
}

