/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.unwrap.AbstractUnwrapper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnwrapper
extends AbstractUnwrapper<Context> {
    public OCUnwrapper(String description) {
        super(description);
    }

    protected Context createContext() {
        return new Context();
    }

    protected static boolean isInArgList(@NotNull PsiElement e) {
        if (e == null) {
            OCUnwrapper.$$$reportNull$$$0(0);
        }
        return e.getParent() instanceof OCArgumentList;
    }

    protected static boolean isElseBlock(@Nullable PsiElement element) {
        if (!(element instanceof OCStatement)) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof OCIfStatement && element == ((OCIfStatement)parent).getElseBranch();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/refactoring/unwrap/OCUnwrapper", "isInArgList"));
    }

    protected static class Context
    extends AbstractUnwrapper.AbstractContext {
        protected Context() {
        }

        protected boolean isWhiteSpace(PsiElement element) {
            return element instanceof PsiWhiteSpace;
        }

        public void addSemicolonBefore(PsiElement anchor) {
            if (this.myIsEffective) {
                PsiElement semicolon = OCElementFactory.create(OCTokenTypes.SEMICOLON, anchor);
                anchor.getParent().addBefore(semicolon, anchor);
            }
        }

        public void addNewLineBefore(PsiElement anchor) {
            if (this.myIsEffective) {
                PsiElement newLine = OCElementFactory.newlineFromText(anchor);
                anchor.getParent().addBefore(newLine, anchor);
            }
        }

        public void extractWhitespace(PsiElement ws, PsiElement from) {
            assert (this.isWhiteSpace(ws));
            PsiElement toExtract = ws;
            if (this.myIsEffective) {
                toExtract = from.getParent().addBefore(ws, from);
            }
            this.addElementToExtract(toExtract);
        }

        public void setElseBranch(OCIfStatement ifStatement, OCStatement elseBranch) throws IncorrectOperationException {
            assert (ifStatement.getElseBranch() != elseBranch) : "Why setting 'else' branch which already belongs to 'if' statement?";
            OCStatement toExtract = elseBranch;
            if (this.myIsEffective) {
                ifStatement.setElse(elseBranch);
                toExtract = ifStatement.getElseBranch();
            }
            this.addElementToExtract(toExtract);
        }

        public void extractFromBlockOrSingleStatement(@Nullable OCStatement block, PsiElement from) throws IncorrectOperationException {
            if (block instanceof OCBlockStatement) {
                this.extractFromCodeBlock((OCBlockStatement)block, from);
            } else if (block != null && !(block instanceof OCEmptyStatement)) {
                this.extract(block, block, from);
            }
        }

        public void extractFromCodeBlock(@Nullable OCBlockStatement block, PsiElement from) throws IncorrectOperationException {
            if (block == null || block.getStatements().isEmpty()) {
                return;
            }
            this.extract(this.getFirstBodyElement(block), this.getLastBodyElement(block), from);
        }

        protected PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, @NotNull PsiElement parent, @NotNull PsiElement anchor) {
            if (first == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (last == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (anchor == null) {
                Context.$$$reportNull$$$0(3);
            }
            PsiElement firstExtracted = OCChangeUtil.addBefore(parent, first, anchor);
            while (first != null && first != last) {
                first = first.getNextSibling();
                OCChangeUtil.addBefore(parent, first, anchor);
            }
            return firstExtracted;
        }

        public void delete(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                if (e instanceof OCStatement) {
                    OCChangeUtil.safeDeleteStatement((OCStatement)e);
                } else {
                    OCChangeUtil.delete(e);
                }
            }
        }

        public void deleteExactly(PsiElement e) throws IncorrectOperationException {
            if (this.myIsEffective) {
                OCChangeUtil.deleteExactly(e);
            }
        }

        private PsiElement getFirstBodyElement(@NotNull OCBlockStatement block) {
            PsiElement lBrace;
            if (block == null) {
                Context.$$$reportNull$$$0(4);
            }
            if ((lBrace = block.getOpeningBrace()) == null) {
                return null;
            }
            PsiElement nextSibling = lBrace.getNextSibling();
            return nextSibling == block.getClosingBrace() ? null : nextSibling;
        }

        private PsiElement getLastBodyElement(@NotNull OCBlockStatement block) {
            PsiElement rBrace;
            if (block == null) {
                Context.$$$reportNull$$$0(5);
            }
            if ((rBrace = block.getClosingBrace()) != null) {
                PsiElement prevSibling = rBrace.getPrevSibling();
                return prevSibling == block.getOpeningBrace() ? null : prevSibling;
            }
            return block.getLastChild();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/unwrap/OCUnwrapper$Context";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRangeBefore";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstBodyElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLastBodyElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

