/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclarationList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClauseList;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangeUtil {
    private OCChangeUtil() {
    }

    public static <T extends PsiElement> T addBefore(PsiElement parent, T element, @Nullable PsiElement anchor) {
        anchor = OCChangeUtil.getRealAnchorForInsertion(parent, element, anchor);
        return (T)OCChangeUtil.addHandlingMacros(parent, element, anchor, true);
    }

    public static <T extends PsiElement> T addAfter(PsiElement parent, T element, @Nullable PsiElement anchor) {
        anchor = OCChangeUtil.getRealAnchorForInsertion(parent, element, anchor);
        IElementType anchorType = OCElementUtil.getElementType(anchor);
        if (anchor != null && anchorType == OCElementTypes.OBJC_KEYWORD) {
            anchorType = OCElementUtil.getObjCKeywordElementType(anchor.getNode());
        }
        return (T)OCChangeUtil.addHandlingMacros(parent, element, anchor, anchorType == OCTokenTypes.END_KEYWORD || anchorType == OCTokenTypes.RBRACE);
    }

    public static <T extends PsiElement> T add(PsiElement parent, T element) {
        return OCChangeUtil.addBefore(parent, element, null);
    }

    @NotNull
    public static PsiElement addAfterWithinBlockStatement(@NotNull PsiElement elementToAdd, @NotNull PsiElement anchorStatement) {
        if (elementToAdd == null) {
            OCChangeUtil.$$$reportNull$$$0(0);
        }
        if (anchorStatement == null) {
            OCChangeUtil.$$$reportNull$$$0(1);
        }
        if (!(anchorStatement.getParent() instanceof OCBlockStatement) && !(anchorStatement.getParent() instanceof OCCaseStatement)) {
            elementToAdd = OCChangeUtil.copyHandlingMacros(elementToAdd);
            OCBlockStatement blockElement = OCElementFactory.surroundByBraces(anchorStatement);
            blockElement = (OCBlockStatement)anchorStatement.replace((PsiElement)blockElement);
            anchorStatement = blockElement.getStatements().get(0);
        }
        if (elementToAdd instanceof OCBlockStatement) {
            OCBlockStatement blockStatement = (OCBlockStatement)elementToAdd;
            PsiElement openingBrace = blockStatement.getOpeningBrace();
            PsiElement closingBrace = blockStatement.getClosingBrace();
            if (openingBrace != null && closingBrace != null) {
                PsiElement firstElement = openingBrace.getNextSibling();
                PsiElement lastElement = closingBrace.getPrevSibling();
                anchorStatement.getParent().addRangeAfter(firstElement, lastElement, anchorStatement);
            }
        } else {
            OCChangeUtil.addAfter(anchorStatement.getParent(), elementToAdd, anchorStatement);
        }
        PsiElement psiElement = anchorStatement;
        if (psiElement == null) {
            OCChangeUtil.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getRealAnchorForInsertion(PsiElement parent, PsiElement anchor) {
        return OCChangeUtil.getRealAnchorForInsertion(parent, null, anchor);
    }

    @Nullable
    private static PsiElement getRealAnchorForInsertion(@Nullable PsiElement parent, @Nullable PsiElement element, @Nullable PsiElement anchor) {
        List<OCMethodSelectorPart> parameters;
        int position;
        if (parent == null) {
            return null;
        }
        if (anchor != null && !Comparing.equal((Object)anchor.getContainingFile(), (Object)parent.getContainingFile())) {
            anchor = null;
        }
        if (element != null && !(element.getContainingFile() instanceof OCFile)) {
            element = null;
        }
        if (element != null && (parent instanceof OCFile || parent instanceof OCClassDeclaration)) {
            OCDeclarationKind kind = OCDeclarationKind.getDeclarationKind(element);
            if (kind != null) {
                int startOffset = kind.getChildrenStartOffset(parent);
                int endOffset = kind.getChildrenEndOffset(parent);
                if (startOffset != -1 && endOffset != -1 && (anchor == null || anchor.getTextOffset() >= endOffset)) {
                    return OCChangeUtil.getChildAt(parent, endOffset + 1);
                }
            }
        } else if (parent instanceof OCStruct) {
            OCFunctionDeclaration function;
            String name2 = ((OCStruct)parent).getName();
            if (element instanceof OCFunctionDeclaration && Comparing.equal((String)(function = (OCFunctionDeclaration)element).getName(), (String)name2)) {
                for (OCDeclaration member : ((OCStruct)parent).getMembers()) {
                    List<OCDeclarator> parameters2 = function.getParameters();
                    if (parameters2 == null || parameters2.size() == 0) {
                        return member;
                    }
                    if (!(member instanceof OCFunctionDeclaration)) {
                        return member;
                    }
                    if (Comparing.equal((String)((OCFunctionDeclaration)member).getName(), (String)name2)) continue;
                    return member;
                }
            }
        }
        if (anchor != null && (position = anchor.getTextOffset() + (anchor.getTextLength() != 0 ? 1 : 0)) < parent.getTextRange().getEndOffset()) {
            return OCChangeUtil.getChildAt(parent, position);
        }
        if (parent instanceof OCParameterList) {
            if (!((OCParameterList)parent).getParameterDeclarations().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCPropertyAttributesList) {
            if (!((OCPropertyAttributesList)parent).getAttributes().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCEnum) {
            if (!((OCEnum)parent).getFields().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCConstructorInitializationList) {
            if (((OCConstructorInitializationList)parent).getInitializers().size() != 0) {
                parent.add(OCElementFactory.create(OCTokenTypes.COMMA, element));
            }
            return null;
        }
        if (parent instanceof OCStructLike || parent instanceof OCBlockStatement || parent instanceof OCCppNamespace) {
            return OCChangeUtil.findChildByType(parent, OCTokenTypes.RBRACE);
        }
        if (parent instanceof OCProtocolList) {
            PsiElement rbrace = OCChangeUtil.findChildByType(parent, OCTokenTypes.GT);
            if (rbrace == null) {
                PsiElement lbrace = parent.add(OCElementFactory.create(OCTokenTypes.LT, parent));
                CodeEditUtil.markToReformatBefore((ASTNode)lbrace.getNode(), (boolean)true);
                return parent.add(OCElementFactory.create(OCTokenTypes.GT, parent));
            }
            if (!((OCProtocolList)parent).getProtocols().isEmpty()) {
                parent.addBefore(OCElementFactory.create(OCTokenTypes.COMMA, parent), parent.getLastChild());
            }
            return parent.getLastChild();
        }
        if (parent instanceof OCCppBaseClauseList) {
            if (((OCCppBaseClauseList)parent).getBaseClauses().isEmpty()) {
                parent.add(OCElementFactory.create(OCTokenTypes.COLON, parent));
            } else {
                parent.add(OCElementFactory.create(OCTokenTypes.COMMA, parent));
            }
            return null;
        }
        if (parent instanceof OCInstanceVariablesList) {
            PsiElement rbrace = OCChangeUtil.findChildByType(parent, OCTokenTypes.RBRACE);
            if (rbrace == null) {
                PsiElement result = null;
                for (PsiElement child = OCElementFactory.instanceVariableList(element).getFirstChild(); child != null; child = child.getNextSibling()) {
                    IElementType type = child.getNode().getElementType();
                    PsiElement newChild = parent.add(child);
                    if (type == OCTokenTypes.RBRACE) {
                        result = newChild;
                    }
                    CodeEditUtil.markToReformatBefore((ASTNode)newChild.getNode(), (type == OCTokenTypes.LBRACE || type == OCTokenTypes.RBRACE ? 1 : 0) != 0);
                }
                return result;
            }
            return rbrace;
        }
        if (parent instanceof OCMethod && element instanceof OCMethodSelectorPart && !(parameters = ((OCMethod)parent).getParameters()).isEmpty()) {
            OCMethodSelectorPart lastParam = parameters.get(parameters.size() - 1);
            if (lastParam.getParameter() == null) {
                OCChangeUtil.delete(lastParam);
            } else {
                parent.addAfter(OCElementFactory.spaceFromText(element), (PsiElement)lastParam);
            }
            return parent.getLastChild();
        }
        return anchor != null ? parent.getLastChild() : null;
    }

    public static void delete(@Nullable PsiElement element) {
        ASTNode prev;
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return;
        }
        Ref parentCleanup = new Ref((Object)ParentCleanup.LEAVE);
        if (OCChangeUtil.isDeletionWithParentCleanup(element, parent, (Ref<ParentCleanup>)parentCleanup)) {
            OCChangeUtil.deleteChildFromList(parent, element, (ParentCleanup)((Object)parentCleanup.get()));
        } else if (element instanceof OCStructLike && parent instanceof OCTypeElement && parent.getParent() instanceof OCDeclaration) {
            OCChangeUtil.delete(parent.getParent());
        } else if (parent instanceof OCStructLike) {
            OCChangeUtil.removeRedundantVisibilityDeclarator(element);
            OCChangeUtil.deleteHandlingMacros(element);
        } else if (parent instanceof OCInstanceVariablesList) {
            OCChangeUtil.removeRedundantVisibilityDeclarator(element);
            OCChangeUtil.deleteHandlingMacros(element);
            if (((OCInstanceVariablesList)parent).getDeclarations().isEmpty()) {
                OCChangeUtil.clear(parent);
            }
        } else if (parent instanceof OCMethod && element instanceof OCBlockStatement) {
            OCChangeUtil.deleteHandlingMacros(element);
            parent.add(OCElementFactory.create(OCTokenTypes.SEMICOLON, parent));
        } else if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == null && ((OCSynthesizeProperty)parent).getPropertyRef() == element) {
            OCChangeUtil.delete(parent);
        } else if (parent instanceof OCSynthesizeProperty && ((OCSynthesizeProperty)parent).getInstanceVariableRef() == element) {
            parent.deleteChildRange(((OCSynthesizeProperty)parent).getPropertyRef().getNextSibling(), parent.getLastChild());
        } else if (parent instanceof OCDeclarator && ((OCDeclarator)parent).getInitializer() == element) {
            prev = TreeUtil.skipElementsBack((ASTNode)element.getNode().getTreePrev(), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL})}));
            if (prev != null && prev.getElementType() == OCTokenTypes.EQ) {
                OCChangeUtil.deleteHandlingMacros(prev.getPsi());
            }
            OCChangeUtil.deleteHandlingMacros(element);
        } else if (element instanceof OCTemplateParameterList) {
            prev = TreeUtil.skipElementsBack((ASTNode)element.getNode().getTreePrev(), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.MACRO_CALL})}));
            if (prev != null && prev.getElementType() == OCTokenTypes.TEMPLATE_CPP_KEYWORD) {
                OCChangeUtil.deleteHandlingMacros(prev.getPsi());
            }
            OCChangeUtil.deleteHandlingMacros(element);
        }
        boolean semicolonRequired = element instanceof OCStatement && !(element.getParent() instanceof OCBlockStatement) && !OCCodeInsightUtil.insideConditionalHeader(element) && !OCCodeInsightUtil.insideLoopHeader(element);
        OCChangeUtil.deleteHandlingMacros(element);
        if (semicolonRequired) {
            parent.add(OCElementFactory.create(OCTokenTypes.SEMICOLON, parent));
        }
    }

    public static void deleteExactly(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return;
        }
        OCChangeUtil.deleteHandlingMacros(element);
    }

    private static boolean isDeletionWithParentCleanup(@NotNull PsiElement element, @NotNull PsiElement parent, @NotNull Ref<ParentCleanup> parentCleanup) {
        boolean clearMode;
        boolean leaveMode;
        boolean deleteMode;
        if (element == null) {
            OCChangeUtil.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            OCChangeUtil.$$$reportNull$$$0(4);
        }
        if (parentCleanup == null) {
            OCChangeUtil.$$$reportNull$$$0(5);
        }
        boolean bl = deleteMode = parent instanceof OCClassPredeclarationList || parent instanceof OCDeclaration && element instanceof OCDeclarator || parent instanceof OCDeclarationStatement || parent instanceof OCPropertyAttributesList || parent instanceof OCProperty && element instanceof OCDeclaration || parent instanceof OCEnum || parent instanceof OCSynthesizePropertiesList || parent instanceof OCTemplateParameterList;
        if (deleteMode) {
            parentCleanup.set((Object)ParentCleanup.DELETE);
            return true;
        }
        boolean bl2 = leaveMode = parent instanceof OCParameterList || parent instanceof OCArgumentList || parent instanceof OCCompoundInitializer || parent instanceof OCTemplateArgumentList;
        if (leaveMode) {
            parentCleanup.set((Object)ParentCleanup.LEAVE);
            return true;
        }
        boolean bl3 = clearMode = parent instanceof OCProtocolList || parent instanceof OCCppBaseClauseList;
        if (clearMode) {
            parentCleanup.set((Object)ParentCleanup.CLEAR);
            return true;
        }
        return false;
    }

    private static void removeRedundantVisibilityDeclarator(PsiElement element) {
        PsiElement prev;
        PsiElement next = element.getNextSibling();
        for (prev = element.getPrevSibling(); prev != null; prev = prev.getPrevSibling()) {
            if (prev instanceof OCDeclaration || OCElementUtil.getElementType(prev) == OCTokenTypes.LBRACE) {
                return;
            }
            if (OCElementUtil.isVisibilityKeyword(prev.getNode())) break;
        }
        while (next != null) {
            if (next instanceof OCDeclaration) {
                return;
            }
            if (OCElementUtil.isVisibilityKeyword(next.getNode())) break;
            next = next.getNextSibling();
        }
        if (prev != null) {
            for (next = prev.getNextSibling(); next != null && OCElementUtil.isElementEmpty(next); next = next.getNextSibling()) {
            }
            OCChangeUtil.deleteHandlingMacros(prev);
            if (next != null && OCElementUtil.getElementType(next) == OCTokenTypes.COLON) {
                OCChangeUtil.deleteHandlingMacros(next);
            }
        }
    }

    @Nullable
    private static PsiElement findChildByType(PsiElement element, IElementType type) {
        ASTNode child = element.getNode().findChildByType(type);
        return child != null ? child.getPsi() : null;
    }

    @Nullable
    private static PsiElement getChildAt(PsiElement parent, int position) {
        PsiElement element = null;
        for (PsiElement child : OCElementUtil.getAllChildren(parent)) {
            if (child.getTextRange().getEndOffset() < position || OCElementUtil.isElementEmpty(child)) continue;
            element = child;
            break;
        }
        if (element == null && (parent instanceof OCStructLike || parent instanceof OCClassDeclaration)) {
            element = parent.getLastChild();
        }
        while (element != null && element.getPrevSibling() instanceof OCMacroCall) {
            element = element.getPrevSibling();
        }
        return element;
    }

    public static boolean canBeReplacedToBlockStatement(PsiElement statement2) {
        if (!(statement2 instanceof OCStatement)) {
            return false;
        }
        return !(statement2.getParent() instanceof OCMacroCallArgument) && !(statement2.getParent() instanceof OCCondition) && (!(statement2.getParent() instanceof OCForStatement) || ((OCForStatement)statement2.getParent()).getBody() == statement2);
    }

    public static OCStatement ensureParentIsBlockStatement(OCStatement statement2) {
        if (!(statement2.getParent() instanceof OCBlockStatement)) {
            OCBlockStatement blockStmt = (OCBlockStatement)OCElementFactory.statementFromText("{\n}", statement2);
            PsiElement statementCopy = statement2.copy();
            blockStmt = (OCBlockStatement)OCChangeUtil.replaceHandlingMacros(statement2, blockStmt);
            return (OCStatement)blockStmt.addBefore(statementCopy, blockStmt.getClosingBrace());
        }
        return statement2;
    }

    @Nullable
    public static PsiElement getAppropriateParent(OCSymbolKind kind, PsiElement anchor) {
        if (kind.isFunction()) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{OCFile.class, OCCppNamespace.class, OCStructLike.class});
        }
        if (kind == OCSymbolKind.LOCAL_VARIABLE) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCBlockStatement.class);
        }
        if (kind == OCSymbolKind.METHOD) {
            return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCClassDeclaration.class);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, OCFile.class);
    }

    public static boolean changeText(@NotNull Project project2, PsiFile file, int offset, int length, String substitution, boolean unblockDocument) {
        if (project2 == null) {
            OCChangeUtil.$$$reportNull$$$0(6);
        }
        return OCChangeUtil.changeText(project2, file, offset, length, substitution, unblockDocument, true);
    }

    public static boolean changeText(@NotNull Project project2, PsiFile file, int offset, int length, String substitution, boolean unblockDocument, boolean commitDocument) {
        Document document;
        if (project2 == null) {
            OCChangeUtil.$$$reportNull$$$0(7);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project2).getDocument(file)) == null || !file.isValid()) {
            return false;
        }
        if (unblockDocument) {
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
        }
        document.replaceString(offset, offset + length, (CharSequence)substitution);
        if (commitDocument) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            int endOffset = offset + substitution.length();
            if (endOffset < file.getTextLength()) {
                ++endOffset;
            }
            OCChangeUtil.reformatTextIfNotInjected(file, offset, endOffset);
        }
        return true;
    }

    public static void reformatTextIfNotInjected(PsiFile file, int offset, int endOffset) {
        if (!InjectedLanguageManager.getInstance((Project)file.getProject()).isInjectedFragment(file)) {
            CodeStyleManager.getInstance((Project)file.getProject()).reformatRange((PsiElement)file, offset, endOffset, true);
        }
    }

    public static OCCaretLocation removeFunctions(@NotNull Collection<OCFunctionSymbol> functions, @NotNull OCCaretLocation location) {
        if (functions == null) {
            OCChangeUtil.$$$reportNull$$$0(8);
        }
        if (location == null) {
            OCChangeUtil.$$$reportNull$$$0(9);
        }
        if (functions.isEmpty()) {
            return location;
        }
        HashMap toRemove = new HashMap();
        for (OCFunctionSymbol function : functions) {
            Document d;
            OCFunctionDeclaration declaration = function.locateFunctionDefinition(location.getProject());
            if (declaration == null || declaration.getContainingFile() == null) continue;
            ArrayList<TextRange> ranges = (ArrayList<TextRange>)toRemove.get(declaration.getContainingFile());
            if (ranges == null) {
                ranges = new ArrayList<TextRange>();
                toRemove.put(declaration.getContainingFile(), ranges);
            }
            TextRange r = declaration.getRangeWithMacros();
            PsiFile file = declaration.getContainingFile();
            if (file == null || (d = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) continue;
            ranges.add(TextRange.create((int)r.getStartOffset(), (int)CharArrayUtil.shiftForward((CharSequence)d.getCharsSequence(), (int)r.getEndOffset(), (String)"\n")));
        }
        Ref result = Ref.create((Object)location);
        int oldOffset = location.getOffsetInFile() == null ? -1 : location.getOffsetInFile();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (location == null) {
                OCChangeUtil.$$$reportNull$$$0(22);
            }
            for (Map.Entry entry : toRemove.entrySet()) {
                PsiFile file = (PsiFile)entry.getKey();
                Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document == null) continue;
                List<TextRange> ranges = OCChangeUtil.mergeRanges((List)entry.getValue(), document);
                boolean shouldFixLocation = location.getElement() != null && location.getFile().equals(file) && oldOffset >= 0;
                int locationFixup = 0;
                for (TextRange range : ranges) {
                    if (!shouldFixLocation || oldOffset <= range.getStartOffset()) continue;
                    locationFixup += Math.min(oldOffset - range.getStartOffset(), range.getLength());
                }
                int fixup = 0;
                for (TextRange range : ranges) {
                    document.deleteString(range.getStartOffset() - fixup, range.getEndOffset() - fixup);
                    fixup += range.getLength();
                }
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                if (!shouldFixLocation) continue;
                result.set((Object)OCCaretLocation.byOffset(location.getFile(), oldOffset - locationFixup));
            }
        });
        return (OCCaretLocation)result.get();
    }

    @NotNull
    private static List<TextRange> mergeRanges(@NotNull List<TextRange> ranges, @NotNull Document document) {
        if (ranges == null) {
            OCChangeUtil.$$$reportNull$$$0(10);
        }
        if (document == null) {
            OCChangeUtil.$$$reportNull$$$0(11);
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        Ref currentNotAdded = Ref.create();
        ranges.stream().sorted((r1, r2) -> r1.getStartOffset() - r2.getStartOffset()).forEach(range -> {
            if (document == null) {
                OCChangeUtil.$$$reportNull$$$0(21);
            }
            if (!currentNotAdded.isNull()) {
                if (((TextRange)currentNotAdded.get()).intersects(range) || CharArrayUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence(), (int)((TextRange)currentNotAdded.get()).getEndOffset(), (int)range.getStartOffset())) {
                    currentNotAdded.set((Object)((TextRange)currentNotAdded.get()).union(range));
                } else {
                    result.add((TextRange)currentNotAdded.get());
                    currentNotAdded.set(range);
                }
            } else {
                currentNotAdded.set(range);
            }
        });
        if (!currentNotAdded.isNull()) {
            result.add((TextRange)currentNotAdded.get());
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            OCChangeUtil.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    private static void deleteChildFromList(@NotNull PsiElement parent, @NotNull PsiElement child, ParentCleanup parentCleanup) {
        ASTNode prev;
        if (parent == null) {
            OCChangeUtil.$$$reportNull$$$0(13);
        }
        if (child == null) {
            OCChangeUtil.$$$reportNull$$$0(14);
        }
        if ((prev = TreeUtil.skipElementsBack((ASTNode)child.getNode().getTreePrev(), (TokenSet)OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET)) != null && prev.getElementType() == OCTokenTypes.COMMA) {
            CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)prev);
        } else {
            ASTNode next = TreeUtil.skipElements((ASTNode)child.getNode().getTreeNext(), (TokenSet)OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
            if (next != null && next.getElementType() == OCTokenTypes.COMMA) {
                CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)next);
            } else {
                if (parentCleanup == ParentCleanup.DELETE) {
                    OCChangeUtil.delete(parent);
                    return;
                }
                if (parentCleanup == ParentCleanup.CLEAR) {
                    OCChangeUtil.clear(parent);
                    return;
                }
            }
        }
        CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)child.getNode());
    }

    public static void clear(PsiElement parent) {
        parent.deleteChildRange(parent.getFirstChild(), parent.getLastChild());
    }

    public static void deleteUnsafe(PsiElement oldElement) {
        OCChangeUtil.deleteHandlingMacros(oldElement);
    }

    private static void deleteHandlingMacros(PsiElement oldElement) {
        PsiElement oldMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(oldElement);
        while (oldMacroCall instanceof OCMacroCall) {
            PsiElement node = oldMacroCall;
            oldMacroCall = oldMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            node.delete();
            if (!nonEmpty) continue;
            break;
        }
        CodeEditUtil.removeChild((ASTNode)oldElement.getParent().getNode(), (ASTNode)oldElement.getNode());
    }

    public static PsiElement addHandlingMacros(@NotNull PsiElement parent, @NotNull PsiElement child, @Nullable PsiElement anchor) {
        if (parent == null) {
            OCChangeUtil.$$$reportNull$$$0(15);
        }
        if (child == null) {
            OCChangeUtil.$$$reportNull$$$0(16);
        }
        return OCChangeUtil.addHandlingMacros(parent, child, anchor, true);
    }

    public static PsiElement addHandlingMacros(@NotNull PsiElement parent, @NotNull PsiElement child, @Nullable PsiElement anchor, boolean isBefore) {
        if (parent == null) {
            OCChangeUtil.$$$reportNull$$$0(17);
        }
        if (child == null) {
            OCChangeUtil.$$$reportNull$$$0(18);
        }
        PsiElement childMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(child);
        child = anchor == null ? parent.add(child) : (isBefore ? parent.addBefore(child, anchor) : parent.addAfter(child, anchor));
        PsiElement insertAnchor = child;
        while (childMacroCall instanceof OCMacroCall) {
            PsiElement node = childMacroCall;
            childMacroCall = childMacroCall.getPrevSibling();
            boolean nonEmpty = node.getTextLength() > 0;
            CodeEditUtil.addChild((ASTNode)parent.getNode(), (ASTNode)node.getNode(), (ASTNode)insertAnchor.getNode());
            insertAnchor = node;
            if (!nonEmpty) continue;
            break;
        }
        return child;
    }

    @NotNull
    public static PsiElement copyHandlingMacros(@NotNull PsiElement element) {
        if (element == null) {
            OCChangeUtil.$$$reportNull$$$0(19);
        }
        OCStatement copy = OCElementFactory.statementFromText(";", element);
        OCStatement oCStatement = copy = OCChangeUtil.replaceHandlingMacros(copy, element);
        if (oCStatement == null) {
            OCChangeUtil.$$$reportNull$$$0(20);
        }
        return oCStatement;
    }

    public static PsiElement replaceHandlingMacros(PsiElement oldElement, PsiElement newElement) {
        boolean nonEmpty;
        PsiElement node;
        if (oldElement == null || newElement == null) {
            return oldElement;
        }
        PsiElement oldMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(oldElement);
        PsiElement newMacroCall = OCElementUtil.getPrevSiblingOrParentSibling(newElement);
        PsiElement insertAnchor = oldElement;
        while (newMacroCall instanceof OCMacroCall) {
            node = newMacroCall;
            newMacroCall = newMacroCall.getPrevSibling();
            nonEmpty = node.getTextLength() > 0;
            insertAnchor = oldElement.getParent().addBefore(node, insertAnchor);
            if (!nonEmpty) continue;
            break;
        }
        while (oldMacroCall instanceof OCMacroCall) {
            node = oldMacroCall;
            oldMacroCall = oldMacroCall.getPrevSibling();
            nonEmpty = node.getTextLength() > 0;
            CodeEditUtil.removeChild((ASTNode)node.getParent().getNode(), (ASTNode)node.getNode());
            if (!nonEmpty) continue;
            break;
        }
        return oldElement.replace(newElement);
    }

    public static void safeDeleteReference(PsiElement element) {
        if (element instanceof OCReferenceElement) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression) {
            List<OCExpression> arguments = ((OCSendMessageExpression)element).getArgumentExpressions();
            OCMethodSymbol responder = ((OCSendMessageExpression)element).getProbableResponders().getKnownResponder();
            PsiElement statement2 = OCParenthesesUtils.topmostParenthesized((OCExpression)element).getParent();
            if (arguments.size() == 1 && (responder == null || responder.isSynthetic() && responder.getAssociatedSymbol(element.getProject()) == null)) {
                OCExpression argument = arguments.get(0);
                if (statement2 instanceof OCExpressionStatement) {
                    if (!OCCodeInsightUtil.hasSideEffects(argument)) {
                        OCChangeUtil.safeDeleteStatement((OCStatement)statement2);
                    } else {
                        OCChangeUtil.replaceHandlingMacros(((OCExpressionStatement)statement2).getExpression(), argument);
                    }
                }
            }
        } else if (element instanceof OCReferenceExpression || element instanceof OCQualifiedExpression) {
            PsiElement assignment = OCParenthesesUtils.topmostParenthesized((OCExpression)element).getParent();
            if (!(assignment instanceof OCAssignmentExpression)) {
                return;
            }
            PsiElement statement3 = OCParenthesesUtils.topmostParenthesized((OCExpression)assignment).getParent();
            OCExpression sourceExpression = ((OCAssignmentExpression)assignment).getSourceExpression();
            if (statement3 instanceof OCExpressionStatement && (sourceExpression == null || !OCCodeInsightUtil.hasSideEffects(sourceExpression))) {
                OCChangeUtil.safeDeleteStatement((OCStatement)statement3);
            } else {
                OCChangeUtil.replaceHandlingMacros(assignment, sourceExpression);
            }
        }
    }

    public static void safeDeleteStatement(OCStatement statement2) {
        PsiElement parent = statement2.getParent();
        if (OCChangeUtil.isElseBranchStatement(statement2)) {
            CodeEditUtil.removeChildren((ASTNode)parent.getNode(), (ASTNode)((OCIfStatement)parent).getElseKeyword(), (ASTNode)statement2.getNode());
        } else if (parent instanceof OCBlockStatement) {
            if (((OCBlockStatement)parent).getStatements().size() == 1 && OCChangeUtil.isElseBranchStatement((OCStatement)parent)) {
                OCChangeUtil.safeDeleteStatement((OCStatement)parent);
            } else {
                OCChangeUtil.delete(statement2);
            }
        } else {
            OCChangeUtil.replaceHandlingMacros(statement2, OCElementFactory.statementFromText(";", statement2));
        }
    }

    private static boolean isElseBranchStatement(OCStatement statement2) {
        return statement2.getParent() instanceof OCIfStatement && ((OCIfStatement)statement2.getParent()).getElseBranch() == statement2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAdd";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorStatement";
                break;
            }
            case 2: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCleanup";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/util/OCChangeUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addAfterWithinBlockStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeRanges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "copyHandlingMacros";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addAfterWithinBlockStatement";
                break;
            }
            case 2: 
            case 12: 
            case 20: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDeletionWithParentCleanup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "changeText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFunctions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mergeRanges";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildFromList";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addHandlingMacros";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyHandlingMacros";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$mergeRanges$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeFunctions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ParentCleanup {
        LEAVE,
        DELETE,
        CLEAR;

    }
}

