/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCVariadicPackExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArgumentsList<E extends OCTypeOwner> {
    @NotNull
    private List<OCType> types;
    @Nullable
    private List<E> exprs;
    private boolean nonExpandedVariadics;

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs, boolean nonExpandedVariadics) {
        if (types == null) {
            OCArgumentsList.$$$reportNull$$$0(0);
        }
        this.types = Collections.unmodifiableList(types);
        this.exprs = exprs != null ? Collections.unmodifiableList(exprs) : null;
        this.nonExpandedVariadics = nonExpandedVariadics;
    }

    public OCArgumentsList(@NotNull List<OCType> types, @Nullable List<E> exprs) {
        if (types == null) {
            OCArgumentsList.$$$reportNull$$$0(1);
        }
        this(types, exprs, false);
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList) {
        if (expressionsList == null) {
            OCArgumentsList.$$$reportNull$$$0(2);
        }
        OCArgumentsList<OCExpression> oCArgumentsList = OCArgumentsList.getArgumentList(expressionsList, null);
        if (oCArgumentsList == null) {
            OCArgumentsList.$$$reportNull$$$0(3);
        }
        return oCArgumentsList;
    }

    @NotNull
    public static OCArgumentsList<OCExpression> getArgumentList(@NotNull List<OCExpression> expressionsList, @Nullable OCResolveContext context) {
        if (expressionsList == null) {
            OCArgumentsList.$$$reportNull$$$0(4);
        }
        ArrayList<OCType> types = new ArrayList<OCType>();
        boolean nonExpandedVariadics = false;
        ArrayList<OCExpression> expressions = new ArrayList<OCExpression>();
        for (OCExpression expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpression) {
                nonExpandedVariadics = true;
                continue;
            }
            expressions.add(expression);
            types.add(expression.getResolvedType(context != null ? context : OCResolveContext.forPsi(expression)));
        }
        OCArgumentsList<OCExpression> oCArgumentsList = new OCArgumentsList<OCExpression>(types, expressions, nonExpandedVariadics);
        if (oCArgumentsList == null) {
            OCArgumentsList.$$$reportNull$$$0(5);
        }
        return oCArgumentsList;
    }

    @NotNull
    public static OCArgumentsList<OCExpressionSymbol> expandVariadicExpressions(@NotNull List<OCExpressionSymbol> expressionsList, @NotNull OCResolveContext context) {
        if (expressionsList == null) {
            OCArgumentsList.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(7);
        }
        ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
        ArrayList<OCExpressionSymbol> expandedExprs = new ArrayList<OCExpressionSymbol>();
        boolean nonExpandedVariadics = false;
        for (OCExpressionSymbol expression : expressionsList) {
            if (expression instanceof OCVariadicPackExpressionSymbol) {
                List<OCType> expansions = ((OCVariadicPackExpressionSymbol)expression).getExpandedResolvedTypes(context);
                if (expansions != null) {
                    for (OCType type : expansions) {
                        expandedExprs.add(((OCVariadicPackExpressionSymbol)expression).getExpression());
                        expandedTypes.add(type);
                    }
                    continue;
                }
                nonExpandedVariadics = true;
                continue;
            }
            expandedExprs.add(expression);
            expandedTypes.add(expression.getResolvedType(context));
        }
        OCArgumentsList<OCExpressionSymbol> oCArgumentsList = new OCArgumentsList<OCExpressionSymbol>(expandedTypes, expandedExprs, nonExpandedVariadics);
        if (oCArgumentsList == null) {
            OCArgumentsList.$$$reportNull$$$0(8);
        }
        return oCArgumentsList;
    }

    @NotNull
    public static <T extends OCTypeArgument> List<T> expandVariadicTypes(@NotNull List<T> types, @NotNull OCResolveContext context) {
        if (types == null) {
            OCArgumentsList.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(10);
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        if (context.isDontExpandVariadics()) {
            List<T> list = types;
            if (list == null) {
                OCArgumentsList.$$$reportNull$$$0(11);
            }
            return list;
        }
        for (OCTypeArgument type : types) {
            List<OCTypeArgument> expandedTypes = null;
            if (type instanceof OCVariadicType) {
                OCType underlyingType = ((OCVariadicType)type).getUnderlyingType();
                expandedTypes = OCArgumentsList.expandExpansionPacks(underlyingType, context);
                if (expandedTypes == null) {
                    expandedTypes = OCArgumentsList.expandVariadicType(underlyingType, context);
                }
            } else if (type.isVariadic()) {
                expandedTypes = OCArgumentsList.expandVariadicPackExpression((OCVariadicPackExpressionSymbol)((OCExpressionTypeArgument)type).getSymbol(), context);
            }
            if (expandedTypes != null) {
                result.addAll(expandedTypes);
                continue;
            }
            result.add(type);
        }
        ArrayList<OCTypeArgument> arrayList = result;
        if (arrayList == null) {
            OCArgumentsList.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandExpansionPacks(@NotNull OCType type, final @NotNull OCResolveContext context) {
        if (type == null) {
            OCArgumentsList.$$$reportNull$$$0(13);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(14);
        }
        final Ref expansionsCnt = new Ref();
        final HashMap<OCTypeParameterSymbol, OCExpansionPackType> expansionSubstitutions = new HashMap<OCTypeParameterSymbol, OCExpansionPackType>();
        type.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitExpansionPackType(OCExpansionPackType type) {
                if (expansionsCnt.isNull() || (Integer)expansionsCnt.get() < type.getExpansionsCnt()) {
                    expansionsCnt.set((Object)type.getExpansionsCnt());
                }
                return true;
            }

            private boolean processSubstitution(@NotNull OCTypeSubstitution substitution, @NotNull Object reference) {
                if (substitution == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (reference == null) {
                    1.$$$reportNull$$$0(1);
                }
                boolean prev = context.dontUseSymbolContextsInDepends();
                context.setDontUseSymbolContextsInDepends(true);
                substitution.getMinimalDependentSubstitution(reference, context).processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)e -> {
                    OCTypeArgument value = (OCTypeArgument)e.getValue();
                    if (value instanceof OCExpansionPackType) {
                        expansionSubstitutions.put(e.getKey(), (OCExpansionPackType)value);
                    }
                    if (value instanceof OCType) {
                        ((OCType)value).accept(this);
                    }
                    return true;
                }));
                context.setDontUseSymbolContextsInDepends(prev);
                return true;
            }

            @Override
            public Boolean visitReferenceType(OCReferenceType type) {
                return this.processSubstitution(type.getSubstitution(), type);
            }

            @Override
            public Boolean visitArrayType(OCArrayType type) {
                return this.processSubstitution(type.getSubstitution(), type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "substitution";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "reference";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$1";
                objectArray[2] = "processSubstitution";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!expansionsCnt.isNull()) {
            ArrayList<OCType> expandedTypes = new ArrayList<OCType>();
            for (int i = 0; i < (Integer)expansionsCnt.get(); ++i) {
                final int expansionIndex = i;
                OCType resolvedType = type;
                if (!expansionSubstitutions.isEmpty()) {
                    HashMap<OCTypeParameterSymbol, OCTypeArgument> map2 = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
                    expansionSubstitutions.forEach((param, pack) -> {
                        if (expansionIndex < pack.getExpansionsCnt()) {
                            map2.put((OCTypeParameterSymbol)param, pack.getExpansions().get(expansionIndex));
                        }
                    });
                    OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create(map2);
                    resolvedType = substitution.substitute(type, true, context).resolve(context);
                    if (resolvedType instanceof OCVariadicType) {
                        resolvedType = new OCVariadicType(substitution.substitute(((OCVariadicType)resolvedType).getUnderlyingType(), context));
                    }
                }
                expandedTypes.add(resolvedType.accept(new OCNonPrimitiveTypeCloneVisitor(){

                    @Override
                    public OCType visitExpansionPackType(OCExpansionPackType type) {
                        OCTypeArgument argument;
                        if (expansionIndex < type.getExpansionsCnt() && (argument = type.getExpansions().get(expansionIndex)) instanceof OCType) {
                            return (OCType)argument;
                        }
                        return OCUnknownType.INSTANCE;
                    }
                }));
            }
            return expandedTypes;
        }
        return null;
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicPackExpression(@NotNull OCVariadicPackExpressionSymbol expressionSymbol, @NotNull OCResolveContext context) {
        if (expressionSymbol == null) {
            OCArgumentsList.$$$reportNull$$$0(15);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(16);
        }
        final OCExpressionSymbol symbol = expressionSymbol.getExpression();
        return OCArgumentsList.getExpandedResolvedTypes(context1 -> symbol.evaluateToTypeArgument((OCResolveContext)context1), new OCTypeOwner(){

            @Override
            @NotNull
            public OCType getResolvedType(@NotNull OCResolveContext context) {
                if (context == null) {
                    3.$$$reportNull$$$0(0);
                }
                OCType oCType = symbol.getResolvedType(context);
                if (oCType == null) {
                    3.$$$reportNull$$$0(1);
                }
                return oCType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getResolvedType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getResolvedType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, context);
    }

    @Nullable
    private static List<? extends OCTypeArgument> expandVariadicType(final @NotNull OCType underlyingType, @NotNull OCResolveContext context) {
        if (underlyingType == null) {
            OCArgumentsList.$$$reportNull$$$0(17);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(18);
        }
        return OCArgumentsList.getExpandedResolvedTypes(context2 -> {
            if (underlyingType == null) {
                OCArgumentsList.$$$reportNull$$$0(33);
            }
            return context2.getSubstitution().substitute(underlyingType, (OCResolveContext)context2);
        }, new OCTypeOwner(){

            @Override
            @NotNull
            public OCType getResolvedType(@NotNull OCResolveContext context2) {
                if (context2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                OCType oCType = underlyingType.resolve(context2);
                if (oCType == null) {
                    4.$$$reportNull$$$0(1);
                }
                return oCType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getResolvedType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getResolvedType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, context);
    }

    @Nullable
    public static List<OCType> getExpandedResolvedTypes(@NotNull OCTypeOwner operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        if (operand == null) {
            OCArgumentsList.$$$reportNull$$$0(19);
        }
        if (dependency == null) {
            OCArgumentsList.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(21);
        }
        return OCArgumentsList.getExpandedResolvedTypes(context1 -> {
            if (operand == null) {
                OCArgumentsList.$$$reportNull$$$0(32);
            }
            return operand.getResolvedType((OCResolveContext)context1);
        }, dependency, context);
    }

    @Nullable
    public static <T extends OCTypeArgument> List<T> getExpandedResolvedTypes(@NotNull Function<OCResolveContext, T> operand, @NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        if (operand == null) {
            OCArgumentsList.$$$reportNull$$$0(22);
        }
        if (dependency == null) {
            OCArgumentsList.$$$reportNull$$$0(23);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(24);
        }
        while (context.isVariadicExpansionMode()) {
            context = context.getOriginalContext();
        }
        Set<OCTypeParameterSymbol> dependencies = OCArgumentsList.getTypeParameterDependencies(dependency, context);
        List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> expansions = OCArgumentsList.getExpansions(dependencies, context);
        if (expansions == null || expansions.isEmpty()) {
            return null;
        }
        ArrayList<OCTypeArgument> result = new ArrayList<OCTypeArgument>();
        for (int i = 0; i < ((OCExpansionPackType)expansions.get((int)0).second).getExpansionsCnt(); ++i) {
            Map<OCTypeParameterSymbol, OCTypeArgument> map2 = OCTypeUtils.newTypeParameterMap();
            for (Pair<OCTypeParameterSymbol, OCExpansionPackType> expansion : expansions) {
                map2.put((OCTypeParameterSymbol)expansion.first, ((OCExpansionPackType)expansion.second).getExpansions().get(i));
            }
            OCResolveContext resolveContext = context.substitute(OCSimpleTypeSubstitution.create(map2), true, false);
            resolveContext.setVariadicExpansionMode(true);
            OCTypeArgument argument = (OCTypeArgument)operand.fun((Object)resolveContext);
            if (argument == null) {
                return null;
            }
            result.add(argument);
        }
        return result;
    }

    @Nullable
    private static List<Pair<OCTypeParameterSymbol, OCExpansionPackType>> getExpansions(@NotNull Set<OCTypeParameterSymbol> dependencies, @NotNull OCResolveContext context) {
        if (dependencies == null) {
            OCArgumentsList.$$$reportNull$$$0(25);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(26);
        }
        HashSet processed = new HashSet();
        ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>> pairs = new ArrayList<Pair<OCTypeParameterSymbol, OCExpansionPackType>>();
        if (!context.getSubstitution().processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)arg_0 -> OCArgumentsList.lambda$getExpansions$4(dependencies, (Set)processed, pairs, arg_0)))) {
            return null;
        }
        return pairs;
    }

    @NotNull
    private static Set<OCTypeParameterSymbol> getTypeParameterDependencies(@NotNull OCTypeOwner dependency, @NotNull OCResolveContext context) {
        if (dependency == null) {
            OCArgumentsList.$$$reportNull$$$0(27);
        }
        if (context == null) {
            OCArgumentsList.$$$reportNull$$$0(28);
        }
        OCResolveContext contextWithoutSubstitutions = context.clearSubstitution();
        contextWithoutSubstitutions.setDontExpandVariadics(true);
        OCType resolvedDependency = dependency.getResolvedType(contextWithoutSubstitutions);
        Set<OCTypeParameterSymbol> set = contextWithoutSubstitutions.getTypeDependencies(resolvedDependency);
        if (set == null) {
            OCArgumentsList.$$$reportNull$$$0(29);
        }
        return set;
    }

    @NotNull
    public List<OCType> getTypes() {
        List<OCType> list = this.types;
        if (list == null) {
            OCArgumentsList.$$$reportNull$$$0(30);
        }
        return list;
    }

    @Nullable
    public List<E> getExprs() {
        return this.exprs;
    }

    public int getCount() {
        return this.types.size();
    }

    public boolean hasNonExpandedVariadics() {
        return this.nonExpandedVariadics;
    }

    private static /* synthetic */ boolean lambda$getExpansions$4(@NotNull Set dependencies, Set processed, List pairs, Map.Entry entry) {
        if (dependencies == null) {
            OCArgumentsList.$$$reportNull$$$0(31);
        }
        OCTypeParameterSymbol parameter = (OCTypeParameterSymbol)entry.getKey();
        OCTypeArgument argument = (OCTypeArgument)entry.getValue();
        if (dependencies.contains(parameter) && !processed.contains(parameter) && argument instanceof OCExpansionPackType) {
            processed.add(parameter);
            if (!pairs.isEmpty() && ((OCExpansionPackType)((Pair)pairs.get((int)0)).second).getExpansionsCnt() != ((OCExpansionPackType)argument).getExpansionsCnt()) {
                return false;
            }
            pairs.add(Pair.create((Object)parameter, (Object)((OCExpansionPackType)argument)));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionsList";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionSymbol";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingType";
                break;
            }
            case 19: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCArgumentsList";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "expandVariadicExpressions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "expandVariadicTypes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDependencies";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentList";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 30: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicExpressions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicTypes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "expandExpansionPacks";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicPackExpression";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandVariadicType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedResolvedTypes";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExpansions";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDependencies";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExpansions$4";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExpandedResolvedTypes$3";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expandVariadicType$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

