/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionArgumentsProcessor {
    public static <E extends OCTypeOwner> boolean processArguments(@NotNull List<? extends OCType> parameterTypes, @Nullable List<OCDeclaratorSymbol> parameterSymbols, @NotNull OCArgumentsList<E> arguments, @NotNull OCResolveContext context, final @NotNull ArgumentsProcessor<E> processor2) {
        if (parameterTypes == null) {
            OCFunctionArgumentsProcessor.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            OCFunctionArgumentsProcessor.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCFunctionArgumentsProcessor.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            OCFunctionArgumentsProcessor.$$$reportNull$$$0(3);
        }
        int paramIndex = 0;
        int argIndex = 0;
        while (paramIndex < parameterTypes.size()) {
            OCTypeOwner expression;
            OCDeclaratorSymbol paramSymbol;
            OCType paramType = parameterTypes.get(paramIndex).resolve(context.clearSubstitution());
            OCDeclaratorSymbol oCDeclaratorSymbol = paramSymbol = parameterSymbols != null && paramIndex < parameterSymbols.size() ? parameterSymbols.get(paramIndex) : null;
            if (paramType instanceof OCVariadicType) {
                if (paramIndex == parameterTypes.size() - 1) {
                    OCType underlyingType = ((OCVariadicType)paramType).getUnderlyingType();
                    for (int j = argIndex; j < arguments.getCount(); ++j) {
                        OCTypeOwner expression2;
                        OCType argumentType = arguments.getTypes().get(j).getGuessedType();
                        OCTypeOwner oCTypeOwner = expression2 = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(j) : null;
                        if (argumentType instanceof OCVariadicType) {
                            argumentType = ((OCVariadicType)argumentType).getUnderlyingType();
                        }
                        if (processor2.process(underlyingType, paramSymbol, argumentType, expression2, true)) continue;
                        return false;
                    }
                    if (argIndex != arguments.getCount() || !underlyingType.accept(new OCBooleanTypeVisitor(){

                        @Override
                        public Boolean visitTypeParameterType(OCTypeParameterType type) {
                            return !processor2.process(type, paramSymbol, new OCExpansionPackType(), null, true);
                        }
                    }).booleanValue()) break;
                    return false;
                }
                ++paramIndex;
                continue;
            }
            if (argIndex >= arguments.getCount()) break;
            OCType argumentType = arguments.getTypes().get(argIndex).getGuessedType();
            OCTypeOwner oCTypeOwner = expression = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(argIndex) : null;
            if (!processor2.process(paramType, paramSymbol, argumentType, expression, false)) {
                return false;
            }
            ++paramIndex;
            ++argIndex;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameterTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "arguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/resolve/OCFunctionArgumentsProcessor";
        objectArray[2] = "processArguments";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ArgumentsProcessor<E extends OCTypeOwner> {
        public boolean process(@NotNull OCType var1, @Nullable OCDeclaratorSymbol var2, @NotNull OCType var3, @Nullable E var4, boolean var5);
    }
}

