/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionArgumentsProcessor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.ResolveTemplateSpecializationsResult;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.resolve.v2.Conversions;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.TemplatesUtils;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveOverloadsUtil {
    private static final int MAX_FUNCTIONS_TO_FILTER_OUT_IDENTICAL = 6;

    @NotNull
    public static FindConstructorResult resolveConstructorOverloads(@NotNull OCStructType type, Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, boolean allowImplicitConversions, boolean isListInitialization, @NotNull OCResolveContext context) {
        List explicitOverloads;
        if (type == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(2);
        }
        List<?> argExprs = arguments.getExprs();
        boolean isExpanded = false;
        if (isListInitialization && argExprs != null && argExprs.size() == 1 && argExprs.get(0) instanceof OCCompoundInitializer) {
            HashSet<OCSymbol> ctorsWithInitList;
            OCCompoundInitializer compInitializer = (OCCompoundInitializer)argExprs.get(0);
            arguments = OCArgumentsList.getArgumentList(compInitializer.getInitializerExpressions(), context);
            OCFunctionSymbol result = OCResolveOverloadsUtil.findStdInitListCtor(cases, arguments, ctorsWithInitList = new HashSet<OCSymbol>(), context);
            if (result != null) {
                FindConstructorResult findConstructorResult = FindConstructorResult.regular(result);
                if (findConstructorResult == null) {
                    OCResolveOverloadsUtil.$$$reportNull$$$0(3);
                }
                return findConstructorResult;
            }
            isExpanded = true;
            if (!ctorsWithInitList.isEmpty() && (arguments.getTypes().isEmpty() || !(arguments.getTypes().get(0) instanceof OCBracedInitListType) && !arguments.getTypes().get(0).isCppStructType(context))) {
                cases = cases.stream().filter(symbol -> !ctorsWithInitList.contains(symbol)).collect(Collectors.toList());
            }
        }
        OCSymbol result = OCResolveOverloadsUtil.resolveOverloads(cases, arguments, null, null, null, true, false, allowImplicitConversions, type.isMagicInside(context) || type.hasSeveralSpecializations(), isListInitialization, context);
        assert (result == null || result instanceof OCFunctionSymbol);
        if (result instanceof OCFunctionGroupSymbol && ((OCFunctionGroupSymbol)result).getParameterSymbols().isEmpty() && ((OCFunctionGroupSymbol)result).getCause() == OCFunctionGroupSymbol.Cause.Ambiguous && (explicitOverloads = ((OCFunctionGroupSymbol)result).getOverloads().stream().filter(f -> !(f instanceof OCCompilerGeneratedConstructorSymbol)).collect(Collectors.toList())).size() == 1) {
            result = (OCSymbol)explicitOverloads.get(0);
        }
        FindConstructorResult findConstructorResult = isExpanded ? FindConstructorResult.expanded((OCFunctionSymbol)result) : FindConstructorResult.regular((OCFunctionSymbol)result);
        if (findConstructorResult == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(4);
        }
        return findConstructorResult;
    }

    private static boolean hasUnevaluatedSubstitutions(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(5);
        }
        Ref result = Ref.create((Object)false);
        if (symbol instanceof OCSymbolWithSubstitution) {
            ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution().processSubstitutions((Processor<Map.Entry<OCTypeParameterSymbol, OCTypeArgument>>)((Processor)entry -> {
                OCTypeArgument arg = (OCTypeArgument)entry.getValue();
                if (arg instanceof OCExpressionTypeArgument && !(((OCExpressionTypeArgument)arg).getSymbol() instanceof OCLiteralExpressionSymbol)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }));
        }
        return (Boolean)result.get();
    }

    @Nullable
    public static OCSymbol resolveOverloads(@NotNull Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, @Nullable OCType leftType, @Nullable OCExprValueCategory leftValueCategory, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, boolean filterByParameters, boolean filterAmbigs, boolean allowUserConversions, boolean hasMagic, boolean isListInitialization, @NotNull OCResolveContext context) {
        if (cases == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(6);
        }
        if (arguments == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(8);
        }
        if (!cases.isEmpty() && !cases.stream().allMatch(s -> s instanceof OCFunctionSymbol || s instanceof OCStructSymbol)) {
            return (OCSymbol)ContainerUtil.getFirstItem(cases);
        }
        hasMagic |= arguments.hasNonExpandedVariadics() || arguments.getTypes().stream().anyMatch(type -> type instanceof OCTypeParameterType);
        CVQualifiers cvQualifiers = leftType != null ? leftType.getCVQualifiers() : null;
        ResolveTemplateSpecializationsResult specs = OCResolveOverloadsUtil.resolveTemplateSpecializations(cases, arguments, cvQualifiers, operatorPlacement, context);
        hasMagic |= !context.isInSFINAE() && specs.getHasBadArguments();
        List<OCFunctionSymbol> filtered = specs.getGood();
        if (!(filterByParameters |= context.isInSFINAE()) && filtered.size() == 1) {
            return (OCSymbol)ContainerUtil.getFirstItem(filtered);
        }
        if (filtered.size() == 0) {
            return OCResolveOverloadsUtil.groupAmbiguousFunctions(specs.getNotDeduced(), context, filterAmbigs && !hasMagic, hasMagic ? OCFunctionGroupSymbol.Cause.Magic : OCFunctionGroupSymbol.Cause.NoViable, cases);
        }
        if (leftValueCategory == null) {
            leftValueCategory = OCExprValueCategory.XValue;
        }
        ArrayList<Overload> viable = new ArrayList<Overload>(filtered.size());
        block0: for (OCFunctionSymbol oCFunctionSymbol : filtered) {
            int i;
            ProgressManager.checkCanceled();
            ArrayList<ImplicitConversionSequence> paramConversions = new ArrayList<ImplicitConversionSequence>(arguments.getCount());
            List<OCType> paramTypes = OCResolveOverloadsUtil.getParameterTypes(oCFunctionSymbol, operatorPlacement, context, cvQualifiers);
            OCSymbolWithQualifiedName resolvedOwner = oCFunctionSymbol.getResolvedOwner(context, false);
            if (resolvedOwner != null && OCResolveOverloadsUtil.hasUnevaluatedSubstitutions(resolvedOwner)) {
                paramConversions.add(ImplicitConversionSequence.magic());
            } else if (leftType != null && !oCFunctionSymbol.isCppConstructor() && resolvedOwner instanceof OCStructSymbol) {
                OCStructType objectType = ((OCStructSymbol)resolvedOwner).getType();
                ImplicitConversionSequence conversion = null;
                if (leftType instanceof OCCppReferenceType) {
                    leftType = ((OCCppReferenceType)leftType).getRefType();
                }
                if (leftType.isMagicInside(context) || leftType instanceof OCStructType && ((OCStructType)leftType).hasSeveralSpecializations() || objectType.isMagicInside(context)) {
                    conversion = ImplicitConversionSequence.magic();
                } else if (!oCFunctionSymbol.isFriendOrStatic()) {
                    if (!(leftType instanceof OCStructType) && (!(leftType instanceof OCPointerType) || !(((OCPointerType)leftType).getRefType() instanceof OCStructType))) continue;
                    conversion = Conversions.TryObjectArgumentInitialization(objectType, leftType, oCFunctionSymbol, leftValueCategory, context);
                }
                if (conversion != null) {
                    if (conversion.isBad()) continue;
                    paramConversions.add(conversion);
                }
            }
            int n = i = OCResolveOverloadsUtil.needsPseudoParamAdded(oCFunctionSymbol, operatorPlacement, context) ? 1 : 0;
            while (i < arguments.getCount()) {
                ProgressManager.checkCanceled();
                OCType declType = i >= paramTypes.size() ? OCEllipsisType.instance() : paramTypes.get(i).resolve(context);
                OCType actualType = arguments.getTypes().get(i);
                if (!(declType instanceof OCAutoType)) {
                    List<OCType> parameterTypes;
                    if (OCTypeUtils.isUnresolvedLambdaAutoType(actualType) && declType.getTerminalType() instanceof OCFunctionType && ((actualType = OCTypeUtils.resolveLambdaAutoType(actualType, context, new OCArgumentsList(parameterTypes = ((OCFunctionType)declType.getTerminalType()).getParameterTypes(), null), true)) == null || actualType == OCUnknownType.INSTANCE)) continue block0;
                    if (declType instanceof OCVariadicType && actualType instanceof OCVariadicType) {
                        declType = ((OCVariadicType)declType).getUnderlyingType();
                        actualType = ((OCVariadicType)actualType).getUnderlyingType();
                    }
                    boolean over_best_ics_4_5 = isListInitialization && i == 0 && OCResolveOverloadsUtil.isCopyOrMoveConstructorOrOperator(oCFunctionSymbol, context);
                    OCTypeOwner argExpression = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(i) : null;
                    ImplicitConversionSequence conversion = Conversions.calculateConversion(argExpression, actualType, declType, allowUserConversions && !over_best_ics_4_5, true, false, false, context);
                    paramConversions.add(conversion);
                    if (conversion.isBad()) continue block0;
                }
                ++i;
            }
            if (("operator++".equals(oCFunctionSymbol.getName()) || "operator--".equals(oCFunctionSymbol.getName())) && (operatorPlacement == OCOperatorReference.OperatorPlacement.POSTFIX && paramTypes.size() == arguments.getCount() || operatorPlacement == OCOperatorReference.OperatorPlacement.PREFIX && paramTypes.size() == arguments.getCount() + 1)) continue;
            viable.add(new Overload(oCFunctionSymbol, paramConversions));
        }
        Overload bestViable = null;
        for (Overload overload : viable) {
            hasMagic |= overload.myHasMagic;
            if (bestViable != null && !overload.myHasMagic && !OCResolveOverloadsUtil.isBetterOverload(overload, bestViable, arguments.getCount(), context)) continue;
            bestViable = overload;
        }
        if (bestViable == null) {
            return OCResolveOverloadsUtil.groupAmbiguousFunctions(filtered, context, filterAmbigs && !hasMagic, OCFunctionGroupSymbol.Cause.NoViable, null);
        }
        ArrayList<OCFunctionSymbol> arrayList = new ArrayList<OCFunctionSymbol>();
        for (Overload overload : viable) {
            ProgressManager.checkCanceled();
            if (overload != bestViable && !bestViable.myHasMagic && !overload.myHasMagic && OCResolveOverloadsUtil.isBetterOverload(bestViable, overload, arguments.getCount(), context)) continue;
            arrayList.add(overload.mySymbol);
            if (!(overload.mySymbol instanceof OCSymbolWithSubstitution) || !OCResolveUtil.hasNonResolvedTemplateParameters(overload.mySymbol, context)) continue;
            hasMagic = true;
        }
        if (arrayList.size() > 1) {
            return OCResolveOverloadsUtil.groupAmbiguousFunctions(arrayList, context, filterAmbigs && !hasMagic, hasMagic ? OCFunctionGroupSymbol.Cause.Magic : OCFunctionGroupSymbol.Cause.Ambiguous, null);
        }
        return bestViable.mySymbol;
    }

    private static boolean isBetterOverload(@NotNull Overload overload1, @NotNull Overload overload2, int argCount, @NotNull OCResolveContext context) {
        OCTemplateSymbol BetterTemplate;
        boolean Cand2IsSpecialization;
        if (overload1 == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(9);
        }
        if (overload2 == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(10);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(11);
        }
        OCFunctionSymbol Cand1 = overload1.mySymbol;
        OCFunctionSymbol Cand2 = overload2.mySymbol;
        boolean HasBetterConversion = false;
        int arg1Index = 0;
        int arg2Index = 0;
        if (overload1.myConversionSequences.size() == overload2.myConversionSequences.size() + 1) {
            arg1Index = 1;
        } else if (overload1.myConversionSequences.size() + 1 == overload2.myConversionSequences.size()) {
            arg2Index = 1;
        } else assert (overload1.myConversionSequences.size() == overload2.myConversionSequences.size()) : "Incorrect num of conversions";
        while (arg1Index < overload1.myConversionSequences.size()) {
            switch (Conversions.CompareImplicitConversionSequences(overload1.myConversionSequences.get(arg1Index), overload2.myConversionSequences.get(arg2Index), context)) {
                case Better: {
                    HasBetterConversion = true;
                    break;
                }
                case Worse: {
                    return false;
                }
            }
            ++arg1Index;
            ++arg2Index;
        }
        if (HasBetterConversion) {
            return true;
        }
        boolean Cand1IsSpecialization = Cand1.isTemplateSymbol();
        if (Cand1IsSpecialization != (Cand2IsSpecialization = Cand2.isTemplateSymbol())) {
            return Cand2IsSpecialization;
        }
        if (Cand1IsSpecialization && Cand2IsSpecialization && (BetterTemplate = TemplatesUtils.getMoreSpecializedTemplate(Cand1, Cand2, argCount, context)) != null) {
            return BetterTemplate == Cand1;
        }
        return false;
    }

    @NotNull
    public static List<OCType> getParameterTypes(@NotNull OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context, @Nullable CVQualifiers cvQualifiers) {
        if (function == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(12);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(13);
        }
        List<OCType> paramTypes = OCArgumentsList.expandVariadicTypes(function.getType().getParameterTypes(), context);
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, operatorPlacement, context)) {
            ArrayList<OCType> newParamTypes = new ArrayList<OCType>(paramTypes.size() + 1);
            OCStructType objectType = ((OCStructSymbol)function.getResolvedOwner(context, false)).getType();
            cvQualifiers = cvQualifiers == null ? function.getType().getCVQualifiers() : cvQualifiers.or(function.getType().getCVQualifiers());
            boolean isRValue = function.getType().isRValueRef();
            if (cvQualifiers != objectType.getCVQualifiers()) {
                objectType = (OCStructType)objectType.cloneWithAddedCVQualifiers(cvQualifiers, context.getProject());
            }
            newParamTypes.add(OCCppReferenceType.to(objectType, isRValue, cvQualifiers.isConst(), cvQualifiers.isVolatile()));
            newParamTypes.addAll(paramTypes);
            paramTypes = newParamTypes;
        }
        List<OCType> list = paramTypes;
        if (list == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean needsPseudoParamAdded(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(15);
        }
        return operatorPlacement != null && function.isCppMemberOperator(context);
    }

    private static int getNonInitializedParametersCount(OCFunctionSymbol function, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(16);
        }
        int parametersCount = function.getNonInitializedParametersCount(context);
        if (OCResolveOverloadsUtil.needsPseudoParamAdded(function, operatorPlacement, context)) {
            ++parametersCount;
        }
        return parametersCount;
    }

    /*
     * WARNING - void declaration
     */
    private static OCFunctionSymbol groupAmbiguousFunctions(List<OCFunctionSymbol> symbols, @NotNull OCResolveContext context, boolean disallowGroup, OCFunctionGroupSymbol.Cause cause, @Nullable Collection<OCSymbol> nonDeduced) {
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(17);
        }
        symbols.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
        ArrayList<FuncDescriptor> allFunctions = new ArrayList<FuncDescriptor>(symbols.size());
        for (OCFunctionSymbol oCFunctionSymbol : symbols) {
            OCQualifiedName qn = oCFunctionSymbol.getResolvedQualifiedName(false, context, true, true, true, true, false);
            allFunctions.add(new FuncDescriptor(oCFunctionSymbol, (OCFunctionType)oCFunctionSymbol.getType().resolve(context), qn, context));
        }
        ArrayList<Object> differentFunctions = new ArrayList<Object>(allFunctions.size());
        if (allFunctions.size() < 6) {
            for (FuncDescriptor newFunc : allFunctions) {
                boolean distinguishable = true;
                for (FuncDescriptor existingFunc : differentFunctions) {
                    if (!newFunc.isUndistinguishable(existingFunc)) continue;
                    distinguishable = false;
                    break;
                }
                if (!distinguishable) continue;
                differentFunctions.add(newFunc);
            }
        } else {
            void var7_10;
            Object var7_9 = null;
            boolean allUndistinguishable = true;
            for (FuncDescriptor function : allFunctions) {
                if (var7_10 == null) {
                    FuncDescriptor funcDescriptor = function;
                    continue;
                }
                if (var7_10.isUndistinguishable(function)) continue;
                allUndistinguishable = false;
                break;
            }
            if (allUndistinguishable) {
                differentFunctions.add(var7_10);
            } else {
                differentFunctions.addAll(allFunctions);
            }
        }
        Object var7_13 = null;
        for (FuncDescriptor desc : differentFunctions) {
            void var7_14;
            OCType returnType = desc.symbol.getType().getReturnType().resolve(context);
            if (var7_14 == null) {
                OCType oCType = returnType;
                continue;
            }
            if (new OCTypeEqualityVisitor((OCType)var7_14, true, false, context).equal(returnType)) continue;
            Object var7_16 = null;
            break;
        }
        if (differentFunctions.size() == 1 && cause != OCFunctionGroupSymbol.Cause.NoViable) {
            return ((FuncDescriptor)differentFunctions.get((int)0)).symbol;
        }
        if (!differentFunctions.isEmpty()) {
            void var7_17;
            return disallowGroup ? null : new OCFunctionGroupSymbol(differentFunctions.stream().map(d -> d.symbol).collect(Collectors.toList()), (OCType)var7_17, cause, nonDeduced, context.getProject());
        }
        return null;
    }

    @Nullable
    private static OCFunctionSymbol findStdInitListCtor(Collection<OCSymbol> cases, @NotNull OCArgumentsList<?> arguments, Collection<OCSymbol> allCandidates, @Nullable OCResolveContext context) {
        if (arguments == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(18);
        }
        for (OCSymbol symbol : cases) {
            OCType stdInitListParameter;
            OCFunctionSymbol function;
            if (!(symbol instanceof OCFunctionSymbol) || !(function = (OCFunctionSymbol)symbol).isCppConstructor() || function.getNonInitializedParametersCount(context) != 1) continue;
            OCType paramType = function.getParameterSymbols().get(0).getType().resolve(context);
            if (paramType instanceof OCCppReferenceType) {
                paramType = ((OCCppReferenceType)paramType).getRefType();
            }
            if (!(paramType instanceof OCStructType) || (stdInitListParameter = OCCodeInsightUtil.getStdInitializerListTemplateParameter(paramType, context.getFile())) == null) continue;
            allCandidates.add(function);
            boolean isCompatible = true;
            for (int i = 0; i < arguments.getExprs().size(); ++i) {
                OCTypeOwner expr = (OCTypeOwner)arguments.getExprs().get(i);
                OCType type = arguments.getTypes().get(i);
                isCompatible &= stdInitListParameter.checkCompatible(type, expr, context.getElement(), true, context).getState() == OCTypeCheckState.OK;
            }
            if (!isCompatible) continue;
            return function;
        }
        return null;
    }

    private static <E extends OCTypeOwner> ResolveTemplateSpecializationsResult resolveTemplateSpecializations(@NotNull Collection<OCSymbol> symbols, @NotNull OCArgumentsList<E> arguments, @Nullable CVQualifiers cvQualifiers, @Nullable OCOperatorReference.OperatorPlacement operatorPlacement, @NotNull OCResolveContext context) {
        if (symbols == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(19);
        }
        if (arguments == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(20);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(21);
        }
        ArrayList<OCFunctionSymbol> unified = new ArrayList<OCFunctionSymbol>();
        ArrayList<OCFunctionSymbol> allSymbols = new ArrayList<OCFunctionSymbol>();
        Ref hasBadArguments = Ref.create((Object)Boolean.FALSE);
        Ref hasMagicArguments = Ref.create((Object)Boolean.FALSE);
        int argumentsCount = arguments.getCount();
        OCStructSymbol structSymbol = null;
        boolean hasCopyOrMoveConstructor = false;
        for (OCSymbol symbol : symbols) {
            ProgressManager.checkCanceled();
            Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
            HashSet<OCTypeParameterSymbol> dependentTypes = new HashSet<OCTypeParameterSymbol>();
            if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                if (function.isTemplateSymbol() && function.isExtern()) continue;
                if (function.isCppConstructor() && OCResolveOverloadsUtil.isCopyOrMoveConstructorOrOperator(function, context)) {
                    hasCopyOrMoveConstructor = true;
                }
                List<OCType> parameterTypes = OCResolveOverloadsUtil.getParameterTypes(function, operatorPlacement, context, cvQualifiers);
                int paramsCount = OCTypeUtils.getNonVariadicParametersCount(parameterTypes);
                if ((OCResolveOverloadsUtil.getNonInitializedParametersCount(function, operatorPlacement, context) <= argumentsCount || arguments.hasNonExpandedVariadics()) && (argumentsCount <= paramsCount || function.isVararg())) {
                    boolean isUnified = OCFunctionArgumentsProcessor.processArguments(parameterTypes, null, arguments, context, (paramType, parameterSymbol, argumentType, argument, isVariadic) -> {
                        if (context == null) {
                            OCResolveOverloadsUtil.$$$reportNull$$$0(27);
                        }
                        if (paramType instanceof OCPointerType && argumentType instanceof OCIntType && OCExpressionEvaluator.isNullCompatible(OCExpressionEvaluator.evaluate(argument, context))) {
                            return true;
                        }
                        if (argumentType.isUnresolved(context)) {
                            hasBadArguments.set((Object)Boolean.TRUE);
                            return false;
                        }
                        if (argumentType instanceof OCMagicType) {
                            hasMagicArguments.set((Object)Boolean.TRUE);
                        }
                        if (paramType instanceof OCTypeParameterType) {
                            argumentType = OCTypeUtils.decayType(argumentType, context.getProject());
                        }
                        return paramType instanceof OCEllipsisType || OCSimpleTypeSubstitution.unifyByFunctionArgument(function, paramType, argumentType, argument, substitutionMap, dependentTypes, isVariadic, context) != OCTypeUnificationVisitor.NOT_UNIFIED;
                    });
                    OCResolveOverloadsUtil.addDefaultSubstitutions(function, substitutionMap);
                    OCSimpleTypeSubstitution substitution = OCSimpleTypeSubstitution.create(substitutionMap);
                    if (isUnified && !((Boolean)hasMagicArguments.get()).booleanValue() && OCResolveOverloadsUtil.isPrunedBySFINAE(function, substitution, dependentTypes, context)) {
                        isUnified = false;
                    }
                    OCFunctionSymbol substituted = substitution.substitute(function, context);
                    allSymbols.add(substituted);
                    if (!isUnified) continue;
                    unified.add(substituted);
                    continue;
                }
                allSymbols.add(function);
                continue;
            }
            if (symbol instanceof OCStructSymbol) {
                if (((OCStructSymbol)symbol).isPredefinition()) continue;
                structSymbol = (OCStructSymbol)symbol;
                continue;
            }
            OCLog.LOG.error("Non-function and non-struct symbol: " + symbol.getName());
        }
        OCResolveOverloadsUtil.addCompilerGeneratedFunctions(arguments, structSymbol, hasCopyOrMoveConstructor, unified, allSymbols, context);
        return new ResolveTemplateSpecializationsResult(unified, allSymbols, (Boolean)hasBadArguments.get());
    }

    private static <E extends OCTypeOwner> void addCompilerGeneratedFunctions(@NotNull OCArgumentsList<E> arguments, OCStructSymbol structSymbol, boolean hasCopyOrMoveConstructor, List<OCFunctionSymbol> unified, List<OCFunctionSymbol> allSymbols, @NotNull OCResolveContext context) {
        if (arguments == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(22);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(23);
        }
        if (structSymbol != null && !structSymbol.isPredefinition()) {
            Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
            HashSet<OCTypeParameterSymbol> dependentTypes = new HashSet<OCTypeParameterSymbol>();
            if (!hasCopyOrMoveConstructor && arguments.getCount() == 1) {
                OCType argumentType = arguments.getTypes().get(0);
                OCTypeOwner argumentExpr = arguments.getExprs() != null ? (OCTypeOwner)arguments.getExprs().get(0) : null;
                OCTypeUnificationVisitor.UnificationResult unifyResult = OCSimpleTypeSubstitution.unifyByFunctionArgument(null, structSymbol.getType(), argumentType, argumentExpr, substitutionMap, dependentTypes, false, context);
                OCStructSymbol substitutedStruct = OCSimpleTypeSubstitution.create(substitutionMap).substitute(structSymbol, context);
                OCCompilerGeneratedConstructorSymbol copyCtor = new OCCompilerGeneratedConstructorSymbol(substitutedStruct, OCCompilerGeneratedConstructorSymbol.Kind.CopyCtor, context.getProject());
                OCCompilerGeneratedConstructorSymbol moveCtor = new OCCompilerGeneratedConstructorSymbol(substitutedStruct, OCCompilerGeneratedConstructorSymbol.Kind.MoveCtor, context.getProject());
                allSymbols.add(copyCtor);
                allSymbols.add(moveCtor);
                if (unifyResult != OCTypeUnificationVisitor.NOT_UNIFIED) {
                    unified.add(copyCtor);
                    unified.add(moveCtor);
                }
            } else if (arguments.getCount() == 0 && !structSymbol.hasDeclaredConstructor(context)) {
                OCCompilerGeneratedConstructorSymbol defaultCtor = new OCCompilerGeneratedConstructorSymbol(structSymbol, OCCompilerGeneratedConstructorSymbol.Kind.DefaultCtor, context.getProject());
                unified.add(defaultCtor);
                allSymbols.add(defaultCtor);
            }
        }
    }

    public static boolean isCopyOrMoveConstructorOrOperator(@NotNull OCFunctionSymbol function, @NotNull OCResolveContext context) {
        OCType param;
        if (function == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(24);
        }
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(25);
        }
        if (function.isTemplateSymbol()) {
            return false;
        }
        List<OCType> parameterTypes = function.getType().getParameterTypes();
        OCSymbolWithQualifiedName parent = function.getParent();
        if (parent != null && function.getNonInitializedParametersCount(context) == 1 && (param = parameterTypes.get(0).resolve(context)) instanceof OCCppReferenceType) {
            OCType arg = parent.getType().resolve(context);
            OCType referencedParam = ((OCCppReferenceType)param).getRefType();
            if (TypeProperties.hasSameUnqualifiedType(referencedParam, arg, context)) {
                return true;
            }
        }
        return false;
    }

    private static void addDefaultSubstitutions(OCFunctionSymbol function, Map<OCTypeParameterSymbol, OCTypeArgument> map2) {
        for (OCTypeParameterSymbol parameter : function.getTemplateParameters()) {
            if (parameter.getDefaultValue() == null || map2.containsKey(parameter)) continue;
            map2.put(parameter, (OCTypeArgument)parameter.getDefaultValue());
        }
    }

    private static <T> boolean containsAny(Set<T> set, Collection<T> collection) {
        for (T element : collection) {
            if (!set.contains(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPrunedBySFINAE(OCFunctionSymbol function, OCSimpleTypeSubstitution substitution, Set<OCTypeParameterSymbol> dependentTypes, @NotNull OCResolveContext context) {
        if (context == null) {
            OCResolveOverloadsUtil.$$$reportNull$$$0(26);
        }
        context = context.substituteFirst(substitution);
        context = context.useFor(function);
        boolean oldSfinaeFlag = OCResolveContext.setInSFINAEFlag(context, true);
        try {
            for (OCDeclaratorSymbol parameter : function.getParameterSymbols(context)) {
                OCType paramType = parameter.getType().resolve(context);
                if (!paramType.isUnresolved(context)) continue;
                boolean bl = true;
                return bl;
            }
            OCType returnType = function.getEffectiveType().resolve(context);
            if (returnType.isUnresolved(context)) {
                boolean bl = true;
                return bl;
            }
            for (OCTypeParameterSymbol parameter : function.getTemplateParameters()) {
                OCType type;
                Object defaultValue = parameter.getDefaultValue();
                if (defaultValue == null && !dependentTypes.contains(parameter) && !parameter.isVariadic() && function.getSubstitution().getSubstitutionFor(parameter) == null && substitution.getSubstitutionFor(parameter) == null) {
                    boolean bl = true;
                    return bl;
                }
                if (parameter instanceof OCTypeParameterValueSymbol && (type = ((OCTypeParameterValueSymbol)parameter).getType().resolve(context)).isUnresolved(context)) {
                    boolean bl = true;
                    return bl;
                }
                if (!(defaultValue instanceof OCType) || !(type = ((OCType)defaultValue).resolve(context)).isUnresolved(context) || OCResolveOverloadsUtil.containsAny(dependentTypes, context.getTypeDependencies(type))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            OCResolveContext.setInSFINAEFlag(context, oldSfinaeFlag);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cases";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overload1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overload2";
                break;
            }
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorOverloads";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorOverloads";
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasUnevaluatedSubstitutions";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveOverloads";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBetterOverload";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "needsPseudoParamAdded";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNonInitializedParametersCount";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "groupAmbiguousFunctions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findStdInitListCtor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveTemplateSpecializations";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addCompilerGeneratedFunctions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isCopyOrMoveConstructorOrOperator";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPrunedBySFINAE";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveTemplateSpecializations$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FuncDescriptor {
        @NotNull
        public final OCFunctionSymbol symbol;
        @NotNull
        private final OCFunctionType myResolvedType;
        @Nullable
        private final OCQualifiedName myName;
        @NotNull
        private final OCTypeEqualityAfterResolvingVisitor myVisitor;

        public FuncDescriptor(@NotNull OCFunctionSymbol symbol, @NotNull OCFunctionType type, @Nullable OCQualifiedName name2, @NotNull OCResolveContext context) {
            if (symbol == null) {
                FuncDescriptor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                FuncDescriptor.$$$reportNull$$$0(1);
            }
            if (context == null) {
                FuncDescriptor.$$$reportNull$$$0(2);
            }
            this.symbol = symbol;
            this.myResolvedType = type;
            this.myName = name2;
            this.myVisitor = new OCTypeEqualityAfterResolvingVisitor(this.myResolvedType, false, context);
        }

        public boolean isUndistinguishable(@NotNull FuncDescriptor other) {
            if (other == null) {
                FuncDescriptor.$$$reportNull$$$0(3);
            }
            return (this.symbol.isFriend() || other.symbol.isFriend() || Objects.equals(this.myName, other.myName)) && this.myVisitor.isFunctionSignatureEqual(other.myResolvedType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$FuncDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isUndistinguishable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Overload {
        @NotNull
        final OCFunctionSymbol mySymbol;
        @NotNull
        final List<ImplicitConversionSequence> myConversionSequences;
        final boolean myHasMagic;

        public Overload(@NotNull OCFunctionSymbol symbol, @NotNull List<ImplicitConversionSequence> paramConversions) {
            if (symbol == null) {
                Overload.$$$reportNull$$$0(0);
            }
            if (paramConversions == null) {
                Overload.$$$reportNull$$$0(1);
            }
            this.mySymbol = symbol;
            this.myConversionSequences = paramConversions;
            this.myHasMagic = symbol.getKind().isTemplateParameter() || paramConversions.stream().anyMatch(c -> c.hasMagic()) || OCResolveOverloadsUtil.hasUnevaluatedSubstitutions(symbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "paramConversions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/resolve/OCResolveOverloadsUtil$Overload";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

