/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.resolve.references.CompositeResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompositeResourceReference
implements OCResourceReference {
    private static final Function<OCResourceReference, PsiElement> ELEMENT = reference -> reference.getElement();
    private static final Function<OCResourceReference, Class> CLASS = reference -> reference.getClass();
    private final List<OCResourceReference> myReferences;

    public OCCompositeResourceReference(List<OCResourceReference> references) {
        CompositeResourceCompletionProvider.assertSameValue(references, CLASS);
        CompositeResourceCompletionProvider.assertSameValue(references, ELEMENT);
        this.myReferences = references;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(boolean includeQuotes) {
        ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        HashSet<String> alreadyProposedNames = new HashSet<String>();
        HashSet<PsiElement> alreadyProposedElements = new HashSet<PsiElement>();
        for (OCResourceReference reference : this.myReferences) {
            for (LookupElement element : reference.getLookupElements(includeQuotes)) {
                PsiElement psiElement;
                if (!alreadyProposedNames.add(element.getLookupString()) || (psiElement = element.getPsiElement()) != null && !alreadyProposedElements.add(psiElement)) continue;
                result.add(element);
            }
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement resolve() {
        Pair<PsiElement, ? extends PsiReference> result = this.resolveInner();
        return result == null ? null : (PsiElement)result.first;
    }

    private Pair<PsiElement, ? extends PsiReference> resolveInner() {
        for (OCResourceReference reference : this.myReferences) {
            PsiElement element = reference.resolve();
            if (element == null) continue;
            return Pair.create((Object)element, (Object)reference);
        }
        return null;
    }

    public PsiElement getElement() {
        return this.getRepresentative().getElement();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        return resolve == null ? null : ((PsiReference)resolve.second).handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(1);
        }
        return this.getRepresentative().bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        for (OCResourceReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        for (OCResourceReference reference : this.myReferences) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public TextRange getRangeInElement() {
        return this.getRepresentative().getRangeInElement();
    }

    @NotNull
    public String getCanonicalText() {
        Pair<PsiElement, ? extends PsiReference> resolve = this.resolveInner();
        String string = resolve == null ? this.getRepresentative().getCanonicalText() : ((PsiReference)resolve.second).getCanonicalText();
        if (string == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public PsiReference getRepresentative() {
        PsiReference psiReference = this.myReferences.get(0);
        if (psiReference == null) {
            OCCompositeResourceReference.$$$reportNull$$$0(4);
        }
        return psiReference;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCCompositeResourceReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentative";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

