/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCGroupedFileNaming;
import com.jetbrains.cidr.lang.OCGroupedFileNamings;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.resolve.references.OCResourceFilesProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.resolve.references.PsiCachingReferenceBase;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileResourceReference
extends PsiCachingReferenceBase<PsiElement>
implements OCResourceReference {
    @Nullable
    private Set<String> myExtensions;
    private boolean myExtensionInLiteral;
    private final boolean myIsDirectory;

    public OCFileResourceReference(PsiElement literal, @Nullable Set<String> extensions, boolean extensionInLiteral, boolean isDirectory) {
        super(literal, false);
        this.myExtensions = extensions;
        this.myExtensionInLiteral = extensionInLiteral;
        this.myIsDirectory = isDirectory;
        assert (!this.myExtensionInLiteral || this.myExtensions != null);
    }

    @Override
    public PsiElement resolveInner() {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processResources(this.getText(), (Processor<VirtualFile>)finder);
        VirtualFile result = (VirtualFile)finder.getFoundValue();
        if (result != null && result.isValid()) {
            return this.findPsiElement(result);
        }
        return null;
    }

    @NotNull
    private String getText() {
        if (this.myElement instanceof OCLiteralExpression) {
            String string = ((OCLiteralExpression)this.getElement()).getUnescapedLiteralText();
            if (string == null) {
                OCFileResourceReference.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = StringUtil.unquoteString((String)this.getElement().getText());
        if (string == null) {
            OCFileResourceReference.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.getText();
        if (!this.myExtensionInLiteral && this.myExtensions != null && this.myExtensions.size() == 1) {
            text = text + "." + this.myExtensions.iterator().next();
        }
        String string = text;
        if (string == null) {
            OCFileResourceReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public TextRange getRangeInElement() {
        if (OCElementUtil.getElementType(this.myElement) == OCTokenTypes.STRING_LITERAL) {
            return new TextRange(1, this.myElement.getTextLength() - 1);
        }
        return super.getRangeInElement();
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            OCFileResourceReference.$$$reportNull$$$0(3);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public List<LookupElement> getLookupElements(boolean includeQuotes) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        HashSet processed = new HashSet();
        this.processResources(null, (PairProcessor<String, VirtualFile>)((PairProcessor)(path, virtualFile) -> {
            String withoutLocalization;
            OCGroupedFileNaming groupedNaming = OCGroupedFileNamings.getGroupedFileNaming(virtualFile);
            if (groupedNaming != null) {
                path = groupedNaming.getBaseName((String)path);
            }
            if ((withoutLocalization = OCResourceFilesProvider.withoutLocalization(path)) != null) {
                path = withoutLocalization;
            }
            if (!processed.add(path)) {
                return true;
            }
            if (!this.myExtensionInLiteral) {
                path = FileUtilRt.getNameWithoutExtension((String)path);
            }
            String text = includeQuotes ? "@\"" + path + "\"" : path;
            Icon fileIcon = virtualFile.getFileType().getIcon();
            PsiElement psiElement = this.findPsiElement((VirtualFile)virtualFile);
            LookupElementBuilder builder = FileInfoManager.getFileLookupItem((PsiElement)psiElement, (String)text, (Icon)(fileIcon == null ? AllIcons.FileTypes.Any_type : fileIcon));
            variants.add(OCCompletionPriority.elementWithPriority((LookupElement)builder, OCCompletionPriority.HIGHEST_PRIORITY));
            return true;
        }));
        ArrayList<LookupElement> arrayList = variants;
        if (arrayList == null) {
            OCFileResourceReference.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private PsiElement findPsiElement(VirtualFile virtualFile) {
        PsiManager manager = this.myElement.getManager();
        return virtualFile.isDirectory() ? manager.findDirectory(virtualFile) : manager.findFile(virtualFile);
    }

    private void processResources(@Nullable String fileName, Processor<VirtualFile> processor2) {
        this.processResources(fileName, (PairProcessor<String, VirtualFile>)((PairProcessor)(path, file) -> processor2.process(file)));
    }

    private void processResources(@Nullable String fileName, PairProcessor<String, VirtualFile> processor2) {
        for (Map.Entry<String, VirtualFile> entry : OCResourceFilesProvider.getAccessibleResources(this.myElement).entrySet()) {
            String entryExtension;
            if (this.myIsDirectory != entry.getValue().isDirectory() || !this.isMatchingExtension(entryExtension = FileUtilRt.getExtension((String)entry.getKey())) || fileName != null && !this.resourceMatchesEntry(fileName, entry) || processor2.process((Object)entry.getKey(), (Object)entry.getValue())) continue;
            return;
        }
    }

    private boolean resourceMatchesEntry(@NotNull String fileName, Map.Entry<String, VirtualFile> entry) {
        if (fileName == null) {
            OCFileResourceReference.$$$reportNull$$$0(5);
        }
        String entryName = entry.getKey();
        if (!this.myExtensionInLiteral) {
            entryName = FileUtilRt.getNameWithoutExtension((String)entryName);
        }
        if (fileName.equals(entryName)) {
            return true;
        }
        OCGroupedFileNaming groupedNaming = OCGroupedFileNamings.getGroupedFileNaming(entry.getValue());
        if (groupedNaming != null && fileName.equals(entryName = groupedNaming.getBaseName(entryName))) {
            return true;
        }
        return fileName.equals(OCResourceFilesProvider.withoutLocalization(entryName));
    }

    private boolean isMatchingExtension(@NonNls @NotNull String extension) {
        if (extension == null) {
            OCFileResourceReference.$$$reportNull$$$0(6);
        }
        return this.myExtensions == null || this.myExtensions.contains(extension.toLowerCase());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(this.myExtensionInLiteral ? newElementName : FileUtil.getNameWithoutExtension((String)newElementName));
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            OCFileResourceReference.$$$reportNull$$$0(7);
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCFileResourceReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCFileResourceReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resourceMatchesEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

