/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCResourceCompletionProvider
extends PsiReferenceProvider {
    private String myClassName;
    private String myArgumentSelector;

    public OCResourceCompletionProvider(String className, String argumentSelector) {
        this.myClassName = className;
        this.myArgumentSelector = argumentSelector;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getArgumentSelector() {
        return this.myArgumentSelector;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        OCResourceReference reference;
        OCMacroCall macroCall;
        PsiElement parent;
        if (element == null) {
            OCResourceCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCResourceCompletionProvider.$$$reportNull$$$0(1);
        }
        if ((parent = PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{OCParenthesizedExpression.class, OCExpressionStatement.class, OCDeclaration.class, OCDeclarationStatement.class})) instanceof OCMacroCallArgument && (macroCall = (OCMacroCall)parent.getParent()).getArguments().get(0) == parent) {
            PsiReference[] psiReferenceArray;
            OCResourceReference reference2 = this.getReferenceByCall(macroCall, null);
            if (reference2 != null) {
                PsiReference[] psiReferenceArray2 = new PsiReference[1];
                psiReferenceArray = psiReferenceArray2;
                psiReferenceArray2[0] = reference2;
            } else {
                psiReferenceArray = PsiReference.EMPTY_ARRAY;
            }
            if (psiReferenceArray == null) {
                OCResourceCompletionProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        if (!(parent instanceof OCMessageArgument && element instanceof OCExpression && ((OCMessageArgument)parent).getArgumentSelector().getSelectorName().equals(this.myArgumentSelector))) {
            if (PsiReference.EMPTY_ARRAY == null) {
                OCResourceCompletionProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        OCType declaringClass = OCReferenceType.resolvedFromText(this.myClassName, element);
        if (!(declaringClass instanceof OCObjectType)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                OCResourceCompletionProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        OCObjectTypeContext receiverContext = ((OCSendMessageExpression)parent.getParent()).getReceiverContext();
        if (receiverContext == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                OCResourceCompletionProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        OCObjectType receiverType = receiverContext.getType();
        if ((receiverType.getName().equals("id") || receiverType.getName().equals("NSObject") || ((OCObjectType)declaringClass).isAncestorOf(receiverType)) && (reference = this.createReference((OCExpression)element, null)) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                OCResourceCompletionProvider.$$$reportNull$$$0(6);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            OCResourceCompletionProvider.$$$reportNull$$$0(7);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public OCResourceReference getReferenceByCall(PsiElement element, @Nullable PsiElement referenceElement) {
        OCReferenceElement macroRef;
        if (element instanceof OCMacroCall && (macroRef = ((OCMacroCall)element).getMacroReferenceElement()) != null && macroRef.getName().startsWith("NSLocalizedString") && (referenceElement == null || PsiTreeUtil.isAncestor((PsiElement)((OCMacroCall)element).getArguments().get(0), (PsiElement)referenceElement, (boolean)false))) {
            element = ((OCMacroCall)element).getExpansionExpression();
        }
        if (!(element instanceof OCSendMessageExpression)) {
            return null;
        }
        for (OCMessageArgument argument : ((OCSendMessageExpression)element).getArguments()) {
            if (!argument.getArgumentSelector().getSelectorName().equals(this.myArgumentSelector)) continue;
            OCExpression expression = OCParenthesesUtils.diveIntoParenthesesAndCasts(argument.getArgumentExpression());
            if (expression instanceof OCLiteralExpression || expression != null && expression.getTextWithMacros().equals("CIDR_RULE_ZZZ")) {
                return this.createReference(expression, referenceElement);
            }
            return null;
        }
        return null;
    }

    @Nullable
    protected abstract OCResourceReference createReference(OCExpression var1, @Nullable PsiElement var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCResourceCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCResourceCompletionProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

