/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCResourceFilesProvider {
    private static final ExtensionPointName<OCResourceFilesProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.resourceFilesProvider");

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        if (project2 == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(1);
        }
        TreeMap<String, VirtualFile> result = new TreeMap<String, VirtualFile>();
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            result.putAll(provider2.getAccessibleResourceFiles(project2, virtualFile));
        }
        TreeMap<String, VirtualFile> treeMap = result;
        if (treeMap == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(2);
        }
        return treeMap;
    }

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(3);
        }
        if ((file = OCResourceFilesProvider.getFileFromElement(element)) != null) {
            SortedMap<String, VirtualFile> sortedMap = OCResourceFilesProvider.getAccessibleResources(element.getProject(), file);
            if (sortedMap == null) {
                OCResourceFilesProvider.$$$reportNull$$$0(4);
            }
            return sortedMap;
        }
        SortedMap<String, VirtualFile> sortedMap = Collections.emptySortedMap();
        if (sortedMap == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(5);
        }
        return sortedMap;
    }

    public static boolean isAccessible(@NotNull Project project2, @Nullable VirtualFile from, @Nullable VirtualFile who) {
        if (project2 == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(6);
        }
        if (from == null) {
            return false;
        }
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            if (!provider2.isAccessibleInner(project2, from, who)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(@NotNull PsiElement element, @NotNull VirtualFile file) {
        if (element == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(8);
        }
        return OCResourceFilesProvider.isAccessible(element.getProject(), OCResourceFilesProvider.getFileFromElement(element), file);
    }

    @Nullable
    private static VirtualFile getFileFromElement(@NotNull PsiElement element) {
        VirtualFile elementFile;
        if (element == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(9);
        }
        if ((elementFile = element.getContainingFile().getVirtualFile()) == null) {
            elementFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        }
        return elementFile;
    }

    @NotNull
    protected abstract SortedMap<String, VirtualFile> getAccessibleResourceFiles(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isAccessibleInner(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable VirtualFile var3);

    @Nullable
    public static String withoutLocalization(String fileName) {
        String locationExtension = ".lproj" + File.separator;
        int extensionIndex = fileName.lastIndexOf(locationExtension);
        if (extensionIndex <= 0) {
            return null;
        }
        int separatorIndex = fileName.lastIndexOf(File.separator, extensionIndex - 1);
        if (separatorIndex == extensionIndex - 1) {
            return null;
        }
        return fileName.substring(0, separatorIndex + 1) + fileName.substring(extensionIndex + locationExtension.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCResourceFilesProvider";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCResourceFilesProvider";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleResources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleResources";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileFromElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

