/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references.kvc;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KVCUtil {
    static KVCMethod[] KVC_METHODS = new KVCMethod[]{new KVCMethod("valueForKey:", KVCType.KEY, 0), new KVCMethod("valueForKeyPath:", KVCType.KEY_PATH, 0), new KVCMethod("mutableArrayValueForKey:", KVCType.KEY, 0), new KVCMethod("mutableArrayValueForKeyPath:", KVCType.KEY_PATH, 0), new KVCMethod("mutableSetValueForKey:", KVCType.KEY, 0), new KVCMethod("mutableSetValueForKeyPath:", KVCType.KEY_PATH, 0), new KVCMethod("setValue:forKeyPath:", KVCType.KEY_PATH, 1), new KVCMethod("setNilValueForKey:", KVCType.KEY, 0), new KVCMethod("setValue:forKey:", KVCType.KEY, 1), new KVCMethod("addObserver:forKeyPath:options:context:", KVCType.KEY_PATH, 1), new KVCMethod("removeObserver:forKeyPath:", KVCType.KEY_PATH, 1), new KVCMethod("removeObserver:forKeyPath:context:", KVCType.KEY_PATH, 1), new KVCMethod("willChangeValueForKey:", KVCType.KEY, 0), new KVCMethod("didChangeValueForKey:", KVCType.KEY, 0), new KVCMethod("willChange:valuesAtIndexes:forKey:", KVCType.KEY, 2), new KVCMethod("didChange:valuesAtIndexes:forKey:", KVCType.KEY, 2), new KVCMethod("willChangeValueForKey:withSetMutation:usingObjects:", KVCType.KEY, 0), new KVCMethod("didChangeValueForKey:withSetMutation:usingObjects:", KVCType.KEY, 0)};
    private static final String[] EXCLUDED_CLASSES = new String[]{"NSDictionary", "NSArray", "NSUserDefaults", "NSManagedObject"};
    private static final String[] EXCLUDED_PAIRS = new String[]{"NSManagedObject", "timeStamp"};

    public static boolean isValidKeyForReferring(@NotNull String key) {
        if (key == null) {
            KVCUtil.$$$reportNull$$$0(0);
        }
        return !key.contains("@");
    }

    public static boolean isValidPairForReferring(@Nullable OCClassSymbol aClass, @NotNull String key, @NotNull OCFile context) {
        if (key == null) {
            KVCUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            KVCUtil.$$$reportNull$$$0(2);
        }
        if (!KVCUtil.isValidKeyForReferring(key)) {
            return false;
        }
        if (aClass == null) {
            return false;
        }
        if (aClass.getType().resolve(context).isPointerToID()) {
            return false;
        }
        if (KVCUtil.classIsKindOfClasses(EXCLUDED_CLASSES, aClass, context)) {
            return false;
        }
        for (int i = 0; i < EXCLUDED_PAIRS.length; i += 2) {
            String forbiddenClass = EXCLUDED_PAIRS[i];
            String forbiddenKey = EXCLUDED_PAIRS[i + 1];
            if (!forbiddenKey.equals(key) || KVCUtil.checkClassPair(aClass, forbiddenClass, context)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkClassPair(OCClassSymbol aClass, String forbiddenClass, @NotNull OCFile context) {
        if (context == null) {
            KVCUtil.$$$reportNull$$$0(3);
        }
        return !KVCUtil.classIsKindOfClasses(new String[]{forbiddenClass}, aClass, context);
    }

    @Nullable
    private static KVCMethod getKVCMethod(String selector, KVCType type) {
        for (KVCMethod kvcMethod : KVC_METHODS) {
            if (!kvcMethod.getMessageSelector().equals(selector) || kvcMethod.getType() != type) continue;
            return kvcMethod;
        }
        return null;
    }

    private KVCUtil() {
    }

    public static boolean isLiteralOnRightPlace(@NotNull OCLiteralExpression literal, @NotNull OCSendMessageExpression sendMessageExpression) {
        if (literal == null) {
            KVCUtil.$$$reportNull$$$0(4);
        }
        if (sendMessageExpression == null) {
            KVCUtil.$$$reportNull$$$0(5);
        }
        String selector = sendMessageExpression.getMessageSelector();
        int index = -1;
        for (KVCMethod kvcMethod : KVC_METHODS) {
            if (!kvcMethod.getMessageSelector().equals(selector)) continue;
            index = kvcMethod.getArgumentIndex();
            break;
        }
        int i = 0;
        for (OCMessageArgument argument : sendMessageExpression.getArguments()) {
            if (argument.getArgumentExpression() == literal && i == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean classIsKindOfClasses(String[] classes, OCClassSymbol classSymbol, @NotNull OCFile context) {
        OCType resolve;
        if (context == null) {
            KVCUtil.$$$reportNull$$$0(6);
        }
        return (resolve = classSymbol.getType().resolve(context)) instanceof OCObjectType && KVCUtil.findAncestorOfClass((OCObjectType)resolve, classes, context) != null;
    }

    @Nullable
    private static OCObjectType findAncestorOfClass(@NotNull OCObjectType decl, @NotNull String[] classes, @NotNull PsiElement context) {
        if (decl == null) {
            KVCUtil.$$$reportNull$$$0(7);
        }
        if (classes == null) {
            KVCUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            KVCUtil.$$$reportNull$$$0(9);
        }
        String name2 = decl.getName(context);
        for (String aClass : classes) {
            if (!aClass.equals(name2)) continue;
            return decl;
        }
        OCObjectType superType = decl.getSuperType();
        if (superType != null) {
            return KVCUtil.findAncestorOfClass(superType, classes, context);
        }
        return null;
    }

    public static boolean isKVCMethod(String messageSelector, KVCType type) {
        return KVCUtil.getKVCMethod(messageSelector, type) != null;
    }

    @Nullable
    public static OCClassSymbol getReceiverClass(OCType receiverType, @NotNull PsiElement context) {
        OCType refType;
        if (context == null) {
            KVCUtil.$$$reportNull$$$0(10);
        }
        if (receiverType instanceof OCPointerType && (refType = ((OCPointerType)receiverType).getRefType().resolve(context)) instanceof OCObjectType) {
            return ((OCObjectType)refType).getClassSymbol();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sendMessageExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/kvc/KVCUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidKeyForReferring";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPairForReferring";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassPair";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isLiteralOnRightPlace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "classIsKindOfClasses";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findAncestorOfClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getReceiverClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum KVCType {
        KEY,
        KEY_PATH;

    }

    private static class KVCMethod {
        private String myMessageSelector;
        private KVCType myType;
        private int myArgumentIndex;

        public String getMessageSelector() {
            return this.myMessageSelector;
        }

        public KVCType getType() {
            return this.myType;
        }

        public int getArgumentIndex() {
            return this.myArgumentIndex;
        }

        private KVCMethod(String messageSelector, KVCType type, int argumentIndex) {
            this.myMessageSelector = messageSelector;
            this.myType = type;
            this.myArgumentIndex = argumentIndex;
        }
    }
}

