/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.v2;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.v2.BadConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionKind;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionRank;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.StandardConversionSequence;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.resolve.v2.UserDefinedConversionSequence;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCValueCategoryHolder;
import com.jetbrains.cidr.lang.types.visitors.OCCompoundInitializerChecker;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Conversions {
    public static ImplicitConversionSequence calculateConversion(@Nullable OCTypeOwner argExpression, @NotNull OCType actualType, @NotNull OCType declType, boolean allowImplicitConversions, boolean inOverloadResolution, boolean allowObjCWritebackConversion, boolean allowExplicit, @NotNull OCResolveContext context) {
        OCType type;
        if (actualType == null) {
            Conversions.$$$reportNull$$$0(0);
        }
        if (declType == null) {
            Conversions.$$$reportNull$$$0(1);
        }
        if (context == null) {
            Conversions.$$$reportNull$$$0(2);
        }
        OCType originalActualType = actualType;
        if (actualType instanceof OCCppReferenceType) {
            actualType = ((OCCppReferenceType)actualType).getRefType();
        }
        if (declType instanceof OCFunctionType) {
            declType = OCPointerType.to(declType);
        }
        if ((type = actualType.getTerminalType()) instanceof OCMagicType || type instanceof OCStructType && ((OCStructType)type).hasSeveralSpecializations() || declType.getTerminalType() instanceof OCMagicType || type instanceof OCAutoType) {
            return ImplicitConversionSequence.magic();
        }
        if (declType instanceof OCEllipsisType) {
            ImplicitConversionSequence conversion = new ImplicitConversionSequence();
            conversion.setEllipsis();
            return conversion;
        }
        OCFunctionType declFunctionType = Conversions.getFunctionType(declType);
        OCFunctionType actualFunctionType = Conversions.getFunctionType(actualType);
        if (declFunctionType != null && actualFunctionType != null && actualFunctionType.isMagicInside(context)) {
            return ImplicitConversionSequence.magic();
        }
        return Conversions.TryCopyInitialization(argExpression, originalActualType, actualType, declType, !allowImplicitConversions, inOverloadResolution, allowObjCWritebackConversion, allowExplicit, context);
    }

    public static ImplicitConversionSequence TryCopyInitialization(@Nullable OCTypeOwner From, @Nullable OCType FromOriginalType, OCType FromType, OCType ToType, boolean SuppressUserConversions, boolean InOverloadResolution, boolean AllowObjCWritebackConversion, boolean AllowExplicit, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(3);
        }
        if (From instanceof OCCompoundInitializer) {
            return Conversions.TryListConversion((OCCompoundInitializer)From, ToType, SuppressUserConversions, InOverloadResolution, AllowObjCWritebackConversion, context);
        }
        if (ToType instanceof OCCppReferenceType) {
            return Conversions.TryReferenceInit(From, FromOriginalType, FromType, ToType, SuppressUserConversions, AllowExplicit, context);
        }
        return Conversions.TryImplicitConversion(From, FromOriginalType, FromType, ToType, SuppressUserConversions, false, InOverloadResolution, false, AllowObjCWritebackConversion, false, context);
    }

    private static ImplicitConversionSequence TryListConversion(OCCompoundInitializer From, OCType ToType, boolean SuppressUserConversions, boolean InOverloadResolution, boolean AllowObjCWritebackConversion, @NotNull OCResolveContext context) {
        OCType X;
        OCType InitType;
        if (context == null) {
            Conversions.$$$reportNull$$$0(4);
        }
        ImplicitConversionSequence Result2 = new ImplicitConversionSequence();
        Result2.setBad(BadConversionSequence.FailureKind.no_conversion, From, null, ToType);
        if (ToType.isUnknown()) {
            return Result2;
        }
        List<OCExpression> initializers = From.getInitializerExpressions();
        boolean isRecord = TypeProperties.isRecordType(ToType);
        if (initializers.size() == 1 && isRecord && (TypeProperties.hasSameUnqualifiedType(InitType = OCTypeUtils.getCppReferencedType(initializers.get(0).getResolvedType(context)), ToType, context) || TypeProperties.IsDerivedFrom(InitType, ToType, context))) {
            return Conversions.TryCopyInitialization(initializers.get(0), null, InitType, ToType, SuppressUserConversions, InOverloadResolution, AllowObjCWritebackConversion, false, context);
        }
        boolean toStdInitializerList = false;
        if (ToType instanceof OCArrayType) {
            X = ToType.getArrayElementType();
        } else {
            X = OCCodeInsightUtil.getStdInitializerListTemplateParameter(ToType, context.getFile());
            if (X != null) {
                toStdInitializerList = true;
            }
        }
        if (X != null) {
            for (OCExpression expr : initializers) {
                ImplicitConversionSequence ICS = Conversions.TryCopyInitialization(expr, null, OCTypeUtils.getCppReferencedType(expr.getResolvedType(context)), X, SuppressUserConversions, InOverloadResolution, AllowObjCWritebackConversion, false, context);
                if (ICS.isBad()) {
                    Result2 = ICS;
                    break;
                }
                if (!Result2.isBad() && Conversions.CompareImplicitConversionSequences(ICS, Result2, context) != ImplicitConversionSequence.CompareKind.Worse) continue;
                Result2 = ICS;
            }
            if (initializers.isEmpty()) {
                Result2.setStandard();
                Result2.Standard.setAsIdentityConversion();
                Result2.Standard.setFromType(ToType);
                Result2.Standard.setAllToTypes(ToType);
            }
            Result2.setStdInitializerListElement(toStdInitializerList);
            return Result2;
        }
        boolean isAggregate = TypeProperties.isAggregateType(ToType);
        if (isRecord && !isAggregate) {
            return Conversions.TryUserDefinedConversion(From, OCBracedInitListType.INSTANCE, ToType, SuppressUserConversions, false, InOverloadResolution, false, AllowObjCWritebackConversion, false, context);
        }
        if (isAggregate) {
            OCTypeCheckResult tcResult = OCCompoundInitializerChecker.checkCompoundInitializer(From, ToType, false, context);
            if (tcResult.getState().isOK()) {
                Result2.setUserDefined();
                Result2.UserDefined = new UserDefinedConversionSequence();
                Result2.UserDefined.Before = new StandardConversionSequence();
                Result2.UserDefined.After = new StandardConversionSequence();
            }
            return Result2;
        }
        if (ToType instanceof OCCppReferenceType) {
            Ref dummy;
            OCExpression Init;
            OCType initOriginalType;
            OCType T2;
            ReferenceCompareResult RefRelationship;
            OCType T1 = ((OCCppReferenceType)ToType).getRefType().resolve(context);
            if (initializers.size() == 1 && (RefRelationship = Conversions.CompareReferenceRelationship(T1, T2 = OCTypeUtils.getCppReferencedType(initOriginalType = (Init = initializers.get(0)).getResolvedType(context)), (Ref<Boolean>)(dummy = Ref.create()), (Ref<Boolean>)dummy, (Ref<Boolean>)dummy, context)).ordinal() >= ReferenceCompareResult.Ref_Related.ordinal()) {
                return Conversions.TryReferenceInit(Init, initOriginalType, T2, ToType, SuppressUserConversions, false, context);
            }
            Result2 = Conversions.TryListConversion(From, T1, SuppressUserConversions, InOverloadResolution, AllowObjCWritebackConversion, context);
            if (Result2.isFailure()) {
                return Result2;
            }
            if (((OCCppReferenceType)ToType).isRvalueRef() || T1.getCVQualifiers() == CVQualifiers.CONST) {
                StandardConversionSequence SCS = Result2.isStandard() ? Result2.Standard : Result2.UserDefined.After;
                SCS.ReferenceBinding = true;
                SCS.IsLvalueReference = !((OCCppReferenceType)ToType).isRvalueRef();
                SCS.BindsToRvalue = true;
                SCS.BindsToFunctionLvalue = false;
                SCS.BindsImplicitObjectArgumentWithoutRefQualifier = false;
                SCS.ObjCLifetimeConversionBinding = false;
            } else {
                Result2.setBad(BadConversionSequence.FailureKind.lvalue_ref_to_rvalue, null, ToType);
            }
            return Result2;
        }
        assert (!isRecord);
        if (initializers.size() == 1 && !(initializers.get(0) instanceof OCCompoundInitializer)) {
            OCExpression firstExpr = initializers.get(0);
            OCType exprType = firstExpr.getResolvedType(context);
            Result2 = Conversions.TryCopyInitialization(firstExpr, exprType, exprType, ToType, SuppressUserConversions, InOverloadResolution, AllowObjCWritebackConversion, false, context);
        } else if (initializers.isEmpty()) {
            Result2.setStandard();
            Result2.Standard.setAsIdentityConversion();
            Result2.Standard.setFromType(ToType);
            Result2.Standard.setAllToTypes(ToType);
        }
        return Result2;
    }

    private static ImplicitConversionSequence TryReferenceInit(@Nullable OCTypeOwner From, @Nullable OCType FromOriginalType, OCType FromType, OCType DeclType, boolean SuppressUserConversions, boolean AllowExplicit, @NotNull OCResolveContext context) {
        CVQualifiers T2Quals;
        CVQualifiers T1Quals;
        if (context == null) {
            Conversions.$$$reportNull$$$0(5);
        }
        assert (DeclType instanceof OCCppReferenceType) : "Reference init needs a reference";
        ImplicitConversionSequence ICS = new ImplicitConversionSequence();
        ICS.setBad(BadConversionSequence.FailureKind.no_conversion, FromType, DeclType);
        OCType T1 = ((OCCppReferenceType)DeclType).getRefType();
        OCType T2 = FromType;
        boolean isRValRef = ((OCCppReferenceType)DeclType).isRvalueRef();
        Ref DerivedToBase = Ref.create((Object)false);
        Ref ObjCConversion = Ref.create((Object)false);
        Ref ObjCLifetimeConversion = Ref.create((Object)false);
        OCExprValueCategory InitCategory = OCExprValueCategory.classify(From, FromOriginalType, context);
        ReferenceCompareResult RefRelationship = Conversions.CompareReferenceRelationship(T1, T2, (Ref<Boolean>)DerivedToBase, (Ref<Boolean>)ObjCConversion, (Ref<Boolean>)ObjCLifetimeConversion, context);
        if (!isRValRef) {
            ImplicitConversionSequence userDefined;
            if (InitCategory == OCExprValueCategory.LValue && RefRelationship.ordinal() >= ReferenceCompareResult.Ref_Compatible_With_Added_Qualification.ordinal()) {
                if (RefRelationship == ReferenceCompareResult.Ref_Magic) {
                    return ImplicitConversionSequence.magic();
                }
                ICS.setStandard();
                ICS.Standard.First = ImplicitConversionKind.ICK_Identity;
                ICS.Standard.Second = (Boolean)DerivedToBase.get() != false ? ImplicitConversionKind.ICK_Derived_To_Base : ((Boolean)ObjCConversion.get() != false ? ImplicitConversionKind.ICK_Compatible_Conversion : ImplicitConversionKind.ICK_Identity);
                ICS.Standard.Third = ImplicitConversionKind.ICK_Identity;
                ICS.Standard.FromTypePtr = T2;
                ICS.Standard.setToType(0, T2);
                ICS.Standard.setToType(1, T1);
                ICS.Standard.setToType(2, T1);
                ICS.Standard.ReferenceBinding = true;
                ICS.Standard.DirectBinding = true;
                ICS.Standard.IsLvalueReference = !isRValRef;
                ICS.Standard.BindsToFunctionLvalue = T2 instanceof OCFunctionType;
                ICS.Standard.BindsToRvalue = false;
                ICS.Standard.BindsImplicitObjectArgumentWithoutRefQualifier = false;
                ICS.Standard.ObjCLifetimeConversionBinding = (Boolean)ObjCLifetimeConversion.get();
                ICS.Standard.CopyConstructor = null;
                ICS.Standard.DeprecatedStringLiteralToCharPtr = false;
                return ICS;
            }
            if (!SuppressUserConversions && TypeProperties.isRecordType(T2) && RefRelationship == ReferenceCompareResult.Ref_Incompatible && !(userDefined = Conversions.TryUserDefinedConversion(From, FromType, DeclType, SuppressUserConversions, AllowExplicit, true, false, false, false, context)).isBad()) {
                return userDefined;
            }
        }
        if (!(isRValRef || T1.isConst() && !T1.isVolatile())) {
            return ICS;
        }
        if (RefRelationship.ordinal() >= ReferenceCompareResult.Ref_Compatible_With_Added_Qualification.ordinal() && (InitCategory == OCExprValueCategory.XValue || InitCategory == OCExprValueCategory.PRValue && (TypeProperties.isRecordType(T2) || T2 instanceof OCArrayType) || InitCategory == OCExprValueCategory.LValue && T2 instanceof OCFunctionType)) {
            ICS.setStandard();
            ICS.Standard.First = ImplicitConversionKind.ICK_Identity;
            ICS.Standard.Second = (Boolean)DerivedToBase.get() != false ? ImplicitConversionKind.ICK_Derived_To_Base : ((Boolean)ObjCConversion.get() != false ? ImplicitConversionKind.ICK_Compatible_Conversion : ImplicitConversionKind.ICK_Identity);
            ICS.Standard.Third = ImplicitConversionKind.ICK_Identity;
            ICS.Standard.FromTypePtr = T2;
            ICS.Standard.setToType(0, T2);
            ICS.Standard.setToType(1, T1);
            ICS.Standard.setToType(2, T1);
            ICS.Standard.ReferenceBinding = true;
            ICS.Standard.DirectBinding = OCCompilerFeatures.supportsInitializerLists(context.getFile()) || InitCategory != OCExprValueCategory.PRValue && !TypeProperties.isRecordType(T2);
            ICS.Standard.IsLvalueReference = !isRValRef;
            ICS.Standard.BindsToFunctionLvalue = T2 instanceof OCFunctionType;
            ICS.Standard.BindsToRvalue = InitCategory.isRValue();
            ICS.Standard.BindsImplicitObjectArgumentWithoutRefQualifier = false;
            ICS.Standard.ObjCLifetimeConversionBinding = (Boolean)ObjCLifetimeConversion.get();
            ICS.Standard.CopyConstructor = null;
            ICS.Standard.DeprecatedStringLiteralToCharPtr = false;
            return ICS;
        }
        if (T1 instanceof OCFunctionType) {
            return ICS;
        }
        if (RefRelationship == ReferenceCompareResult.Ref_Related && !(T1Quals = T1.getCVQualifiers()).isSuperset(T2Quals = T2.getCVQualifiers())) {
            return ICS;
        }
        if (SuppressUserConversions && RefRelationship == ReferenceCompareResult.Ref_Incompatible && (TypeProperties.isRecordType(T1) || TypeProperties.isRecordType(T2))) {
            return ICS;
        }
        if (RefRelationship.ordinal() >= ReferenceCompareResult.Ref_Related.ordinal() && isRValRef && OCExprValueCategory.classify(From, FromOriginalType, context) == OCExprValueCategory.LValue) {
            return ICS;
        }
        ICS = Conversions.TryImplicitConversion(From, FromOriginalType, FromType, T1, SuppressUserConversions, false, false, false, false, false, context);
        if (ICS.isStandard()) {
            ICS.Standard.ReferenceBinding = true;
            ICS.Standard.IsLvalueReference = !isRValRef;
            ICS.Standard.BindsToFunctionLvalue = false;
            ICS.Standard.BindsToRvalue = true;
            ICS.Standard.BindsImplicitObjectArgumentWithoutRefQualifier = false;
            ICS.Standard.ObjCLifetimeConversionBinding = false;
        } else if (ICS.isUserDefined()) {
            OCType LValRefType = ICS.UserDefined.ConversionFunction.getEffectiveType();
            if (LValRefType instanceof OCCppReferenceType && ((OCCppReferenceType)DeclType).isRvalueRef()) {
                ICS.setBad(BadConversionSequence.FailureKind.lvalue_ref_to_rvalue, FromType, DeclType);
                return ICS;
            }
            ICS.UserDefined.Before.setAsIdentityConversion();
            ICS.UserDefined.After.ReferenceBinding = true;
            ICS.UserDefined.After.IsLvalueReference = !isRValRef;
            ICS.UserDefined.After.BindsToFunctionLvalue = false;
            ICS.UserDefined.After.BindsToRvalue = !(LValRefType instanceof OCCppReferenceType);
            ICS.UserDefined.After.BindsImplicitObjectArgumentWithoutRefQualifier = false;
            ICS.UserDefined.After.ObjCLifetimeConversionBinding = false;
        }
        return ICS;
    }

    public static ReferenceCompareResult CompareReferenceRelationship(OCType OrigT1, OCType OrigT2, Ref<Boolean> DerivedToBase, Ref<Boolean> ObjCConversion, Ref<Boolean> ObjCLifetimeConversion, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(6);
        }
        assert (!(OrigT1 instanceof OCCppReferenceType)) : "T1 must be the pointee type of the reference type";
        assert (!(OrigT2 instanceof OCCppReferenceType)) : "T2 cannot be a reference type";
        OCType T1 = OrigT1.resolve(context);
        OCType T2 = OrigT2.resolve(context);
        Pair<OCType, CVQualifiers> pair1 = TypeProperties.getUnqualifiedArrayType(T1, context.getProject());
        Pair<OCType, CVQualifiers> pair2 = TypeProperties.getUnqualifiedArrayType(T2, context.getProject());
        OCType UnqualT1 = (OCType)pair1.first;
        OCType UnqualT2 = (OCType)pair2.first;
        CVQualifiers T1Quals = (CVQualifiers)((Object)pair1.second);
        CVQualifiers T2Quals = (CVQualifiers)((Object)pair2.second);
        DerivedToBase.set((Object)false);
        ObjCConversion.set((Object)false);
        ObjCLifetimeConversion.set((Object)false);
        OCTypeEqualityVisitor visitor = new OCTypeEqualityVisitor(UnqualT2, true, false, context);
        if (UnqualT2 != null && visitor.equal(UnqualT1)) {
            if (visitor.isMagicallyEquals()) {
                return ReferenceCompareResult.Ref_Magic;
            }
        } else if (TypeProperties.IsDerivedFrom(UnqualT2, UnqualT1, context)) {
            DerivedToBase.set((Object)true);
        } else if (UnqualT1.isPointerToObject() && UnqualT2.isPointerToObject() && UnqualT1.isCompatible(UnqualT2, context)) {
            ObjCConversion.set((Object)true);
        } else {
            return ReferenceCompareResult.Ref_Incompatible;
        }
        if (T1Quals == T2Quals) {
            return ReferenceCompareResult.Ref_Compatible;
        }
        if (T1Quals.isSuperset(T2Quals)) {
            return ReferenceCompareResult.Ref_Compatible_With_Added_Qualification;
        }
        return ReferenceCompareResult.Ref_Related;
    }

    public static ImplicitConversionSequence TryImplicitConversion(@Nullable OCTypeOwner From, OCType FromOriginalType, OCType FromType, OCType ToType, boolean SuppressUserConversions, boolean AllowExplicit, boolean InOverloadResolution, boolean CStyle, boolean AllowObjCWritebackConversion, boolean AllowObjCConversionOnExplicit, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(7);
        }
        ImplicitConversionSequence ICS = new ImplicitConversionSequence();
        ICS.Standard = Conversions.IsStandardConversion(From, FromOriginalType, FromType, ToType, InOverloadResolution, CStyle, AllowObjCWritebackConversion, context);
        if (ICS.Standard != null) {
            ICS.setStandard();
            return ICS;
        }
        if (!context.isCpp()) {
            ICS.setBad(BadConversionSequence.FailureKind.no_conversion, From, FromType, ToType);
            return ICS;
        }
        if (TypeProperties.isRecordType(ToType) && TypeProperties.isRecordType(FromType)) {
            TypeProperties.SameUnqualTypeResult res = TypeProperties.hasSameUnqualifiedTypeEx(FromType, ToType, context);
            if (res == TypeProperties.SameUnqualTypeResult.SAME_MAGIC) {
                return ImplicitConversionSequence.magic();
            }
            if (res == TypeProperties.SameUnqualTypeResult.SAME || TypeProperties.IsDerivedFrom(FromType, ToType, context)) {
                ICS.setStandard();
                ICS.Standard = new StandardConversionSequence();
                ICS.Standard.setFromType(FromType);
                ICS.Standard.setAllToTypes(ToType);
                ICS.Standard.CopyConstructor = null;
                if (!TypeProperties.hasSameUnqualifiedType(FromType, ToType, context)) {
                    ICS.Standard.Second = ImplicitConversionKind.ICK_Derived_To_Base;
                }
                return ICS;
            }
        }
        return Conversions.TryUserDefinedConversion(From, FromType, ToType, SuppressUserConversions, AllowExplicit, InOverloadResolution, CStyle, AllowObjCWritebackConversion, AllowObjCConversionOnExplicit, context);
    }

    @Nullable
    static StandardConversionSequence IsStandardConversion(@Nullable OCTypeOwner From, OCType FromOriginalType, OCType FromType, OCType ToType, boolean InOverloadResolution, boolean CStyle, boolean AllowObjCWritebackConversion, @NotNull OCResolveContext context) {
        OCType CanonTo;
        OCType CanonFrom;
        if (context == null) {
            Conversions.$$$reportNull$$$0(8);
        }
        StandardConversionSequence SCS = new StandardConversionSequence();
        if (FromType.equals(ToType, context)) {
            return SCS;
        }
        SCS.IncompatibleObjC = false;
        SCS.setFromType(FromType);
        SCS.CopyConstructor = null;
        if (context.isCpp() && (TypeProperties.isRecordType(FromType) || TypeProperties.isRecordType(ToType))) {
            return null;
        }
        boolean argIsLValue = OCExprValueCategory.classify(From, FromOriginalType, context).isGLValue();
        if (argIsLValue && !(FromType instanceof OCFunctionType) && !(FromType instanceof OCArrayType)) {
            SCS.First = ImplicitConversionKind.ICK_Lvalue_To_Rvalue;
            FromType = FromType.cloneWithoutCVQualifiers(context.getProject());
        } else if (FromType instanceof OCArrayType) {
            SCS.First = ImplicitConversionKind.ICK_Array_To_Pointer;
            FromType = TypeProperties.getArrayDecayedType((OCArrayType)FromType, context);
            if (Conversions.IsStringLiteralToNonConstPointerConversion(From, ToType)) {
                SCS.DeprecatedStringLiteralToCharPtr = true;
                SCS.Second = ImplicitConversionKind.ICK_Identity;
                SCS.Third = ImplicitConversionKind.ICK_Qualification;
                SCS.QualificationIncludesObjCLifetime = false;
                SCS.setAllToTypes(FromType);
                return SCS;
            }
        } else if (FromType instanceof OCFunctionType && argIsLValue) {
            SCS.First = ImplicitConversionKind.ICK_Function_To_Pointer;
            FromType = OCPointerType.to(FromType);
        } else {
            SCS.First = ImplicitConversionKind.ICK_Identity;
        }
        SCS.setToType(0, FromType);
        Ref IncompatibleObjC = Ref.create((Object)false);
        Ref ConvertedType = Ref.create();
        ImplicitConversionKind SecondICK = ImplicitConversionKind.ICK_Identity;
        if (TypeProperties.hasSameUnqualifiedType(FromType, ToType, context)) {
            SCS.Second = ImplicitConversionKind.ICK_Identity;
        } else if (Conversions.IsIntegralPromotion(From, FromType, ToType, context)) {
            SCS.Second = ImplicitConversionKind.ICK_Integral_Promotion;
            FromType = ToType.cloneWithoutCVQualifiers(context.getProject());
        } else if (Conversions.IsFloatingPointPromotion(FromType, ToType, context)) {
            SCS.Second = ImplicitConversionKind.ICK_Floating_Promotion;
            FromType = ToType.cloneWithoutCVQualifiers(context.getProject());
        } else if (OCIntType.isBool(ToType, context) && (TypeProperties.isArithmeticType(FromType) || FromType instanceof OCPointerType)) {
            SCS.Second = ImplicitConversionKind.ICK_Boolean_Conversion;
            FromType = OCIntType.isBool(ToType, context) ? ToType : OCIntType.getAppropriateBool(context.isObjc());
        } else if (TypeProperties.isIntegerLikeType(FromType) && TypeProperties.isIntegralType(ToType, context)) {
            SCS.Second = FromType instanceof OCIntType && ToType instanceof OCIntType && Conversions.shouldApplyWorkaroundForImproperIntegrals((OCIntType)FromType, (OCIntType)ToType) ? ImplicitConversionKind.ICK_Identity : ImplicitConversionKind.ICK_Integral_Conversion;
            FromType = ToType.cloneWithoutCVQualifiers(context.getProject());
        } else if (FromType instanceof OCRealType && ToType instanceof OCRealType) {
            SCS.Second = ImplicitConversionKind.ICK_Floating_Conversion;
            FromType = ToType.cloneWithoutCVQualifiers(context.getProject());
        } else if (FromType instanceof OCRealType && TypeProperties.isIntegralType(ToType, context) || TypeProperties.isIntegerLikeType(FromType) && ToType instanceof OCRealType) {
            SCS.Second = ImplicitConversionKind.ICK_Floating_Integral;
            FromType = ToType.cloneWithoutCVQualifiers(context.getProject());
        } else if (Conversions.IsPointerConversion(From, FromType, ToType, InOverloadResolution, (Ref<OCType>)ConvertedType, (Ref<Boolean>)IncompatibleObjC, context)) {
            SCS.Second = ImplicitConversionKind.ICK_Pointer_Conversion;
            SCS.IncompatibleObjC = (Boolean)IncompatibleObjC.get();
            FromType = ((OCType)ConvertedType.get()).cloneWithoutCVQualifiers(context.getProject());
        } else if (Conversions.IsMemberPointerConversion(From, FromType, ToType, InOverloadResolution, (Ref<OCType>)ConvertedType, context)) {
            SCS.Second = ImplicitConversionKind.ICK_Pointer_Member;
            FromType = (OCType)ConvertedType.get();
        } else if (!context.isCpp() && ToType.equals(FromType, context)) {
            SCS.Second = ImplicitConversionKind.ICK_Compatible_Conversion;
            FromType = ToType.cloneWithoutCVQualifiers(context.getProject());
        } else {
            SCS.Second = ImplicitConversionKind.ICK_Identity;
        }
        SCS.setToType(1, FromType);
        boolean ObjCLifetimeConversion = false;
        if (Conversions.IsQualificationConversion(FromType, ToType, CStyle, context)) {
            SCS.Third = ImplicitConversionKind.ICK_Qualification;
            SCS.QualificationIncludesObjCLifetime = ObjCLifetimeConversion;
            FromType = ToType;
            CanonFrom = FromType.resolve(context);
            CanonTo = ToType.resolve(context);
        } else {
            SCS.Third = ImplicitConversionKind.ICK_Identity;
            CanonFrom = FromType.resolve(context);
            CanonTo = ToType.resolve(context);
            if (TypeProperties.hasSameUnqualifiedType(FromType, ToType, context) && FromType.getCVQualifiers() != ToType.getCVQualifiers()) {
                FromType = ToType;
                CanonFrom = CanonTo;
            }
        }
        SCS.setToType(2, FromType);
        if (CanonFrom.equals(CanonTo, context)) {
            return SCS;
        }
        if (context.isCpp() || !InOverloadResolution) {
            return null;
        }
        if (!Conversions.CheckSingleAssignmentConstraints(ToType, FromType, From, context)) {
            return null;
        }
        SCS.setAllToTypes(ToType);
        SCS.First = ImplicitConversionKind.ICK_C_Only_Conversion;
        SCS.Second = ImplicitConversionKind.ICK_C_Only_Conversion;
        SCS.Third = ImplicitConversionKind.ICK_C_Only_Conversion;
        return SCS;
    }

    private static boolean shouldApplyWorkaroundForImproperIntegrals(@NotNull OCIntType FromType, @NotNull OCIntType ToType) {
        if (FromType == null) {
            Conversions.$$$reportNull$$$0(9);
        }
        if (ToType == null) {
            Conversions.$$$reportNull$$$0(10);
        }
        return FromType.isSigned() == ToType.isSigned() && (CTypeId.isImproperType(FromType.getCTypeId()) && ToType.getCTypeId() == CTypeId.LONG || CTypeId.isImproperType(ToType.getCTypeId()) && FromType.getCTypeId() == CTypeId.LONG);
    }

    private static boolean IsIntegralPromotion(@Nullable OCTypeOwner From, OCType FromType, OCType ToType, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(11);
        }
        if (!(ToType instanceof OCNumericType)) {
            return false;
        }
        OCNumericType toNumType = (OCNumericType)ToType;
        if (TypeProperties.isPromotableIntegerType(FromType, context) && !OCIntType.isBool(FromType, context) && !TypeProperties.isEnum(FromType)) {
            if (TypeProperties.isSignedIntegerType(FromType) || TypeProperties.getTypeSize(FromType, context) < TypeProperties.getTypeSize(ToType, context)) {
                return toNumType.getCTypeId() == CTypeId.INT && toNumType.isSigned();
            }
            return toNumType.getCTypeId() == CTypeId.INT && !toNumType.isSigned();
        }
        if (TypeProperties.isEnum(FromType)) {
            if (((OCStructType)FromType).getSymbol().isEnumClass()) {
                return false;
            }
            if (TypeProperties.isIntegerLikeType(ToType)) {
                return TypeProperties.hasSameUnqualifiedType(ToType, TypeProperties.getEnumPromotionType(FromType), context);
            }
        }
        if (TypeProperties.isAnyCharacterType(FromType) && !TypeProperties.isCharacterType(FromType) && TypeProperties.isIntegerLikeType(ToType)) {
            boolean FromIsSigned = TypeProperties.isSignedIntegerType(FromType);
            int FromSize = TypeProperties.getTypeSize(FromType, context);
            OCType[] PromoteTypes = new OCType[]{OCIntType.INT, OCIntType.UINT, OCIntType.LONG, OCIntType.ULONG, OCIntType.LONGLONG, OCIntType.ULONGLONG};
            for (int Idx = 0; Idx < PromoteTypes.length; ++Idx) {
                int ToSize = TypeProperties.getTypeSize(PromoteTypes[Idx], context);
                if (FromSize >= ToSize && (FromSize != ToSize || FromIsSigned != TypeProperties.isSignedIntegerType(PromoteTypes[Idx]))) continue;
                return TypeProperties.hasSameUnqualifiedType(ToType, PromoteTypes[Idx], context);
            }
        }
        return OCIntType.isBool(FromType, context) && ToType instanceof OCIntType && toNumType.getCTypeId() == CTypeId.INT && toNumType.isSigned();
    }

    private static boolean IsFloatingPointPromotion(OCType FromType, OCType ToType, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(12);
        }
        if (FromType instanceof OCRealType && ToType instanceof OCRealType) {
            CTypeId fromPrec = ((OCRealType)FromType).getCTypeId();
            CTypeId toPrec = ((OCRealType)ToType).getCTypeId();
            if (fromPrec == CTypeId.FLOAT && toPrec == CTypeId.DOUBLE) {
                return true;
            }
            if (!(context.isCpp() || fromPrec != CTypeId.FLOAT && fromPrec != CTypeId.DOUBLE || toPrec != CTypeId.LONG_DOUBLE)) {
                return true;
            }
        }
        return false;
    }

    private static boolean IsPointerConversion(@Nullable OCTypeOwner From, OCType FromType, OCType ToType, boolean InOverloadResolution, Ref<OCType> ConvertedType, Ref<Boolean> IncompatibleObjC, @NotNull OCResolveContext Context2) {
        if (Context2 == null) {
            Conversions.$$$reportNull$$$0(13);
        }
        IncompatibleObjC.set((Object)false);
        if (ToType.isPointerToObject() && Conversions.isNullPointerConstantForConversion(From, InOverloadResolution, Context2)) {
            ConvertedType.set((Object)ToType);
            return true;
        }
        if (FromType instanceof OCBlockPointerType && ToType.isPointerToVoid()) {
            ConvertedType.set((Object)ToType);
            return true;
        }
        if (ToType instanceof OCBlockPointerType && Conversions.isNullPointerConstantForConversion(From, InOverloadResolution, Context2)) {
            ConvertedType.set((Object)ToType);
            return true;
        }
        if (ToType == OCPointerType.NULLPTR_T && Conversions.isNullPointerConstantForConversion(From, InOverloadResolution, Context2)) {
            ConvertedType.set((Object)ToType);
            return true;
        }
        if (!(ToType instanceof OCPointerType)) {
            return false;
        }
        OCPointerType ToTypePtr = (OCPointerType)ToType;
        if (Conversions.isNullPointerConstantForConversion(From, InOverloadResolution, Context2)) {
            ConvertedType.set((Object)ToType);
            return true;
        }
        OCType ToPointeeType = ToTypePtr.getRefType();
        if (FromType.isPointerToObject() && ToPointeeType.isVoid() && !OCCompilerFeatures.isArcEnabled(Context2.getFile())) {
            ConvertedType.set((Object)Conversions.BuildSimilarlyQualifiedPointerType((OCPointerType)FromType, ToPointeeType, ToType, Context2));
            return true;
        }
        if (!(FromType instanceof OCPointerType)) {
            return false;
        }
        OCPointerType FromTypePtr = (OCPointerType)FromType;
        OCType FromPointeeType = FromTypePtr.getRefType();
        if (TypeProperties.hasSameUnqualifiedType(FromPointeeType, ToPointeeType, Context2)) {
            return false;
        }
        if (TypeProperties.isIncompleteOrObjectType(FromPointeeType) && ToPointeeType.isVoid()) {
            ConvertedType.set((Object)Conversions.BuildSimilarlyQualifiedPointerType(FromTypePtr, ToPointeeType, ToType, Context2, true));
            return true;
        }
        if (!Context2.isCpp() && FromPointeeType.equals(ToPointeeType, Context2)) {
            ConvertedType.set((Object)Conversions.BuildSimilarlyQualifiedPointerType(FromTypePtr, ToPointeeType, ToType, Context2));
            return true;
        }
        if (Context2.isCpp() && TypeProperties.isRecordType(FromPointeeType) && TypeProperties.isRecordType(ToPointeeType) && !TypeProperties.hasSameUnqualifiedType(FromPointeeType, ToPointeeType, Context2) && TypeProperties.IsDerivedFrom(FromPointeeType, ToPointeeType, Context2)) {
            ConvertedType.set((Object)Conversions.BuildSimilarlyQualifiedPointerType(FromTypePtr, ToPointeeType, ToType, Context2));
            return true;
        }
        return false;
    }

    private static boolean IsMemberPointerConversion(@Nullable OCTypeOwner From, OCType FromType, OCType ToType, boolean InOverloadResolution, Ref<OCType> ConvertedType, @NotNull OCResolveContext context) {
        OCType ToClass;
        if (context == null) {
            Conversions.$$$reportNull$$$0(14);
        }
        if (!(ToType instanceof OCPointerType) || ((OCPointerType)ToType).getClassQualifier() == null) {
            return false;
        }
        if (Conversions.isNullPointerConstantForConversion(From, InOverloadResolution, context)) {
            ConvertedType.set((Object)ToType);
            return true;
        }
        if (!(FromType instanceof OCPointerType) || ((OCPointerType)FromType).getClassQualifier() == null) {
            return false;
        }
        OCType FromClass = ((OCPointerType)FromType).getClassQualifier();
        if (!TypeProperties.hasSameUnqualifiedType(FromClass, ToClass = ((OCPointerType)ToType).getClassQualifier(), context) && TypeProperties.IsDerivedFrom(ToClass, FromClass, context)) {
            ConvertedType.set((Object)OCPointerType.to(((OCPointerType)FromType).getRefType(), null, ToClass));
            return true;
        }
        return false;
    }

    private static boolean isNullPointerConstantForConversion(@Nullable OCTypeOwner Expr2, boolean InOverloadResolution, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(15);
        }
        return OCExpressionEvaluator.isLikeNil(Expr2, context);
    }

    private static OCType BuildSimilarlyQualifiedPointerType(OCPointerType FromPtr, OCType ToPointee, OCType ToType, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(16);
        }
        return Conversions.BuildSimilarlyQualifiedPointerType(FromPtr, ToPointee, ToType, context, false);
    }

    private static OCType BuildSimilarlyQualifiedPointerType(OCPointerType FromPtr, OCType ToPointee, OCType ToType, @NotNull OCResolveContext context, boolean StripObjCLifetime) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(17);
        }
        if (ToType.isPointerToID()) {
            return ToType.cloneWithoutCVQualifiers(context.getProject());
        }
        OCType CanonFromPointee = FromPtr.getRefType();
        OCType CanonToPointee = ToPointee;
        CVQualifiers Quals = CanonFromPointee.getCVQualifiers();
        if (CanonToPointee.getCVQualifiers() == Quals) {
            return ToType.cloneWithoutCVQualifiers(context.getProject());
        }
        OCType QualifiedCanonToPointee = CanonToPointee.cloneWithCVQualifiers(Quals, context.getProject());
        return OCPointerType.to(QualifiedCanonToPointee);
    }

    private static boolean IsQualificationConversion(OCType FromType, OCType ToType, boolean CStyle, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(18);
        }
        if (TypeProperties.hasSameUnqualifiedType(FromType, ToType, context)) {
            return false;
        }
        boolean PreviousToQualsIncludeConst = true;
        boolean UnwrappedAnyPointer = false;
        while (TypeProperties.AreSimilarPointerTypes(FromType, ToType, context)) {
            FromType = ((OCPointerType)FromType).getRefType();
            ToType = ((OCPointerType)ToType).getRefType();
            UnwrappedAnyPointer = true;
            CVQualifiers FromQuals = FromType.getCVQualifiers();
            CVQualifiers ToQuals = ToType.getCVQualifiers();
            if (!CStyle && !ToQuals.isSuperset(FromQuals)) {
                return false;
            }
            if (!CStyle && FromQuals != ToQuals && !PreviousToQualsIncludeConst) {
                return false;
            }
            PreviousToQualsIncludeConst = PreviousToQualsIncludeConst && ToQuals.isConst();
        }
        return UnwrappedAnyPointer && TypeProperties.hasSameUnqualifiedType(FromType, ToType, context);
    }

    private static boolean IsStringLiteralToNonConstPointerConversion(@Nullable OCTypeOwner From, OCType ToType) {
        OCTypeOwner oCTypeOwner = From = From instanceof OCExpression ? OCParenthesesUtils.diveIntoParenthesesAndCasts((OCExpression)From) : From;
        return From instanceof OCLiteralExpression && ((OCLiteralExpression)From).isStringLiteral() && ToType.isPointerToChar() && ((OCPointerType)ToType).getRefType().getCVQualifiers() == CVQualifiers.EMPTY;
    }

    public static ImplicitConversionSequence.CompareKind CompareImplicitConversionSequences(ImplicitConversionSequence ICS1, ImplicitConversionSequence ICS2, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(19);
        }
        if (context.isCpp() && TypeProperties.hasDeprecatedStringLiteralToCharPtrConversion(ICS1) != TypeProperties.hasDeprecatedStringLiteralToCharPtrConversion(ICS2)) {
            return TypeProperties.hasDeprecatedStringLiteralToCharPtrConversion(ICS1) ? ImplicitConversionSequence.CompareKind.Worse : ImplicitConversionSequence.CompareKind.Better;
        }
        if (ICS1.getKindRank() < ICS2.getKindRank()) {
            return ImplicitConversionSequence.CompareKind.Better;
        }
        if (ICS2.getKindRank() < ICS1.getKindRank()) {
            return ImplicitConversionSequence.CompareKind.Worse;
        }
        if (ICS1.getKind() != ICS2.getKind()) {
            return ImplicitConversionSequence.CompareKind.Indistinguishable;
        }
        ImplicitConversionSequence.CompareKind Result2 = ImplicitConversionSequence.CompareKind.Indistinguishable;
        if (!ICS1.isBad()) {
            if (ICS1.isStdInitializerListElement() && !ICS2.isStdInitializerListElement()) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (!ICS1.isStdInitializerListElement() && ICS2.isStdInitializerListElement()) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
        }
        if (ICS1.isStandard()) {
            Result2 = Conversions.CompareStandardConversionSequences(ICS1.Standard, ICS2.Standard, context);
        } else if (ICS1.isUserDefined()) {
            Result2 = Objects.equals(ICS1.UserDefined.ConversionFunction, ICS2.UserDefined.ConversionFunction) ? Conversions.CompareStandardConversionSequences(ICS1.UserDefined.After, ICS2.UserDefined.After, context) : Conversions.compareConversionFunctions(ICS1.UserDefined.ConversionFunction, ICS2.UserDefined.ConversionFunction, context);
        }
        return Result2;
    }

    private static ImplicitConversionSequence.CompareKind CompareStandardConversionSequences(StandardConversionSequence SCS1, StandardConversionSequence SCS2, @NotNull OCResolveContext context) {
        ImplicitConversionSequence.CompareKind QualCK;
        boolean SCS2ConvertsToVoid;
        ImplicitConversionSequence.CompareKind CK;
        if (context == null) {
            Conversions.$$$reportNull$$$0(20);
        }
        if ((CK = Conversions.compareStandardConversionSubsets(SCS1, SCS2, context)) != ImplicitConversionSequence.CompareKind.Indistinguishable) {
            return CK;
        }
        ImplicitConversionRank Rank1 = SCS1.getRank();
        ImplicitConversionRank Rank2 = SCS2.getRank();
        if (Rank1.ordinal() < Rank2.ordinal()) {
            return ImplicitConversionSequence.CompareKind.Better;
        }
        if (Rank2.ordinal() < Rank1.ordinal()) {
            return ImplicitConversionSequence.CompareKind.Worse;
        }
        if (SCS1.isPointerConversionToBool(context) != SCS2.isPointerConversionToBool(context)) {
            return SCS2.isPointerConversionToBool(context) ? ImplicitConversionSequence.CompareKind.Better : ImplicitConversionSequence.CompareKind.Worse;
        }
        boolean SCS1ConvertsToVoid = SCS1.isPointerConversionToVoidPointer(context);
        if (SCS1ConvertsToVoid != (SCS2ConvertsToVoid = SCS2.isPointerConversionToVoidPointer(context))) {
            return SCS2ConvertsToVoid ? ImplicitConversionSequence.CompareKind.Better : ImplicitConversionSequence.CompareKind.Worse;
        }
        if (!SCS1ConvertsToVoid && !SCS2ConvertsToVoid) {
            ImplicitConversionSequence.CompareKind DerivedCK = Conversions.CompareDerivedToBaseConversions(SCS1, SCS2, context);
            if (DerivedCK != ImplicitConversionSequence.CompareKind.Indistinguishable) {
                return DerivedCK;
            }
        } else if (SCS1ConvertsToVoid && SCS2ConvertsToVoid && !SCS1.getFromType().equalsAfterResolving(SCS2.getFromType(), context)) {
            boolean AssignRight;
            boolean AssignLeft;
            OCType FromType1 = SCS1.getFromType();
            OCType FromType2 = SCS2.getFromType();
            if (SCS1.First == ImplicitConversionKind.ICK_Array_To_Pointer) {
                FromType1 = TypeProperties.getArrayDecayedType((OCArrayType)FromType1, context);
            }
            if (SCS2.First == ImplicitConversionKind.ICK_Array_To_Pointer) {
                FromType2 = TypeProperties.getArrayDecayedType((OCArrayType)FromType2, context);
            }
            OCType FromPointee1 = ((OCPointerType)FromType1).getRefType().cloneWithoutCVQualifiers(context.getProject());
            OCType FromPointee2 = ((OCPointerType)FromType2).getRefType().cloneWithoutCVQualifiers(context.getProject());
            if (TypeProperties.IsDerivedFrom(FromPointee2, FromPointee1, context)) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (TypeProperties.IsDerivedFrom(FromPointee1, FromPointee2, context)) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
            if (FromType1.isPointerToObject() && FromType2.isPointerToObject() && (AssignLeft = TypeProperties.canAssignObjCInterfaces(FromType1, FromType2, context)) != (AssignRight = TypeProperties.canAssignObjCInterfaces(FromType2, FromType1, context))) {
                return AssignLeft ? ImplicitConversionSequence.CompareKind.Better : ImplicitConversionSequence.CompareKind.Worse;
            }
        }
        if ((QualCK = Conversions.CompareQualificationConversions(SCS1, SCS2, context)) != ImplicitConversionSequence.CompareKind.Indistinguishable) {
            return QualCK;
        }
        if (SCS1.ReferenceBinding && SCS2.ReferenceBinding) {
            if (Conversions.isBetterReferenceBindingKind(SCS1, SCS2)) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (Conversions.isBetterReferenceBindingKind(SCS2, SCS1)) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
            OCType T1 = SCS1.getToType(2);
            OCType T2 = SCS2.getToType(2);
            T1 = T1.resolve(context);
            T2 = T2.resolve(context);
            Pair<OCType, CVQualifiers> pair1 = TypeProperties.getUnqualifiedArrayType(T1, context.getProject());
            Pair<OCType, CVQualifiers> pair2 = TypeProperties.getUnqualifiedArrayType(T2, context.getProject());
            OCType UnqualT1 = (OCType)pair1.first;
            OCType UnqualT2 = (OCType)pair2.first;
            CVQualifiers T1Quals = (CVQualifiers)((Object)pair1.second);
            CVQualifiers T2Quals = (CVQualifiers)((Object)pair2.second);
            if (UnqualT1.equals(UnqualT2, context)) {
                if (SCS1.ObjCLifetimeConversionBinding != SCS2.ObjCLifetimeConversionBinding) {
                    return SCS1.ObjCLifetimeConversionBinding ? ImplicitConversionSequence.CompareKind.Worse : ImplicitConversionSequence.CompareKind.Better;
                }
                if (TypeProperties.isMoreQualifiedThan(T2Quals, T1Quals)) {
                    return ImplicitConversionSequence.CompareKind.Better;
                }
                if (TypeProperties.isMoreQualifiedThan(T1Quals, T2Quals)) {
                    return ImplicitConversionSequence.CompareKind.Worse;
                }
            }
        }
        return ImplicitConversionSequence.CompareKind.Indistinguishable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ImplicitConversionSequence.CompareKind compareStandardConversionSubsets(StandardConversionSequence SCS1, StandardConversionSequence SCS2, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(21);
        }
        ImplicitConversionSequence.CompareKind Result2 = ImplicitConversionSequence.CompareKind.Indistinguishable;
        if (SCS1.isIdentityConversion() && !SCS2.isIdentityConversion()) {
            return ImplicitConversionSequence.CompareKind.Better;
        }
        if (!SCS1.isIdentityConversion() && SCS2.isIdentityConversion()) {
            return ImplicitConversionSequence.CompareKind.Worse;
        }
        if (SCS1.Second != SCS2.Second) {
            if (SCS1.Second == ImplicitConversionKind.ICK_Identity) {
                Result2 = ImplicitConversionSequence.CompareKind.Better;
            } else {
                if (SCS2.Second != ImplicitConversionKind.ICK_Identity) return ImplicitConversionSequence.CompareKind.Indistinguishable;
                Result2 = ImplicitConversionSequence.CompareKind.Worse;
            }
        } else if (!TypeProperties.hasSimilarType(SCS1.getToType(1), SCS2.getToType(1), context)) {
            return ImplicitConversionSequence.CompareKind.Indistinguishable;
        }
        if (SCS1.Third == SCS2.Third) {
            return SCS1.getToType(2).equals(SCS2.getToType(2), context) ? Result2 : ImplicitConversionSequence.CompareKind.Indistinguishable;
        }
        if (SCS1.Third == ImplicitConversionKind.ICK_Identity) {
            return Result2 == ImplicitConversionSequence.CompareKind.Worse ? ImplicitConversionSequence.CompareKind.Indistinguishable : ImplicitConversionSequence.CompareKind.Better;
        }
        if (SCS2.Third != ImplicitConversionKind.ICK_Identity) return ImplicitConversionSequence.CompareKind.Indistinguishable;
        return Result2 == ImplicitConversionSequence.CompareKind.Better ? ImplicitConversionSequence.CompareKind.Indistinguishable : ImplicitConversionSequence.CompareKind.Worse;
    }

    private static ImplicitConversionSequence.CompareKind compareConversionFunctions(OCFunctionSymbol Function12, OCFunctionSymbol Function22, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(22);
        }
        return ImplicitConversionSequence.CompareKind.Indistinguishable;
    }

    private static ImplicitConversionSequence.CompareKind CompareDerivedToBaseConversions(StandardConversionSequence SCS1, StandardConversionSequence SCS2, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(23);
        }
        OCType FromType1 = SCS1.getFromType();
        OCType ToType1 = SCS1.getToType(1);
        OCType FromType2 = SCS2.getFromType();
        OCType ToType2 = SCS2.getToType(1);
        if (SCS1.First == ImplicitConversionKind.ICK_Array_To_Pointer) {
            FromType1 = TypeProperties.getArrayDecayedType((OCArrayType)FromType1, context);
        }
        if (SCS2.First == ImplicitConversionKind.ICK_Array_To_Pointer) {
            FromType2 = TypeProperties.getArrayDecayedType((OCArrayType)FromType2, context);
        }
        FromType1 = FromType1.resolve(context);
        ToType1 = ToType1.resolve(context);
        FromType2 = FromType2.resolve(context);
        ToType2 = ToType2.resolve(context);
        if (SCS1.Second == ImplicitConversionKind.ICK_Pointer_Conversion && SCS2.Second == ImplicitConversionKind.ICK_Pointer_Conversion && FromType1 instanceof OCPointerType && FromType2 instanceof OCPointerType && ToType1 instanceof OCPointerType && ToType2 instanceof OCPointerType) {
            OCType FromPointee1 = ((OCPointerType)FromType1).getRefType().cloneWithoutCVQualifiers(context.getProject());
            OCType ToPointee1 = ((OCPointerType)ToType1).getRefType().cloneWithoutCVQualifiers(context.getProject());
            OCType FromPointee2 = ((OCPointerType)FromType2).getRefType().cloneWithoutCVQualifiers(context.getProject());
            OCType ToPointee2 = ((OCPointerType)ToType2).getRefType().cloneWithoutCVQualifiers(context.getProject());
            if (FromPointee1 == FromPointee2 && ToPointee1 != ToPointee2) {
                if (TypeProperties.IsDerivedFrom(ToPointee1, ToPointee2, context)) {
                    return ImplicitConversionSequence.CompareKind.Better;
                }
                if (TypeProperties.IsDerivedFrom(ToPointee2, ToPointee1, context)) {
                    return ImplicitConversionSequence.CompareKind.Worse;
                }
            }
            if (FromPointee1 != FromPointee2 && ToPointee1 == ToPointee2) {
                if (TypeProperties.IsDerivedFrom(FromPointee2, FromPointee1, context)) {
                    return ImplicitConversionSequence.CompareKind.Better;
                }
                if (TypeProperties.IsDerivedFrom(FromPointee1, FromPointee2, context)) {
                    return ImplicitConversionSequence.CompareKind.Worse;
                }
            }
        } else if (SCS1.Second == ImplicitConversionKind.ICK_Pointer_Conversion && SCS2.Second == ImplicitConversionKind.ICK_Pointer_Conversion && FromType1.isPointerToObject() && FromType2.isPointerToObject() && ToType1.isPointerToObject() && ToType2.isPointerToObject()) {
            boolean FromAssignLeft = TypeProperties.canAssignObjCInterfaces(FromType1, FromType2, context);
            boolean FromAssignRight = TypeProperties.canAssignObjCInterfaces(FromType2, FromType1, context);
            boolean ToAssignLeft = TypeProperties.canAssignObjCInterfaces(ToType1, ToType2, context);
            boolean ToAssignRight = TypeProperties.canAssignObjCInterfaces(ToType2, ToType1, context);
            if (ToType1.isPointerToID() && (ToType2.isPointerToID(true) || !ToType2.isPointerToID())) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
            if (ToType2.isPointerToID() && (ToType1.isPointerToID(true) || !ToType1.isPointerToID())) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (ToType1.isPointerToID(true) && !ToType2.isPointerToID()) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
            if (ToType2.isPointerToID(true) && !ToType1.isPointerToID()) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (ToType1.isClassType() && (ToType2.isClassType(true) || !ToType2.isPointerToID())) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
            if (ToType2.isClassType() && (ToType1.isClassType(true) || !ToType1.isPointerToID())) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (ToType1.isClassType(true) && !ToType2.isPointerToID()) {
                return ImplicitConversionSequence.CompareKind.Worse;
            }
            if (ToType2.isClassType() && !ToType1.isPointerToID()) {
                return ImplicitConversionSequence.CompareKind.Better;
            }
            if (FromType1.equals(FromType2, context) && !FromType1.isPointerToID() && !FromType1.isClassType() && ToAssignLeft != ToAssignRight) {
                return ToAssignLeft ? ImplicitConversionSequence.CompareKind.Worse : ImplicitConversionSequence.CompareKind.Better;
            }
            if (TypeProperties.hasSameUnqualifiedType(ToType1, ToType2, context) && FromAssignLeft != FromAssignRight) {
                return FromAssignLeft ? ImplicitConversionSequence.CompareKind.Better : ImplicitConversionSequence.CompareKind.Worse;
            }
        }
        if (SCS1.Second == ImplicitConversionKind.ICK_Pointer_Member && SCS2.Second == ImplicitConversionKind.ICK_Pointer_Member && FromType1 instanceof OCPointerType && FromType2 instanceof OCPointerType && ToType1 instanceof OCPointerType && ToType2 instanceof OCPointerType) {
            OCType FromPointeeType1 = ((OCPointerType)FromType1).getClassQualifier();
            OCType ToPointeeType1 = ((OCPointerType)ToType1).getClassQualifier();
            OCType FromPointeeType2 = ((OCPointerType)FromType2).getClassQualifier();
            OCType ToPointeeType2 = ((OCPointerType)ToType2).getClassQualifier();
            if (FromPointeeType1 != null && ToPointeeType1 != null && FromPointeeType2 != null && ToPointeeType2 != null) {
                OCType FromPointee1 = FromPointeeType1.cloneWithoutCVQualifiers(context.getProject());
                OCType ToPointee1 = ToPointeeType1.cloneWithoutCVQualifiers(context.getProject());
                OCType FromPointee2 = FromPointeeType2.cloneWithoutCVQualifiers(context.getProject());
                OCType ToPointee2 = ToPointeeType2.cloneWithoutCVQualifiers(context.getProject());
                if (FromPointee1 == FromPointee2 && ToPointee1 != ToPointee2) {
                    if (TypeProperties.IsDerivedFrom(ToPointee1, ToPointee2, context)) {
                        return ImplicitConversionSequence.CompareKind.Worse;
                    }
                    if (TypeProperties.IsDerivedFrom(ToPointee2, ToPointee1, context)) {
                        return ImplicitConversionSequence.CompareKind.Better;
                    }
                }
                if (ToPointee1 == ToPointee2 && FromPointee1 != FromPointee2) {
                    if (TypeProperties.IsDerivedFrom(FromPointee1, FromPointee2, context)) {
                        return ImplicitConversionSequence.CompareKind.Better;
                    }
                    if (TypeProperties.IsDerivedFrom(FromPointee2, FromPointee1, context)) {
                        return ImplicitConversionSequence.CompareKind.Worse;
                    }
                }
            }
        }
        if (SCS1.Second == ImplicitConversionKind.ICK_Derived_To_Base) {
            if (TypeProperties.hasSameUnqualifiedType(FromType1, FromType2, context) && !TypeProperties.hasSameUnqualifiedType(ToType1, ToType2, context)) {
                if (TypeProperties.IsDerivedFrom(ToType1, ToType2, context)) {
                    return ImplicitConversionSequence.CompareKind.Better;
                }
                if (TypeProperties.IsDerivedFrom(ToType2, ToType1, context)) {
                    return ImplicitConversionSequence.CompareKind.Worse;
                }
            }
            if (!TypeProperties.hasSameUnqualifiedType(FromType1, FromType2, context) && TypeProperties.hasSameUnqualifiedType(ToType1, ToType2, context)) {
                if (TypeProperties.IsDerivedFrom(FromType2, FromType1, context)) {
                    return ImplicitConversionSequence.CompareKind.Better;
                }
                if (TypeProperties.IsDerivedFrom(FromType1, FromType2, context)) {
                    return ImplicitConversionSequence.CompareKind.Worse;
                }
            }
        }
        return ImplicitConversionSequence.CompareKind.Indistinguishable;
    }

    private static ImplicitConversionSequence.CompareKind CompareQualificationConversions(StandardConversionSequence SCS1, StandardConversionSequence SCS2, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(24);
        }
        if (SCS1.First != SCS2.First || SCS1.Second != SCS2.Second || SCS1.Third != SCS2.Third || SCS1.Third != ImplicitConversionKind.ICK_Qualification) {
            return ImplicitConversionSequence.CompareKind.Indistinguishable;
        }
        OCType T1 = SCS1.getToType(2);
        OCType T2 = SCS2.getToType(2);
        T1 = T1.resolve(context);
        T2 = T2.resolve(context);
        Pair<OCType, CVQualifiers> pair1 = TypeProperties.getUnqualifiedArrayType(T1, context.getProject());
        Pair<OCType, CVQualifiers> pair2 = TypeProperties.getUnqualifiedArrayType(T2, context.getProject());
        OCType UnqualT1 = (OCType)pair1.first;
        OCType UnqualT2 = (OCType)pair2.first;
        CVQualifiers T1Quals = (CVQualifiers)((Object)pair1.second);
        CVQualifiers T2Quals = (CVQualifiers)((Object)pair2.second);
        if (UnqualT1.equals(UnqualT2, context)) {
            return ImplicitConversionSequence.CompareKind.Indistinguishable;
        }
        if (T1 instanceof OCArrayType && T1Quals != CVQualifiers.EMPTY) {
            T1 = UnqualT1.cloneWithCVQualifiers(T1Quals, context.getProject());
        }
        if (T2 instanceof OCArrayType && T2Quals != CVQualifiers.EMPTY) {
            T2 = UnqualT2.cloneWithCVQualifiers(T2Quals, context.getProject());
        }
        ImplicitConversionSequence.CompareKind Result2 = ImplicitConversionSequence.CompareKind.Indistinguishable;
        if (SCS1.QualificationIncludesObjCLifetime != SCS2.QualificationIncludesObjCLifetime) {
            ImplicitConversionSequence.CompareKind compareKind = Result2 = SCS1.QualificationIncludesObjCLifetime ? ImplicitConversionSequence.CompareKind.Worse : ImplicitConversionSequence.CompareKind.Better;
        }
        while (TypeProperties.AreSimilarPointerTypes(T1, T2, context)) {
            T1 = ((OCPointerType)T1).getRefType();
            T2 = ((OCPointerType)T2).getRefType();
            if (T1.getCVQualifiers() != T2.getCVQualifiers()) {
                if (TypeProperties.isMoreQualifiedThan(T2, T1)) {
                    if (Result2 == ImplicitConversionSequence.CompareKind.Worse) {
                        return ImplicitConversionSequence.CompareKind.Indistinguishable;
                    }
                    Result2 = ImplicitConversionSequence.CompareKind.Better;
                } else if (TypeProperties.isMoreQualifiedThan(T1, T2)) {
                    if (Result2 == ImplicitConversionSequence.CompareKind.Better) {
                        return ImplicitConversionSequence.CompareKind.Indistinguishable;
                    }
                    Result2 = ImplicitConversionSequence.CompareKind.Worse;
                } else {
                    return ImplicitConversionSequence.CompareKind.Indistinguishable;
                }
            }
            if (!TypeProperties.hasSameUnqualifiedType(T1, T2, context)) continue;
        }
        switch (Result2) {
            case Better: {
                if (!SCS1.DeprecatedStringLiteralToCharPtr) break;
                Result2 = ImplicitConversionSequence.CompareKind.Indistinguishable;
                break;
            }
            case Indistinguishable: {
                break;
            }
            case Worse: {
                if (!SCS2.DeprecatedStringLiteralToCharPtr) break;
                Result2 = ImplicitConversionSequence.CompareKind.Indistinguishable;
            }
        }
        return Result2;
    }

    static boolean isBetterReferenceBindingKind(StandardConversionSequence SCS1, StandardConversionSequence SCS2) {
        if (SCS1.BindsImplicitObjectArgumentWithoutRefQualifier || SCS2.BindsImplicitObjectArgumentWithoutRefQualifier) {
            return false;
        }
        return !SCS1.IsLvalueReference && SCS1.BindsToRvalue && SCS2.IsLvalueReference || SCS1.IsLvalueReference && SCS1.BindsToFunctionLvalue && !SCS2.IsLvalueReference && SCS2.BindsToFunctionLvalue;
    }

    public static ImplicitConversionSequence TryObjectArgumentInitialization(OCType ClassType2, OCType FromType, @NotNull OCFunctionSymbol Method2, OCExprValueCategory FromClassification, @NotNull OCResolveContext context) {
        ImplicitConversionKind SecondKind;
        if (Method2 == null) {
            Conversions.$$$reportNull$$$0(25);
        }
        if (context == null) {
            Conversions.$$$reportNull$$$0(26);
        }
        CVQualifiers Quals = Method2.isCppDestructor() ? CVQualifiers.CONST_VOLATILE : Method2.getType().getCVQualifiers();
        OCType ImplicitParamType = ClassType2.cloneWithCVQualifiers(Quals, context.getProject());
        ImplicitConversionSequence ICS = new ImplicitConversionSequence();
        if (FromType instanceof OCPointerType) {
            FromType = ((OCPointerType)FromType).getRefType();
        }
        assert (TypeProperties.isRecordType(FromType));
        OCType FromTypeCanon = FromType.resolve(context);
        if (ImplicitParamType.getCVQualifiers() != FromTypeCanon.getCVQualifiers() && !ImplicitParamType.getCVQualifiers().isSuperset(FromTypeCanon.getCVQualifiers())) {
            ICS.setBad(BadConversionSequence.FailureKind.bad_qualifiers, FromType, ImplicitParamType);
            return ICS;
        }
        OCType ClassTypeCanon = ClassType2.resolve(context);
        if (ClassTypeCanon.equals(FromTypeCanon, false, context)) {
            SecondKind = ImplicitConversionKind.ICK_Identity;
        } else if (TypeProperties.IsDerivedFrom(FromType, ClassType2, context)) {
            SecondKind = ImplicitConversionKind.ICK_Derived_To_Base;
        } else {
            ICS.setBad(BadConversionSequence.FailureKind.unrelated_class, FromType, ImplicitParamType);
            return ICS;
        }
        TypeProperties.RefQualifier refQualifier = TypeProperties.getRefQualifier(Method2.getType());
        switch (refQualifier) {
            case RQ_None: {
                break;
            }
            case RQ_LValue: {
                if (FromClassification == OCExprValueCategory.LValue || Quals == CVQualifiers.CONST) break;
                ICS.setBad(BadConversionSequence.FailureKind.lvalue_ref_to_rvalue, FromType, ImplicitParamType);
                return ICS;
            }
            case RQ_RValue: {
                if (FromClassification.isRValue()) break;
                ICS.setBad(BadConversionSequence.FailureKind.rvalue_ref_to_lvalue, FromType, ImplicitParamType);
                return ICS;
            }
        }
        ICS.setStandard();
        ICS.Standard.setAsIdentityConversion();
        ICS.Standard.Second = SecondKind;
        ICS.Standard.setFromType(FromType);
        ICS.Standard.setAllToTypes(ImplicitParamType);
        ICS.Standard.ReferenceBinding = true;
        ICS.Standard.DirectBinding = true;
        ICS.Standard.IsLvalueReference = refQualifier != TypeProperties.RefQualifier.RQ_RValue;
        ICS.Standard.BindsToFunctionLvalue = false;
        ICS.Standard.BindsToRvalue = FromClassification.isRValue();
        ICS.Standard.BindsImplicitObjectArgumentWithoutRefQualifier = refQualifier == TypeProperties.RefQualifier.RQ_None;
        return ICS;
    }

    private static ImplicitConversionSequence TryUserDefinedConversion(@Nullable OCTypeOwner From, OCType FromType, OCType ToType, boolean SuppressUserConversions, boolean AllowExplicit, boolean InOverloadResolution, boolean CStyle, boolean AllowObjCWritebackConversion, boolean AllowObjCConversionOnExplicit, @NotNull OCResolveContext context) {
        ImplicitConversionSequence seq;
        OCTypeCheckResult result;
        if (context == null) {
            Conversions.$$$reportNull$$$0(27);
        }
        ImplicitConversionSequence ICS = new ImplicitConversionSequence();
        if (SuppressUserConversions) {
            ICS.setBad(BadConversionSequence.FailureKind.no_conversion, From, FromType, ToType);
            return ICS;
        }
        if (From instanceof OCCompoundInitializer && !(result = OCCompoundInitializerChecker.checkCompoundInitializer((OCCompoundInitializer)From, ToType, true, context)).getState().isError(context.getElement())) {
            ICS.setUserDefined();
            ICS.UserDefined = new UserDefinedConversionSequence();
            ICS.UserDefined.Before = new StandardConversionSequence();
            ICS.UserDefined.After = new StandardConversionSequence();
            return ICS;
        }
        if (FromType instanceof OCStructType && (result = OCTypeCompatibilityVisitor.checkConversionOperators(ToType, (OCStructType)FromType, From, context.getElement(), null, false, context)) != null && !result.getState().isError(context.getElement()) && result.isWithConversion() && result.getTypeAfterConversion() != null && (seq = Conversions.calculateConversion(Conversions.getFakeCallableFromOperatorCall(context, result.getImplicitConstructor()), result.getTypeAfterConversion(), ToType, false, true, AllowObjCWritebackConversion, AllowExplicit, context)).isStandard()) {
            ICS.setUserDefined();
            ICS.UserDefined = new UserDefinedConversionSequence();
            ICS.UserDefined.Before = new StandardConversionSequence();
            ICS.UserDefined.After = seq.Standard;
            ICS.UserDefined.ConversionFunction = result.getImplicitConstructor();
            return ICS;
        }
        if (ToType instanceof OCStructType && (result = OCTypeCompatibilityVisitor.checkConstructors((OCStructType)ToType.getTerminalType(), FromType, From, context)) != null && !result.getState().isError(context.getElement()) && result.isWithConversion() && result.getTypeBeforeConversion() != null && ((seq = Conversions.calculateConversion(From, FromType, result.getTypeBeforeConversion(), false, true, AllowObjCWritebackConversion, AllowExplicit, context)).isStandard() || seq.isEllipsis())) {
            ICS.setUserDefined();
            (ICS.UserDefined = new UserDefinedConversionSequence()).Before = seq.Standard != null ? seq.Standard : new StandardConversionSequence();
            ICS.UserDefined.After = new StandardConversionSequence();
            ICS.UserDefined.ConversionFunction = result.getImplicitConstructor();
            return ICS;
        }
        ICS.setBad(BadConversionSequence.FailureKind.no_conversion, From, FromType, ToType);
        return ICS;
    }

    @NotNull
    private static OCValueCategoryHolder getFakeCallableFromOperatorCall(@NotNull OCResolveContext context, @Nullable OCFunctionSymbol operator) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(28);
        }
        if (operator == null) {
            OCValueCategoryHolder oCValueCategoryHolder = new OCValueCategoryHolder(OCUnknownType.INSTANCE, OCExprValueCategory.PRValue);
            if (oCValueCategoryHolder == null) {
                Conversions.$$$reportNull$$$0(29);
            }
            return oCValueCategoryHolder;
        }
        OCValueCategoryHolder oCValueCategoryHolder = OCValueCategoryHolder.createFakeCallable(operator.getType().getReturnType().resolve(context));
        if (oCValueCategoryHolder == null) {
            Conversions.$$$reportNull$$$0(30);
        }
        return oCValueCategoryHolder;
    }

    private static boolean CheckSingleAssignmentConstraints(OCType LHSType, OCType RHSType, OCTypeOwner RHS, @NotNull OCResolveContext context) {
        if (context == null) {
            Conversions.$$$reportNull$$$0(31);
        }
        if (LHSType instanceof OCBlockPointerType || RHSType instanceof OCBlockPointerType) {
            return LHSType.checkCompatible(RHSType, null, (PsiElement)ObjectUtils.tryCast((Object)RHS, OCExpression.class), true, context).getState() == OCTypeCheckState.OK;
        }
        return true;
    }

    @Nullable
    private static OCFunctionType getFunctionType(@Nullable OCType type) {
        if (type instanceof OCFunctionType) {
            return (OCFunctionType)type;
        }
        if (type instanceof OCPointerType && ((OCPointerType)type).getRefType() instanceof OCFunctionType) {
            return (OCFunctionType)((OCPointerType)type).getRefType();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "FromType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ToType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "Context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "Method";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/v2/Conversions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/v2/Conversions";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFakeCallableFromOperatorCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateConversion";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "TryCopyInitialization";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "TryListConversion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "TryReferenceInit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "CompareReferenceRelationship";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "TryImplicitConversion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "IsStandardConversion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldApplyWorkaroundForImproperIntegrals";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "IsIntegralPromotion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "IsFloatingPointPromotion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "IsPointerConversion";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "IsMemberPointerConversion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNullPointerConstantForConversion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "BuildSimilarlyQualifiedPointerType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "IsQualificationConversion";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "CompareImplicitConversionSequences";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "CompareStandardConversionSequences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "compareStandardConversionSubsets";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compareConversionFunctions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "CompareDerivedToBaseConversions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "CompareQualificationConversions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "TryObjectArgumentInitialization";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "TryUserDefinedConversion";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFakeCallableFromOperatorCall";
                break;
            }
            case 29: 
            case 30: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "CheckSingleAssignmentConstraints";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ReferenceCompareResult {
        Ref_Incompatible,
        Ref_Related,
        Ref_Compatible_With_Added_Qualification,
        Ref_Compatible,
        Ref_Magic;

    }
}

