/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCClassInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    public static final OCClassInheritorsSearch INSTANCE = new OCClassInheritorsSearch();

    private OCClassInheritorsSearch() {
    }

    public static Query<OCClassSymbol> search(OCClassDeclaration aClass) {
        Project project2 = aClass.getProject();
        return OCClassInheritorsSearch.search(aClass.getName(), aClass instanceof OCProtocol, GlobalSearchScope.allScope((Project)project2), project2, aClass instanceof OCImplementation);
    }

    public static Query<OCClassSymbol> search(OCClassSymbol aClass, @NotNull Project project2) {
        if (project2 == null) {
            OCClassInheritorsSearch.$$$reportNull$$$0(0);
        }
        return OCClassInheritorsSearch.search(aClass.getName(), aClass instanceof OCProtocolSymbol, GlobalSearchScope.allScope((Project)project2), project2, aClass instanceof OCImplementationSymbol);
    }

    public static Query<OCClassSymbol> search(String className, boolean isProtocol, GlobalSearchScope scope, Project project2, boolean myPreferImplementations) {
        return INSTANCE.createQuery(new SearchParameters(scope, className, isProtocol, project2, myPreferImplementations));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch", "search"));
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<OCClassSymbol> consumer) {
            if (p == null) {
                DefaultExecutor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DefaultExecutor.$$$reportNull$$$0(1);
            }
            GlobalSearchScope scope = p.getScope();
            Project project2 = p.getProject();
            Stack names = new Stack();
            HashSet<Pair> processed = new HashSet<Pair>();
            names.push((Object)Pair.create((Object)p.getClassName(), (Object)p.isProtocol()));
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                Pair name2 = (Pair)names.pop();
                if (!processed.add(name2)) continue;
                Query<OCClassSymbol> search = OCDirectInheritorsSearch.search((String)name2.getFirst(), GlobalSearchScope.allScope((Project)project2), project2, (Boolean)name2.getSecond(), p.isPreferImplementations());
                search.forEach(symbol -> {
                    if (consumer == null) {
                        DefaultExecutor.$$$reportNull$$$0(2);
                    }
                    names.push((Object)Pair.create((Object)symbol.getName(), (Object)(symbol instanceof OCProtocolSymbol)));
                    return !scope.contains(symbol.getContainingFile()) || consumer.process(symbol);
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/search/OCClassInheritorsSearch$DefaultExecutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processQuery";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processQuery$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SearchParameters {
        private final GlobalSearchScope myScope;
        private final String myClassName;
        private final Project myProject;
        private boolean myProtocol;
        private final boolean myPreferImplementations;

        public SearchParameters(GlobalSearchScope scope, String className, boolean protocol, Project project2, boolean preferImplementations) {
            this.myScope = scope;
            this.myClassName = className;
            this.myProtocol = protocol;
            this.myProject = project2;
            this.myPreferImplementations = preferImplementations;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public Project getProject() {
            return this.myProject;
        }

        public boolean isProtocol() {
            return this.myProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }
    }
}

