/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.EmptyQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionInheritorsSearch
extends QueryFactory<OCFunctionSymbol, SearchParameters> {
    public static final OCFunctionInheritorsSearch INSTANCE = new OCFunctionInheritorsSearch();

    public static SearchParameters getParameters(OCSymbolWithQualifiedName symbol, @NotNull OCFile context, boolean searchBySignature) {
        if (context == null) {
            OCFunctionInheritorsSearch.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            return new SearchParameters();
        }
        Project project2 = context.getProject();
        OCQualifiedName parentName = OCFunctionInheritorsSearch.getParentResolvedQualifiedName(symbol, project2);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project2);
        SearchParameters parameters = searchBySignature ? SearchParameters.getSearchFunctionBySignatureParameters(context, scope, symbol.getName(), symbol.getType(), parentName) : SearchParameters.getSearchFunctionByNameParameters(context, scope, symbol.getName(), parentName);
        if (symbol instanceof OCFunctionSymbol && symbol.isFriend() && !((OCFunctionSymbol)symbol).isCppOperator()) {
            parameters.myIsFriend = true;
        }
        parameters.myIsFriendOrStatic = symbol.isFriendOrStatic();
        return parameters;
    }

    private static OCQualifiedName getParentResolvedQualifiedName(OCSymbolWithQualifiedName symbol, @NotNull Project project2) {
        OCQualifiedName qualifiedName;
        if (project2 == null) {
            OCFunctionInheritorsSearch.$$$reportNull$$$0(1);
        }
        return (qualifiedName = symbol.getResolvedQualifiedName(OCResolveContext.forSymbol(symbol, project2))) != null ? qualifiedName.getQualifier() : OCQualifiedName.GLOBAL;
    }

    public static SearchParameters getParameters(OCFunctionDeclaration function, boolean searchBySignature) {
        return OCFunctionInheritorsSearch.getParameters((OCSymbolWithQualifiedName)function.getSymbol(), function.getContainingOCFile(), searchBySignature);
    }

    public static Query<OCFunctionSymbol> search(SearchParameters parameters) {
        return OCFunctionInheritorsSearch.search(parameters, null);
    }

    public static Query<OCFunctionSymbol> search(SearchParameters parameters, @Nullable MultiMap<OCQualifiedName, OCQualifiedName> inheritanceCache) {
        if (parameters.myFunctionName == null) {
            return new EmptyQuery();
        }
        parameters.myInheritenceCache = inheritanceCache;
        return INSTANCE.createQuery(parameters);
    }

    public static Query<OCFunctionSymbol> search(OCFunctionSymbol function, OCFile context, boolean searchBySignature) {
        return OCFunctionInheritorsSearch.search(OCFunctionInheritorsSearch.getParameters(function, context, searchBySignature));
    }

    private OCFunctionInheritorsSearch() {
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/search/OCFunctionInheritorsSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentResolvedQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCFunctionSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<OCFunctionSymbol> consumer) {
            HashSet<OCQualifiedName> curSubstructs;
            if (p == null) {
                DefaultExecutor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                DefaultExecutor.$$$reportNull$$$0(1);
            }
            GlobalSearchScope scope = p.myScope;
            HashSet<OCQualifiedName> substructs = new HashSet<OCQualifiedName>();
            OCQualifiedName parentStruct = p.myParentStruct;
            OCResolveContext resolveContext = OCResolveContext.forNullablePsi(p.myContext, p.myProject);
            if (p.myInheritenceCache != null && p.myInheritenceCache.containsKey((Object)parentStruct)) {
                Collection cached = p.myInheritenceCache.get((Object)parentStruct);
                substructs.addAll(cached);
            } else {
                Query<OCStructSymbol> search = p.myIncludeOnlyDirectInheritors ? OCDirectStructInheritorsSearch.search(parentStruct, scope, p.myContext, p.myProject) : OCStructInheritorsSearch.search(parentStruct, scope, p.myContext, p.myProject);
                for (OCStructSymbol substruct : search.findAll()) {
                    substructs.add(substruct.getResolvedQualifiedNameWithoutArguments(resolveContext));
                }
                if (p.myInheritenceCache != null) {
                    p.myInheritenceCache.putValues((Object)parentStruct, substructs);
                }
            }
            HashSet<OCQualifiedName> hashSet = curSubstructs = p.myIsFriendOrStatic ? new HashSet<OCQualifiedName>() : new HashSet(substructs);
            if (p.myIncludeSameSymbols) {
                curSubstructs.add(parentStruct.dropArguments());
            }
            HashMap map2 = new HashMap();
            boolean needSpecificOrder = p.myImplementationsThenPredefinitions || p.myPredefinitionsThenImplementations;
            Processor processor2 = needSpecificOrder ? symbol -> {
                if (p == null) {
                    DefaultExecutor.$$$reportNull$$$0(3);
                }
                OCFunctionSymbol old = (OCFunctionSymbol)map2.get(symbol.getResolvedQualifiedName(resolveContext));
                if (p.myIncludeSameSymbols || old == null || old.isPredeclaration() && p.myImplementationsThenPredefinitions || !old.isPredeclaration() && p.myPredefinitionsThenImplementations) {
                    map2.put(symbol.getResolvedQualifiedName(resolveContext), symbol);
                }
                return true;
            } : consumer;
            OCFile context = p.myContext;
            VirtualFile contextFile = context != null ? context.getContainingFile().getVirtualFile() : null;
            OCType resolved = p.myType != null ? p.myType.resolve(resolveContext) : null;
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(p.myProject, (Processor<OCSymbol>)((Processor)symbol -> {
                if (p == null) {
                    DefaultExecutor.$$$reportNull$$$0(2);
                }
                ProgressManager.checkCanceled();
                if (!(symbol instanceof OCFunctionSymbol) || !scope.accept(symbol.getContainingFile())) {
                    return true;
                }
                OCFunctionSymbol function = (OCFunctionSymbol)symbol;
                if (!p.myIncludeFriendsInResults && (p.myIsFriend || function.isFriend())) {
                    return true;
                }
                OCQualifiedName parentName = OCFunctionInheritorsSearch.getParentResolvedQualifiedName(function, p.myProject);
                if (parentName == null ? parentStruct != OCQualifiedName.GLOBAL || !curSubstructs.contains(OCQualifiedName.GLOBAL) : !curSubstructs.contains(parentName.dropArguments())) {
                    return true;
                }
                if (function.isLocalInFile(resolveContext) && !Comparing.equal((Object)contextFile, (Object)function.getContainingFile())) {
                    return false;
                }
                if (resolved != null && !function.getType().equalsAfterResolving(resolved, resolveContext)) {
                    return true;
                }
                return function.processSameSymbols((Processor<OCSymbol>)((Processor)sameSymbol -> {
                    if (!(sameSymbol instanceof OCFunctionSymbol)) {
                        return true;
                    }
                    return processor2.process((Object)((OCFunctionSymbol)sameSymbol));
                }), p.myProject);
            }), p.myFunctionName);
            if (processor2 != consumer) {
                new CollectionQuery(map2.values()).forEach(consumer);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/search/OCFunctionInheritorsSearch$DefaultExecutor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processQuery";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processQuery$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$processQuery$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SearchParameters {
        private GlobalSearchScope myScope;
        private Project myProject;
        private String myFunctionName;
        private OCType myType;
        private OCFile myContext;
        private OCQualifiedName myParentStruct;
        private boolean myIncludeSameSymbols;
        private boolean myIsFriend;
        private boolean myIsFriendOrStatic;
        private boolean myIncludeFriendsInResults;
        private boolean myIncludeOnlyDirectInheritors;
        private boolean myPredefinitionsThenImplementations;
        private boolean myImplementationsThenPredefinitions;
        private MultiMap<OCQualifiedName, OCQualifiedName> myInheritenceCache;

        public void setIncludeSameSymbols(boolean value) {
            this.myIncludeSameSymbols = value;
        }

        public void setIncludeOnlyDirectInheritors(boolean value) {
            this.myIncludeOnlyDirectInheritors = value;
        }

        public void setIncludeFriendsInResults(boolean includeFriendsInResults) {
            this.myIncludeFriendsInResults = includeFriendsInResults;
        }

        public void setPredeclarationsThenImplementations(boolean value) {
            this.myPredefinitionsThenImplementations = value;
        }

        public void setImplementationsThenPredeclarations(boolean value) {
            this.myImplementationsThenPredefinitions = value;
        }

        public static SearchParameters getSearchFunctionByNameParameters(OCFile context, GlobalSearchScope scope, String name2, OCQualifiedName receiverType) {
            SearchParameters result = new SearchParameters();
            result.myProject = context.getProject();
            result.myContext = context;
            result.myScope = scope;
            result.myFunctionName = name2;
            result.myParentStruct = receiverType;
            return result;
        }

        public static SearchParameters getSearchFunctionBySignatureParameters(OCFile context, GlobalSearchScope scope, String name2, OCType type, OCQualifiedName receiverType) {
            SearchParameters result = new SearchParameters();
            result.myProject = context.getProject();
            result.myContext = context;
            result.myScope = scope;
            result.myFunctionName = name2;
            result.myType = type;
            result.myParentStruct = receiverType;
            return result;
        }

        private SearchParameters() {
        }

        public String toString() {
            return "SearchParameters{myFunctionName='" + this.myFunctionName + '\'' + ", myParentStruct='" + this.myParentStruct + '\'' + ", myType=" + this.myType + ", myContext=" + this.myContext + ", myIncludeSameSymbols=" + this.myIncludeSameSymbols + ", myIsFriend=" + this.myIsFriend + ", myIsFriendOrStatic=" + this.myIsFriendOrStatic + '}';
        }
    }
}

