/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import org.jetbrains.annotations.NotNull;

public class OCPropertyReferencesSearch
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            OCPropertyReferencesSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            OCPropertyReferencesSearch.$$$reportNull$$$0(1);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (queryParameters == null) {
                OCPropertyReferencesSearch.$$$reportNull$$$0(2);
            }
            if (consumer == null) {
                OCPropertyReferencesSearch.$$$reportNull$$$0(3);
            }
            return OCPropertyReferencesSearch.doExecute(queryParameters, consumer);
        });
    }

    private static Boolean doExecute(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer) {
        PsiElement element = queryParameters.getElementToSearch();
        if (!(element instanceof OCSymbolDeclarator)) {
            return true;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (!(symbol instanceof OCPropertySymbol)) {
            return true;
        }
        OCPropertySymbol property = (OCPropertySymbol)symbol;
        return ((OCClassSymbol)property.getParent()).processMembers(OCMethodSymbol.class, method -> method.getGeneratedFromProperty() != property || OCPropertyReferencesSearch.processMethod(queryParameters, method, element, consumer));
    }

    private static boolean processMethod(ReferencesSearch.SearchParameters queryParameters, OCMethodSymbol method, PsiElement declarator, Processor<PsiReference> consumer) {
        String methodSelector = method.getName();
        TextOccurenceProcessor processor2 = (element, offsetInElement) -> {
            PsiReference ref;
            String selector = null;
            if (element instanceof OCSendMessageExpression) {
                selector = ((OCSendMessageExpression)element).getMessageSelector();
            } else if (element instanceof OCSelectorExpression) {
                selector = ((OCSelectorExpression)element).getSelector();
            } else if (element instanceof OCQualifiedExpression) {
                selector = ((OCQualifiedExpression)element).getName();
            }
            if (methodSelector.equals(selector) && (ref = element.getReference()) != null && ref.isReferenceTo(declarator)) {
                return consumer.process((Object)ref);
            }
            return true;
        };
        PsiSearchHelper helper = PsiSearchHelper.SERVICE.getInstance((Project)declarator.getProject());
        return helper.processElementsWithWord(processor2, queryParameters.getEffectiveSearchScope(), methodSelector, (short)1, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/search/OCPropertyReferencesSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

