/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCConstructorInEmptyInitializationUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCExternalReferenceUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCPropertyAttributeUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorImplicitReferenceSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchUtil {
    @NotNull
    public static Collection<VirtualFile> getProjectVirtualFilesByName(@NotNull Project project2, @NotNull String name2) {
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            OCSearchUtil.$$$reportNull$$$0(1);
        }
        Collection collection = FilenameIndex.getVirtualFilesByName((Project)project2, (String)name2, (boolean)SystemInfo.isFileSystemCaseSensitive, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project2));
        if (collection == null) {
            OCSearchUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public static List<OCFile> getProjectOCFilesByName(@NotNull Project project2, @NotNull String name2) {
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(3);
        }
        if (name2 == null) {
            OCSearchUtil.$$$reportNull$$$0(4);
        }
        List<OCFile> list = OCSearchUtil.getOCFilesByName(project2, name2, GlobalSearchScope.projectScope((Project)project2));
        if (list == null) {
            OCSearchUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<OCFile> getOCFilesByName(@NotNull Project project2, @NotNull String name2, @NotNull GlobalSearchScope scope) {
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            OCSearchUtil.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            OCSearchUtil.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter((Object[])FilenameIndex.getFilesByName((Project)project2, (String)name2, (GlobalSearchScope)scope), (Condition)new FilteringIterator.InstanceOf(OCFile.class));
        if (list == null) {
            OCSearchUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(@Nullable T member, @NotNull Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors, @NotNull Project project2) {
        if (processor2 == null) {
            OCSearchUtil.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(11);
        }
        return OCSearchUtil.processMembersHierarchy(member, processor2, searchAncestors, searchInheritors, true, project2);
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(@Nullable T member, @NotNull Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors, boolean includeSameSymbols, Project project2) {
        if (processor2 == null) {
            OCSearchUtil.$$$reportNull$$$0(12);
        }
        if (member instanceof OCFunctionSymbol) {
            OCFile file = member.getContainingOCFile(project2);
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)member;
            if (searchInheritors && file != null) {
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(functionSymbol, file, true);
                parameters.setIncludeSameSymbols(includeSameSymbols);
                parameters.setIncludeFriendsInResults(functionSymbol.isFriend());
                if (!OCFunctionInheritorsSearch.search(parameters).forEach(processor2)) {
                    return false;
                }
            }
            if (searchAncestors && !new OCFunctionAncestorsQuery(functionSymbol, true, includeSameSymbols, project2).forEach(processor2)) {
                return false;
            }
        }
        if (member instanceof OCMemberSymbol) {
            OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)member, project2);
            parameters.setIncludeSelfImplementation(includeSameSymbols);
            parameters.setInheritors(searchInheritors);
            parameters.setAncestors(searchAncestors);
            if (!OCMemberInheritorsSearch.search(parameters).forEach(processor2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean processMembersHierarchyPsi(@Nullable OCSymbolWithParent member, @NotNull Processor<PsiElement> processor2, boolean searchAncestors, boolean searchInheritors, @NotNull Project project2) {
        if (processor2 == null) {
            OCSearchUtil.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(14);
        }
        return OCSearchUtil.processMembersHierarchy(member, symbol -> {
            Object overridingMethod;
            if (project2 == null) {
                OCSearchUtil.$$$reportNull$$$0(44);
            }
            if (processor2 == null) {
                OCSearchUtil.$$$reportNull$$$0(45);
            }
            if ((overridingMethod = symbol.locateDefinition(project2)) instanceof OCDeclarator) {
                overridingMethod = overridingMethod.getParent();
            }
            if (overridingMethod != null) {
                return processor2.process(overridingMethod);
            }
            return true;
        }, searchAncestors, searchInheritors, project2);
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> _")
    public static Ancestor findSomeAncestor(@Nullable OCSymbolWithParent member, @NotNull Project project2) {
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(15);
        }
        AncestorBuilder result = new AncestorBuilder();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            if (project2 == null) {
                OCSearchUtil.$$$reportNull$$$0(43);
            }
            result.symbol = symbol;
            if (!OCSearchScope.isInProjectSources(symbol, project2)) {
                result.isOutOfProject = true;
                return false;
            }
            return true;
        }, true, false, false, project2);
        return result.getAncestor();
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> _")
    public static Ancestor findSomeInProjectAncestor(@Nullable OCSymbolWithParent member, @NotNull Project project2) {
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(16);
        }
        AncestorBuilder result = new AncestorBuilder();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            if (project2 == null) {
                OCSearchUtil.$$$reportNull$$$0(42);
            }
            if (OCSearchScope.isInProjectSources(symbol, project2)) {
                result.symbol = symbol;
                return false;
            }
            return true;
        }, true, false, false, project2);
        return result.getAncestor();
    }

    public static boolean processMemberAncestors(@Nullable OCSymbolWithParent member, @NotNull Processor<? super OCSymbolWithParent> processor2, boolean onlyDeclarations, @NotNull Project project2) {
        if (processor2 == null) {
            OCSearchUtil.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(18);
        }
        return OCSearchUtil.processMembersHierarchy(member, ancestor -> {
            if (project2 == null) {
                OCSearchUtil.$$$reportNull$$$0(40);
            }
            if (processor2 == null) {
                OCSearchUtil.$$$reportNull$$$0(41);
            }
            if (onlyDeclarations && ancestor.isDefinition() && OCSearchUtil.getFirstPredeclaration(ancestor, project2) != null || ancestor.equals(member)) {
                return true;
            }
            return processor2.process(ancestor);
        }, true, false, true, project2);
    }

    public static boolean findAllMemberUsages(@Nullable OCSymbolWithParent member, @NotNull Set<UsageInfo> result, boolean searchInheritors, boolean searchAncestors, @NotNull Project project2) {
        if (result == null) {
            OCSearchUtil.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(20);
        }
        return OCSearchUtil.processMembersHierarchyPsi(member, (Processor<PsiElement>)((Processor)element -> {
            if (result == null) {
                OCSearchUtil.$$$reportNull$$$0(39);
            }
            OCSearchUtil.findOneMethodUsages(element, result);
            return true;
        }), searchAncestors, searchInheritors, project2);
    }

    public static void findOneMethodUsages(@NotNull PsiElement method, @NotNull Set<UsageInfo> result) {
        if (method == null) {
            OCSearchUtil.$$$reportNull$$$0(21);
        }
        if (result == null) {
            OCSearchUtil.$$$reportNull$$$0(22);
        }
        GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(method.getProject());
        if (method instanceof OCFunctionDeclaration) {
            OCDeclarator declarator = ((OCFunctionDeclaration)method).getDeclarator();
            if (declarator != null) {
                for (PsiReference ref : ReferencesSearch.search((PsiElement)declarator, (SearchScope)scope).findAll()) {
                    if (ref.getElement() == null || !((Object)((Object)OCLanguage.getInstance())).equals(ref.getElement().getLanguage())) continue;
                    result.add(new OCFunctionUsage(ref));
                }
                for (PsiReference ref : OCConstructorImplicitReferenceSearch.search(declarator, (SearchScope)scope)) {
                    result.add(new OCConstructorInEmptyInitializationUsage((OCBaseConstructorReference)ref));
                }
            }
        } else if (method instanceof OCMethod) {
            Processor consumer = psiReference -> {
                if (result == null) {
                    OCSearchUtil.$$$reportNull$$$0(38);
                }
                if (psiReference instanceof OCExternalReference) {
                    result.add(new OCExternalReferenceUsage((OCExternalReference)psiReference));
                    return true;
                }
                PsiElement element = psiReference.getElement();
                if (element instanceof OCSendMessageExpression) {
                    result.add(new OCMethodCallUsage((PsiReference)psiReference));
                } else if (element instanceof OCSelectorExpression) {
                    result.add(new OCSelectorExpressionUsage((PsiReference)psiReference));
                } else if (element instanceof OCPropertyAttribute) {
                    result.add(new OCPropertyAttributeUsage((PsiReference)psiReference));
                } else if (element instanceof OCQualifiedExpression) {
                    result.add(new OCMethodDotCallUsage((PsiReference)psiReference));
                }
                return true;
            };
            ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).forEach(consumer);
        }
    }

    public static boolean hasRelatedSymbols(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(23);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(24);
        }
        Ref result = Ref.create((Object)false);
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (symbol == null) {
                OCSearchUtil.$$$reportNull$$$0(37);
            }
            if (s instanceof OCStructSymbol && !s.isPredeclaration() && !symbol.equals(s)) {
                result.set((Object)true);
                return false;
            }
            return true;
        }), project2);
        return (Boolean)result.get();
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(25);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(26);
        }
        List<OCSymbol> list = OCSearchUtil.getRelatedSymbols(symbol, false, project2);
        if (list == null) {
            OCSearchUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, boolean excludeProcessingSymbol, @NotNull Project project2) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(28);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(29);
        }
        ArrayList<OCSymbol> result = new ArrayList<OCSymbol>();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (symbol == null) {
                OCSearchUtil.$$$reportNull$$$0(36);
            }
            if (excludeProcessingSymbol && symbol.equals(s)) {
                return true;
            }
            if (s instanceof OCStructSymbol && !s.isPredeclaration()) {
                if (((OCStructSymbol)s).isSpecialization()) {
                    if (!s.isPredeclaration()) {
                        result.add((OCSymbol)s);
                    }
                } else {
                    result.add(0, (OCSymbol)s);
                }
            }
            return true;
        }), project2);
        ArrayList<OCSymbol> arrayList = result;
        if (arrayList == null) {
            OCSearchUtil.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    public static boolean processPredeclarations(@NotNull OCSymbol symbol, @NotNull Processor<OCSymbol> processor2, @NotNull Project project2) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(31);
        }
        if (processor2 == null) {
            OCSearchUtil.$$$reportNull$$$0(32);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(33);
        }
        return symbol.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(s -> s.isPredeclaration(), processor2), project2);
    }

    @Nullable
    public static OCSymbol getFirstPredeclaration(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            OCSearchUtil.$$$reportNull$$$0(34);
        }
        if (project2 == null) {
            OCSearchUtil.$$$reportNull$$$0(35);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCSearchUtil.processPredeclarations(symbol, (Processor<OCSymbol>)finder, project2);
        return (OCSymbol)finder.getFoundValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 27: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 27: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/OCSearchUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 32: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 19: 
            case 22: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/OCSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectVirtualFilesByName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectOCFilesByName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCFilesByName";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProjectVirtualFilesByName";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 27: 
            case 30: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectOCFilesByName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOCFilesByName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processMembersHierarchy";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processMembersHierarchyPsi";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSomeAncestor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findSomeInProjectAncestor";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processMemberAncestors";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findAllMemberUsages";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findOneMethodUsages";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasRelatedSymbols";
                break;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedSymbols";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processPredeclarations";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getFirstPredeclaration";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRelatedSymbols$7";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$hasRelatedSymbols$6";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findOneMethodUsages$5";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findAllMemberUsages$4";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMemberAncestors$3";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSomeInProjectAncestor$2";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findSomeAncestor$1";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMembersHierarchyPsi$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 27: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AncestorBuilder {
        @Nullable
        private OCSymbolWithParent symbol;
        private boolean isOutOfProject;

        private AncestorBuilder() {
        }

        @Nullable
        private Ancestor getAncestor() {
            return this.symbol != null ? new Ancestor(this.symbol, this.isOutOfProject) : null;
        }
    }

    public static class Ancestor {
        @NotNull
        private final OCSymbolWithParent symbol;
        private final boolean isOutOfProject;

        private Ancestor(@NotNull OCSymbolWithParent symbol, boolean isOutOfProject) {
            if (symbol == null) {
                Ancestor.$$$reportNull$$$0(0);
            }
            this.symbol = symbol;
            this.isOutOfProject = isOutOfProject;
        }

        @NotNull
        public OCSymbolWithParent getSymbol() {
            OCSymbolWithParent oCSymbolWithParent = this.symbol;
            if (oCSymbolWithParent == null) {
                Ancestor.$$$reportNull$$$0(1);
            }
            return oCSymbolWithParent;
        }

        public boolean isOutOfProject() {
            return this.isOutOfProject;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/search/OCSearchUtil$Ancestor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/search/OCSearchUtil$Ancestor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

