/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCType;
import org.jetbrains.annotations.NotNull;

public abstract class OCBaseConstructorReference
implements PsiReference {
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final OCSymbolDeclarator myField;
    @NotNull
    protected final OCFunctionSymbol myTargetConstructor;

    public OCBaseConstructorReference(@NotNull PsiElement element, @NotNull OCSymbolDeclarator field, @NotNull OCFunctionSymbol targetConstructor) {
        if (element == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(0);
        }
        if (field == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(1);
        }
        if (targetConstructor == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(2);
        }
        this.myElement = element;
        this.myField = field;
        this.myTargetConstructor = targetConstructor;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public PsiElement resolve() {
        return this.myTargetConstructor.locateDefinition(this.myElement.getProject());
    }

    @NotNull
    public OCFunctionSymbol getTargetConstructor() {
        OCFunctionSymbol oCFunctionSymbol = this.myTargetConstructor;
        if (oCFunctionSymbol == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(3);
        }
        return oCFunctionSymbol;
    }

    @NotNull
    public OCSymbolDeclarator getField() {
        OCSymbolDeclarator oCSymbolDeclarator = this.myField;
        if (oCSymbolDeclarator == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(4);
        }
        return oCSymbolDeclarator;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(5);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof OCFunctionDeclaration)) {
            return false;
        }
        OCSymbol symbol = ((OCFunctionDeclaration)element).getSymbol();
        if (Comparing.equal((Object)this.myTargetConstructor, (Object)symbol)) {
            return true;
        }
        if (symbol != null && symbol.isGlobal()) {
            OCQualifiedName symbolName;
            OCResolveContext context = OCResolveContext.forPsi(element);
            OCQualifiedName thisName = this.myTargetConstructor.getResolvedQualifiedName(context);
            if (Comparing.equal((Object)thisName, (Object)(symbolName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName(context)))) {
                OCType symbolType;
                OCType thisResolvedType;
                return !(symbol instanceof OCFunctionSymbol) || (thisResolvedType = this.myTargetConstructor.getResolvedType(context)).equals(symbolType = symbol.getResolvedType(context), context);
            }
            return false;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = new Object[]{};
        if (objectArray == null) {
            OCBaseConstructorReference.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetConstructor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/constructors/OCBaseConstructorReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetConstructor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

