/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.constructors;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCConstructorReferenceSearchBase
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            OCConstructorReferenceSearchBase.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            OCConstructorReferenceSearchBase.$$$reportNull$$$0(1);
        }
        PsiElement element = queryParameters.getElementToSearch();
        PsiElement parent = (PsiElement)ReadAction.compute(() -> ((PsiElement)element).getParent());
        if (!(parent instanceof OCFunctionDeclaration)) {
            return true;
        }
        OCFunctionDeclaration constructor = (OCFunctionDeclaration)parent;
        SearchWordAndProcessor searchWordAndProcessor = (SearchWordAndProcessor)ReadAction.compute(() -> {
            if (queryParameters == null) {
                OCConstructorReferenceSearchBase.$$$reportNull$$$0(4);
            }
            if (consumer == null) {
                OCConstructorReferenceSearchBase.$$$reportNull$$$0(5);
            }
            return this.getSearchWordAndProcessor(queryParameters, consumer, constructor);
        });
        if (searchWordAndProcessor == null) {
            return true;
        }
        PsiSearchHelper helper = (PsiSearchHelper)ReadAction.compute(() -> {
            Project project2 = element.getProject();
            if (project2.isDisposed()) {
                throw new ProcessCanceledException();
            }
            return PsiSearchHelper.SERVICE.getInstance((Project)project2);
        });
        return helper.processElementsWithWord(searchWordAndProcessor.myProcessor, queryParameters.getEffectiveSearchScope(), searchWordAndProcessor.mySearchWord, (short)1, true);
    }

    @Nullable
    private SearchWordAndProcessor getSearchWordAndProcessor(ReferencesSearch.SearchParameters queryParameters, Processor<PsiReference> consumer, OCFunctionDeclaration constructor) {
        OCFunctionSymbol constructorPredefinition;
        OCSymbolWithQualifiedName constructorSymbol = (OCSymbolWithQualifiedName)constructor.getSymbol();
        if (!(constructorSymbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)constructorSymbol).isCppConstructor()) {
            return null;
        }
        String searchWord = constructor.getName();
        if (searchWord == null) {
            return null;
        }
        OCFunctionSymbol predefinition = (OCFunctionSymbol)OCSearchUtil.getFirstPredeclaration(constructorSymbol, constructor.getProject());
        OCFunctionSymbol oCFunctionSymbol = constructorPredefinition = predefinition != null ? predefinition : (OCFunctionSymbol)constructorSymbol;
        if (!(constructorPredefinition.getParent() instanceof OCStructSymbol)) {
            return null;
        }
        OCStructSymbol structSymbol = (OCStructSymbol)constructorPredefinition.getParent();
        OCStructType structType = structSymbol.getType();
        CommonProcessors.CollectProcessor constructors = new CommonProcessors.CollectProcessor();
        constructors.process((Object)structSymbol);
        structSymbol.processConstructors((Processor<? super OCFunctionSymbol>)constructors, OCResolveContext.forPsi(constructor));
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        TextOccurenceProcessor processor2 = (element, offsetInElement) -> {
            OCSymbol symbol;
            PsiElement parent = element.getParent();
            if (parent instanceof OCTypeElement && parent.getContext() instanceof OCDeclaration) {
                OCDeclaration declaration = (OCDeclaration)parent.getContext();
                if (PsiTreeUtil.getContextOfType((PsiElement)declaration, (Class[])new Class[]{OCParameterList.class}) != null) {
                    return true;
                }
                if (declaration.getParent() instanceof OCStruct) {
                    OCStructSymbol symbol2 = (OCStructSymbol)((OCStruct)declaration.getParent()).getSymbol();
                    OCResolveContext context = OCResolveContext.forPsi(declaration);
                    for (OCDeclarator declarator : declaration.getDeclarators()) {
                        if (!declarator.getType().resolve(context).equals(structType, context)) {
                            return true;
                        }
                        if (this.processStructFieldInitializers(symbol2, declarator, structType, constructorPredefinition, constructors.getResults(), consumer, searchScope)) continue;
                        this.onReferenceFromStruct((OCStruct)declaration.getParent(), declarator, constructorPredefinition, consumer);
                    }
                    return true;
                }
                for (OCDeclarator declarator : declaration.getDeclarators()) {
                    for (PsiReference ref : declarator.getReferences()) {
                        if (!ref.isReferenceTo((PsiElement)constructor) || this.onReferenceFromDeclarator(declarator, constructorPredefinition, consumer)) continue;
                        return false;
                    }
                }
            } else if (parent instanceof OCCppBaseClause) {
                OCStructSymbol symbol3;
                OCStruct struct = (OCStruct)parent.getContext().getContext();
                OCStructSymbol oCStructSymbol = symbol3 = struct != null ? (OCStructSymbol)struct.getSymbol() : null;
                if (symbol3 != null && !this.processStructFieldInitializers(symbol3, constructor, structType, constructorPredefinition, constructors.getResults(), consumer, searchScope)) {
                    this.onReferenceFromStruct(struct, constructor, constructorPredefinition, consumer);
                }
            } else if (parent instanceof OCCppUsingStatement && (symbol = ((OCCppUsingStatement)parent).getLocalSymbol()) instanceof OCUsingSymbol && ((OCUsingSymbol)symbol).getSymbolReference().resolveToSymbols(OCResolveContext.forPsi(element)).contains(constructorPredefinition) && !this.onReferenceFromUsing((OCCppUsingStatement)parent, constructorPredefinition, consumer)) {
                return false;
            }
            return true;
        };
        return new SearchWordAndProcessor(searchWord, processor2);
    }

    private boolean processStructFieldInitializers(@Nullable OCStructSymbol symbol, @NotNull OCSymbolDeclarator member, OCStructType constructorOwner, OCFunctionSymbol constructor, Collection<OCSymbol> constructors, Processor<PsiReference> consumer, SearchScope searchScope) {
        if (member == null) {
            OCConstructorReferenceSearchBase.$$$reportNull$$$0(2);
        }
        if (symbol == null) {
            return false;
        }
        Ref hasConstructors = new Ref((Object)false);
        OCResolveContext context = OCResolveContext.forPsi(member);
        symbol.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)symbol1 -> {
            if (member == null) {
                OCConstructorReferenceSearchBase.$$$reportNull$$$0(3);
            }
            hasConstructors.set((Object)true);
            if (symbol1.getKind().isConstructorOrDestructor() && !symbol1.isPredeclaration()) {
                Object psiElement = symbol1.locateDefinition(member.getProject());
                if (!(psiElement instanceof OCDeclarator)) {
                    return true;
                }
                OCFunctionDefinition definition = (OCFunctionDefinition)psiElement.getParent();
                OCConstructorInitializationList initializationList = definition.getConstructorInitializationList();
                boolean found = false;
                if (initializationList != null) {
                    if (!OCConstructorReferenceSearchBase.isInScope(searchScope, initializationList)) {
                        return true;
                    }
                    for (OCConstructorFieldInitializer initializer : initializationList.getInitializers()) {
                        OCArgumentsList<OCExpression> argumentsList;
                        OCSymbol resolved;
                        OCReferenceElement field = initializer.getReferenceElement();
                        if (field == null || !field.getReference().isReferenceTo((PsiElement)member)) continue;
                        if (member instanceof OCFunctionDefinition) {
                            found = true;
                            break;
                        }
                        OCSymbol fieldSymbol = field.resolveToSymbol();
                        if (fieldSymbol == null || !constructorOwner.equals(fieldSymbol.getResolvedType(context), context) || !Comparing.equal((Object)(resolved = OCResolveOverloadsUtil.resolveOverloads(constructors, argumentsList = OCArgumentsList.getArgumentList(initializer.getInitializers()), null, null, null, false, false, true, false, false, context)), (Object)constructor)) continue;
                        found = true;
                        this.onReferenceFromInitializer(initializer, member, constructor, consumer);
                        break;
                    }
                }
                if (!found && constructor.getNonInitializedParametersCount(context) == 0) {
                    this.onReferenceFromOtherConstructor(definition, member, constructor, consumer);
                }
            }
            return true;
        }), true, context);
        return (Boolean)hasConstructors.get();
    }

    private static boolean isInScope(SearchScope scope, PsiElement element) {
        PsiFile file = element.getContainingFile();
        if (scope instanceof GlobalSearchScope) {
            return scope.contains(file.getVirtualFile());
        }
        if (scope instanceof LocalSearchScope) {
            return ((LocalSearchScope)scope).containsRange(file, element.getTextRange());
        }
        return false;
    }

    protected abstract boolean onReferenceFromInitializer(OCConstructorFieldInitializer var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<PsiReference> var4);

    protected abstract boolean onReferenceFromOtherConstructor(OCFunctionDefinition var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<PsiReference> var4);

    protected abstract boolean onReferenceFromStruct(OCStruct var1, OCSymbolDeclarator var2, OCFunctionSymbol var3, Processor<PsiReference> var4);

    protected abstract boolean onReferenceFromDeclarator(OCDeclarator var1, OCFunctionSymbol var2, Processor<PsiReference> var3);

    protected abstract boolean onReferenceFromUsing(OCCppUsingStatement var1, OCFunctionSymbol var2, Processor<PsiReference> var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/search/constructors/OCConstructorReferenceSearchBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processStructFieldInitializers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processStructFieldInitializers$3";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SearchWordAndProcessor {
        final String mySearchWord;
        final TextOccurenceProcessor myProcessor;

        SearchWordAndProcessor(String searchWord, TextOccurenceProcessor processor2) {
            this.mySearchWord = searchWord;
            this.myProcessor = processor2;
        }
    }
}

