/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchScope {
    private static final Key<GlobalSearchScope> PROJECT_SOURCES_SCOPE = Key.create((String)"PROJECT_SOURCES_SCOPE");
    private static final Key<CachedValue<Collection<VirtualFile>>> EXPLICIT_PROJECT_SOURCE_FILES = Key.create((String)"EXPLICIT_PROJECT_SOURCE_FILES");

    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project2, boolean includeNonProjectFiles) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(0);
        }
        GlobalSearchScope globalSearchScope = includeNonProjectFiles ? ProjectScope.getAllScope((Project)project2) : OCSearchScope.getProjectSourcesScope(project2);
        if (globalSearchScope == null) {
            OCSearchScope.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project2) {
        GlobalSearchScope cached;
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(2);
        }
        GlobalSearchScope globalSearchScope = (cached = (GlobalSearchScope)project2.getUserData(PROJECT_SOURCES_SCOPE)) != null ? cached : (GlobalSearchScope)((UserDataHolderEx)project2).putUserDataIfAbsent(PROJECT_SOURCES_SCOPE, (Object)OCSearchScope.createProjectSourcesScope(project2));
        if (globalSearchScope == null) {
            OCSearchScope.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public static SearchScope restrictScopeToOCFiles(@NotNull SearchScope originalScope) {
        if (originalScope == null) {
            OCSearchScope.$$$reportNull$$$0(4);
        }
        if (originalScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)originalScope), (FileType[])new FileType[]{OCFileType.INSTANCE});
            if (globalSearchScope == null) {
                OCSearchScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }
        SearchScope searchScope = originalScope;
        if (searchScope == null) {
            OCSearchScope.$$$reportNull$$$0(6);
        }
        return searchScope;
    }

    @NotNull
    private static DelegatingGlobalSearchScope createProjectSourcesScope(@NotNull Project project2) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(7);
        }
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)project2)){

            @NotNull
            public String getDisplayName() {
                if ("Project Source Files" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Project Source Files";
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                return OCSearchScope.isInProjectSources(index, file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (delegatingGlobalSearchScope == null) {
            OCSearchScope.$$$reportNull$$$0(8);
        }
        return delegatingGlobalSearchScope;
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project2) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(9);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, EXPLICIT_PROJECT_SOURCE_FILES, () -> {
            if (project2 == null) {
                OCSearchScope.$$$reportNull$$$0(21);
            }
            THashSet result = new THashSet();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
            final ProjectFileIndex index = rootManager.getFileIndex();
            final FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
            for (VirtualFile eachSourceRoot : rootManager.getContentSourceRoots()) {
                VfsUtilCore.visitChildrenRecursively((VirtualFile)eachSourceRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)result){
                    final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                        super(arg0);
                    }

                    public boolean visitFile(@NotNull VirtualFile each) {
                        if (each == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (index.isExcluded(each) || typeRegistry.isFileIgnored(each)) {
                            return false;
                        }
                        if (!each.isDirectory() && OCSearchScope.isInProjectSources(index, each)) {
                            this.val$result.add(each);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "each", "com/jetbrains/cidr/lang/search/scopes/OCSearchScope$2", "visitFile"));
                    }
                });
            }
            return CachedValueProvider.Result.create(Collections.unmodifiableCollection(result), OCSearchScope.getProjectSourcesCacheDependencies(project2));
        }, false);
        if (collection == null) {
            OCSearchScope.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static Collection<?> getProjectSourcesCacheDependencies(@NotNull Project project2) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(11);
        }
        List<ModificationTracker> list = Arrays.asList(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)project2));
        if (list == null) {
            OCSearchScope.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Contract(value="null, _->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol, Project project2) {
        return OCSearchScope.isInProjectSources((PsiElement)OCSearchScope.getContainingFile(symbol, project2));
    }

    @Nullable
    private static PsiFile getContainingFile(@Nullable OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(13);
        }
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile(project2);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && OCSearchScope.isInProjectSources(element.getProject(), OCSearchScope.getVirtualFile(element));
    }

    public static boolean isInProjectSources(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(14);
        }
        return OCSearchScope.isInProjectSources(ProjectRootManager.getInstance((Project)project2).getFileIndex(), file);
    }

    private static boolean isInProjectSources(@NotNull ProjectFileIndex index, @Nullable VirtualFile file) {
        if (index == null) {
            OCSearchScope.$$$reportNull$$$0(15);
        }
        return file != null && index.isInSourceContent(file) && !index.isInLibrarySource(file) && !index.isInLibraryClasses(file);
    }

    public static boolean isInProjectNonSources(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(16);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return file != null && index.isInContent(file) && !index.isInSourceContent(file) && !index.isInLibrarySource(file) && !index.isInLibraryClasses(file);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScope.isInProjectSourcesOrLibraries(element.getProject(), OCSearchScope.getVirtualFile(element));
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(17);
        }
        if (file == null) {
            return false;
        }
        return OCSearchScope.getProjectSourcesScope(project2).contains(file) || ProjectScope.getLibrariesScope((Project)project2).contains(file);
    }

    @Contract(value="null, _->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(18);
        }
        return OCSearchScope.isInLibraries((PsiElement)OCSearchScope.getContainingFile(symbol, project2));
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file = OCSearchScope.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        return OCSearchScope.isInLibraries(file, element.getProject());
    }

    public static boolean isInLibraries(@NotNull VirtualFile file, @NotNull Project project2) {
        if (file == null) {
            OCSearchScope.$$$reportNull$$$0(19);
        }
        if (project2 == null) {
            OCSearchScope.$$$reportNull$$$0(20);
        }
        return ProjectScope.getLibrariesScope((Project)project2).contains(file);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiCodeFragment) {
            PsiElement context = file.getContext();
            file = context == null ? null : context.getContainingFile();
        }
        return file == null ? null : OCInclusionContextUtil.getVirtualFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/scopes/OCSearchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoSymbolScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeToOCFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectSourcesScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSourcesCacheDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getGotoSymbolScope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeToOCFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createProjectSourcesScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitlySpecifiedProjectSourceFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProjectSourcesCacheDependencies";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSources";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectNonSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isInProjectSourcesOrLibraries";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInLibraries";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExplicitlySpecifiedProjectSourceFiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

