/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProjectSourcesScopeProvider
extends CustomScopesProviderEx {
    private List<NamedScope> myScopes = ContainerUtil.immutableList((Object[])new NamedScope[]{new SourceFilesScope(), new NonSourceFilesScope()});

    @NotNull
    public List<NamedScope> getCustomScopes() {
        List<NamedScope> list = this.myScopes;
        if (list == null) {
            ProjectSourcesScopeProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/search/scopes/ProjectSourcesScopeProvider", "getCustomScopes"));
    }

    public static class NonSourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Non-Source Files";

        public NonSourceFilesScope() {
            super(NAME, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(VirtualFile file, NamedScopesHolder holder) {
                    return OCSearchScope.isInProjectNonSources(holder.getProject(), file);
                }
            });
        }
    }

    public static class SourceFilesScope
    extends NamedScope {
        public static final String NAME = "Project Source Files";

        public SourceFilesScope() {
            super(NAME, (PackageSet)new AbstractPackageSet(NAME){

                public boolean contains(VirtualFile file, NamedScopesHolder holder) {
                    return OCSearchScope.isInProjectSources(holder.getProject(), file);
                }
            });
        }
    }
}

