/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.psi.PsiElement;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;

public class OCUsageTypeProvider
implements UsageTypeProvider {
    private static final UsageType SUPER_CLASS = new UsageType("Superclass reference");
    private static final UsageType PROTOCOL_LIST = new UsageType("Protocol reference");
    private static final UsageType MESSAGE_RECEIVER = new UsageType("Message receiver");
    private static final UsageType QUALIFIER = new UsageType("Qualifier");
    private static final UsageType MEMBER_ACCESS = new UsageType("Member access");
    private static final UsageType VARIABLE_DECLARATION = new UsageType("Variable declaration");
    private static final UsageType PARAMETER_DECLARATION = new UsageType("Parameter declaration");
    private static final UsageType METHOD_CALL = new UsageType("Method call");
    private static final UsageType PROPERTY_ATTRIBUTE = new UsageType("Usage in property attribute");
    private static final UsageType SELECTOR_EXPRESSION = new UsageType("Selector expression");
    private static final UsageType SYNTHESIZE = new UsageType("Usage in synthesize statement");
    private static final UsageType CLASS_PREDECLARATION = new UsageType("Class predeclaration");
    private static final UsageType PROTOCOL_PREDECLARATION = new UsageType("Protocol predeclaration");
    private static final UsageType NAMESPACE_QUALIFIER = new UsageType("Namespace qualifier");
    private static final UsageType INSIDE_MACRO_SUBSTITUTION = new UsageType("Inside macro substitution");

    public UsageType getUsageType(PsiElement element) {
        PsiElement superParent;
        PsiElement parent = element.getParent();
        PsiElement psiElement = superParent = parent != null ? parent.getParent() : null;
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return INSIDE_MACRO_SUBSTITUTION;
        }
        if (element instanceof OCCppNamespaceQualifier) {
            return NAMESPACE_QUALIFIER;
        }
        if (element instanceof OCSendMessageExpression) {
            return METHOD_CALL;
        }
        if (element instanceof OCPropertyAttribute) {
            return PROPERTY_ATTRIBUTE;
        }
        if (element instanceof OCSelectorExpression) {
            return SELECTOR_EXPRESSION;
        }
        if (element instanceof OCIncludeDirective) {
            return UsageType.CLASS_IMPORT;
        }
        if (element instanceof OCClassPredeclaration) {
            return ((OCClassPredeclaration)element).isProtocol() ? PROTOCOL_PREDECLARATION : CLASS_PREDECLARATION;
        }
        if (element instanceof OCQualifiedExpression) {
            return MEMBER_ACCESS;
        }
        if (parent instanceof OCSuperClassRef || parent instanceof OCCppBaseClause) {
            return SUPER_CLASS;
        }
        if (parent instanceof OCProtocolList || parent instanceof OCReferenceElement) {
            return PROTOCOL_LIST;
        }
        if (superParent instanceof OCCastExpression) {
            return UsageType.CLASS_CAST_TO;
        }
        if (parent instanceof OCSynthesizeProperty) {
            return SYNTHESIZE;
        }
        if (parent instanceof OCReferenceExpression) {
            if (superParent instanceof OCSendMessageExpression) {
                return MESSAGE_RECEIVER;
            }
            if (superParent instanceof OCQualifiedExpression) {
                return QUALIFIER;
            }
        }
        if (parent instanceof OCTypeElement) {
            if (superParent instanceof OCMethod) {
                return UsageType.CLASS_METHOD_RETURN_TYPE;
            }
            if (superParent instanceof OCMethodSelectorPart || superParent instanceof OCParameterDeclaration) {
                return PARAMETER_DECLARATION;
            }
            if (superParent instanceof OCDeclaration) {
                return VARIABLE_DECLARATION;
            }
        }
        return null;
    }
}

