/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileExtensionsSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        MyMasterDetailsComponent myMasterDetailsComponent = new MyMasterDetailsComponent(settings);
        if (myMasterDetailsComponent == null) {
            OCFileExtensionsSettingsProvider.$$$reportNull$$$0(0);
        }
        return myMasterDetailsComponent;
    }

    @Nullable
    public String getConfigurableDisplayName() {
        return OCBundle.message("fileExtensions.tabName", new Object[0]);
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @Nullable
    public Language getLanguage() {
        return OCLanguage.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider", "createSettingsPage"));
    }

    private static class MyMasterDetailsComponent
    extends MasterDetailsComponent
    implements CodeStyleConfigurable {
        private final CodeStyleSettings mySettings;

        public MyMasterDetailsComponent(CodeStyleSettings settings) {
            this.mySettings = settings;
            this.initTree();
            this.myTree.getEmptyText().setText(OCBundle.message("fileExtensions.no.extensions", new Object[0]));
        }

        protected void reInitWholePanelIfNeeded() {
            boolean reinit = this.myToReInitWholePanel;
            super.reInitWholePanelIfNeeded();
            if (reinit) {
                this.getMaster().putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
                this.myWholePanel.setBorder(null);
            }
        }

        @Nullable
        protected ArrayList<AnAction> createActions(boolean fromPopup) {
            ArrayList<AnAction> result = new ArrayList<AnAction>();
            result.add(new MyAddAction());
            result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
            result.add(new MyMoveAction(ExecutionBundle.message((String)"move.up.action.name", (Object[])new Object[0]), IconUtil.getMoveUpIcon(), -1));
            result.add(new MyMoveAction(ExecutionBundle.message((String)"move.down.action.name", (Object[])new Object[0]), IconUtil.getMoveDownIcon(), 1));
            return result;
        }

        @Nls
        public String getDisplayName() {
            return OCBundle.message("fileExtensions.tabName", new Object[0]);
        }

        public void reset() {
            this.reset(this.mySettings);
        }

        public void reset(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                MyMasterDetailsComponent.$$$reportNull$$$0(0);
            }
            this.myRoot.removeAllChildren();
            for (OCCodeStyleSettings.FileExtensionPair pair2 : ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).FILE_EXTENSION_PAIRS_ORDERED) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable(pair2)));
            }
            super.reset();
        }

        public void apply() throws ConfigurationException {
            this.apply(this.mySettings);
        }

        public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
            if (settings == null) {
                MyMasterDetailsComponent.$$$reportNull$$$0(1);
            }
            String title = OCBundle.message("fileExtensions.error", new Object[0]);
            if (this.myRoot.getChildCount() == 0) {
                throw new ConfigurationException(OCBundle.message("fileExtensions.noExtensionsError", new Object[0]), title);
            }
            this.checkForEmptyAndDuplicatedNames(OCBundle.message("fileExtensions.extensionPair", new Object[0]), title, MyFileExtensionPairConfigurable.class);
            super.apply();
            Enumeration children = this.myRoot.children();
            ArrayList list = ContainerUtil.newArrayList();
            while (children.hasMoreElements()) {
                list.add((OCCodeStyleSettings.FileExtensionPair)((MasterDetailsComponent.MyNode)children.nextElement()).getConfigurable().getEditableObject());
            }
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).FILE_EXTENSION_PAIRS_ORDERED = ContainerUtil.immutableList((List)list);
        }

        public boolean isModified() {
            ImmutableList<OCCodeStyleSettings.FileExtensionPair> pairs = ((OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
            if (this.myRoot.getChildCount() != pairs.size()) {
                return true;
            }
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node;
                MyFileExtensionPairConfigurable configurable;
                OCCodeStyleSettings.FileExtensionPair editablePair;
                OCCodeStyleSettings.FileExtensionPair originalPair = (OCCodeStyleSettings.FileExtensionPair)pairs.get(i);
                if (!originalPair.equals(editablePair = (configurable = (MyFileExtensionPairConfigurable)(node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable()).getEditableObject())) {
                    return true;
                }
                if (!this.isInitialized(configurable) || !configurable.isModified()) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "settings";
            objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reset";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyFileExtensionPairConfigurable
        extends NamedConfigurable {
            @NotNull
            private OCCodeStyleSettings.FileExtensionPair myFileExtensionPair;
            private ComboBox<String> mySourceExtField;
            private ComboBox<String> myHeaderExtField;
            private ComboBox<NamingConvention> myFileNamingField;

            public MyFileExtensionPairConfigurable() {
                this.myFileExtensionPair = new OCCodeStyleSettings.FileExtensionPair("cpp", "h", NamingConvention.NONE);
            }

            public MyFileExtensionPairConfigurable(OCCodeStyleSettings.FileExtensionPair fileExtensionPair) {
                if (fileExtensionPair == null) {
                    MyFileExtensionPairConfigurable.$$$reportNull$$$0(0);
                }
                this.myFileExtensionPair = fileExtensionPair;
            }

            public void setDisplayName(String name2) {
            }

            public OCCodeStyleSettings.FileExtensionPair getEditableObject() {
                return this.myFileExtensionPair;
            }

            public String getBannerSlogan() {
                return null;
            }

            public JComponent createOptionsPanel() {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBag bag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultAnchor(1, 23).setDefaultInsets(0, 0, 4, 10);
                this.startNewRowWithLabel(panel, bag, OCBundle.message("fileExtensions.sourceExtension", new Object[0]));
                List list = ContainerUtil.sorted(OCFileTypeHelpers.sourceExtensions());
                this.mySourceExtField = new ComboBox((Object[])ArrayUtil.toStringArray((Collection)list));
                panel.add((Component)this.mySourceExtField, bag.next());
                this.mySourceExtField.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MyMasterDetailsComponent.this.TREE_UPDATER.run();
                    }
                });
                this.startNewRowWithLabel(panel, bag, OCBundle.message("fileExtensions.headerExtension", new Object[0]));
                list = ContainerUtil.filter(OCFileTypeHelpers.headerExtensions(), s -> !s.isEmpty() && !"pch".equals(s));
                this.myHeaderExtField = new ComboBox((Object[])ArrayUtil.toStringArray((Collection)ContainerUtil.sorted((Collection)list)));
                panel.add((Component)this.myHeaderExtField, bag.next());
                this.myHeaderExtField.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MyMasterDetailsComponent.this.TREE_UPDATER.run();
                    }
                });
                this.startNewRowWithLabel(panel, bag, OCBundle.message("fileExtensions.fileNamingConvention", new Object[0]));
                NamingConvention[] cs = NamingConvention.values();
                this.myFileNamingField = new ComboBox((Object[])cs);
                panel.add((Component)this.myFileNamingField, bag.next());
                this.myFileNamingField.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        MyMasterDetailsComponent.this.TREE_UPDATER.run();
                    }
                });
                JPanel wrapper = new JPanel(new BorderLayout());
                panel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                wrapper.add((Component)panel, "North");
                return wrapper;
            }

            private void startNewRowWithLabel(JPanel panel, GridBag bag, String labelName) {
                panel.add((Component)new JBLabel(labelName, 2), bag.nextLine().next().anchor(17));
            }

            public String getDisplayName() {
                String sourceExt = this.mySourceExtField == null ? this.myFileExtensionPair.mySourceExt : (String)this.mySourceExtField.getSelectedItem();
                String headerExt = this.myHeaderExtField == null ? this.myFileExtensionPair.myHeaderExt : (String)this.myHeaderExtField.getSelectedItem();
                return new OCCodeStyleSettings.FileExtensionPair(sourceExt, headerExt, this.getSelectedNamingConvention()).toString();
            }

            @Nullable
            public String getHelpTopic() {
                return null;
            }

            public boolean isModified() {
                return !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)this.mySourceExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.mySourceExt) || !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)this.myHeaderExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.myHeaderExt) || !this.myFileExtensionPair.myFileNamingConvention.equals((Object)this.getSelectedNamingConvention());
            }

            public void apply() throws ConfigurationException {
                this.myFileExtensionPair = new OCCodeStyleSettings.FileExtensionPair((String)this.mySourceExtField.getSelectedItem(), (String)this.myHeaderExtField.getSelectedItem(), this.getSelectedNamingConvention());
            }

            @NotNull
            private NamingConvention getSelectedNamingConvention() {
                NamingConvention namingConvention = this.myFileNamingField == null ? this.myFileExtensionPair.myFileNamingConvention : (NamingConvention)((Object)this.myFileNamingField.getSelectedItem());
                if (namingConvention == null) {
                    MyFileExtensionPairConfigurable.$$$reportNull$$$0(1);
                }
                return namingConvention;
            }

            public void reset() {
                this.mySourceExtField.setSelectedItem((Object)this.myFileExtensionPair.mySourceExt.toLowerCase(Locale.getDefault()));
                this.myHeaderExtField.setSelectedItem((Object)this.myFileExtensionPair.myHeaderExt.toLowerCase(Locale.getDefault()));
                this.myFileNamingField.setSelectedItem((Object)this.myFileExtensionPair.myFileNamingConvention);
            }

            public void disposeUIResources() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileExtensionPair";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyFileExtensionPairConfigurable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCFileExtensionsSettingsProvider$MyMasterDetailsComponent$MyFileExtensionPairConfigurable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedNamingConvention";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyMoveAction
        extends AnAction {
            private final int myDirection;

            protected MyMoveAction(String text, Icon icon, int direction) {
                super(text, text, icon);
                this.myDirection = direction;
            }

            public void actionPerformed(AnActionEvent e) {
                TreeUtil.moveSelectedRow((JTree)MyMasterDetailsComponent.this.myTree, (int)this.myDirection);
            }

            public void update(AnActionEvent e) {
                boolean enabled = false;
                TreePath selectionPath = MyMasterDetailsComponent.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    enabled = (this.myDirection < 0 ? treeNode.getPreviousSibling() : treeNode.getNextSibling()) != null;
                }
                e.getPresentation().setEnabled(enabled);
            }
        }

        private class MyAddAction
        extends AnAction {
            public MyAddAction() {
                super(IdeBundle.message((String)"add.scope.popup.title", (Object[])new Object[0]), null, IconUtil.getAddIcon());
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)MyMasterDetailsComponent.this.myTree);
            }

            public void actionPerformed(AnActionEvent e) {
                MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable());
                MyMasterDetailsComponent.this.myRoot.add((MutableTreeNode)node);
                ((DefaultTreeModel)MyMasterDetailsComponent.this.myTree.getModel()).reload((TreeNode)MyMasterDetailsComponent.this.myRoot);
                MyMasterDetailsComponent.this.selectNodeInTree((DefaultMutableTreeNode)node);
            }
        }
    }
}

