/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.OCBaseLanguageCodeStyleSettingsProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCCustomOption;
import com.jetbrains.cidr.lang.settings.OCCustomOptionCpp;
import com.jetbrains.cidr.lang.settings.OCCustomOptionObjC;
import com.jetbrains.cidr.lang.settings.OCGenerateCodeConfigurable;
import com.jetbrains.cidr.lang.settings.OCIndentOptionsEditor;
import org.jetbrains.annotations.NotNull;

public class OCLanguageCodeStyleSettingsProvider
extends OCBaseLanguageCodeStyleSettingsProvider {
    public OCLanguageCodeStyleSettingsProvider() {
        super(OCLanguage.getInstance());
    }

    private static OCCustomOption getCustomOption() {
        return OCLanguage.enableObjectiveCSettings() ? new OCCustomOptionObjC() : new OCCustomOptionCpp();
    }

    @Override
    @NotNull
    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings result = super.getDefaultCommonSettings();
        OCLanguageCodeStyleSettingsProvider.configureDefaultSettings(result);
        CommonCodeStyleSettings commonCodeStyleSettings = result;
        if (commonCodeStyleSettings == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return commonCodeStyleSettings;
    }

    public static void configureDefaultSettings(@NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !PlatformUtils.isAppCode()) {
            settings.ALIGN_MULTILINE_BINARY_OPERATION = true;
            settings.ALIGN_MULTILINE_ASSIGNMENT = true;
            settings.ALIGN_MULTILINE_TERNARY_OPERATION = true;
            settings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = true;
            settings.SPACE_WITHIN_BRACES = true;
            settings.BINARY_OPERATION_WRAP = 1;
            settings.TERNARY_OPERATION_WRAP = 1;
            settings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
            settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
            settings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
            settings.ARRAY_INITIALIZER_WRAP = 1;
            settings.ENUM_CONSTANTS_WRAP = 5;
        }
    }

    public static void configureCustomSettings(@NotNull OCCodeStyleSettings ocSettings) {
        if (ocSettings == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !PlatformUtils.isAppCode()) {
            ocSettings.FUNCTION_PARAMETERS_WRAP = 1;
            ocSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP = 1;
            ocSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP = 1;
            ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
            ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP = 1;
            ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = true;
            ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 1;
            ocSettings.ALIGN_INIT_LIST_IN_COLUMNS = true;
            ocSettings.SPACE_BETWEEN_ADJACENT_BRACKETS = false;
        }
    }

    @NotNull
    public static String getCodeSample(@NotNull String fileNameWithoutExt) {
        if (fileNameWithoutExt == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        String defExampleExtension = OCLanguageCodeStyleSettingsProvider.getCustomOption().getExampleExtension();
        String string = OCLanguageCodeStyleSettingsProvider.getCodeSample(fileNameWithoutExt, defExampleExtension);
        if (string == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getCodeSample(@NotNull String fileNameWithoutExtension, @NotNull String extension) {
        if (fileNameWithoutExtension == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (extension == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        String string = OCCustomOption.ResourceReader.readExampleString(OCCustomOption.class, "formatter/" + extension + "/" + fileNameWithoutExtension + "." + extension);
        if (string == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static OCCustomOption.CustomOption[] getFoldingCustomOptions() {
        OCCustomOption.CustomOption[] customOptionArray = OCLanguageCodeStyleSettingsProvider.getCustomOption().getFoldingCustomOptions();
        if (customOptionArray == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        return customOptionArray;
    }

    @NotNull
    public static AttributesDescriptor[] getAttributeDescriptors() {
        AttributesDescriptor[] attributesDescriptorArray = OCLanguageCodeStyleSettingsProvider.getCustomOption().getAttributeDescriptors();
        if (attributesDescriptorArray == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        return attributesDescriptorArray;
    }

    @Override
    @NotNull
    protected String getCodeSampleContent(@NotNull String fileNameWithoutExt) {
        if (fileNameWithoutExt == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        String string = OCLanguageCodeStyleSettingsProvider.getCodeSample(fileNameWithoutExt);
        if (string == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String getFileExt() {
        return OCLanguageCodeStyleSettingsProvider.getCustomOption().getExampleExtension();
    }

    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.KEY_LANGUAGE_SETTINGS;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new OCIndentOptionsEditor(this);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable c, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (c == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        if (settingsType == null) {
            OCLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        OCCustomOption customOption = OCLanguageCodeStyleSettingsProvider.getCustomOption();
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            c.showStandardOptions(customOption.getWrappingAndBracesOptions());
            for (OCCustomOption.RenameAction renameAction : customOption.getWrappingAndBracesRenames()) {
                c.renameStandardOption(renameAction.from, renameAction.to);
            }
            for (OCCustomOption.CustomOption customOption2 : customOption.getWrappingAndBracesCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption2.fieldName, customOption2.title, customOption2.groupName, customOption2.anchor, customOption2.anchorFieldName, customOption2.options);
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            c.showStandardOptions(customOption.getSpacingOptions());
            for (OCCustomOption.RenameAction renameAction : customOption.getSpacingRenames()) {
                c.renameStandardOption(renameAction.from, renameAction.to);
            }
            for (OCCustomOption.CustomOption customOption3 : customOption.getSpacingCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption3.fieldName, customOption3.title, customOption3.groupName, customOption3.anchor, customOption3.anchorFieldName, customOption3.options);
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            for (OCCustomOption.CustomOption customOption4 : customOption.getIndentCustomOptions()) {
                c.showCustomOption(OCCodeStyleSettings.class, customOption4.fieldName, customOption4.title, customOption4.groupName, customOption4.anchor, customOption4.anchorFieldName, customOption4.options);
            }
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC) {
            OCGenerateCodeConfigurable.customizeSettings(c);
        } else {
            c.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_DECLARATIONS", "KEEP_BLANK_LINES_IN_CODE", "KEEP_BLANK_LINES_BEFORE_RBRACE", "BLANK_LINES_BEFORE_IMPORTS", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_CLASS", "BLANK_LINES_AFTER_CLASS_HEADER", "BLANK_LINES_AROUND_FIELD_IN_INTERFACE", "BLANK_LINES_AROUND_METHOD_IN_INTERFACE", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_BEFORE_METHOD_BODY"});
        }
        for (OCCustomOption.RenameAction renameAction : customOption.getBlankLinesRenames()) {
            c.renameStandardOption(renameAction.from, renameAction.to);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ocSettings";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExt";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameWithoutExtension";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCommonSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/settings/OCLanguageCodeStyleSettingsProvider";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeSample";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingCustomOptions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeSampleContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureDefaultSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "configureCustomSettings";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSampleContent";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

