/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import org.jetbrains.annotations.NotNull;

public class ComplexTextRange {
    private final long myStartOffset;
    private final long myEndOffset;

    public ComplexTextRange(long startOffset, long endOffset) {
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    public long getStartOffset() {
        return this.myStartOffset;
    }

    public long getEndOffset() {
        return this.myEndOffset;
    }

    public boolean contains(@NotNull ComplexTextRange range) {
        if (range == null) {
            ComplexTextRange.$$$reportNull$$$0(0);
        }
        return this.myStartOffset <= range.getStartOffset() && range.getEndOffset() <= this.myEndOffset;
    }

    public boolean contains(long offset) {
        return this.myStartOffset <= offset && offset < this.myEndOffset;
    }

    public boolean containsOffset(long offset) {
        return this.myStartOffset <= offset && offset <= this.myEndOffset;
    }

    public boolean isEmpty() {
        return this.myStartOffset >= this.myEndOffset;
    }

    @NotNull
    public TextRange simple() {
        TextRange textRange = new TextRange(OCSymbolOffsetUtil.getTextOffset(this.myStartOffset), OCSymbolOffsetUtil.getTextOffset(this.myEndOffset));
        if (textRange == null) {
            ComplexTextRange.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public TextRange subst() {
        TextRange textRange = new TextRange(OCSymbolOffsetUtil.getSubstOffset(this.myStartOffset), OCSymbolOffsetUtil.getSubstOffset(this.myEndOffset));
        if (textRange == null) {
            ComplexTextRange.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexTextRange range = (ComplexTextRange)o;
        if (this.myStartOffset != range.myStartOffset) {
            return false;
        }
        return this.myEndOffset == range.myEndOffset;
    }

    public int hashCode() {
        int result = (int)(this.myStartOffset ^ this.myStartOffset >>> 32);
        result = 31 * result + (int)(this.myEndOffset ^ this.myEndOffset >>> 32);
        return result;
    }

    public String toString() {
        return "text " + this.simple() + ", subst " + this.subst();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/ComplexTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/ComplexTextRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "simple";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "subst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

