/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedName
implements Serializable,
DeepEqual.Equality<OCQualifiedName> {
    @NotNull
    private static final String GLOBAL_NAME = "";
    @NotNull
    public static final OCQualifiedName GLOBAL = new OCQualifiedName(null, "");
    @Nullable
    protected OCQualifiedName myQualifier;
    @Nullable
    protected String myName;

    protected OCQualifiedName() {
    }

    protected OCQualifiedName(@Nullable OCQualifiedName qualifier, @Nullable String name2) {
        this.myQualifier = qualifier;
        this.myName = name2;
    }

    public static OCQualifiedName interned(@Nullable OCQualifiedName qualifier, @Nullable String name2) {
        OCQualifiedName result = OCQualifiedName.with(qualifier, name2);
        return result == GLOBAL ? result : OCNamesInternary.intern(result);
    }

    public static OCQualifiedName with(@Nullable OCQualifiedName qualifier, @Nullable String name2) {
        if (qualifier == null && GLOBAL_NAME.equals(name2)) {
            return GLOBAL;
        }
        return new OCQualifiedName(qualifier, name2);
    }

    public static OCQualifiedName interned(@Nullable String name2) {
        return OCQualifiedName.interned(null, name2);
    }

    public static OCQualifiedName with(@Nullable String name2) {
        return OCQualifiedName.with(null, name2);
    }

    public static boolean areResolvedNamesEquals(@Nullable OCQualifiedName a, @Nullable OCQualifiedName b, @NotNull OCResolveContext context) {
        if (context == null) {
            OCQualifiedName.$$$reportNull$$$0(0);
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        return a.resolvedEqualsStep(b, context);
    }

    protected boolean resolvedEqualsStep(@NotNull OCQualifiedName other, @NotNull OCResolveContext context) {
        if (other == null) {
            OCQualifiedName.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCQualifiedName.$$$reportNull$$$0(2);
        }
        if (!Comparing.equal((String)this.myName, (String)other.myName)) {
            return false;
        }
        return OCQualifiedName.areResolvedNamesEquals(this.myQualifier, other.myQualifier, context);
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public OCQualifiedName dropArguments() {
        if (this.myQualifier != null) {
            return OCQualifiedName.with(this.myQualifier.dropArguments(), this.myName);
        }
        return this;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (c == null) {
            OCQualifiedName.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCQualifiedName.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCQualifiedName.$$$reportNull$$$0(5);
        }
        if (!Comparing.equal((String)first.myName, (String)second.myName)) {
            return false;
        }
        return c.equalObjects(first.myQualifier, second.myQualifier);
    }

    public boolean canThisNamePartBeInterned() {
        return true;
    }

    public final boolean equals(@Nullable Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    public int hashCode() {
        int result = this.myQualifier != null ? this.myQualifier.hashCode() : 0;
        result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
        return result;
    }

    public String getSuperQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getSuperQualifier();
    }

    public boolean isAbsolute() {
        if (this == GLOBAL) {
            return true;
        }
        if (this.myQualifier == null) {
            return false;
        }
        return this.myQualifier.isAbsolute();
    }

    @NotNull
    public OCQualifiedName dropSuperQualifier() {
        if (this.myQualifier == null) {
            OCQualifiedName oCQualifiedName = this;
            if (oCQualifiedName == null) {
                OCQualifiedName.$$$reportNull$$$0(6);
            }
            return oCQualifiedName;
        }
        if (this.myQualifier.myQualifier == null) {
            OCQualifiedName oCQualifiedName = OCQualifiedName.with(null, this.myName);
            if (oCQualifiedName == null) {
                OCQualifiedName.$$$reportNull$$$0(7);
            }
            return oCQualifiedName;
        }
        OCQualifiedName oCQualifiedName = OCQualifiedName.with(this.myQualifier.dropSuperQualifier(), this.myName);
        if (oCQualifiedName == null) {
            OCQualifiedName.$$$reportNull$$$0(8);
        }
        return oCQualifiedName;
    }

    @NotNull
    public OCQualifiedName changeName(@Nullable String name2) {
        if (Comparing.equal((String)this.myName, (String)name2)) {
            OCQualifiedName oCQualifiedName = this;
            if (oCQualifiedName == null) {
                OCQualifiedName.$$$reportNull$$$0(9);
            }
            return oCQualifiedName;
        }
        OCQualifiedName oCQualifiedName = OCQualifiedName.with(this.myQualifier, name2);
        if (oCQualifiedName == null) {
            OCQualifiedName.$$$reportNull$$$0(10);
        }
        return oCQualifiedName;
    }

    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        OCQualifiedName oCQualifiedName = OCQualifiedName.with(qualifier, this.myName);
        if (oCQualifiedName == null) {
            OCQualifiedName.$$$reportNull$$$0(11);
        }
        return oCQualifiedName;
    }

    public OCQualifiedName append(OCQualifiedName name2) {
        OCQualifiedName appended = OCQualifiedName.with(this, name2.getSuperQualifier());
        return name2.getQualifier() == null ? appended : appended.append(name2.dropSuperQualifier());
    }

    public String getFullName(@NotNull OCResolveContext context) {
        if (context == null) {
            OCQualifiedName.$$$reportNull$$$0(12);
        }
        return this.getCanonicalName(OCType.Presentation.FULL, true, context, 0);
    }

    private String doGetShortName() {
        return this.myName != null ? this.myName : "<anonymous>";
    }

    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        if (presentation == null) {
            OCQualifiedName.$$$reportNull$$$0(13);
        }
        if (context == null) {
            OCQualifiedName.$$$reportNull$$$0(14);
        }
        String name2 = this.doGetShortName();
        return this.myQualifier != null && (includeGlobalQualifier || this.myQualifier != GLOBAL) ? this.myQualifier.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth) + "::" + name2 : name2;
    }

    public String getShortName(int templateDepth) {
        return this.doGetShortName();
    }

    public String getNameWithParent() {
        String name2 = this.doGetShortName();
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.doGetShortName() + "::" + name2 : name2;
    }

    public static OCQualifiedName parse(String qualifiedName) {
        OCQualifiedName result = null;
        for (String name2 : qualifiedName.split("::")) {
            result = OCQualifiedName.with(result, name2);
        }
        return result;
    }

    public String toString() {
        String name2 = this.getShortName(0);
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.toString() + "::" + name2 : name2;
    }

    public List<String> flatten() {
        ArrayList<String> result = new ArrayList<String>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result.add(current.getName());
        }
        Collections.reverse(result);
        return result;
    }

    public List<Pair<String, List<OCTypeArgument>>> flattenWithArguments() {
        ArrayList<Pair<String, List<OCTypeArgument>>> result = new ArrayList<Pair<String, List<OCTypeArgument>>>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result.add((Pair<String, List<OCTypeArgument>>)Pair.create((Object)current.getName(), current instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)current).getArguments() : null));
        }
        Collections.reverse(result);
        return result;
    }

    public int getDepth() {
        return (this.myQualifier != null ? this.myQualifier.getDepth() : 0) + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/OCQualifiedName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/OCQualifiedName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "dropSuperQualifier";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "changeName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areResolvedNamesEquals";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolvedEqualsStep";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

